// Generated from libavfilter/opencl/convolution.cl
const char *ff_opencl_source_convolution =
"#line 1 \"libavfilter/opencl/convolution.cl\"\n"
"/*\n"
" * Copyright (c) 2018 Danil Iashchenko\n"
" *\n"
" * This file is part of FFmpeg.\n"
" *\n"
" * FFmpeg is free software; you can redistribute it and/or\n"
" * modify it under the terms of the GNU Lesser General Public\n"
" * License as published by the Free Software Foundation; either\n"
" * version 2.1 of the License, or (at your option) any later version.\n"
" *\n"
" * FFmpeg is distributed in the hope that it will be useful,\n"
" * but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
" * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU\n"
" * Lesser General Public License for more details.\n"
" *\n"
" * You should have received a copy of the GNU Lesser General Public\n"
" * License along with FFmpeg; if not, write to the Free Software\n"
" * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA\n"
" */\n"
"\n"
"__kernel void convolution_global(__write_only image2d_t dst,\n"
"                                 __read_only  image2d_t src,\n"
"                                 int coef_matrix_dim,\n"
"                                 __constant float *coef_matrix,\n"
"                                 float div,\n"
"                                 float bias)\n"
"{\n"
"    const sampler_t sampler = (CLK_NORMALIZED_COORDS_FALSE |\n"
"                               CLK_ADDRESS_CLAMP_TO_EDGE   |\n"
"                               CLK_FILTER_NEAREST);\n"
"\n"
"    const int half_matrix_dim = (coef_matrix_dim / 2);\n"
"    int2 loc = (int2)(get_global_id(0), get_global_id(1));\n"
"    float4 convPix = (float4)(0.0f, 0.0f, 0.0f, 0.0f);\n"
"\n"
"    for (int conv_i = -half_matrix_dim; conv_i <= half_matrix_dim; conv_i++) {\n"
"        for (int conv_j = -half_matrix_dim; conv_j <= half_matrix_dim; conv_j++) {\n"
"            float4 px = read_imagef(src, sampler, loc + (int2)(conv_j, conv_i));\n"
"            convPix += px * coef_matrix[(conv_i + half_matrix_dim) * coef_matrix_dim +\n"
"                                        (conv_j + half_matrix_dim)];\n"
"        }\n"
"     }\n"
"     float4 dstPix = convPix * div + bias;\n"
"     write_imagef(dst, loc, dstPix);\n"
"}\n"
"\n"
"\n"
"__kernel void sobel_global(__write_only image2d_t dst,\n"
"                           __read_only  image2d_t src,\n"
"                             float div,\n"
"                             float bias)\n"
"{\n"
"    const sampler_t sampler = (CLK_NORMALIZED_COORDS_FALSE |\n"
"                               CLK_ADDRESS_CLAMP_TO_EDGE   |\n"
"                               CLK_FILTER_NEAREST);\n"
"\n"
"    int2 loc = (int2)(get_global_id(0), get_global_id(1));\n"
"\n"
"    float4 sum1 = read_imagef(src, sampler, loc + (int2)(-1,-1)) * -1 +\n"
"                  read_imagef(src, sampler, loc + (int2)( 0,-1)) * -2 +\n"
"                  read_imagef(src, sampler, loc + (int2)( 1,-1)) * -1 +\n"
"                  read_imagef(src, sampler, loc + (int2)(-1, 1)) *  1 +\n"
"                  read_imagef(src, sampler, loc + (int2)( 0, 1)) *  2 +\n"
"                  read_imagef(src, sampler, loc + (int2)( 1, 1)) *  1;\n"
"\n"
"    float4 sum2 = read_imagef(src, sampler, loc + (int2)(-1,-1)) * -1 +\n"
"                  read_imagef(src, sampler, loc + (int2)(-1, 0)) * -2 +\n"
"                  read_imagef(src, sampler, loc + (int2)(-1, 1)) * -1 +\n"
"                  read_imagef(src, sampler, loc + (int2)( 1,-1)) *  1 +\n"
"                  read_imagef(src, sampler, loc + (int2)( 1, 0)) *  2 +\n"
"                  read_imagef(src, sampler, loc + (int2)( 1, 1)) *  1;\n"
"\n"
"    float4 dstPix = hypot(sum1, sum2) * div + bias;\n"
"    write_imagef(dst, loc, dstPix);\n"
"}\n"
"\n"
"__kernel void prewitt_global(__write_only image2d_t dst,\n"
"                             __read_only  image2d_t src,\n"
"                             float div,\n"
"                             float bias)\n"
"{\n"
"    const sampler_t sampler = (CLK_NORMALIZED_COORDS_FALSE |\n"
"                               CLK_ADDRESS_CLAMP_TO_EDGE   |\n"
"                               CLK_FILTER_NEAREST);\n"
"\n"
"    int2 loc = (int2)(get_global_id(0), get_global_id(1));\n"
"\n"
"    float4 sum1 = read_imagef(src, sampler, loc + (int2)(-1,-1)) *  1 +\n"
"                  read_imagef(src, sampler, loc + (int2)( 0,-1)) *  1 +\n"
"                  read_imagef(src, sampler, loc + (int2)( 1,-1)) *  1 +\n"
"                  read_imagef(src, sampler, loc + (int2)(-1, 1)) * -1 +\n"
"                  read_imagef(src, sampler, loc + (int2)( 0, 1)) * -1 +\n"
"                  read_imagef(src, sampler, loc + (int2)( 1, 1)) * -1;\n"
"\n"
"    float4 sum2 = read_imagef(src, sampler, loc + (int2)(-1,-1)) *  1 +\n"
"                  read_imagef(src, sampler, loc + (int2)(-1, 0)) *  1 +\n"
"                  read_imagef(src, sampler, loc + (int2)(-1, 1)) *  1 +\n"
"                  read_imagef(src, sampler, loc + (int2)( 1,-1)) * -1 +\n"
"                  read_imagef(src, sampler, loc + (int2)( 1, 0)) * -1 +\n"
"                  read_imagef(src, sampler, loc + (int2)( 1, 1)) * -1;\n"
"\n"
"    float4 dstPix = hypot(sum1, sum2) * div + bias;\n"
"    write_imagef(dst, loc, dstPix);\n"
"}\n"
"\n"
"__kernel void roberts_global(__write_only image2d_t dst,\n"
"                             __read_only  image2d_t src,\n"
"                             float div,\n"
"                             float bias)\n"
"{\n"
"    const sampler_t sampler = (CLK_NORMALIZED_COORDS_FALSE |\n"
"                               CLK_ADDRESS_CLAMP_TO_EDGE   |\n"
"                               CLK_FILTER_NEAREST);\n"
"\n"
"    int2 loc = (int2)(get_global_id(0), get_global_id(1));\n"
"\n"
"    float4 sum1 = read_imagef(src, sampler, loc + (int2)(-1,-1)) *  1 +\n"
"                  read_imagef(src, sampler, loc + (int2)( 0,-1)) * -1;\n"
"\n"
"\n"
"    float4 sum2 = read_imagef(src, sampler, loc + (int2)(-1, 0)) * -1 +\n"
"                  read_imagef(src, sampler, loc + (int2)( 0, 0)) *  1;\n"
"\n"
"\n"
"    float4 dstPix = hypot(sum1, sum2) * div + bias;\n"
"    write_imagef(dst, loc, dstPix);\n"
"}\n"
;
