// Generated from libavfilter/opencl/neighbor.cl
const char *ff_opencl_source_neighbor =
"#line 1 \"libavfilter/opencl/neighbor.cl\"\n"
"/*\n"
" * Copyright (c) 2018 Danil Iashchenko\n"
" *\n"
" * This file is part of FFmpeg.\n"
" *\n"
" * FFmpeg is free software; you can redistribute it and/or\n"
" * modify it under the terms of the GNU Lesser General Public\n"
" * License as published by the Free Software Foundation; either\n"
" * version 2.1 of the License, or (at your option) any later version.\n"
" *\n"
" * FFmpeg is distributed in the hope that it will be useful,\n"
" * but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
" * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU\n"
" * Lesser General Public License for more details.\n"
" *\n"
" * You should have received a copy of the GNU Lesser General Public\n"
" * License along with FFmpeg; if not, write to the Free Software\n"
" * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA\n"
" */\n"
"\n"
"\n"
"__kernel void erosion_global(__write_only image2d_t dst,\n"
"                             __read_only  image2d_t src,\n"
"                             float threshold,\n"
"                             __constant int *coord)\n"
"{\n"
"    const sampler_t sampler = (CLK_NORMALIZED_COORDS_FALSE |\n"
"                               CLK_ADDRESS_CLAMP_TO_EDGE   |\n"
"                               CLK_FILTER_NEAREST);\n"
"\n"
"    int2 loc = (int2)(get_global_id(0), get_global_id(1));\n"
"\n"
"    float4 px = read_imagef(src, sampler, loc);\n"
"    float limit = px.x - threshold;\n"
"    if (limit < 0) {\n"
"        limit = 0;\n"
"    }\n"
"\n"
"    for (int i = -1; i <= 1; i++) {\n"
"        for (int j = -1; j <= 1; j++) {\n"
"            if (coord[(j + 1) * 3 + (i + 1)] == 1) {\n"
"                float4 cur = read_imagef(src, sampler, loc + (int2)(i, j));\n"
"                if (cur.x < px.x) {\n"
"                    px = cur;\n"
"                }\n"
"            }\n"
"        }\n"
"    }\n"
"    if (limit > px.x) {\n"
"        px = (float4)(limit);\n"
"    }\n"
"    write_imagef(dst, loc, px);\n"
"}\n"
"\n"
"\n"
"__kernel void dilation_global(__write_only image2d_t dst,\n"
"                              __read_only  image2d_t src,\n"
"                              float threshold,\n"
"                              __constant int *coord)\n"
"{\n"
"    const sampler_t sampler = (CLK_NORMALIZED_COORDS_FALSE |\n"
"                               CLK_ADDRESS_CLAMP_TO_EDGE   |\n"
"                               CLK_FILTER_NEAREST);\n"
"\n"
"    int2 loc = (int2)(get_global_id(0), get_global_id(1));\n"
"\n"
"    float4 px = read_imagef(src, sampler, loc);\n"
"    float limit = px.x + threshold;\n"
"    if (limit > 1) {\n"
"        limit = 1;\n"
"    }\n"
"\n"
"    for (int i = -1; i <= 1; i++) {\n"
"        for (int j = -1; j <= 1; j++) {\n"
"            if (coord[(j + 1) * 3 + (i + 1)] == 1) {\n"
"                float4 cur = read_imagef(src, sampler, loc + (int2)(i, j));\n"
"                if (cur.x > px.x) {\n"
"                    px = cur;\n"
"                }\n"
"            }\n"
"        }\n"
"    }\n"
"    if (limit < px.x) {\n"
"        px = (float4)(limit);\n"
"    }\n"
"    write_imagef(dst, loc, px);\n"
"}\n"
;
