/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.connector;

import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.SessionTrackingMode;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpServletResponseWrapper;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.catalina.Context;
import org.apache.catalina.Session;
import org.apache.catalina.connector.CoyoteOutputStream;
import org.apache.catalina.connector.CoyoteWriter;
import org.apache.catalina.connector.OutputBuffer;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.ResponseFacade;
import org.apache.catalina.security.SecurityUtil;
import org.apache.catalina.util.SessionConfig;
import org.apache.coyote.ActionCode;
import org.apache.coyote.Constants;
import org.apache.coyote.ContinueResponseTiming;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.buf.CharChunk;
import org.apache.tomcat.util.buf.UEncoder;
import org.apache.tomcat.util.buf.UriUtil;
import org.apache.tomcat.util.http.FastHttpDateFormat;
import org.apache.tomcat.util.http.MimeHeaders;
import org.apache.tomcat.util.http.parser.MediaTypeCache;
import org.apache.tomcat.util.res.StringManager;
import org.apache.tomcat.util.security.Escape;

public class Response
implements HttpServletResponse {
    private static final Log log = LogFactory.getLog(Response.class);
    protected static final StringManager sm = StringManager.getManager(Response.class);
    private static final MediaTypeCache MEDIA_TYPE_CACHE = new MediaTypeCache(100);
    protected org.apache.coyote.Response coyoteResponse;
    protected final OutputBuffer outputBuffer;
    protected CoyoteOutputStream outputStream;
    protected CoyoteWriter writer;
    protected boolean appCommitted = false;
    protected boolean included = false;
    private boolean isCharacterEncodingSet = false;
    protected boolean usingOutputStream = false;
    protected boolean usingWriter = false;
    protected final UEncoder urlEncoder = new UEncoder(UEncoder.SafeCharsSet.WITH_SLASH);
    protected final CharChunk redirectURLCC = new CharChunk();
    private final List<Cookie> cookies = new ArrayList<Cookie>();
    private HttpServletResponse applicationResponse = null;
    protected Request request = null;
    protected ResponseFacade facade = null;

    public Response() {
        this(8192);
    }

    public Response(int n) {
        this.outputBuffer = new OutputBuffer(n);
    }

    public void setCoyoteResponse(org.apache.coyote.Response response) {
        this.coyoteResponse = response;
        this.outputBuffer.setResponse(response);
    }

    public org.apache.coyote.Response getCoyoteResponse() {
        return this.coyoteResponse;
    }

    public Context getContext() {
        return this.request.getContext();
    }

    public void recycle() {
        this.cookies.clear();
        this.outputBuffer.recycle();
        this.usingOutputStream = false;
        this.usingWriter = false;
        this.appCommitted = false;
        this.included = false;
        this.isCharacterEncodingSet = false;
        this.applicationResponse = null;
        if (this.getRequest().getDiscardFacades()) {
            if (this.facade != null) {
                this.facade.clear();
                this.facade = null;
            }
            if (this.outputStream != null) {
                this.outputStream.clear();
                this.outputStream = null;
            }
            if (this.writer != null) {
                this.writer.clear();
                this.writer = null;
            }
        } else if (this.writer != null) {
            this.writer.recycle();
        }
    }

    public List<Cookie> getCookies() {
        return this.cookies;
    }

    public long getContentWritten() {
        return this.outputBuffer.getContentWritten();
    }

    public long getBytesWritten(boolean bl) {
        if (bl) {
            try {
                this.outputBuffer.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return this.getCoyoteResponse().getBytesWritten(bl);
    }

    public void setAppCommitted(boolean bl) {
        this.appCommitted = bl;
    }

    public boolean isAppCommitted() {
        return this.appCommitted || this.isCommitted() || this.isSuspended() || this.getContentLength() > 0 && this.getContentWritten() >= (long)this.getContentLength();
    }

    public Request getRequest() {
        return this.request;
    }

    public void setRequest(Request request) {
        this.request = request;
    }

    public HttpServletResponse getResponse() {
        if (this.facade == null) {
            this.facade = new ResponseFacade(this);
        }
        if (this.applicationResponse == null) {
            this.applicationResponse = this.facade;
        }
        return this.applicationResponse;
    }

    public void setResponse(HttpServletResponse httpServletResponse) {
        HttpServletResponse httpServletResponse2 = httpServletResponse;
        while (httpServletResponse2 instanceof HttpServletResponseWrapper) {
            httpServletResponse2 = ((HttpServletResponseWrapper)httpServletResponse2).getResponse();
        }
        if (httpServletResponse2 != this.facade) {
            throw new IllegalArgumentException(sm.getString("response.illegalWrap"));
        }
        this.applicationResponse = httpServletResponse;
    }

    public void setSuspended(boolean bl) {
        this.outputBuffer.setSuspended(bl);
    }

    public boolean isSuspended() {
        return this.outputBuffer.isSuspended();
    }

    public boolean isClosed() {
        return this.outputBuffer.isClosed();
    }

    public boolean setError() {
        return this.getCoyoteResponse().setError();
    }

    public boolean isError() {
        return this.getCoyoteResponse().isError();
    }

    public boolean isErrorReportRequired() {
        return this.getCoyoteResponse().isErrorReportRequired();
    }

    public boolean setErrorReported() {
        return this.getCoyoteResponse().setErrorReported();
    }

    public void finishResponse() throws IOException {
        this.outputBuffer.close();
    }

    public int getContentLength() {
        return this.getCoyoteResponse().getContentLength();
    }

    public String getContentType() {
        return this.getCoyoteResponse().getContentType();
    }

    public PrintWriter getReporter() throws IOException {
        if (this.outputBuffer.isNew()) {
            this.outputBuffer.checkConverter();
            if (this.writer == null) {
                this.writer = new CoyoteWriter(this.outputBuffer);
            }
            return this.writer;
        }
        return null;
    }

    public void flushBuffer() throws IOException {
        this.outputBuffer.flush();
    }

    public int getBufferSize() {
        return this.outputBuffer.getBufferSize();
    }

    public String getCharacterEncoding() {
        String string = this.getCoyoteResponse().getCharacterEncoding();
        if (string != null) {
            return string;
        }
        Context context = this.getContext();
        String string2 = null;
        if (context != null) {
            string2 = context.getResponseCharacterEncoding();
        }
        if (string2 == null) {
            string2 = Constants.DEFAULT_BODY_CHARSET.name();
        }
        return string2;
    }

    public ServletOutputStream getOutputStream() throws IOException {
        if (this.usingWriter) {
            throw new IllegalStateException(sm.getString("coyoteResponse.getOutputStream.ise"));
        }
        this.usingOutputStream = true;
        if (this.outputStream == null) {
            this.outputStream = new CoyoteOutputStream(this.outputBuffer);
        }
        return this.outputStream;
    }

    public Locale getLocale() {
        return this.getCoyoteResponse().getLocale();
    }

    public PrintWriter getWriter() throws IOException {
        if (this.usingOutputStream) {
            throw new IllegalStateException(sm.getString("coyoteResponse.getWriter.ise"));
        }
        if (this.request.getConnector().getEnforceEncodingInGetWriter()) {
            this.setCharacterEncoding(this.getCharacterEncoding());
        }
        this.usingWriter = true;
        this.outputBuffer.checkConverter();
        if (this.writer == null) {
            this.writer = new CoyoteWriter(this.outputBuffer);
        }
        return this.writer;
    }

    public boolean isCommitted() {
        return this.getCoyoteResponse().isCommitted();
    }

    public void reset() {
        if (this.included) {
            return;
        }
        this.getCoyoteResponse().reset();
        this.outputBuffer.reset();
        this.usingOutputStream = false;
        this.usingWriter = false;
        this.isCharacterEncodingSet = false;
    }

    public void resetBuffer() {
        this.resetBuffer(false);
    }

    public void resetBuffer(boolean bl) {
        if (this.isCommitted()) {
            throw new IllegalStateException(sm.getString("coyoteResponse.resetBuffer.ise"));
        }
        this.outputBuffer.reset(bl);
        if (bl) {
            this.usingOutputStream = false;
            this.usingWriter = false;
            this.isCharacterEncodingSet = false;
        }
    }

    public void setBufferSize(int n) {
        if (this.isCommitted() || !this.outputBuffer.isNew()) {
            throw new IllegalStateException(sm.getString("coyoteResponse.setBufferSize.ise"));
        }
        this.outputBuffer.setBufferSize(n);
    }

    public void setContentLength(int n) {
        this.setContentLengthLong(n);
    }

    public void setContentLengthLong(long l) {
        if (this.isCommitted()) {
            return;
        }
        if (this.included) {
            return;
        }
        this.getCoyoteResponse().setContentLength(l);
    }

    public void setContentType(String string) {
        if (this.isCommitted()) {
            return;
        }
        if (this.included) {
            return;
        }
        if (string == null) {
            this.getCoyoteResponse().setContentType(null);
            try {
                this.getCoyoteResponse().setCharacterEncoding(null);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            this.isCharacterEncodingSet = false;
            return;
        }
        String[] stringArray = MEDIA_TYPE_CACHE.parse(string);
        if (stringArray == null) {
            this.getCoyoteResponse().setContentTypeNoCharset(string);
            return;
        }
        if (stringArray[1] == null) {
            this.getCoyoteResponse().setContentTypeNoCharset(string);
        } else {
            this.getCoyoteResponse().setContentTypeNoCharset(stringArray[0]);
            if (!this.usingWriter) {
                try {
                    this.getCoyoteResponse().setCharacterEncoding(stringArray[1]);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    log.warn((Object)sm.getString("coyoteResponse.encoding.invalid", new Object[]{stringArray[1]}), (Throwable)unsupportedEncodingException);
                }
                this.isCharacterEncodingSet = true;
            }
        }
    }

    public void setCharacterEncoding(String string) {
        if (this.isCommitted()) {
            return;
        }
        if (this.included) {
            return;
        }
        if (this.usingWriter) {
            return;
        }
        try {
            this.getCoyoteResponse().setCharacterEncoding(string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            log.warn((Object)sm.getString("coyoteResponse.encoding.invalid", new Object[]{string}), (Throwable)unsupportedEncodingException);
            return;
        }
        this.isCharacterEncodingSet = string != null;
    }

    public void setLocale(Locale locale) {
        if (this.isCommitted()) {
            return;
        }
        if (this.included) {
            return;
        }
        this.getCoyoteResponse().setLocale(locale);
        if (this.usingWriter) {
            return;
        }
        if (this.isCharacterEncodingSet) {
            return;
        }
        if (locale == null) {
            try {
                this.getCoyoteResponse().setCharacterEncoding(null);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {}
        } else {
            String string;
            Context context = this.getContext();
            if (context != null && (string = context.getCharset(locale)) != null) {
                try {
                    this.getCoyoteResponse().setCharacterEncoding(string);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    log.warn((Object)sm.getString("coyoteResponse.encoding.invalid", new Object[]{string}), (Throwable)unsupportedEncodingException);
                }
            }
        }
    }

    public String getHeader(String string) {
        return this.getCoyoteResponse().getMimeHeaders().getHeader(string);
    }

    public Collection<String> getHeaderNames() {
        MimeHeaders mimeHeaders = this.getCoyoteResponse().getMimeHeaders();
        int n = mimeHeaders.size();
        ArrayList<String> arrayList = new ArrayList<String>(n);
        for (int i = 0; i < n; ++i) {
            arrayList.add(mimeHeaders.getName(i).toString());
        }
        return arrayList;
    }

    public Collection<String> getHeaders(String string) {
        Enumeration enumeration = this.getCoyoteResponse().getMimeHeaders().values(string);
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        while (enumeration.hasMoreElements()) {
            linkedHashSet.add((String)enumeration.nextElement());
        }
        return linkedHashSet;
    }

    public String getMessage() {
        return this.getCoyoteResponse().getMessage();
    }

    public int getStatus() {
        return this.getCoyoteResponse().getStatus();
    }

    public void addCookie(Cookie cookie) {
        if (this.included || this.isCommitted()) {
            return;
        }
        this.cookies.add(cookie);
        String string = this.generateCookieString(cookie);
        this.addHeader("Set-Cookie", string, this.getContext().getCookieProcessor().getCharset());
    }

    public void addSessionCookieInternal(Cookie cookie) {
        if (this.isCommitted()) {
            return;
        }
        String string = cookie.getName();
        String string2 = string + "=";
        String string3 = this.generateCookieString(cookie);
        boolean bl = false;
        MimeHeaders mimeHeaders = this.getCoyoteResponse().getMimeHeaders();
        int n = mimeHeaders.size();
        for (int i = 0; i < n; ++i) {
            if (!mimeHeaders.getName(i).toString().equals("Set-Cookie") || !mimeHeaders.getValue(i).toString().startsWith(string2)) continue;
            mimeHeaders.getValue(i).setString(string3);
            bl = true;
        }
        if (!bl) {
            this.addHeader("Set-Cookie", string3);
        }
    }

    public String generateCookieString(Cookie cookie) {
        if (SecurityUtil.isPackageProtectionEnabled()) {
            return AccessController.doPrivileged(new PrivilegedGenerateCookieString(this.getContext(), cookie, this.request.getRequest()));
        }
        return this.getContext().getCookieProcessor().generateHeader(cookie, this.request.getRequest());
    }

    public void addDateHeader(String string, long l) {
        if (string == null || string.length() == 0) {
            return;
        }
        if (this.isCommitted()) {
            return;
        }
        if (this.included) {
            return;
        }
        this.addHeader(string, FastHttpDateFormat.formatDate((long)l));
    }

    public void addHeader(String string, String string2) {
        this.addHeader(string, string2, null);
    }

    private void addHeader(String string, String string2, Charset charset) {
        if (string == null || string.length() == 0 || string2 == null) {
            return;
        }
        if (this.isCommitted()) {
            return;
        }
        if (this.included) {
            return;
        }
        char c = string.charAt(0);
        if ((c == 'C' || c == 'c') && this.checkSpecialHeader(string, string2)) {
            return;
        }
        this.getCoyoteResponse().addHeader(string, string2, charset);
    }

    private boolean checkSpecialHeader(String string, String string2) {
        if (string.equalsIgnoreCase("Content-Type")) {
            this.setContentType(string2);
            return true;
        }
        return false;
    }

    public void addIntHeader(String string, int n) {
        if (string == null || string.length() == 0) {
            return;
        }
        if (this.isCommitted()) {
            return;
        }
        if (this.included) {
            return;
        }
        this.addHeader(string, "" + n);
    }

    public boolean containsHeader(String string) {
        char c = string.charAt(0);
        if (c == 'C' || c == 'c') {
            if (string.equalsIgnoreCase("Content-Type")) {
                return this.getCoyoteResponse().getContentType() != null;
            }
            if (string.equalsIgnoreCase("Content-Length")) {
                return this.getCoyoteResponse().getContentLengthLong() != -1L;
            }
        }
        return this.getCoyoteResponse().containsHeader(string);
    }

    public void setTrailerFields(Supplier<Map<String, String>> supplier) {
        this.getCoyoteResponse().setTrailerFields(supplier);
    }

    public Supplier<Map<String, String>> getTrailerFields() {
        return this.getCoyoteResponse().getTrailerFields();
    }

    public String encodeRedirectURL(String string) {
        if (this.isEncodeable(this.toAbsolute(string))) {
            return this.toEncoded(string, this.request.getSessionInternal().getIdInternal());
        }
        return string;
    }

    public String encodeURL(String object) {
        String string;
        try {
            string = this.toAbsolute((String)object);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return object;
        }
        if (this.isEncodeable(string)) {
            if (((String)object).equalsIgnoreCase("")) {
                object = string;
            } else if (((String)object).equals(string) && !this.hasPath((String)object)) {
                object = (String)object + "/";
            }
            return this.toEncoded((String)object, this.request.getSessionInternal().getIdInternal());
        }
        return object;
    }

    public void sendAcknowledgement(ContinueResponseTiming continueResponseTiming) throws IOException {
        if (this.isCommitted()) {
            return;
        }
        if (this.included) {
            return;
        }
        this.getCoyoteResponse().action(ActionCode.ACK, (Object)continueResponseTiming);
    }

    public void sendError(int n) throws IOException {
        this.sendError(n, null);
    }

    public void sendError(int n, String string) throws IOException {
        if (this.isCommitted()) {
            throw new IllegalStateException(sm.getString("coyoteResponse.sendError.ise"));
        }
        if (this.included) {
            return;
        }
        this.setError();
        this.getCoyoteResponse().setStatus(n);
        this.getCoyoteResponse().setMessage(string);
        this.resetBuffer();
        this.setSuspended(true);
    }

    public void sendRedirect(String string) throws IOException {
        this.sendRedirect(string, 302);
    }

    public void sendRedirect(String string, int n) throws IOException {
        if (this.isCommitted()) {
            throw new IllegalStateException(sm.getString("coyoteResponse.sendRedirect.ise"));
        }
        if (this.included) {
            return;
        }
        this.resetBuffer(true);
        try {
            Context context = this.getContext();
            String string2 = this.getRequest().getCoyoteRequest().getSupportsRelativeRedirects() && (context == null || context.getUseRelativeRedirects()) ? string : this.toAbsolute(string);
            this.setStatus(n);
            this.setHeader("Location", string2);
            if (context != null && context.getSendRedirectBody()) {
                PrintWriter printWriter = this.getWriter();
                printWriter.print(sm.getString("coyoteResponse.sendRedirect.note", new Object[]{Escape.htmlElementContent((String)string2)}));
                this.flushBuffer();
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            log.warn((Object)sm.getString("response.sendRedirectFail", new Object[]{string}), (Throwable)illegalArgumentException);
            this.setStatus(404);
        }
        this.setSuspended(true);
    }

    public void setDateHeader(String string, long l) {
        if (string == null || string.length() == 0) {
            return;
        }
        if (this.isCommitted()) {
            return;
        }
        if (this.included) {
            return;
        }
        this.setHeader(string, FastHttpDateFormat.formatDate((long)l));
    }

    public void setHeader(String string, String string2) {
        if (string == null || string.length() == 0 || string2 == null) {
            return;
        }
        if (this.isCommitted()) {
            return;
        }
        if (this.included) {
            return;
        }
        char c = string.charAt(0);
        if ((c == 'C' || c == 'c') && this.checkSpecialHeader(string, string2)) {
            return;
        }
        this.getCoyoteResponse().setHeader(string, string2);
    }

    public void setIntHeader(String string, int n) {
        if (string == null || string.length() == 0) {
            return;
        }
        if (this.isCommitted()) {
            return;
        }
        if (this.included) {
            return;
        }
        this.setHeader(string, "" + n);
    }

    public void setStatus(int n) {
        if (this.isCommitted()) {
            return;
        }
        if (this.included) {
            return;
        }
        this.getCoyoteResponse().setStatus(n);
    }

    protected boolean isEncodeable(String string) {
        if (string == null) {
            return false;
        }
        if (string.startsWith("#")) {
            return false;
        }
        Request request = this.request;
        Session session = request.getSessionInternal(false);
        if (session == null) {
            return false;
        }
        if (request.isRequestedSessionIdFromCookie()) {
            return false;
        }
        if (!request.getServletContext().getEffectiveSessionTrackingModes().contains(SessionTrackingMode.URL)) {
            return false;
        }
        if (SecurityUtil.isPackageProtectionEnabled()) {
            Boolean bl = AccessController.doPrivileged(new PrivilegedDoIsEncodable(this.getContext(), request, session, string));
            return bl;
        }
        return Response.doIsEncodeable(this.getContext(), request, session, string);
    }

    private static boolean doIsEncodeable(Context context, Request request, Session session, String string) {
        int n;
        URL uRL = null;
        try {
            URI uRI = new URI(string);
            uRL = uRI.toURL();
        }
        catch (MalformedURLException | URISyntaxException exception) {
            return false;
        }
        if (!request.getScheme().equalsIgnoreCase(uRL.getProtocol())) {
            return false;
        }
        if (!request.getServerName().equalsIgnoreCase(uRL.getHost())) {
            return false;
        }
        int n2 = request.getServerPort();
        if (n2 == -1) {
            n2 = "https".equals(request.getScheme()) ? 443 : 80;
        }
        if ((n = uRL.getPort()) == -1) {
            n = "https".equals(uRL.getProtocol()) ? 443 : 80;
        }
        if (n2 != n) {
            return false;
        }
        String string2 = context.getPath();
        if (string2 != null) {
            String string3 = uRL.getFile();
            if (!string3.startsWith(string2)) {
                return false;
            }
            String string4 = ";" + SessionConfig.getSessionUriParamName(context) + "=" + session.getIdInternal();
            if (string3.indexOf(string4, string2.length()) >= 0) {
                return false;
            }
        }
        return true;
    }

    protected String toAbsolute(String string) {
        if (string == null) {
            return string;
        }
        boolean bl = string.startsWith("/");
        if (string.startsWith("//")) {
            this.redirectURLCC.recycle();
            String string2 = this.request.getScheme();
            try {
                this.redirectURLCC.append(string2, 0, string2.length());
                this.redirectURLCC.append(':');
                this.redirectURLCC.append(string, 0, string.length());
                return this.redirectURLCC.toString();
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException(string, iOException);
            }
        }
        if (bl || !UriUtil.hasScheme((CharSequence)string)) {
            this.redirectURLCC.recycle();
            String string3 = this.request.getScheme();
            String string4 = this.request.getServerName();
            int n = this.request.getServerPort();
            try {
                Object object;
                this.redirectURLCC.append(string3, 0, string3.length());
                this.redirectURLCC.append("://", 0, 3);
                this.redirectURLCC.append(string4, 0, string4.length());
                if (string3.equals("http") && n != 80 || string3.equals("https") && n != 443) {
                    this.redirectURLCC.append(':');
                    object = "" + n;
                    this.redirectURLCC.append((String)object, 0, ((String)object).length());
                }
                if (!bl) {
                    object = this.request.getDecodedRequestURI();
                    int n2 = ((String)object).lastIndexOf(47);
                    CharChunk charChunk = null;
                    if (SecurityUtil.isPackageProtectionEnabled()) {
                        try {
                            charChunk = AccessController.doPrivileged(new PrivilegedEncodeUrl(this.urlEncoder, (String)object, n2));
                        }
                        catch (PrivilegedActionException privilegedActionException) {
                            throw new IllegalArgumentException(string, privilegedActionException.getException());
                        }
                    } else {
                        charChunk = this.urlEncoder.encodeURL((String)object, 0, n2);
                    }
                    this.redirectURLCC.append(charChunk);
                    charChunk.recycle();
                    this.redirectURLCC.append('/');
                }
                this.redirectURLCC.append(string, 0, string.length());
                this.normalize(this.redirectURLCC);
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException(string, iOException);
            }
            return this.redirectURLCC.toString();
        }
        return string;
    }

    private void normalize(CharChunk charChunk) {
        int n;
        int n2 = charChunk.indexOf('?');
        if (n2 == -1) {
            n2 = charChunk.indexOf('#');
        }
        char[] cArray = null;
        if (n2 > -1) {
            cArray = Arrays.copyOfRange(charChunk.getBuffer(), charChunk.getStart() + n2, charChunk.getEnd());
            charChunk.setEnd(charChunk.getStart() + n2);
        }
        if (charChunk.endsWith("/.") || charChunk.endsWith("/..")) {
            try {
                charChunk.append('/');
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException(charChunk.toString(), iOException);
            }
        }
        char[] cArray2 = charChunk.getChars();
        int n3 = charChunk.getStart();
        int n4 = charChunk.getEnd();
        int n5 = 0;
        int n6 = 0;
        for (n = 0; n < 3; ++n) {
            n6 = charChunk.indexOf('/', n6 + 1);
        }
        n5 = n6;
        while ((n5 = charChunk.indexOf("/./", 0, 3, n5)) >= 0) {
            this.copyChars(cArray2, n3 + n5, n3 + n5 + 2, n4 - n3 - n5 - 2);
            charChunk.setEnd(n4 -= 2);
        }
        n5 = n6;
        while ((n5 = charChunk.indexOf("/../", 0, 4, n5)) >= 0) {
            if (n5 == n6) {
                throw new IllegalArgumentException();
            }
            int n7 = -1;
            for (n = n3 + n5 - 1; n >= 0 && n7 < 0; --n) {
                if (cArray2[n] != '/') continue;
                n7 = n;
            }
            this.copyChars(cArray2, n3 + n7, n3 + n5 + 3, n4 - n3 - n5 - 3);
            n4 = n4 + n7 - n5 - 3;
            charChunk.setEnd(n4);
            n5 = n7;
        }
        if (cArray != null) {
            try {
                charChunk.append(cArray, 0, cArray.length);
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException(iOException);
            }
        }
    }

    private void copyChars(char[] cArray, int n, int n2, int n3) {
        System.arraycopy(cArray, n2, cArray, n, n3);
    }

    private boolean hasPath(String string) {
        int n = string.indexOf("://");
        if (n < 0) {
            return false;
        }
        return (n = string.indexOf(47, n + 3)) >= 0;
    }

    protected String toEncoded(String string, String string2) {
        StringBuilder stringBuilder;
        int n;
        if (string == null || string2 == null) {
            return string;
        }
        String string3 = string;
        String string4 = "";
        String string5 = "";
        int n2 = string.indexOf(63);
        if (n2 >= 0) {
            string3 = string.substring(0, n2);
            string4 = string.substring(n2);
        }
        if ((n = string3.indexOf(35)) >= 0) {
            string5 = string3.substring(n);
            string3 = string3.substring(0, n);
        }
        if ((stringBuilder = new StringBuilder(string3)).length() > 0) {
            stringBuilder.append(';');
            stringBuilder.append(SessionConfig.getSessionUriParamName(this.request.getContext()));
            stringBuilder.append('=');
            stringBuilder.append(string2);
        }
        stringBuilder.append(string5);
        stringBuilder.append(string4);
        return stringBuilder.toString();
    }

    private static class PrivilegedEncodeUrl
    implements PrivilegedExceptionAction<CharChunk> {
        private final UEncoder urlEncoder;
        private final String relativePath;
        private final int end;

        public PrivilegedEncodeUrl(UEncoder uEncoder, String string, int n) {
            this.urlEncoder = uEncoder;
            this.relativePath = string;
            this.end = n;
        }

        @Override
        public CharChunk run() throws IOException {
            return this.urlEncoder.encodeURL(this.relativePath, 0, this.end);
        }
    }

    private static class PrivilegedDoIsEncodable
    implements PrivilegedAction<Boolean> {
        private final Context context;
        private final Request hreq;
        private final Session session;
        private final String location;

        public PrivilegedDoIsEncodable(Context context, Request request, Session session, String string) {
            this.context = context;
            this.hreq = request;
            this.session = session;
            this.location = string;
        }

        @Override
        public Boolean run() {
            return Response.doIsEncodeable(this.context, this.hreq, this.session, this.location);
        }
    }

    private static class PrivilegedGenerateCookieString
    implements PrivilegedAction<String> {
        private final Context context;
        private final Cookie cookie;
        private final HttpServletRequest request;

        public PrivilegedGenerateCookieString(Context context, Cookie cookie, HttpServletRequest httpServletRequest) {
            this.context = context;
            this.cookie = cookie;
            this.request = httpServletRequest;
        }

        @Override
        public String run() {
            return this.context.getCookieProcessor().generateHeader(this.cookie, this.request);
        }
    }
}

