/*
 * Decompiled with CFR 0.152.
 */
package cc.arduino;

import java.io.ByteArrayOutputStream;
import processing.app.debug.MessageConsumer;

public class MessageConsumerOutputStream
extends ByteArrayOutputStream {
    private final MessageConsumer consumer;
    private final String lineSeparator;

    public MessageConsumerOutputStream(MessageConsumer consumer) {
        this(consumer, System.getProperty("line.separator"));
    }

    public MessageConsumerOutputStream(MessageConsumer consumer, String lineSeparator) {
        this.consumer = consumer;
        this.lineSeparator = lineSeparator;
    }

    @Override
    public void write(byte[] b, int off, int len) {
        super.write(b, off, len);
        this.flush();
    }

    @Override
    public void flush() {
        String asString = this.toString();
        if (!asString.contains(this.lineSeparator)) {
            return;
        }
        while (asString.contains(this.lineSeparator)) {
            String line = asString.substring(0, asString.indexOf(this.lineSeparator));
            this.reset();
            byte[] bytes = asString.substring(asString.indexOf(this.lineSeparator) + this.lineSeparator.length()).getBytes();
            super.write(bytes, 0, bytes.length);
            asString = this.toString();
            this.consumer.message(line);
        }
    }
}

