/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.images;

import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.List;
import java.util.Optional;
import net.sf.freecol.client.gui.ImageLibrary;
import net.sf.freecol.common.model.Direction;
import net.sf.freecol.common.model.TileType;
import net.sf.freecol.common.resources.ImageCache;
import net.sf.freecol.common.resources.ImageResource;
import net.sf.freecol.common.util.ImageUtils;

public final class BeachTileAnimationImageCreator {
    private final ImageLibrary lib;
    private final ImageCache imageCache;

    public BeachTileAnimationImageCreator(ImageLibrary lib, ImageCache imageCache) {
        this.lib = lib;
        this.imageCache = imageCache;
    }

    public BufferedImage getAnimatedScaledWaterAndBeachTerrainImage(TileType type, List<Direction> directionsWithLand, long ticks) {
        ImageResource beachCenterImageResource = ImageLibrary.getBeachCenterImageResource();
        if (beachCenterImageResource == null) {
            return null;
        }
        String beachVariationKey = this.determineDirectionCombinationKey(directionsWithLand);
        ImageResource oceanImageResource = ImageCache.getImageResource(ImageLibrary.getTerrainImageKey(type));
        int oceanVariationNumber = oceanImageResource.getVariationNumberForTick(ticks);
        String generatedKey = oceanImageResource.getPrimaryKey() + ".beach." + beachVariationKey + "$gen";
        BufferedImage result = this.imageCache.getCachedImageOrGenerate(generatedKey, this.lib.getTileSize(), false, oceanVariationNumber, () -> {
            BufferedImage oceanImage = this.lib.getAnimatedScaledTerrainImage(type, ticks);
            String beachMaskKey = "image.mask.beach." + beachVariationKey;
            BufferedImage beachMaskImage = this.imageCache.getSizedImage(beachMaskKey, this.lib.getTileSize(), false);
            BufferedImage beachImage = beachCenterImageResource.getImage(this.lib.getTileSize(), false);
            BufferedImage tileMask = this.lib.getTerrainMask(null);
            return BeachTileAnimationImageCreator.generateImage(beachImage, oceanImage, oceanVariationNumber, beachMaskImage, tileMask);
        });
        return result;
    }

    private static BufferedImage generateImage(BufferedImage beachImage, BufferedImage oceanImage, int oceanImageVariationNumber, BufferedImage beachMaskImage, BufferedImage tileMask) {
        int width = oceanImage.getWidth();
        int height = oceanImage.getHeight();
        if (beachImage.getWidth() != width || beachImage.getHeight() != height) {
            throw new IllegalArgumentException("All images should be of the same size.");
        }
        if (beachMaskImage.getWidth() != width || beachMaskImage.getHeight() != height) {
            throw new IllegalArgumentException("All images should be of the same size.");
        }
        if (tileMask.getWidth() != width || tileMask.getHeight() != height) {
            throw new IllegalArgumentException("All images should be of the same size.");
        }
        BufferedImage maskedInputImage = ImageUtils.imageWithAlphaFromMask(oceanImage, beachMaskImage);
        float extraOcean = 0.05f;
        float alpha = oceanImageVariationNumber <= 10 ? 0.05f * (float)oceanImageVariationNumber : 0.5f - 0.05f * (float)(oceanImageVariationNumber - 10);
        BufferedImage resultImage = new BufferedImage(width, height, 2);
        Graphics2D g2d = resultImage.createGraphics();
        g2d.drawImage((Image)beachImage, 0, 0, null);
        g2d.drawImage((Image)maskedInputImage, 0, 0, null);
        g2d.setComposite(AlphaComposite.getInstance(3, alpha));
        g2d.drawImage((Image)maskedInputImage, 0, 0, null);
        g2d.dispose();
        return ImageUtils.imageWithAlphaFromMask(resultImage, tileMask);
    }

    private String determineDirectionCombinationKey(List<Direction> directions) {
        Optional<String> neighboursPre = directions.stream().filter(d -> Direction.longSides.contains(d)).map(d -> d.toString().toLowerCase()).sorted().reduce((a, b) -> a + "_" + b);
        String beachVariationKey = directions.stream().filter(d -> Direction.longSides.contains(d) || neighboursPre.isEmpty() || !((String)neighboursPre.get()).contains(d.toString().toLowerCase())).map(d -> d.toString().toLowerCase()).sorted().reduce((a, b) -> a + "_" + b).get();
        return beachVariationKey;
    }
}

