/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.logging.Logger;
import net.sf.freecol.common.model.Europe;
import net.sf.freecol.common.model.FreeColObject;
import net.sf.freecol.common.model.ObjectWas;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.util.CollectionUtils;

public class EuropeWas
extends ObjectWas {
    private static final Logger logger = Logger.getLogger(EuropeWas.class.getName());
    private final Europe europe;
    private final int unitCount;

    public EuropeWas(Europe europe) {
        this.europe = europe;
        this.unitCount = europe.getUnitCount();
    }

    public Unit getNewUnit() {
        return this.europe.getUnitCount() <= this.unitCount ? null : CollectionUtils.maximize(this.europe.getUnits(), CollectionUtils.cachingIntComparator(FreeColObject::getIdNumber));
    }

    @Override
    public boolean fireChanges() {
        int newCount = this.europe.getUnitCount();
        if (newCount != this.unitCount) {
            this.europe.firePropertyChange("unitChange", this.unitCount, newCount);
            return true;
        }
        return false;
    }
}

