/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.Collection;
import java.util.List;
import java.util.stream.Stream;
import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.io.FreeColXMLWriter;
import net.sf.freecol.common.model.Ability;
import net.sf.freecol.common.model.FeatureContainer;
import net.sf.freecol.common.model.FreeColObject;
import net.sf.freecol.common.model.FreeColSpecObject;
import net.sf.freecol.common.model.Modifier;
import net.sf.freecol.common.model.Named;
import net.sf.freecol.common.model.Scope;
import net.sf.freecol.common.model.ScopeContainer;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.util.CollectionUtils;

public abstract class FreeColSpecObjectType
extends FreeColSpecObject
implements Named {
    private boolean abstractType;
    private FeatureContainer featureContainer = null;
    private ScopeContainer scopeContainer;
    private int index = -1;
    private static final String ABSTRACT_TAG = "abstract";
    protected static final String DELETE_TAG = "delete";
    public static final String EXTENDS_TAG = "extends";
    public static final String PRESERVE_TAG = "preserve";

    protected FreeColSpecObjectType() {
        super(null);
    }

    public FreeColSpecObjectType(String id) {
        this(id, null);
    }

    public FreeColSpecObjectType(Specification specification) {
        this(null, specification);
    }

    public FreeColSpecObjectType(String id, Specification specification) {
        super(specification);
        this.setId(id);
    }

    public int getIndex() {
        return this.index;
    }

    protected final void setIndex(int index) {
        this.index = index;
    }

    public final String getDescriptionKey() {
        return Messages.descriptionKey(this.getId());
    }

    public final boolean isAbstractType() {
        return this.abstractType;
    }

    public final List<Scope> getScopeList() {
        return ScopeContainer.getScopeList(this.scopeContainer);
    }

    public final Stream<Scope> getScopes() {
        return ScopeContainer.getScopes(this.scopeContainer);
    }

    public final void copyScopes(Collection<Scope> scopes) {
        this.scopeContainer = ScopeContainer.setScopes(this.scopeContainer, scopes);
    }

    public final void addScope(Scope scope) {
        this.scopeContainer = ScopeContainer.addScope(this.scopeContainer, scope);
    }

    public final void removeScope(Scope scope) {
        ScopeContainer.removeScope(this.scopeContainer, scope);
    }

    public boolean appliesTo(FreeColObject fco) {
        return ScopeContainer.scopeContainerAppliesTo(this.scopeContainer, fco);
    }

    @Override
    public final String getNameKey() {
        return Messages.nameKey(this.getId());
    }

    @Override
    public final FeatureContainer getFeatureContainer() {
        if (this.featureContainer == null) {
            this.featureContainer = new FeatureContainer();
        }
        return this.featureContainer;
    }

    @Override
    public <T extends FreeColObject> boolean copyIn(T other) {
        FreeColSpecObjectType o = this.copyInCast(other, FreeColSpecObjectType.class);
        if (o == null || !super.copyIn(o)) {
            return false;
        }
        this.abstractType = o.isAbstractType();
        this.featureContainer.copy(o.getFeatureContainer());
        this.scopeContainer = ScopeContainer.setScopes(this.scopeContainer, o.getScopeList());
        this.index = o.getIndex();
        return true;
    }

    @Override
    protected void writeChildren(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeChildren(xw);
        for (Ability ability : CollectionUtils.sort(this.getAbilities())) {
            ability.toXML(xw);
        }
        for (Modifier modifier : this.getSortedModifiers()) {
            modifier.toXML(xw);
        }
        ScopeContainer.scopeContainerToXML(this.scopeContainer, xw);
    }

    @Override
    protected void readAttributes(FreeColXMLReader xr) throws XMLStreamException {
        super.readAttributes(xr);
        this.abstractType = xr.getAttribute(ABSTRACT_TAG, false);
    }

    @Override
    protected void readChildren(FreeColXMLReader xr) throws XMLStreamException {
        if (xr.shouldClearContainers()) {
            if (this.featureContainer != null) {
                this.featureContainer.clear();
            }
            ScopeContainer.clearScopes(this.scopeContainer);
        }
        super.readChildren(xr);
    }

    @Override
    protected void readChild(FreeColXMLReader xr) throws XMLStreamException {
        Specification spec = this.getSpecification();
        String tag = xr.getLocalName();
        if ("ability".equals(tag)) {
            if (xr.getAttribute(DELETE_TAG, false)) {
                this.removeAbilities(xr.readId());
                xr.closeTag("ability");
            } else {
                Ability ability = new Ability(xr, spec);
                if (ability.getSource() == null) {
                    ability.setSource(this);
                }
                this.addAbility(ability);
                spec.addAbility(ability);
            }
        } else if ("modifier".equals(tag)) {
            if (xr.getAttribute(DELETE_TAG, false)) {
                this.removeModifiers(xr.readId());
                xr.closeTag("modifier");
            } else {
                Modifier modifier = new Modifier(xr, spec);
                if (modifier.getSource() == null) {
                    modifier.setSource(this);
                }
                this.addModifier(modifier);
                spec.addModifier(modifier);
            }
        } else if ("scope".equals(tag)) {
            this.scopeContainer = ScopeContainer.addScope(this.scopeContainer, new Scope(xr));
        } else {
            super.readChild(xr);
        }
    }

    @Override
    public String toString() {
        return this.getId();
    }
}

