/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.List;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import net.sf.freecol.common.io.FreeColRules;
import net.sf.freecol.common.io.FreeColSavegameFile;
import net.sf.freecol.common.io.FreeColXMLWriter;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.FreeColObject;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.option.OptionGroup;
import net.sf.freecol.server.ServerTestHelper;
import net.sf.freecol.server.model.ServerGame;
import net.sf.freecol.util.test.FreeColTestCase;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class SerializationTest
extends FreeColTestCase {
    private static Validator buildValidator(String path) throws SAXException {
        SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        File schemaLocation = new File(path);
        Schema schema = factory.newSchema(schemaLocation);
        return schema.newValidator();
    }

    private Source buildSource(FreeColObject object) throws Exception {
        return new StreamSource(new StringReader(object.serialize()));
    }

    private void validateMap(String name) throws Exception {
        try {
            Validator mapValidator = SerializationTest.buildValidator("schema/data/data-savedGame.xsd");
            FreeColSavegameFile mapFile = new FreeColSavegameFile(new File(name));
            mapValidator.validate(new StreamSource(mapFile.getSavegameInputStream()));
        }
        catch (SAXParseException e) {
            String errMsg = e.getMessage() + " at line=" + e.getLineNumber() + " column=" + e.getColumnNumber();
            SerializationTest.fail((String)errMsg);
        }
    }

    private void logParseFailure(SAXParseException e, String serialized) {
        int col = e.getColumnNumber();
        String errMsg = e.getMessage() + "\nAt line=" + e.getLineNumber() + ", column=" + col + ":\n" + serialized.substring(Math.max(0, col - 100), Math.min(col + 100, serialized.length()));
        SerializationTest.fail((String)errMsg);
    }

    public void testValidation() throws Exception {
        ServerGame game = ServerTestHelper.startServerGame(SerializationTest.getTestMap(true));
        Colony colony = this.getStandardColony(6);
        Player player = game.getPlayerByNationId("model.nation.dutch");
        ServerTestHelper.newTurn();
        ServerTestHelper.newTurn();
        String serialized = null;
        try {
            Validator validator = SerializationTest.buildValidator("schema/data/data-game.xsd");
            serialized = game.serialize();
            validator.validate(new StreamSource(new StringReader(serialized)));
        }
        catch (SAXParseException e) {
            int col = e.getColumnNumber();
            String errMsg = e.getMessage() + "\nAt line=" + e.getLineNumber() + ", column=" + col + ":\n";
            if (serialized != null) {
                errMsg = errMsg + serialized.substring(Math.max(0, col - 100), Math.min(col + 100, serialized.length()));
            }
            SerializationTest.fail((String)errMsg);
        }
        ServerTestHelper.stopServerGame();
    }

    public void testStandardMaps() throws Exception {
        for (String name : FreeColTestCase.STANDARD_MAPS) {
            this.validateMap(name);
        }
    }

    public void testStringTemplate() throws Exception {
        Object t1 = ((StringTemplate)StringTemplate.template("model.goods.goodsAmount").add("%goods%", "model.goods.food.name")).addName("%amount%", "100");
        Object t2 = ((StringTemplate)StringTemplate.template("model.goods.goodsAmount").addAmount("%amount%", 50)).addStringTemplate("%goods%", (StringTemplate)t1);
        Game game = SerializationTest.getGame();
        Player player = game.getPlayerByNationId("model.nation.dutch");
        try {
            Validator validator = SerializationTest.buildValidator("schema/data/data-stringTemplate.xsd");
            validator.validate(this.buildSource((FreeColObject)t2));
        }
        catch (SAXParseException e) {
            String errMsg = e.getMessage() + " at line=" + e.getLineNumber() + " column=" + e.getColumnNumber();
            SerializationTest.fail((String)errMsg);
        }
    }

    public void testSpecification() throws Exception {
        try {
            String filename = "test/data/specification.xml";
            Validator validator = SerializationTest.buildValidator("schema/specification-schema.xsd");
            FileOutputStream fos = new FileOutputStream(filename);
            try (FreeColXMLWriter xw = new FreeColXMLWriter(fos, null, false);){
                SerializationTest.spec().toXML(xw);
            }
            catch (IOException ioe) {
                SerializationTest.fail((String)ioe.getMessage());
            }
            validator.validate(new StreamSource(new FileReader(filename)));
        }
        catch (SAXParseException e) {
            String errMsg = e.getMessage() + " at line=" + e.getLineNumber() + " column=" + e.getColumnNumber();
            SerializationTest.fail((String)errMsg);
        }
    }

    public void testDifficulty() throws Exception {
        Specification spec1 = null;
        Specification spec2 = null;
        spec1 = FreeColRules.getFreeColRulesFile("classic").getSpecification();
        spec1.applyDifficultyLevel("model.difficulty.veryEasy");
        StringWriter sw = new StringWriter();
        try (FreeColXMLWriter xw = new FreeColXMLWriter(sw, FreeColXMLWriter.WriteScope.toSave());){
            spec1.toXML(xw);
        }
        catch (IOException ioe) {
            SerializationTest.fail((String)ioe.getMessage());
        }
        spec2 = new Specification(new ByteArrayInputStream(sw.toString().getBytes()));
        SerializationTest.assertNotNull((Object)spec1);
        SerializationTest.assertNotNull((Object)spec2);
        OptionGroup level1 = spec1.getDifficultyOptionGroup();
        OptionGroup level2 = spec2.getDifficultyOptionGroup();
        SerializationTest.assertNotNull((Object)level1);
        SerializationTest.assertNotNull((Object)level2);
        SerializationTest.assertEquals((String)level1.getId(), (String)level2.getId());
        try {
            int increment1 = spec1.getInteger("model.option.crossesIncrement");
            int increment2 = spec2.getInteger("model.option.crossesIncrement");
            SerializationTest.assertEquals((int)increment1, (int)increment2);
        }
        catch (Exception e) {
            SerializationTest.fail((String)e.getMessage());
        }
    }

    public void testGeneratedLists() throws Exception {
        Specification spec1 = null;
        Specification spec2 = null;
        spec1 = FreeColRules.getFreeColRulesFile("classic").getSpecification();
        spec1.applyDifficultyLevel("model.difficulty.veryEasy");
        StringWriter sw = new StringWriter();
        try (FreeColXMLWriter xw = new FreeColXMLWriter(sw, FreeColXMLWriter.WriteScope.toSave(), false);){
            spec1.toXML(xw);
        }
        catch (IOException ioe) {
            SerializationTest.fail((String)ioe.getMessage());
        }
        spec2 = new Specification(new ByteArrayInputStream(sw.toString().getBytes()));
        List<GoodsType> food1 = spec1.getFoodGoodsTypeList();
        List<GoodsType> food2 = spec2.getFoodGoodsTypeList();
        SerializationTest.assertEquals((int)food1.size(), (int)food2.size());
        SerializationTest.assertEquals((String)food1.get(0).getId(), (String)food2.get(0).getId());
        List<GoodsType> farmed1 = spec1.getFarmedGoodsTypeList();
        List<GoodsType> farmed2 = spec2.getFarmedGoodsTypeList();
        SerializationTest.assertEquals((int)farmed1.size(), (int)farmed2.size());
        SerializationTest.assertEquals((String)farmed1.get(0).getId(), (String)farmed2.get(0).getId());
    }
}

