/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.option;

import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.io.FreeColXMLWriter;
import net.sf.freecol.common.model.FreeColObject;
import net.sf.freecol.common.model.FreeColSpecObject;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.option.AbstractUnitOption;
import net.sf.freecol.common.option.AudioMixerOption;
import net.sf.freecol.common.option.BooleanOption;
import net.sf.freecol.common.option.FileOption;
import net.sf.freecol.common.option.IntegerOption;
import net.sf.freecol.common.option.LanguageOption;
import net.sf.freecol.common.option.ModListOption;
import net.sf.freecol.common.option.ModOption;
import net.sf.freecol.common.option.Option;
import net.sf.freecol.common.option.OptionGroup;
import net.sf.freecol.common.option.PercentageOption;
import net.sf.freecol.common.option.RangeOption;
import net.sf.freecol.common.option.SelectOption;
import net.sf.freecol.common.option.StringOption;
import net.sf.freecol.common.option.TextOption;
import net.sf.freecol.common.option.UnitListOption;
import net.sf.freecol.common.option.UnitTypeOption;

public abstract class AbstractOption<T>
extends FreeColSpecObject
implements Option<T> {
    private static final Logger logger = Logger.getLogger(AbstractOption.class.getName());
    private static final String ENABLED_BY_TAG = "enabledBy";
    private String optionGroupId = "";
    protected boolean isDefined = false;
    private String enabledBy = null;
    protected static final String ACTION_TAG = "action";
    protected static final String DEFAULT_VALUE_TAG = "defaultValue";

    protected AbstractOption(String id, Specification specification) {
        super(specification);
        this.setId(id);
    }

    protected AbstractOption(String id) {
        this(id, null);
    }

    public AbstractOption(Specification specification) {
        this(null, specification);
    }

    protected void setValues(AbstractOption<T> source) {
        this.setId(source.getId());
        this.setSpecification(source.getSpecification());
        this.setValue(source.getValue());
        this.setGroup(source.getGroup());
        this.isDefined = source.isDefined;
    }

    protected void setValue(String valueString, String defaultValueString) throws XMLStreamException {
        throw new XMLStreamException("setValue unsupported: " + this);
    }

    public void generateChoices() {
    }

    public boolean isNullValueOK() {
        return false;
    }

    @Override
    public abstract AbstractOption<T> cloneOption() throws CloneNotSupportedException;

    @Override
    public String getGroup() {
        return this.optionGroupId;
    }

    @Override
    public void setGroup(String group) {
        this.optionGroupId = group == null ? "" : group;
    }

    @Override
    public abstract T getValue();

    @Override
    public abstract void setValue(T var1);

    @Override
    public String getEnabledBy() {
        return this.enabledBy;
    }

    @Override
    protected void readAttributes(FreeColXMLReader xr) throws XMLStreamException {
        super.readAttributes(xr);
        String defaultValue = xr.getAttribute(DEFAULT_VALUE_TAG, null);
        String value = xr.getAttribute("value", null);
        if (defaultValue == null && value == null) {
            if (!this.isNullValueOK()) {
                throw new XMLStreamException("invalid option " + this.getId() + ": no value nor default value found.");
            }
        } else {
            this.setValue(value, defaultValue);
        }
        this.enabledBy = xr.getAttribute(ENABLED_BY_TAG, null);
    }

    @Override
    protected void writeAttributes(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeAttributes(xw);
        if (this.enabledBy != null) {
            xw.writeAttribute(ENABLED_BY_TAG, this.enabledBy);
        }
    }

    protected AbstractOption readOption(FreeColXMLReader xr) throws XMLStreamException {
        Specification spec = this.getSpecification();
        String tag = xr.getLocalName();
        FreeColObject option = null;
        if (ACTION_TAG.equals(tag)) {
            xr.nextTag();
        } else if ("unitOption".equals(tag)) {
            option = new AbstractUnitOption(spec);
        } else if ("audioMixerOption".equals(tag)) {
            option = new AudioMixerOption(spec);
        } else if ("booleanOption".equals(tag)) {
            option = new BooleanOption(spec);
        } else if ("fileOption".equals(tag)) {
            option = new FileOption(spec);
        } else if ("integerOption".equals(tag)) {
            option = new IntegerOption(spec);
        } else if ("languageOption".equals(tag)) {
            option = new LanguageOption(spec);
        } else if ("modListOption".equals(tag)) {
            option = new ModListOption(spec);
        } else if ("modOption".equals(tag)) {
            option = new ModOption(spec);
        } else if ("optionGroup".equals(tag)) {
            option = new OptionGroup(spec);
        } else if ("percentageOption".equals(tag)) {
            option = new PercentageOption(spec);
        } else if ("rangeOption".equals(tag)) {
            option = new RangeOption(spec);
        } else if ("selectOption".equals(tag)) {
            option = new SelectOption(spec);
        } else if ("stringOption".equals(tag)) {
            option = new StringOption(spec);
        } else if ("unitListOption".equals(tag)) {
            option = new UnitListOption(spec);
        } else if ("unitTypeOption".equals(tag)) {
            option = new UnitTypeOption(spec);
        } else if ("textOption".equals(tag)) {
            option = new TextOption(spec);
        } else {
            logger.warning("Not an option type: " + tag);
            xr.nextTag();
        }
        if (option != null) {
            option.readFromXML(xr);
            ((AbstractOption)option).generateChoices();
        }
        return option;
    }
}

