/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.utils;

import java.util.ArrayList;
import java.util.List;
import net.sf.freecol.common.util.CollectionUtils;
import net.sf.freecol.util.test.FreeColTestCase;

public class UtilsTest
extends FreeColTestCase {
    private List<Integer> makeList(int ... args) {
        ArrayList<Integer> l = new ArrayList<Integer>();
        for (int a : args) {
            l.add(a);
        }
        return l;
    }

    public void testGetPermutations() {
        ArrayList<Integer> l = new ArrayList<Integer>();
        l.add(1);
        l.add(2);
        l.add(3);
        ArrayList p = new ArrayList();
        for (List li : CollectionUtils.getPermutations(l)) {
            p.add(li);
        }
        UtilsTest.assertEquals((int)p.size(), (int)6);
        UtilsTest.assertEquals(p.get(0), this.makeList(1, 2, 3));
        UtilsTest.assertEquals(p.get(1), this.makeList(1, 3, 2));
        UtilsTest.assertEquals(p.get(2), this.makeList(2, 1, 3));
        UtilsTest.assertEquals(p.get(3), this.makeList(2, 3, 1));
        UtilsTest.assertEquals(p.get(4), this.makeList(3, 1, 2));
        UtilsTest.assertEquals(p.get(5), this.makeList(3, 2, 1));
    }

    public void testComparator() {
        ArrayList<Double> d = new ArrayList<Double>();
        d.add(1.0);
        d.add(2.0);
        d.add(3.0);
        d.sort(CollectionUtils.descendingDoubleComparator);
        UtilsTest.assertEquals(d.get(0), (Object)3.0);
        d.sort(CollectionUtils.ascendingDoubleComparator);
        UtilsTest.assertEquals(d.get(0), (Object)1.0);
        ArrayList<List<Object>> o = new ArrayList<List<Object>>();
        ArrayList<Integer> o1 = new ArrayList<Integer>();
        ArrayList<Integer> o2 = new ArrayList<Integer>();
        ArrayList<Integer> o3 = new ArrayList<Integer>();
        o.add(o1);
        o.add(o2);
        o.add(o3);
        o1.add(1);
        o2.add(1);
        o2.add(2);
        o3.add(1);
        o3.add(2);
        o3.add(3);
        o.sort(CollectionUtils.descendingListLengthComparator);
        UtilsTest.assertEquals(o.get(0), o3);
    }
}

