/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.ai;

import net.sf.freecol.common.model.BuildingType;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.Direction;
import net.sf.freecol.common.model.IndianSettlement;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Stance;
import net.sf.freecol.common.model.Tension;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.TileType;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.util.LogBuilder;
import net.sf.freecol.server.ServerTestHelper;
import net.sf.freecol.server.ai.AIMain;
import net.sf.freecol.server.ai.AIUnit;
import net.sf.freecol.server.ai.NativeAIPlayer;
import net.sf.freecol.server.ai.mission.DefendSettlementMission;
import net.sf.freecol.server.ai.mission.UnitSeekAndDestroyMission;
import net.sf.freecol.server.ai.mission.UnitWanderHostileMission;
import net.sf.freecol.server.control.InGameController;
import net.sf.freecol.server.model.ServerGame;
import net.sf.freecol.server.model.ServerPlayer;
import net.sf.freecol.server.model.ServerUnit;
import net.sf.freecol.util.test.FreeColTestCase;
import net.sf.freecol.util.test.FreeColTestUtils;

public class MissionAssignmentTest
extends FreeColTestCase {
    private static final BuildingType stockadeType = MissionAssignmentTest.spec().getBuildingType("model.building.stockade");
    private static final TileType plainsType = MissionAssignmentTest.spec().getTileType("model.tile.plains");
    private static final UnitType colonistType = MissionAssignmentTest.spec().getUnitType("model.unit.freeColonist");
    private static final UnitType veteranType = MissionAssignmentTest.spec().getUnitType("model.unit.veteranSoldier");
    private static final UnitType braveType = MissionAssignmentTest.spec().getUnitType("model.unit.brave");
    private static final UnitType artilleryType = MissionAssignmentTest.spec().getUnitType("model.unit.artillery");
    private static final UnitType galleonType = MissionAssignmentTest.spec().getUnitType("model.unit.galleon");
    final int MISSION_IMPOSSIBLE = Integer.MIN_VALUE;
    private LogBuilder lb = new LogBuilder(0);

    @Override
    public void tearDown() throws Exception {
        ServerTestHelper.stopServerGame();
        super.tearDown();
    }

    public void testImpossibleConditionsForTargetSelection() {
        ServerGame game = ServerTestHelper.startServerGame(MissionAssignmentTest.getCoastTestMap(plainsType));
        Map map = game.getMap();
        AIMain aiMain = ServerTestHelper.getServer().getAIMain();
        ServerPlayer dutch = this.getServerPlayer(game, "model.nation.dutch");
        Tile tile1 = map.getTile(2, 2);
        Tile tile2 = map.getTile(2, 1);
        ServerUnit soldier = new ServerUnit(game, tile1, dutch, veteranType);
        ServerUnit friendlyColonist = new ServerUnit(game, tile2, dutch, colonistType);
        AIUnit aiUnit = aiMain.getAIUnit(soldier);
        MissionAssignmentTest.assertNotNull((Object)aiUnit);
        ServerPlayer french = this.getServerPlayer(game, "model.nation.french");
        Tile tile3 = map.getTile(1, 2);
        ServerUnit enemyColonist = new ServerUnit(game, tile3, french, colonistType);
        Tile tile4 = map.getTile(12, 12);
        MissionAssignmentTest.assertFalse((String)"Tle should be water", (boolean)tile4.isLand());
        ServerUnit enemyGalleon = new ServerUnit(game, tile4, french, galleonType);
        MissionAssignmentTest.assertNotNull((String)"Cannot attack own unit", (Object)UnitSeekAndDestroyMission.invalidMissionReason(aiUnit, friendlyColonist));
        MissionAssignmentTest.assertNotNull((String)"Players are not at war", (Object)UnitSeekAndDestroyMission.invalidMissionReason(aiUnit, enemyColonist));
        dutch.setStance(french, Stance.WAR);
        french.setStance(dutch, Stance.WAR);
        MissionAssignmentTest.assertEquals((String)"Unit should be able to attack land unit", null, (String)UnitSeekAndDestroyMission.invalidMissionReason(aiUnit, enemyColonist));
        MissionAssignmentTest.assertNotNull((String)"Land unit cannot attack naval unit", (Object)UnitSeekAndDestroyMission.invalidMissionReason(aiUnit, enemyGalleon));
    }

    public void testIsTargetValidForSeekAndDestroy() {
        ServerGame game = ServerTestHelper.startServerGame(MissionAssignmentTest.getTestMap());
        Map map = game.getMap();
        AIMain aiMain = ServerTestHelper.getServer().getAIMain();
        ServerPlayer incaPlayer = this.getServerPlayer(game, "model.nation.inca");
        NativeAIPlayer aiInca = (NativeAIPlayer)aiMain.getAIPlayer(incaPlayer);
        ServerPlayer dutchPlayer = this.getServerPlayer(game, "model.nation.dutch");
        Tile dutchUnitTile = map.getTile(9, 9);
        Tile braveUnitTile = map.getTile(9, 8);
        ServerUnit brave = new ServerUnit(game, braveUnitTile, incaPlayer, braveType);
        ServerUnit soldier = new ServerUnit(game, dutchUnitTile, dutchPlayer, veteranType);
        Player.makeContact(incaPlayer, dutchPlayer);
        MissionAssignmentTest.assertFalse((String)"Target should NOT be valid for UnitSeekAndDestroyMission", (boolean)aiInca.isTargetValidForSeekAndDestroy(brave, soldier.getTile()));
        incaPlayer.setTension(dutchPlayer, new Tension(Tension.Level.HATEFUL.getLimit()));
        MissionAssignmentTest.assertTrue((String)"Target should be valid for UnitSeekAndDestroyMission", (boolean)aiInca.isTargetValidForSeekAndDestroy(brave, soldier.getTile()));
        incaPlayer.setStance(dutchPlayer, Stance.WAR);
        dutchPlayer.setStance(incaPlayer, Stance.WAR);
        MissionAssignmentTest.assertTrue((String)"Target should be valid for UnitSeekAndDestroyMission", (boolean)aiInca.isTargetValidForSeekAndDestroy(brave, soldier.getTile()));
    }

    public void testAssignDefendSettlementMission() {
        ServerGame game = ServerTestHelper.startServerGame(MissionAssignmentTest.getTestMap());
        Map map = game.getMap();
        AIMain aiMain = ServerTestHelper.getServer().getAIMain();
        ServerPlayer dutch = this.getServerPlayer(game, "model.nation.dutch");
        Tile tile1 = map.getTile(2, 2);
        ServerUnit soldier = new ServerUnit(game, tile1, dutch, veteranType);
        AIUnit aiUnit = aiMain.getAIUnit(soldier);
        MissionAssignmentTest.assertNotNull((Object)aiUnit);
        Tile colonyTile = map.getTile(2, 3);
        MissionAssignmentTest.assertTrue((colonyTile != null ? 1 : 0) != 0);
        colonyTile.setExplored(dutch, true);
        Colony colony = FreeColTestUtils.getColonyBuilder().player(dutch).colonyTile(colonyTile).build();
        MissionAssignmentTest.assertTrue((colonyTile.getSettlement() == colony ? 1 : 0) != 0);
        MissionAssignmentTest.assertTrue((colony.getOwner() == dutch ? 1 : 0) != 0);
        MissionAssignmentTest.assertTrue((colony.getUnitCount() == 1 ? 1 : 0) != 0);
        aiUnit.setMission(null);
        MissionAssignmentTest.assertEquals((String)"DefendSettlementMission should be possible", null, (String)DefendSettlementMission.invalidMissionReason(aiUnit));
        MissionAssignmentTest.assertEquals((String)"DefendSettlementMission should work with colony", null, (String)DefendSettlementMission.invalidMissionReason(aiUnit, colony));
    }

    public void testSecureIndianSettlementMission() {
        ServerGame game = ServerTestHelper.startServerGame(MissionAssignmentTest.getTestMap());
        Map map = game.getMap();
        AIMain aiMain = ServerTestHelper.getServer().getAIMain();
        ServerPlayer inca = this.getServerPlayer(game, "model.nation.inca");
        NativeAIPlayer aiInca = (NativeAIPlayer)aiMain.getAIPlayer(inca);
        ServerPlayer dutch = this.getServerPlayer(game, "model.nation.dutch");
        Tile settlementTile = map.getTile(9, 9);
        Tile adjacentTile = settlementTile.getNeighbourOrNull(Direction.N);
        MissionAssignmentTest.assertTrue((String)"Settlement tile should be land", (boolean)settlementTile.isLand());
        MissionAssignmentTest.assertTrue((String)"Adjacent tile should be land", (adjacentTile != null && adjacentTile.isLand() ? 1 : 0) != 0);
        FreeColTestCase.IndianSettlementBuilder builder = new FreeColTestCase.IndianSettlementBuilder(game);
        IndianSettlement camp = builder.player(inca).settlementTile(settlementTile).initialBravesInCamp(8).build();
        MissionAssignmentTest.assertEquals((String)"One camp", (int)1, (int)inca.getSettlementCount());
        ServerUnit braveOutside = new ServerUnit(game, settlementTile, inca, braveType);
        braveOutside.changeHomeIndianSettlement(camp);
        int enemyUnits = camp.getUnitCount() + 1;
        for (int i = 0; i < enemyUnits; ++i) {
            new ServerUnit(game, adjacentTile, dutch, veteranType);
        }
        for (Unit brave : camp.getOwnedUnitList()) {
            MissionAssignmentTest.assertNotNull((String)"Got null while getting the camps units", (Object)brave);
            AIUnit aiUnit = aiMain.getAIUnit(brave);
            MissionAssignmentTest.assertNotNull((String)"Couldnt get the ai object for the brave", (Object)aiUnit);
            new UnitWanderHostileMission(aiMain, aiUnit);
            MissionAssignmentTest.assertTrue((String)"Should be UnitWanderHostileMission", (boolean)aiUnit.hasMission(UnitWanderHostileMission.class));
            MissionAssignmentTest.assertEquals((String)"Unit should be candidate for seek+destroy", null, (String)UnitSeekAndDestroyMission.invalidMissionReason(aiUnit));
            MissionAssignmentTest.assertEquals((String)"Unit should be candidate for defend", null, (String)DefendSettlementMission.invalidMissionReason(aiUnit));
        }
        inca.setStance(dutch, Stance.WAR);
        inca.setTension(dutch, new Tension(Tension.Level.HATEFUL.getLimit()));
        camp.setAlarm(dutch, inca.getTension(dutch));
        MissionAssignmentTest.assertTrue((String)"Indian player should be at war with dutch", (inca.getStance(dutch) == Stance.WAR ? 1 : 0) != 0);
        MissionAssignmentTest.assertEquals((String)"Wrong Indian player tension towards dutch", (int)Tension.Level.HATEFUL.getLimit(), (int)inca.getTension(dutch).getValue());
        aiInca.secureIndianSettlement(camp, this.lb);
        boolean isSeekAndDestroyMission = false;
        for (Unit brave : inca.getUnitSet()) {
            AIUnit aiUnit = aiMain.getAIUnit(brave);
            MissionAssignmentTest.assertNotNull((String)"Couldnt get aiUnit for players brave", (Object)aiUnit);
            MissionAssignmentTest.assertNotNull((String)"Unit missing mission", (Object)aiUnit.getMission());
            isSeekAndDestroyMission = aiUnit.hasMission(UnitSeekAndDestroyMission.class);
            if (!isSeekAndDestroyMission) continue;
            break;
        }
        MissionAssignmentTest.assertTrue((String)"A brave should have a UnitSeekAndDestroyMission", (boolean)isSeekAndDestroyMission);
    }

    public void testSecureIndianSettlementMissionIgnoreNavalThreat() {
        ServerGame game = ServerTestHelper.startServerGame(MissionAssignmentTest.getCoastTestMap(plainsType));
        Map map = game.getMap();
        AIMain aiMain = ServerTestHelper.getServer().getAIMain();
        InGameController igc = ServerTestHelper.getInGameController();
        ServerPlayer inca = this.getServerPlayer(game, "model.nation.inca");
        NativeAIPlayer aiInca = (NativeAIPlayer)aiMain.getAIPlayer(inca);
        ServerPlayer dutch = this.getServerPlayer(game, "model.nation.dutch");
        Tile settlementTile = map.getTile(9, 9);
        Tile seaTile = map.getTile(10, 9);
        MissionAssignmentTest.assertTrue((String)"Settlement tile should be land", (boolean)settlementTile.isLand());
        MissionAssignmentTest.assertFalse((String)"Galleon tile should be ocean", (boolean)seaTile.isLand());
        FreeColTestCase.IndianSettlementBuilder builder = new FreeColTestCase.IndianSettlementBuilder(game);
        IndianSettlement camp = builder.player(inca).settlementTile(settlementTile).initialBravesInCamp(10).build();
        ServerUnit galleon = new ServerUnit(game, seaTile, dutch, galleonType);
        int unitsInGalleon = 6;
        for (int i = 0; i < unitsInGalleon; ++i) {
            ServerUnit artillery = new ServerUnit(game, settlementTile, dutch, artilleryType);
            igc.embarkUnit(dutch, artillery, galleon);
        }
        MissionAssignmentTest.assertEquals((String)"Wrong number of units onboard galleon", (int)unitsInGalleon, (int)galleon.getUnitCount());
        MissionAssignmentTest.assertEquals((String)"Galleon should be full", (int)0, (int)galleon.getSpaceLeft());
        for (Unit brave : camp.getUnitList()) {
            AIUnit aiUnit = aiMain.getAIUnit(brave);
            MissionAssignmentTest.assertNotNull((Object)aiUnit);
            new UnitWanderHostileMission(aiMain, aiUnit);
            MissionAssignmentTest.assertTrue((String)"No enemy units present", (boolean)aiUnit.hasMission(UnitWanderHostileMission.class));
        }
        inca.setStance(dutch, Stance.WAR);
        inca.setTension(dutch, new Tension(Tension.Level.HATEFUL.getLimit()));
        MissionAssignmentTest.assertTrue((String)"Indian player should be at war with dutch", (inca.getStance(dutch) == Stance.WAR ? 1 : 0) != 0);
        MissionAssignmentTest.assertEquals((String)"Wrong Indian player tension towards dutch", (int)Tension.Level.HATEFUL.getLimit(), (int)inca.getTension(dutch).getValue());
        aiInca.abortInvalidMissions();
        aiInca.secureIndianSettlement(camp, this.lb);
        boolean seeking = false;
        for (Unit brave : inca.getUnitSet()) {
            AIUnit aiUnit = aiMain.getAIUnit(brave);
            MissionAssignmentTest.assertNotNull((Object)aiUnit);
            if (!aiUnit.hasMission(UnitSeekAndDestroyMission.class)) continue;
            seeking = true;
            break;
        }
        MissionAssignmentTest.assertFalse((String)"Braves should not pursue naval units", (boolean)seeking);
    }
}

