/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.control;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import net.sf.freecol.common.FreeColException;
import net.sf.freecol.common.model.Nation;
import net.sf.freecol.common.model.NationOptions;
import net.sf.freecol.common.model.NationType;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.networking.ChangeSet;
import net.sf.freecol.common.networking.Message;
import net.sf.freecol.common.networking.ReadyMessage;
import net.sf.freecol.common.networking.SetAvailableMessage;
import net.sf.freecol.common.networking.SetColorMessage;
import net.sf.freecol.common.networking.SetNationMessage;
import net.sf.freecol.common.networking.SetNationTypeMessage;
import net.sf.freecol.common.networking.UpdateGameOptionsMessage;
import net.sf.freecol.common.networking.UpdateMapGeneratorOptionsMessage;
import net.sf.freecol.common.networking.VacantPlayersMessage;
import net.sf.freecol.common.option.OptionGroup;
import net.sf.freecol.server.FreeColServer;
import net.sf.freecol.server.control.Controller;
import net.sf.freecol.server.model.ServerGame;
import net.sf.freecol.server.model.ServerPlayer;

public final class PreGameController
extends Controller {
    private static final Logger logger = Logger.getLogger(PreGameController.class.getName());
    private boolean launching = false;

    public PreGameController(FreeColServer freeColServer) {
        super(freeColServer);
    }

    private synchronized boolean setLaunching(boolean launching) {
        boolean old = this.launching;
        this.launching = launching;
        return old;
    }

    public ChangeSet ready(ServerPlayer serverPlayer, boolean ready) {
        serverPlayer.setReady(ready);
        this.getFreeColServer().sendToAll((Message)new ReadyMessage(serverPlayer, ready), serverPlayer);
        return null;
    }

    public ChangeSet requestLaunch(ServerPlayer serverPlayer) {
        logger.info("Launching for " + serverPlayer);
        if (this.setLaunching(true)) {
            logger.warning("Already launching");
            return null;
        }
        FreeColServer freeColServer = this.getFreeColServer();
        ServerGame game = this.getGame();
        Specification spec = game.getSpecification();
        if (!serverPlayer.isAdmin()) {
            this.setLaunching(false);
            return serverPlayer.clientError(StringTemplate.template("server.onlyAdminCanLaunch"));
        }
        serverPlayer.setReady(true);
        List<Player> players = game.getLivePlayerList(new Player[0]);
        ArrayList<Nation> nations = new ArrayList<Nation>(players.size());
        for (Player p : players) {
            Nation nation = spec.getNation(p.getNationId());
            if (nations.contains(nation)) {
                this.setLaunching(false);
                return serverPlayer.clientError(StringTemplate.template("server.invalidPlayerNations"));
            }
            nations.add(nation);
        }
        if (!game.allPlayersReadyToLaunch()) {
            this.setLaunching(false);
            return serverPlayer.clientError(StringTemplate.template("server.notAllReady"));
        }
        try {
            freeColServer.startGame();
        }
        catch (FreeColException fce) {
            return serverPlayer.clientError(fce.getMessage());
        }
        return null;
    }

    public ChangeSet setAvailable(ServerPlayer serverPlayer, Nation nation, NationOptions.NationState state) {
        this.getGame().getNationOptions().setNationState(nation, state);
        this.getFreeColServer().sendToAll((Message)new SetAvailableMessage(nation, state), serverPlayer);
        return null;
    }

    public ChangeSet setColor(ServerPlayer serverPlayer, Nation nation, Color color) {
        nation.setColor(color);
        this.getFreeColServer().sendToAll((Message)new SetColorMessage(nation, color), serverPlayer);
        return null;
    }

    public ChangeSet setNation(ServerPlayer serverPlayer, Nation nation) {
        serverPlayer.setNation(nation);
        this.getFreeColServer().sendToAll((Message)new SetNationMessage(serverPlayer, nation), serverPlayer);
        return null;
    }

    public ChangeSet setNationType(ServerPlayer serverPlayer, NationType nationType) {
        serverPlayer.changeNationType(nationType);
        this.getFreeColServer().sendToAll((Message)new SetNationTypeMessage(serverPlayer, nationType), serverPlayer);
        return null;
    }

    public ChangeSet updateGameOptions(ServerPlayer serverPlayer, OptionGroup options) {
        FreeColServer fcs = this.getFreeColServer();
        ServerGame game = fcs.getGame();
        Specification spec = game.getSpecification();
        if (!spec.mergeGameOptions(options, "server")) {
            return serverPlayer.clientError("Game option merge failed");
        }
        fcs.sendToAll((Message)new UpdateGameOptionsMessage(spec.getGameOptions()), serverPlayer);
        return null;
    }

    public ChangeSet updateMapGeneratorOptions(ServerPlayer serverPlayer, OptionGroup options) {
        FreeColServer fcs = this.getFreeColServer();
        ServerGame game = fcs.getGame();
        Specification spec = game.getSpecification();
        if (!spec.mergeMapGeneratorOptions(options, "server")) {
            return serverPlayer.clientError("Map option merge failed");
        }
        fcs.sendToAll((Message)new UpdateMapGeneratorOptionsMessage(spec.getMapGeneratorOptions()), serverPlayer);
        return null;
    }

    public ChangeSet vacantPlayers() {
        return ChangeSet.simpleChange((Player)null, (Message)new VacantPlayersMessage().setVacantPlayers(this.getFreeColServer().getGame()));
    }
}

