/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.logging.Logger;
import net.sf.freecol.common.FreeColException;
import net.sf.freecol.common.model.AbstractGoods;
import net.sf.freecol.common.model.AbstractUnit;
import net.sf.freecol.common.model.Europe;
import net.sf.freecol.common.model.FreeColSpecObjectType;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Role;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.networking.ChangeSet;
import net.sf.freecol.common.option.IntegerOption;
import net.sf.freecol.common.util.CollectionUtils;
import net.sf.freecol.common.util.LogBuilder;
import net.sf.freecol.common.util.RandomChoice;
import net.sf.freecol.common.util.RandomUtils;
import net.sf.freecol.server.model.ServerPlayer;
import net.sf.freecol.server.model.ServerUnit;
import net.sf.freecol.server.model.TurnTaker;

public class ServerEurope
extends Europe
implements TurnTaker {
    private static final Logger logger = Logger.getLogger(ServerEurope.class.getName());

    public ServerEurope(Game game, String id) {
        super(game, id);
    }

    public ServerEurope(Game game, Player owner) {
        super(game, owner);
    }

    @Override
    public boolean equipForRole(Unit unit, Role role, int roleCount) {
        if (!unit.roleIsAvailable(role)) {
            return false;
        }
        List<AbstractGoods> req = unit.getGoodsDifference(role, roleCount);
        try {
            int price = this.priceGoods(req);
            if (price > 0 && !unit.getOwner().checkGold(price)) {
                return false;
            }
        }
        catch (FreeColException fce) {
            return false;
        }
        Player owner = this.getOwner();
        for (AbstractGoods ag : CollectionUtils.transform(req, g -> g.getAmount() < 0)) {
            int rm = ((ServerPlayer)owner).sellInEurope(null, null, ag.getType(), -ag.getAmount());
            if (rm <= 0) continue;
            ((ServerPlayer)owner).addExtraTrade(new AbstractGoods(ag.getType(), rm));
        }
        for (AbstractGoods ag : CollectionUtils.transform(req, AbstractGoods::isPositive)) {
            int m = ((ServerPlayer)owner).buyInEurope(null, null, ag.getType(), ag.getAmount());
            if (m <= 0) continue;
            ((ServerPlayer)owner).addExtraTrade(new AbstractGoods(ag.getType(), -m));
        }
        unit.changeRole(role, roleCount);
        return true;
    }

    public void initializeMigration(Random random) {
        Specification spec = this.getGame().getSpecification();
        for (AbstractUnit au : spec.getUnitList("model.option.immigrants")) {
            this.addRecruitable(au, true);
        }
        this.fillRecruitables(random);
    }

    private void fillRecruitables(Random random) {
        UnitType unitType;
        List recruits = this.generateRecruitablesList();
        while (this.addRecruitable(unitType = (UnitType)RandomChoice.getWeightedRandom(logger, "Recruits", recruits, random), false)) {
        }
    }

    public void increaseRecruitmentDifficulty() {
        Specification spec = this.getSpecification();
        this.baseRecruitPrice += spec.getInteger("model.option.recruitPriceIncrease");
        this.recruitLowerCap += spec.getInteger("model.option.lowerCapIncrease");
    }

    public AbstractUnit extractRecruitable(int slot, Random random) {
        int count = Europe.MigrationType.getMigrantCount();
        int index = Europe.MigrationType.specificMigrantSlot(slot) ? Europe.MigrationType.migrantSlotToIndex(slot) : RandomUtils.randomInt(logger, "Choose emigrant", random, count);
        List<AbstractUnit> expanded = this.getExpandedRecruitables(true);
        AbstractUnit result = expanded.remove(index);
        this.recruitables.clear();
        AbstractUnit top = expanded.remove(0);
        this.recruitables.add(top);
        for (AbstractUnit au : expanded) {
            if (au.getId().equals(top.getId()) && au.getRoleId().equals(top.getRoleId())) {
                top.addToNumber(au.getNumber());
                continue;
            }
            this.recruitables.add(au);
            top = au;
        }
        this.fillRecruitables(random);
        return result;
    }

    private List<RandomChoice<UnitType>> generateRecruitablesList() {
        Player owner = this.getOwner();
        return CollectionUtils.transform(this.getSpecification().getUnitTypeList(), ut -> ut.isRecruitable() && owner.hasAbility("model.ability.canRecruitUnit", (FreeColSpecObjectType)ut), ut -> new RandomChoice<UnitType>((UnitType)ut, ut.getRecruitProbability()));
    }

    public boolean replaceRecruits(Random random) {
        Specification spec = this.getSpecification();
        boolean result = CollectionUtils.removeInPlace(this.recruitables, au -> !this.hasAbility("model.ability.canRecruitUnit", au.getType(spec)));
        this.fillRecruitables(random);
        return result;
    }

    public List<Unit> generateFountainRecruits(int n, Random random) {
        Game game = this.getGame();
        Player owner = this.getOwner();
        ArrayList<Unit> ret = new ArrayList<Unit>(n);
        List recruits = this.generateRecruitablesList();
        for (int k = 0; k < n; ++k) {
            UnitType ut = (UnitType)RandomChoice.getWeightedRandom(logger, "Choose FoY", recruits, random);
            ret.add(new ServerUnit(game, this, owner, ut));
        }
        return ret;
    }

    public void increasePrice(UnitType unitType, int price) {
        int increase;
        String baseOption;
        Specification spec = this.getSpecification();
        String option = spec.getBoolean(baseOption = "model.option.priceIncreasePerType") ? "model.option.priceIncrease." + unitType.getSuffix() : "model.option.priceIncrease";
        int n = increase = spec.hasOption(option, IntegerOption.class) ? spec.getInteger(option) : 0;
        if (increase != 0) {
            this.unitPrices.put(unitType, price + increase);
        }
    }

    public boolean csEquipForRole(Unit unit, Role role, int roleCount, Random random, ChangeSet cs) {
        boolean ret = this.equipForRole(unit, role, roleCount);
        if (ret) {
            Player owner = this.getOwner();
            cs.addPartial(ChangeSet.See.only(owner), owner, "gold", String.valueOf(owner.getGold()));
            cs.add(ChangeSet.See.only(owner), unit);
            ((ServerPlayer)owner).flushExtraTrades(random);
            ((ServerPlayer)owner).csFlushMarket(cs);
        }
        return ret;
    }

    @Override
    public void csNewTurn(Random random, LogBuilder lb, ChangeSet cs) {
        lb.add(this);
        for (Unit unit : CollectionUtils.transform(this.getUnits(), u -> u.isNaval() && u.isDamaged())) {
            ((ServerUnit)unit).csRepairUnit(cs);
        }
    }
}

