/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.model;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.ToIntFunction;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.stream.XMLStreamException;
import net.sf.freecol.FreeCol;
import net.sf.freecol.common.FreeColException;
import net.sf.freecol.common.debug.FreeColDebugger;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.i18n.NameCache;
import net.sf.freecol.common.model.AbstractGoods;
import net.sf.freecol.common.model.AbstractUnit;
import net.sf.freecol.common.model.Building;
import net.sf.freecol.common.model.BuildingType;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.CombatModel;
import net.sf.freecol.common.model.Constants;
import net.sf.freecol.common.model.DiplomaticTrade;
import net.sf.freecol.common.model.Disaster;
import net.sf.freecol.common.model.Effect;
import net.sf.freecol.common.model.Europe;
import net.sf.freecol.common.model.Event;
import net.sf.freecol.common.model.Feature;
import net.sf.freecol.common.model.Force;
import net.sf.freecol.common.model.FoundingFather;
import net.sf.freecol.common.model.FreeColGameObject;
import net.sf.freecol.common.model.FreeColObject;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.GoodsContainer;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.HistoryEvent;
import net.sf.freecol.common.model.IndianSettlement;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.Market;
import net.sf.freecol.common.model.ModelMessage;
import net.sf.freecol.common.model.Modifier;
import net.sf.freecol.common.model.Monarch;
import net.sf.freecol.common.model.Named;
import net.sf.freecol.common.model.Nation;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Role;
import net.sf.freecol.common.model.Settlement;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.Stance;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.Tension;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.TradeRoute;
import net.sf.freecol.common.model.Turn;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitChangeType;
import net.sf.freecol.common.model.UnitLocation;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.model.UnitTypeChange;
import net.sf.freecol.common.model.WorkLocation;
import net.sf.freecol.common.model.pathfinding.GoalDeciders;
import net.sf.freecol.common.networking.ChangeSet;
import net.sf.freecol.common.networking.ChooseFoundingFatherMessage;
import net.sf.freecol.common.networking.Connection;
import net.sf.freecol.common.networking.FirstContactMessage;
import net.sf.freecol.common.networking.IndianDemandMessage;
import net.sf.freecol.common.networking.LootCargoMessage;
import net.sf.freecol.common.networking.MonarchActionMessage;
import net.sf.freecol.common.networking.SetDeadMessage;
import net.sf.freecol.common.option.IntegerOption;
import net.sf.freecol.common.util.CollectionUtils;
import net.sf.freecol.common.util.LogBuilder;
import net.sf.freecol.common.util.RandomChoice;
import net.sf.freecol.common.util.RandomUtils;
import net.sf.freecol.server.model.DiplomacySession;
import net.sf.freecol.server.model.LootSession;
import net.sf.freecol.server.model.MonarchSession;
import net.sf.freecol.server.model.ServerColony;
import net.sf.freecol.server.model.ServerEurope;
import net.sf.freecol.server.model.ServerIndianSettlement;
import net.sf.freecol.server.model.ServerUnit;
import net.sf.freecol.server.model.TurnTaker;

public class ServerPlayer
extends Player
implements TurnTaker {
    private static final Logger logger = Logger.getLogger(ServerPlayer.class.getName());
    public static final int ALARM_RADIUS = 2;
    public static final int ALARM_TILE_IN_USE = 2;
    public static final int SCORE_SETTLEMENT_DESTROYED = -5;
    public static final int SCORE_NATION_DESTROYED = -50;
    public static final double SCORE_GOLD = 0.001;
    public static final int SCORE_FOUNDING_FATHER = 5;
    public static final int SCORE_INDEPENDENCE_BONUS_FIRST = 100;
    public static final int SCORE_INDEPENDENCE_BONUS_SECOND = 50;
    public static final int SCORE_INDEPENDENCE_BONUS_THIRD = 25;
    private Connection connection;
    private int remainingEmigrants = 0;
    private final List<Player> stanceDirty = new ArrayList<Player>();
    private final List<AbstractGoods> extraTrades = new ArrayList<AbstractGoods>();

    public ServerPlayer(Game game, String id) {
        super(game, id);
    }

    public ServerPlayer(Game game, Connection connection) {
        super(game);
        this.setConnection(connection);
    }

    public ServerPlayer(Game game, boolean admin, Nation nation) {
        super(game);
        this.setConnection(null);
        this.initialize(game, admin, nation);
    }

    public final void initialize(Game game, boolean admin, Nation nation) {
        if (nation == null) {
            throw new RuntimeException("Null nation: " + this);
        }
        this.name = nation.getRulerName();
        this.admin = admin;
        this.nationId = nation.getId();
        this.immigration = 0;
        if (nation.isUnknownEnemy()) {
            this.nationType = null;
            this.playerType = Player.PlayerType.COLONIAL;
            this.europe = null;
            this.monarch = null;
            this.gold = 0;
            this.setAI(true);
            this.setReady(true);
        } else if (nation.getType() != null) {
            this.nationType = nation.getType();
            this.addFeatures(this.nationType);
            if (this.nationType.isEuropean()) {
                this.playerType = this.nationType.isREF() ? Player.PlayerType.ROYAL : Player.PlayerType.COLONIAL;
                this.europe = new ServerEurope(game, this);
                this.initializeHighSeas();
                if (this.playerType == Player.PlayerType.COLONIAL) {
                    this.monarch = new Monarch(game, this);
                    Specification spec = game.getSpecification();
                    this.immigration = spec.getInteger("model.option.playerImmigrationBonus");
                }
                this.gold = 0;
            } else {
                this.playerType = Player.PlayerType.NATIVE;
                this.gold = Integer.MIN_VALUE;
            }
        } else {
            throw new RuntimeException("Bogus nation: " + nation);
        }
        this.market = new Market(this.getGame(), this);
        this.liberty = 0;
        this.currentFather = null;
    }

    @Override
    public final Connection getConnection() {
        return this.connection;
    }

    @Override
    public final void setConnection(Connection connection) {
        this.connection = connection;
    }

    @Override
    public boolean send(ChangeSet cs) {
        if (!this.isConnected()) {
            return false;
        }
        try {
            this.connection.request(cs.build(this));
        }
        catch (IOException | XMLStreamException | FreeColException ex) {
            logger.log(Level.WARNING, "send fail", ex);
            return false;
        }
        return true;
    }

    public void updateCurrentFather(FoundingFather ff) {
        this.setCurrentFather(ff);
        this.clearOfferedFathers();
        if (ff != null) {
            logger.finest(this.getId() + " is recruiting " + ff.getId() + " in " + this.getGame().getTurn());
        }
    }

    public TradeRoute newTradeRoute() {
        TradeRoute route = new TradeRoute(this.getGame(), this.getNameForTradeRoute(), this);
        this.addTradeRoute(route);
        return route;
    }

    public void addExtraTrade(AbstractGoods ag) {
        this.extraTrades.add(ag);
    }

    public void flushExtraTrades(Random random) {
        while (!this.extraTrades.isEmpty()) {
            AbstractGoods ag = this.extraTrades.remove(0);
            this.propagateToEuropeanMarkets(ag.getType(), ag.getAmount(), random);
        }
    }

    public void randomizeGame(Random random) {
        if (!this.isEuropean() || this.isREF() || this.isUnknownEnemy()) {
            return;
        }
        Specification spec = this.getGame().getSpecification();
        int i0 = spec.getInteger("model.option.initialImmigration");
        this.immigrationRequired = (int)this.apply(i0, null, "model.modifier.religiousUnrestBonus");
        this.modifyGold(spec.getInteger("model.option.startingMoney"));
        ((ServerEurope)this.getEurope()).initializeMigration(random);
        Market market = this.getMarket();
        StringBuilder sb = new StringBuilder();
        boolean changed = false;
        for (GoodsType type : spec.getGoodsTypeList()) {
            int add;
            String prefix = "model.option." + type.getSuffix("model.goods.");
            if (!spec.hasOption(prefix + ".minimumPrice", IntegerOption.class) || !spec.hasOption(prefix + ".maximumPrice", IntegerOption.class)) continue;
            int min = spec.getInteger(prefix + ".minimumPrice");
            int max = spec.getInteger(prefix + ".maximumPrice");
            if (max < min) {
                int bad = min;
                min = max;
                max = bad;
            } else if (max == min) continue;
            if ((add = RandomUtils.randomInt(logger, type.getId() + " initial price", random, max - min)) <= 0) continue;
            market.setInitialPrice(type, min + add);
            market.update(type);
            market.flushPriceChange(type);
            sb.append(", ").append(type.getId()).append(" -> ").append(min + add);
            changed = true;
        }
        if (changed) {
            logger.finest("randomizeGame(" + this.getId() + ") initial prices: " + sb.toString().substring(2));
        }
    }

    public DeadCheck checkForDeath() {
        int price;
        if (this.isUnknownEnemy()) {
            return DeadCheck.IS_ALIVE;
        }
        Specification spec = this.getGame().getSpecification();
        switch (this.getPlayerType()) {
            case NATIVE: 
            case UNDEAD: {
                return this.getUnitCount() == 0 ? DeadCheck.IS_DEAD : DeadCheck.IS_ALIVE;
            }
            case COLONIAL: {
                break;
            }
            case REBEL: 
            case INDEPENDENT: {
                return this.getNumberOfPorts() > 0 ? DeadCheck.IS_ALIVE : DeadCheck.IS_DEAD;
            }
            case ROYAL: {
                return this.checkForREFDefeat() ? DeadCheck.IS_DEFEATED : DeadCheck.IS_ALIVE;
            }
            default: {
                throw new RuntimeException("Bogus player type: " + this.getPlayerType());
            }
        }
        if (CollectionUtils.any(this.getColonies())) {
            return DeadCheck.IS_ALIVE;
        }
        if (!this.isAI() && FreeColDebugger.getDebugRunTurns() >= 0) {
            return DeadCheck.IS_ALIVE;
        }
        boolean hasCarrier = false;
        boolean hasColonist = false;
        boolean hasEmbarked = false;
        boolean hasGoods = false;
        for (Unit unit : this.getUnitSet()) {
            if (unit.isCarrier()) {
                if (unit.hasGoodsCargo()) {
                    hasGoods = true;
                }
                hasCarrier = true;
                continue;
            }
            if (!unit.isColonist() && !unit.isOffensiveUnit()) continue;
            hasColonist = true;
            Unit carrier = unit.getCarrier();
            if (carrier != null) {
                if (carrier.hasTile()) {
                    logger.info(this.getName() + " alive, unit " + unit.getId() + " (embarked) on map.");
                    return DeadCheck.IS_ALIVE;
                }
                hasEmbarked = true;
            }
            if (!unit.hasTile() || unit.isInMission()) continue;
            logger.info(this.getName() + " alive, unit " + unit.getId() + " on map.");
            return DeadCheck.IS_ALIVE;
        }
        int mandatory = spec.getInteger("model.option.mandatoryColonyYear");
        if (this.getGame().getTurn().getYear() >= mandatory) {
            logger.info(this.getName() + " dead, no presence >= " + mandatory);
            return DeadCheck.IS_DEAD;
        }
        if (hasEmbarked) {
            logger.info(this.getName() + " alive, has embarked unit.");
            return DeadCheck.IS_ALIVE;
        }
        if (hasGoods) {
            logger.info(this.getName() + " alive, has cargo.");
            return DeadCheck.IS_ALIVE;
        }
        Europe europe = this.getEurope();
        ToIntFunction<UnitType> unitPricer = ut -> {
            int p = europe.getUnitPrice((UnitType)ut);
            return p == Integer.MIN_VALUE ? Integer.MAX_VALUE : p;
        };
        int goldNeeded = 0;
        if (!hasCarrier) {
            int n = price = europe == null ? Integer.MAX_VALUE : CollectionUtils.min(spec.getUnitTypesWithAbility("model.ability.navalUnit"), unitPricer);
            if (price == Integer.MAX_VALUE || !this.checkGold(price)) {
                logger.info(this.getName() + " dead, can not buy carrier.");
                return DeadCheck.IS_DEAD;
            }
            goldNeeded += price;
        }
        if (hasColonist) {
            logger.info(this.getName() + " alive, has waiting colonist.");
            return DeadCheck.IS_ALIVE;
        }
        if (europe == null) {
            logger.info(this.getName() + " dead, can not recruit.");
            return DeadCheck.IS_DEAD;
        }
        price = Math.min(europe.getCurrentRecruitPrice(), CollectionUtils.min(spec.getUnitTypesWithAbility("model.ability.foundColony"), unitPricer));
        if (this.checkGold(goldNeeded += price)) {
            logger.info(this.getName() + " alive, can buy colonist.");
            return DeadCheck.IS_ALIVE;
        }
        logger.info(this.getName() + " survives by autorecruit.");
        return DeadCheck.IS_AUTORECRUIT;
    }

    private boolean checkForREFDefeat() {
        if (!this.isREF()) {
            return false;
        }
        if (this.getRebels().isEmpty()) {
            return false;
        }
        if (this.hasSettlements()) {
            return false;
        }
        int naval = 0;
        int land = 0;
        int landOnMap = 0;
        for (Unit u : this.getUnitSet()) {
            if (u.isNaval()) {
                ++naval;
                continue;
            }
            ++land;
            if (!u.isOnTile()) continue;
            ++landOnMap;
        }
        double presenceFactor = 0.6666666666666666;
        if ((double)landOnMap < 0.6666666666666666 * (double)land) {
            return false;
        }
        double refLandPower = 1.5 * (double)this.calculateStrength(false);
        for (Player r : this.getRebels()) {
            double rebelLandPower = r.calculateStrength(false);
            if (rebelLandPower < refLandPower) {
                return false;
            }
            logger.fine("REF in trouble wrt " + r.getName() + " (" + refLandPower + " <= " + rebelLandPower + ")");
        }
        int landREFUnitsRequired = 7;
        if (land < 7) {
            logger.info("REF surrenders due to land army collapse (" + land + " < 7)");
            return true;
        }
        int navalREFUnitsRequired = 2;
        if (naval < 2) {
            logger.info("REF surrenders due to lack of naval support (" + naval + " < 2)");
            return true;
        }
        return false;
    }

    private void csKill(ChangeSet cs) {
        Game game = this.getGame();
        this.setDead(true);
        cs.addPartial(ChangeSet.See.all(), this, "dead", Boolean.TRUE.toString());
        cs.add(ChangeSet.See.all(), new SetDeadMessage(this));
        for (Player player : game.getLivePlayerList(this)) {
            if (this.isEuropean() && player.isIndian()) {
                for (IndianSettlement is : player.getIndianSettlementList()) {
                    ServerIndianSettlement sis = (ServerIndianSettlement)is;
                    if (is.hasMissionary(this)) {
                        sis.csKillMissionary(null, cs);
                    }
                    is.getTile().cacheUnseen();
                    sis.removeAlarm(this);
                }
                player.removeTension(this);
            }
            player.setStance(this, null);
        }
        HashSet<Tile> tiles = new HashSet<Tile>(64);
        for (FreeColGameObject fcgo : game.getFreeColGameObjectList()) {
            Unit u;
            if (!(fcgo instanceof Unit) || !(u = (Unit)fcgo).hasTile() || this.owns(u)) continue;
            Tile t = u.getTile();
            cs.addRemove(ChangeSet.See.only(this), t, u);
            tiles.add(t);
        }
        cs.add(ChangeSet.See.only(this), tiles);
        List<Settlement> list = this.getSettlementList();
        while (!list.isEmpty()) {
            this.csDisposeSettlement(list.remove(0), cs);
        }
        tiles.clear();
        tiles.addAll(game.getMap().getTileList(CollectionUtils.matchKeyEquals(this, Tile::getOwner)));
        for (Tile t : tiles) {
            t.cacheUnseen();
            t.changeOwnership(null, null);
        }
        for (Unit u : this.getUnitSet()) {
            if (u.hasTile()) {
                tiles.add(u.getTile());
            }
            ((ServerUnit)u).csRemove(ChangeSet.See.perhaps().always(this), u.getLocation(), cs);
        }
        cs.add(ChangeSet.See.perhaps().always(this), tiles);
        if (this.market != null) {
            this.market.dispose();
            this.market = null;
        }
        if (this.monarch != null) {
            this.monarch.dispose();
            this.monarch = null;
        }
        if (this.europe != null) {
            this.europe.dispose();
            this.europe = null;
        }
        this.currentFather = null;
        if (this.foundingFathers != null) {
            this.foundingFathers.clear();
        }
        if (this.offeredFathers != null) {
            this.offeredFathers.clear();
        }
        if (this.tradeRoutes != null) {
            this.tradeRoutes.clear();
        }
        if (this.lastSales != null) {
            this.lastSales = null;
        }
        this.featureContainer.clear();
        this.invalidateCanSeeTiles();
    }

    public void csWithdraw(ChangeSet cs, ModelMessage mm, HistoryEvent he) {
        Game game = this.getGame();
        if (mm == null) {
            String key = this.isEuropean() ? "model.player.dead.european" : "model.player.dead.native";
            mm = (ModelMessage)new ModelMessage(ModelMessage.MessageType.FOREIGN_DIPLOMACY, key, this).addStringTemplate("%nation%", this.getNationLabel());
        }
        if (he == null) {
            he = (HistoryEvent)new HistoryEvent(game.getTurn(), HistoryEvent.HistoryEventType.NATION_DESTROYED, null).addStringTemplate("%nation%", this.getNationLabel());
        }
        cs.addGlobalMessage(game, null, mm);
        cs.addGlobalHistory(game, he);
        this.csKill(cs);
    }

    public int getRemainingEmigrants() {
        return this.remainingEmigrants;
    }

    public void setRemainingEmigrants(int emigrants) {
        this.remainingEmigrants = emigrants;
    }

    private FoundingFather checkFoundingFather() {
        int extraLiberty;
        FoundingFather father = null;
        if (this.currentFather != null && (extraLiberty = this.getRemainingFoundingFatherCost()) <= 0) {
            boolean overflow = this.getSpecification().getBoolean("model.option.saveProductionOverflow");
            this.setLiberty(overflow ? -extraLiberty : 0);
            father = this.currentFather;
            this.currentFather = null;
        }
        return father;
    }

    public boolean canRecruitFoundingFather() {
        Specification spec = this.getGame().getSpecification();
        switch (this.getPlayerType()) {
            case COLONIAL: {
                break;
            }
            case REBEL: 
            case INDEPENDENT: {
                if (spec.getBoolean("model.option.continueFoundingFatherRecruitment")) break;
                return false;
            }
            default: {
                return false;
            }
        }
        return this.currentFather == null && this.hasSettlements() && this.getFatherCount() < spec.getFoundingFathers().size() && this.canHaveFoundingFathers();
    }

    private List<FoundingFather> getRandomFoundingFathers(Random random) {
        Game game = this.getGame();
        Specification spec = game.getSpecification();
        int age = game.getAge();
        EnumMap choices = new EnumMap(FoundingFather.FoundingFatherType.class);
        for (FoundingFather father : CollectionUtils.transform(spec.getFoundingFathers(), ff -> !this.hasFather((FoundingFather)ff) && ff.isAvailableTo(this))) {
            FoundingFather.FoundingFatherType type = father.getType();
            ArrayList<RandomChoice<FoundingFather>> rc = (ArrayList<RandomChoice<FoundingFather>>)choices.get((Object)type);
            if (rc == null) {
                rc = new ArrayList<RandomChoice<FoundingFather>>();
            }
            int weight = father.getWeight(age);
            rc.add(new RandomChoice<FoundingFather>(father, weight));
            choices.put(father.getType(), rc);
        }
        Function<FoundingFather.FoundingFatherType, FoundingFather> mapper = ft -> {
            List rc = (List)choices.get(ft);
            return rc == null ? null : (FoundingFather)RandomChoice.getWeightedRandom(logger, "Choose founding father", rc, random);
        };
        List<FoundingFather> fathers = CollectionUtils.transform(FoundingFather.FoundingFatherType.values(), CollectionUtils.alwaysTrue(), mapper, CollectionUtils.toListNoNulls());
        LogBuilder lb = new LogBuilder(64);
        lb.add("Random fathers for ", this.getDebugName(), ":");
        for (FoundingFather f : fathers) {
            lb.add(" ", f.getSuffix());
        }
        lb.log(logger, Level.INFO);
        return fathers;
    }

    @Override
    public void addHistory(HistoryEvent event) {
        this.history.add(event);
    }

    private boolean updateScore() {
        int oldScore = this.score;
        this.score = CollectionUtils.sum(this.getUnits(), Unit::getScoreValue) + CollectionUtils.sum(this.getColonies(), Colony::getLiberty) + 5 * CollectionUtils.count(this.getFoundingFathers());
        int gold = this.getGold();
        if (gold != Integer.MIN_VALUE) {
            this.score += (int)Math.floor(0.001 * (double)gold);
        }
        int bonus = 0;
        block8: for (HistoryEvent h : CollectionUtils.transform(this.getHistory(), CollectionUtils.matchKeyEquals(this.getId(), HistoryEvent::getPlayerId))) {
            switch (h.getEventType()) {
                case INDEPENDENCE: {
                    switch (h.getScore()) {
                        case 0: {
                            bonus = 100;
                            continue block8;
                        }
                        case 1: {
                            bonus = 50;
                            continue block8;
                        }
                        case 2: {
                            bonus = 25;
                            continue block8;
                        }
                    }
                    bonus = 0;
                    continue block8;
                }
            }
            this.score += h.getScore();
        }
        this.score += this.score * bonus / 100;
        return this.score != oldScore;
    }

    @Override
    public boolean hasExplored(Tile tile) {
        return tile.isExploredBy(this);
    }

    public boolean exploreTile(Tile tile) {
        boolean ret;
        boolean bl = ret = !this.hasExplored(tile);
        if (ret) {
            tile.setExplored(this, true);
        }
        return ret;
    }

    public Set<Tile> exploreTiles(Collection<? extends Tile> tiles) {
        return CollectionUtils.transform(tiles, t -> this.exploreTile((Tile)t), Function.identity(), Collectors.toSet());
    }

    public Set<Tile> exploreForSettlement(Settlement settlement) {
        HashSet<Tile> tiles = new HashSet<Tile>(settlement.getOwnedTiles());
        tiles.addAll(settlement.getVisibleTileSet());
        tiles.remove(settlement.getTile());
        return this.exploreTiles(tiles);
    }

    public Set<Tile> exploreForUnit(Unit unit) {
        return unit == null || !unit.isOnTile() || this.getGame() == null || this.getGame().getMap() == null ? Collections.emptySet() : this.exploreTiles(unit.getVisibleTileSet());
    }

    public Set<Tile> exploreMap(boolean reveal) {
        Set<Tile> tiles = this.getGame().getMap().getTileSet(t -> this.hasExplored((Tile)t) != reveal);
        for (Tile t2 : tiles) {
            t2.setExplored(this, reveal);
        }
        this.invalidateCanSeeTiles();
        if (!reveal) {
            for (Settlement s : this.getSettlementList()) {
                this.exploreForSettlement(s);
            }
            for (Unit u : this.getUnitSet()) {
                this.exploreForUnit(u);
            }
        }
        return tiles;
    }

    public Set<Tile> collectNewTiles(Tile center, int radius) {
        return this.collectNewTiles(center.getSurroundingTiles(0, radius));
    }

    public Set<Tile> collectNewTiles(Collection<Tile> collection) {
        return collection == null ? Collections.emptySet() : this.collectNewTiles(collection.stream());
    }

    public Set<Tile> collectNewTiles(Stream<Tile> tiles) {
        return CollectionUtils.transform(tiles, t -> this.exploreTile((Tile)t) || !this.canSee((Tile)t), Function.identity(), Collectors.toSet());
    }

    public void reassignTiles(Collection<Tile> tiles, Settlement avoid) {
        Settlement claimant;
        HashMap<Settlement, Integer> votes = new HashMap<Settlement, Integer>();
        HashMap<Tile, Settlement> claims = new HashMap<Tile, Settlement>();
        for (Tile tile : tiles) {
            Player occupier = tile.getFirstUnit() == null ? null : tile.getFirstUnit().getOwner();
            claims.put(tile, null);
            votes.clear();
            for (Tile t : tile.getSurroundingTiles(1)) {
                int value;
                claimant = t.getOwningSettlement();
                if (claimant == null || claimant.isDisposed() || claimant.getOwner() == null || !claimant.getOwner().canOwnTile(tile) || occupier != null && claimant.getOwner() != occupier || claimant.getTile().getDistanceTo(tile) > claimant.getRadius()) continue;
                int n = claimant.getOwner() == this ? 3 : (value = claimant.getOwner().isEuropean() == this.isEuropean() ? 2 : 1);
                if (votes.get(claimant) != null) {
                    value += ((Integer)votes.get(claimant)).intValue();
                }
                votes.put(claimant, value);
            }
            boolean lastResort = false;
            int bestValue = 0;
            claimant = null;
            for (Map.Entry entry : votes.entrySet()) {
                if (avoid == entry.getKey()) {
                    lastResort = true;
                    continue;
                }
                int value = (Integer)entry.getValue();
                if (bestValue >= value) continue;
                bestValue = value;
                claimant = (Settlement)entry.getKey();
            }
            if (claimant == null && lastResort) {
                claimant = avoid;
            }
            claims.put(tile, claimant);
        }
        for (Map.Entry entry : claims.entrySet()) {
            Tile t = (Tile)entry.getKey();
            claimant = (Settlement)entry.getValue();
            Player newOwner = claimant == null ? null : claimant.getOwner();
            t.changeOwnership(newOwner, claimant);
        }
    }

    public List<Unit> createUnits(List<AbstractUnit> abstractUnits, Location location, Random random) {
        Game game = this.getGame();
        Specification spec = game.getSpecification();
        ArrayList<Unit> units = new ArrayList<Unit>();
        LogBuilder lb = new LogBuilder(32);
        lb.add("createUnits for ", this, " at ", location);
        for (AbstractUnit au : abstractUnits) {
            UnitType type = au.getType(spec);
            Role role = au.getRole(spec);
            if (!type.isAvailableTo(this)) {
                lb.add(" ignoring type-unavailable ", au);
                continue;
            }
            if (!role.isAvailableTo(this, type)) {
                lb.add(" ignoring role-unavailable ", au);
                continue;
            }
            for (int i = 0; i < au.getNumber(); ++i) {
                ServerUnit su = new ServerUnit(game, location, this, type, role);
                su.setName(this.getNameForUnit(type, random));
                units.add(su);
                lb.add(Character.valueOf(' '), su);
            }
        }
        lb.log(logger, Level.FINEST);
        return units;
    }

    public List<Unit> loadShips(List<Unit> landUnits, List<Unit> navalUnits, Random random) {
        ArrayList<Unit> leftOver = new ArrayList<Unit>();
        if (random != null) {
            RandomUtils.randomShuffle(logger, "Naval load", navalUnits, random);
            RandomUtils.randomShuffle(logger, "Land load", landUnits, random);
        }
        LogBuilder lb = new LogBuilder(256);
        lb.add("Load ", navalUnits.size(), " ships with ", landUnits.size(), " land units: ");
        for (Unit unit : landUnits) {
            Unit carrier = CollectionUtils.find(navalUnits, u -> u.canAdd(unit));
            if (carrier != null) {
                unit.setLocation(carrier);
                lb.add(unit, " -> ", carrier, ", ");
                continue;
            }
            leftOver.add(unit);
        }
        if (leftOver.isEmpty()) {
            lb.add("no leftovers.");
        } else {
            lb.add("leftover");
            for (Unit u2 : leftOver) {
                lb.add(" ", u2);
            }
            lb.add(".");
        }
        lb.log(logger, Level.FINEST);
        return leftOver;
    }

    public boolean csFlushMarket(ChangeSet cs) {
        Market market = this.getMarket();
        if (market == null) {
            return false;
        }
        Specification spec = this.getSpecification();
        boolean ret = false;
        StringBuilder sb = new StringBuilder(32);
        sb.append("Flush market for ").append(this.getId()).append(':');
        for (GoodsType goodsType : CollectionUtils.transform(spec.getGoodsTypeList(), gt -> this.csFlushMarket((GoodsType)gt, cs))) {
            sb.append(' ').append(goodsType.getId());
            ret = true;
        }
        if (ret) {
            logger.finest(sb.toString());
        }
        return ret;
    }

    public boolean csFlushMarket(GoodsType type, ChangeSet cs) {
        Market market = this.getMarket();
        boolean ret = market.hasPriceChanged(type);
        if (ret) {
            cs.addMessage(this, market.makePriceChangeMessage(type));
            market.flushPriceChange(type);
            cs.add(ChangeSet.See.only(this), market.getMarketData(type));
        }
        return ret;
    }

    public int buyInEurope(Random random, GoodsContainer container, GoodsType type, int amount) {
        Market market = this.getMarket();
        int marketAmount = 0;
        while (amount > 0) {
            int a = amount <= 100 ? amount : 100;
            int price = market.getBidPrice(type, a);
            if (!this.checkGold(price)) {
                if (marketAmount != 0) break;
                return -1;
            }
            this.modifyGold(-price);
            market.modifySales(type, -a);
            if (container != null) {
                container.addGoods(type, a);
            }
            market.modifyIncomeBeforeTaxes(type, -price);
            market.modifyIncomeAfterTaxes(type, -price);
            int ma = (int)this.apply(a, this.getGame().getTurn(), "model.modifier.tradeBonus", type);
            market.addGoodsToMarket(type, -ma);
            marketAmount += ma;
            this.propagateToEuropeanMarkets(type, -a, random);
            amount -= a;
        }
        return marketAmount;
    }

    public int sellInEurope(Random random, GoodsContainer container, GoodsType type, int amount) {
        Market market = this.getMarket();
        int tax = this.getTax();
        int marketAmount = 0;
        while (amount > 0) {
            int a = amount <= 100 ? amount : 100;
            int incomeBeforeTaxes = market.getSalePrice(type, a);
            int incomeAfterTaxes = (100 - tax) * incomeBeforeTaxes / 100;
            this.modifyGold(incomeAfterTaxes);
            market.modifySales(type, a);
            if (container != null) {
                container.addGoods(type, -a);
            }
            market.modifyIncomeBeforeTaxes(type, incomeBeforeTaxes);
            market.modifyIncomeAfterTaxes(type, incomeAfterTaxes);
            int ma = (int)this.apply(a, this.getGame().getTurn(), "model.modifier.tradeBonus", type);
            market.addGoodsToMarket(type, ma);
            marketAmount += ma;
            this.propagateToEuropeanMarkets(type, a, random);
            amount -= a;
        }
        return marketAmount;
    }

    private void addStanceChange(Player other) {
        if (!this.stanceDirty.contains(other)) {
            this.stanceDirty.add(other);
        }
    }

    public boolean csChangeStance(Stance stance, Player otherPlayer, boolean symmetric, ChangeSet cs) {
        int modifier;
        boolean change = false;
        Stance old = this.getStance(otherPlayer);
        if (old != stance) {
            modifier = old.getTensionModifier(stance);
            this.setStance(otherPlayer, stance);
            if (modifier != 0) {
                this.csModifyTension(otherPlayer, modifier, cs);
            }
            cs.addHistory(this, (HistoryEvent)new HistoryEvent(this.getGame().getTurn(), HistoryEvent.getEventTypeFromStance(stance), otherPlayer).addStringTemplate("%nation%", otherPlayer.getNationLabel()));
            logger.info("Stance modification " + this.getName() + " " + old + " -> " + stance + " wrt " + otherPlayer.getName());
            this.addStanceChange(otherPlayer);
            if (old != Stance.UNCONTACTED) {
                cs.addMessage(otherPlayer, (ModelMessage)new ModelMessage(ModelMessage.MessageType.FOREIGN_DIPLOMACY, stance.getStanceChangeKey(), this).addStringTemplate("%nation%", this.getNationLabel()));
            }
            cs.addStance(ChangeSet.See.only(this), this, stance, otherPlayer);
            cs.addStance(ChangeSet.See.only(otherPlayer), this, stance, otherPlayer);
            change = true;
        }
        if (symmetric && (old = otherPlayer.getStance(this)) != stance) {
            modifier = old.getTensionModifier(stance);
            otherPlayer.setStance(this, stance);
            if (modifier != 0) {
                ((ServerPlayer)otherPlayer).csModifyTension(this, modifier, cs);
            }
            cs.addHistory(otherPlayer, (HistoryEvent)new HistoryEvent(this.getGame().getTurn(), HistoryEvent.getEventTypeFromStance(stance), this).addStringTemplate("%nation%", this.getNationLabel()));
            logger.info("Stance modification " + otherPlayer.getName() + " " + old + " -> " + stance + " wrt " + this.getName() + " (symmetric)");
            ((ServerPlayer)otherPlayer).addStanceChange(this);
            if (old != Stance.UNCONTACTED) {
                cs.addMessage(this, (ModelMessage)new ModelMessage(ModelMessage.MessageType.FOREIGN_DIPLOMACY, stance.getStanceChangeKey(), otherPlayer).addStringTemplate("%nation%", otherPlayer.getNationLabel()));
            }
            cs.addStance(ChangeSet.See.only(this), otherPlayer, stance, this);
            cs.addStance(ChangeSet.See.only(otherPlayer), otherPlayer, stance, this);
            change = true;
        }
        return change;
    }

    public void csModifyTension(Player player, int add, ChangeSet cs) {
        this.csModifyTension(player, add, null, cs);
    }

    public void csModifyTension(Player player, int add, Settlement origin, ChangeSet cs) {
        Tension.Level oldLevel = this.getTension(player).getLevel();
        this.getTension(player).modify(add);
        if (oldLevel != this.getTension(player).getLevel()) {
            cs.add(ChangeSet.See.only(player), this);
        }
        if (this.isIndian()) {
            for (IndianSettlement is : CollectionUtils.transform(this.getIndianSettlements(), i -> i != origin && i.hasContacted(player))) {
                ((ServerIndianSettlement)is).csModifyAlarm(player, add, false, cs);
            }
        }
    }

    private void csPayUpkeep(Random random, ChangeSet cs) {
        Specification spec = this.getSpecification();
        Disaster bankruptcy = spec.getDisaster("model.disaster.bankruptcy");
        boolean changed = false;
        int upkeep = CollectionUtils.sum(this.getSettlements(), Settlement::getUpkeep);
        if (this.checkGold(upkeep)) {
            this.modifyGold(-upkeep);
            if (this.getBankrupt()) {
                this.setBankrupt(false);
                changed = true;
                CollectionUtils.forEach(CollectionUtils.flatten(bankruptcy.getEffects(), e -> ((Effect)e.getObject()).getModifiers()), m -> cs.addModifier(this, this, (Modifier)m, false));
                cs.addMessage(this, new ModelMessage(ModelMessage.MessageType.GOVERNMENT_EFFICIENCY, "model.player.disaster.bankruptcy.stop", this));
            }
        } else {
            this.modifyGold(-this.getGold());
            if (!this.getBankrupt()) {
                this.setBankrupt(true);
                changed = true;
                this.csApplyDisaster(random, null, bankruptcy, cs);
                cs.addMessage(this, new ModelMessage(ModelMessage.MessageType.GOVERNMENT_EFFICIENCY, "model.player.disaster.bankruptcy.start", this));
            }
        }
        if (upkeep > 0) {
            cs.addPartial(ChangeSet.See.only(this), this, "gold", String.valueOf(this.getGold()));
        }
        if (changed) {
            cs.addPartial(ChangeSet.See.only(this), this, "bankrupt", String.valueOf(this.getBankrupt()));
        }
    }

    private void csNaturalDisasters(Random random, ChangeSet cs, int probability) {
        if (RandomUtils.randomInt(logger, "Natural disaster", random, 100) < probability) {
            List<Colony> colonies = this.getColonyList();
            int size = colonies.size();
            if (size <= 0) {
                return;
            }
            int start = RandomUtils.randomInt(logger, "select colony", random, size);
            for (int i = 0; i < size; ++i) {
                Disaster disaster;
                Colony colony = colonies.get((start + i) % size);
                List<ModelMessage> messages = this.csApplyDisaster(random, colony, disaster = (Disaster)RandomChoice.getWeightedRandom(logger, "select disaster", colony.getDisasterChoices(), random), cs);
                if (messages.isEmpty()) continue;
                cs.addMessage(this, (ModelMessage)((StringTemplate)new ModelMessage(ModelMessage.MessageType.DISASTERS, "model.player.disaster.strikes", colony).addName("%colony%", colony.getName())).addName("%disaster%", disaster));
                for (ModelMessage message : messages) {
                    cs.addMessage(this, message);
                }
                return;
            }
        }
    }

    public List<ModelMessage> csApplyDisaster(Random random, Colony colony, Disaster disaster, ChangeSet cs) {
        StringBuilder sb = new StringBuilder(64);
        sb.append("Applying ").append((Object)disaster.getNumberOfEffects()).append(" effect/s of disaster ").append(Messages.getName(disaster));
        if (colony != null) {
            sb.append(" to ").append(colony.getName());
        }
        sb.append(':');
        ArrayList<Effect> effects = new ArrayList<Effect>();
        switch (disaster.getNumberOfEffects()) {
            case ONE: {
                effects.add((Effect)RandomChoice.getWeightedRandom(logger, "Get effect of disaster", disaster.getEffects(), random));
                sb.append(' ').append(Messages.getName((Named)effects.get(0)));
                break;
            }
            case SEVERAL: {
                for (RandomChoice<Effect> effect : disaster.getEffects()) {
                    if (RandomUtils.randomInt(logger, "Get effects of disaster", random, 100) >= effect.getProbability()) continue;
                    effects.add(effect.getObject());
                    sb.append(' ').append(Messages.getName(effect.getObject()));
                }
                break;
            }
            case ALL: {
                for (RandomChoice<Effect> effect : disaster.getEffects()) {
                    effects.add(effect.getObject());
                    sb.append(' ').append(Messages.getName(effect.getObject()));
                }
                break;
            }
        }
        if (effects.isEmpty()) {
            sb.append(" All avoided");
        }
        logger.fine(sb.toString());
        boolean colonyDirty = false;
        ArrayList<ModelMessage> messages = new ArrayList<ModelMessage>();
        block21: for (Effect effect : effects) {
            ModelMessage mm = null;
            if (colony == null) {
                CollectionUtils.forEach(effect.getModifiers(), modifier -> {
                    if (modifier.getDuration() > 0) {
                        Modifier timedModifier = Modifier.makeTimedModifier(modifier.getId(), modifier, this.getGame().getTurn());
                        modifier.setModifierIndex(100);
                        cs.addModifier(this, this, timedModifier, true);
                    } else {
                        cs.addModifier(this, this, (Modifier)modifier, true);
                    }
                });
            } else if (null != effect.getId()) {
                switch (effect.getId()) {
                    case "model.disaster.effect.lossOfMoney": {
                        int plunder = Math.max(1, colony.getPlunder(null, random) / 5);
                        this.modifyGold(-plunder);
                        cs.addPartial(ChangeSet.See.only(this), this, "gold", String.valueOf(this.getGold()));
                        mm = (ModelMessage)new ModelMessage(ModelMessage.MessageType.DISASTERS, effect.getId(), this).addAmount("%amount%", plunder);
                        break;
                    }
                    case "model.disaster.effect.lossOfBuilding": {
                        Building building = this.getBuildingForEffect(colony, effect, random);
                        if (building == null) break;
                        mm = (ModelMessage)new ModelMessage(ModelMessage.MessageType.DISASTERS, effect.getId(), colony).addNamed("%building%", building.getType());
                        this.csDamageBuilding(building, cs);
                        colonyDirty = true;
                        break;
                    }
                    case "model.disaster.effect.lossOfGoods": {
                        Goods goods = RandomUtils.getRandomMember(logger, "select goods", colony.getLootableGoodsList(), random);
                        if (goods == null) break;
                        goods.setAmount(Math.min(goods.getAmount() / 2, 50));
                        colony.removeGoods(goods);
                        mm = (ModelMessage)new ModelMessage(ModelMessage.MessageType.DISASTERS, effect.getId(), colony).addStringTemplate("%goods%", goods.getLabel(true));
                        colonyDirty = true;
                        break;
                    }
                    case "model.disaster.effect.lossOfUnit": {
                        Unit unit = this.getUnitForEffect(colony, effect, random);
                        if (unit == null) break;
                        if (colony.getUnitCount() == 1) {
                            messages.clear();
                            mm = (ModelMessage)new ModelMessage(ModelMessage.MessageType.DISASTERS, "model.player.disaster.effect.colonyDestroyed", this).addName("%colony%", colony.getName());
                            messages.add(mm);
                            this.csDisposeSettlement(colony, cs);
                            colonyDirty = false;
                            break block21;
                        }
                        mm = (ModelMessage)new ModelMessage(ModelMessage.MessageType.DISASTERS, effect.getId(), colony).addStringTemplate("%unit%", unit.getLabel());
                        ((ServerUnit)unit).csRemove(ChangeSet.See.only(this), null, cs);
                        colonyDirty = true;
                        break;
                    }
                    case "model.disaster.effect.damagedUnit": {
                        Unit unit = this.getUnitForEffect(colony, effect, random);
                        if (unit == null || !unit.isNaval()) break;
                        Location repairLocation = unit.getRepairLocation();
                        if (repairLocation == null) {
                            mm = (ModelMessage)new ModelMessage(ModelMessage.MessageType.DISASTERS, effect.getId(), colony).addStringTemplate("%unit%", unit.getLabel());
                            this.csSinkShip(unit, null, cs);
                        } else {
                            mm = (ModelMessage)new ModelMessage(ModelMessage.MessageType.DISASTERS, effect.getId(), colony).addStringTemplate("%unit%", unit.getLabel());
                            this.csDamageShip(unit, repairLocation, cs);
                        }
                        colonyDirty = true;
                        break;
                    }
                    default: {
                        mm = new ModelMessage(ModelMessage.MessageType.DISASTERS, effect.getId(), colony);
                        CollectionUtils.forEach(effect.getModifiers(), m -> {
                            if (m.getDuration() > 0) {
                                Modifier timedModifier = Modifier.makeTimedModifier(m.getId(), m, this.getGame().getTurn());
                                timedModifier.setModifierIndex(100);
                                cs.addModifier(this, colony, timedModifier, true);
                            } else {
                                cs.addModifier(this, colony, (Modifier)m, true);
                            }
                        });
                        colonyDirty |= CollectionUtils.first(effect.getModifiers()) != null;
                    }
                }
            }
            if (mm == null) continue;
            messages.add(mm);
        }
        if (colonyDirty) {
            cs.add(ChangeSet.See.perhaps(), colony);
        }
        return messages;
    }

    private Building getBuildingForEffect(Colony colony, Effect effect, Random random) {
        List<Building> buildings = colony.getBurnableBuildings();
        return buildings.isEmpty() ? null : RandomUtils.getRandomMember(logger, "Select building for effect", buildings, random);
    }

    private Unit getUnitForEffect(Colony colony, Effect effect, Random random) {
        List<Unit> units = CollectionUtils.transform(colony.getAllUnitsList(), u -> effect.appliesTo(u.getType()));
        return units.isEmpty() ? null : RandomUtils.getRandomMember(logger, "Select unit for effect", units, random);
    }

    public void propagateToEuropeanMarkets(GoodsType type, int amount, Random random) {
        if (!type.isStorable()) {
            return;
        }
        int lowerBound = 5;
        int upperBound = 30;
        int r = random == null ? 17 : RandomUtils.randomInt(logger, "Propagate goods", random, 26) + 5;
        amount *= r;
        if ((amount /= 100) == 0) {
            return;
        }
        for (Player p : this.getGame().getLiveEuropeanPlayerList(this)) {
            Market market = p.getMarket();
            if (market == null) continue;
            market.addGoodsToMarket(type, amount);
        }
    }

    public void csYearlyGoodsAdjust(Random random, ChangeSet cs) {
        GoodsType extraType;
        Game game = this.getGame();
        List<GoodsType> goodsTypes = game.getSpecification().getStorableGoodsTypeList();
        Market market = this.getMarket();
        if (market == null) {
            return;
        }
        while (!(extraType = RandomUtils.getRandomMember(logger, "Choose goods type", goodsTypes, random)).isStorable()) {
        }
        for (GoodsType type : CollectionUtils.transform(goodsTypes, gt -> market.hasBeenTraded((GoodsType)gt))) {
            boolean add = market.getAmountInMarket(type) < type.getInitialAmount();
            int amount = game.getTurn().getNumber() / 10;
            if (type == extraType) {
                amount = 2 * amount + 1;
            }
            if (amount <= 0) continue;
            amount = RandomUtils.randomInt(logger, "Market adjust " + type, random, amount);
            if (!add) {
                amount = -amount;
            }
            market.addGoodsToMarket(type, amount);
            logger.finest(this.getName() + " adjust of " + amount + " " + type + ", total: " + market.getAmountInMarket(type) + ", initial: " + type.getInitialAmount());
            this.addExtraTrade(new AbstractGoods(type, amount));
        }
        this.flushExtraTrades(random);
        this.csFlushMarket(cs);
    }

    public void csStartTurn(Random random, ChangeSet cs) {
        Game game = this.getGame();
        if (this.isEuropean()) {
            this.csBombardEnemyShips(random, cs);
            this.csYearlyGoodsAdjust(random, cs);
            FoundingFather father = this.checkFoundingFather();
            if (father != null) {
                this.csAddFoundingFather(father, random, cs);
                this.clearOfferedFathers();
            }
            List<FoundingFather> ffs = this.getOfferedFathers();
            if (this.canRecruitFoundingFather() && ffs.isEmpty()) {
                ffs = this.getRandomFoundingFathers(random);
                this.setOfferedFathers(ffs);
            }
            if (!ffs.isEmpty()) {
                cs.add(ChangeSet.See.only(this), new ChooseFoundingFatherMessage(ffs, null));
            }
            if (this.updateScore()) {
                cs.addPartial(ChangeSet.See.only(this), this, "score", String.valueOf(this.getScore()));
            }
        } else if (this.isIndian()) {
            List<IndianSettlement> allSettlements = this.getIndianSettlementList();
            HashMap oldLevels = new HashMap(allSettlements.size());
            for (IndianSettlement is : allSettlements) {
                HashMap<Player, Tension.Level> oldLevel = new HashMap<Player, Tension.Level>();
                oldLevels.put(is, oldLevel);
                Iterator<Player> iterator = game.getLiveEuropeanPlayerList(this).iterator();
                while (iterator.hasNext()) {
                    Player enemy;
                    Tension tension = is.getAlarm(enemy = iterator.next());
                    oldLevel.put(enemy, tension == null ? null : tension.getLevel());
                }
            }
            for (IndianSettlement is : allSettlements) {
                List<Player> enemies = game.getLiveEuropeanPlayerList(this);
                HashMap<Player, Integer> extra = new HashMap<Player, Integer>(enemies.size());
                for (Player player : enemies) {
                    extra.put(player, 0);
                }
                int alarmRadius = is.getRadius() + 2;
                for (Tile tile : is.getTile().getSurroundingTiles(alarmRadius)) {
                    Player enemy;
                    Colony colony = tile.getColony();
                    if (tile.getFirstUnit() != null) {
                        Integer alarm;
                        Player enemy3 = tile.getFirstUnit().getOwner();
                        if (!enemy3.isEuropean() || (alarm = (Integer)extra.get(enemy3)) == null) continue;
                        alarm = alarm + (int)CollectionUtils.sumDouble(tile.getUnits(), u -> u.isOffensiveUnit() && !u.isNaval(), u -> u.getType().getOffence());
                        extra.put(enemy3, alarm);
                        continue;
                    }
                    if (colony != null) {
                        enemy = colony.getOwner();
                        extra.put(enemy, (Integer)extra.get(enemy) + 2 + colony.getUnitCount());
                        continue;
                    }
                    if (tile.getOwningSettlement() == null || (enemy = tile.getOwningSettlement().getOwner()) == null || !enemy.isEuropean()) continue;
                    extra.put(enemy, (Integer)extra.get(enemy) + 2);
                }
                if (is.hasMissionary()) {
                    Unit unit = is.getMissionary();
                    int missionAlarm = this.getGame().getSpecification().getInteger("model.option.missionInfluence");
                    if (unit.hasAbility("model.ability.expertMissionary")) {
                        missionAlarm *= 2;
                    }
                    Player enemy4 = unit.getOwner();
                    extra.put(enemy4, (Integer)extra.get(enemy4) + missionAlarm);
                }
                CollectionUtils.forEachMapEntry(extra, e -> (Integer)e.getValue() != 0, e -> {
                    Player player = (Player)e.getKey();
                    int change = (int)player.apply(((Integer)e.getValue()).intValue(), game.getTurn(), "model.modifier.nativeAlarmModifier");
                    ((ServerIndianSettlement)is).csModifyAlarm(player, change, true, cs);
                });
            }
            for (Player enemy : CollectionUtils.transform(game.getLiveEuropeanPlayers(this), p -> this.getTension((Player)p).getValue() > 0)) {
                int change = -this.getTension(enemy).getValue() / 100 - 4;
                this.csModifyTension(enemy, change, cs);
            }
            for (IndianSettlement is : allSettlements) {
                CollectionUtils.forEachMapEntry((Map)oldLevels.get(is), e -> ((ServerIndianSettlement)is).csCheckTension((Player)e.getKey(), (Tension.Level)((Object)((Object)((Object)e.getValue()))), cs));
            }
            for (IndianSettlement is : allSettlements) {
                ((ServerIndianSettlement)is).csStartTurn(random, cs);
            }
        }
    }

    private void csBombardEnemyShips(Random random, ChangeSet cs) {
        Predicate<Unit> bombardUnit = u -> u.getOwner() != this && u.isNaval() && !u.getTile().isLand() && (this.atWarWith(u.getOwner()) || u.hasAbility("model.ability.piracy"));
        for (Colony c : CollectionUtils.transform(this.getColonies(), Settlement::canBombardEnemyShip)) {
            Tile tile = c.getTile();
            for (Unit u2 : CollectionUtils.transform(CollectionUtils.flatten(tile.getSurroundingTiles(1, 1), UnitLocation::getUnits), bombardUnit)) {
                this.csCombat(c, u2, null, random, cs);
            }
        }
    }

    public void csAddFoundingFather(FoundingFather father, Random random, ChangeSet cs) {
        UnitChangeType uct;
        Game game = this.getGame();
        Specification spec = game.getSpecification();
        ServerEurope europe = (ServerEurope)this.getEurope();
        Turn turn = game.getTurn();
        boolean europeDirty = false;
        boolean visibilityChange = false;
        this.addFather(father);
        this.addHistory((HistoryEvent)new HistoryEvent(turn, HistoryEvent.HistoryEventType.FOUNDING_FATHER, this).addNamed("%father%", father));
        cs.add(ChangeSet.See.only(this), this);
        cs.addMessage(this, (ModelMessage)((StringTemplate)new ModelMessage(ModelMessage.MessageType.SONS_OF_LIBERTY, "model.player.foundingFatherJoinedCongress", this).addNamed("%foundingFather%", father)).add("%description%", father.getDescriptionKey()));
        List<AbstractUnit> units = father.getUnitList();
        if (europe != null && units != null && !units.isEmpty()) {
            this.createUnits(units, europe, random);
            europeDirty = true;
        }
        if ((uct = spec.getUnitChangeType("model.unitChange.foundingFather")) != null && uct.appliesTo(this)) {
            block18: for (Unit u2 : this.getUnitSet()) {
                for (UnitTypeChange uc : uct.getUnitChanges(u2.getType())) {
                    if (!uc.appliesTo(u2)) continue;
                    u2.changeType(uc.to);
                    visibilityChange = true;
                    cs.add(ChangeSet.See.perhaps(), u2);
                    continue block18;
                }
            }
        }
        for (Modifier m : CollectionUtils.iterable(father.getModifiers())) {
            if ("model.modifier.lineOfSightBonus".equals(m.getId())) {
                Set<Tile> tiles = this.collectNewTiles(this.getVisibleTileSet());
                cs.add(ChangeSet.See.only(this), tiles);
                visibilityChange = !tiles.isEmpty();
                continue;
            }
            if (!"model.modifier.SoL".equals(m.getId())) continue;
            for (Colony c : this.getColonyList()) {
                c.addLiberty(0);
                c.invalidateCache();
            }
        }
        block22: for (Event event : father.getEvents()) {
            String eventId;
            switch (eventId = event.getId()) {
                case "model.event.resetBannedMissions": {
                    for (Player player : game.getLiveNativePlayerList(new Player[0])) {
                        if (!player.missionsBanned(this)) continue;
                        player.removeMissionBan(this);
                        cs.add(ChangeSet.See.only(this), player);
                    }
                    continue block22;
                }
                case "model.event.resetNativeAlarm": {
                    for (Player player : CollectionUtils.transform(game.getLiveNativePlayers(new Player[0]), p -> p.hasContacted(this))) {
                        player.setTension(this, new Tension(0));
                        for (IndianSettlement is2 : CollectionUtils.transform(player.getIndianSettlements(), is -> is.hasContacted(this))) {
                            is2.getTile().cacheUnseen();
                            is2.setAlarm(this, new Tension(0));
                            cs.add(ChangeSet.See.only(this), is2);
                        }
                        this.csChangeStance(Stance.PEACE, player, true, cs);
                    }
                    continue block22;
                }
                case "model.event.boycottsLifted": {
                    Market market = this.getMarket();
                    for (GoodsType goodsType : spec.getGoodsTypeList()) {
                        if (market.getArrears(goodsType) <= 0) continue;
                        market.setArrears(goodsType, 0);
                        cs.add(ChangeSet.See.only(this), market.getMarketData(goodsType));
                    }
                    continue block22;
                }
                case "model.event.freeBuilding": {
                    BuildingType buildingType = spec.getBuildingType(event.getValue());
                    for (Colony c : this.getColonyList()) {
                        ((ServerColony)c).csFreeBuilding(buildingType, cs);
                    }
                    continue block22;
                }
                case "model.event.seeAllColonies": {
                    visibilityChange = true;
                    for (Colony colony : game.getAllColoniesList(null)) {
                        Tile t = colony.getTile();
                        HashSet<Tile> tiles = new HashSet<Tile>();
                        if (this.exploreTile(t)) {
                            if (!this.hasAbility("model.ability.seeAllColonies")) {
                                Tile c = (Tile)t.copy(game);
                                c.getColony().setDisplayUnitCount(1);
                                t.setCachedTile(this, c);
                            }
                            tiles.add(t);
                        }
                        int fullRadius = (int)father.apply(colony.getLineOfSight(), turn, "model.modifier.exposedTilesRadius");
                        tiles.addAll(this.exploreTiles(t.getSurroundingTiles(1, fullRadius)));
                        cs.add(ChangeSet.See.only(this), tiles);
                    }
                    continue block22;
                }
                case "model.event.newRecruits": {
                    if (europe == null) break;
                    europeDirty = europe.replaceRecruits(random);
                    break;
                }
                case "model.event.movementChange": {
                    for (Unit u3 : CollectionUtils.transform(this.getUnits(), u -> u.getMovesLeft() > 0)) {
                        u3.setMovesLeft(u3.getInitialMovesLeft());
                        cs.addPartial(ChangeSet.See.only(this), u3, "movesLeft", String.valueOf(u3.getMovesLeft()));
                    }
                    continue block22;
                }
            }
        }
        if (europeDirty) {
            cs.add(ChangeSet.See.only(this), europe);
        }
        if (visibilityChange) {
            this.invalidateCanSeeTiles();
        }
    }

    public List<BuildingType> getFreeBuildingTypes() {
        Specification spec = this.getGame().getSpecification();
        return CollectionUtils.transform(CollectionUtils.flatten(this.getFoundingFathers(), ff -> ff.getEvents().stream()), CollectionUtils.matchKeyEquals("model.event.freeBuilding", FreeColObject::getId), ev -> spec.getBuildingType(ev.getValue()));
    }

    public void csClaimLand(Tile tile, Settlement settlement, int price, ChangeSet cs) {
        Player owner = tile.getOwner();
        Settlement ownerSettlement = tile.getOwningSettlement();
        tile.cacheUnseen();
        tile.changeOwnership(this, settlement);
        cs.add(ChangeSet.See.perhaps(), tile);
        if (price > 0) {
            this.modifyGold(-price);
            owner.modifyGold(price);
            cs.addPartial(ChangeSet.See.only(this), this, "gold", String.valueOf(this.getGold()));
        } else if (price < 0 && owner.isIndian()) {
            ServerIndianSettlement sis = (ServerIndianSettlement)ownerSettlement;
            if (sis == null) {
                ((ServerPlayer)owner).csModifyTension(this, 200, cs);
            } else {
                sis.csModifyAlarm(this, 200, true, cs);
            }
        }
        logger.finest(this.getName() + " claimed " + tile + " from " + (owner == null ? "no-one" : owner.getName()) + ", price: " + (Serializable)(price == 0 ? "free" : (price < 0 ? "stolen" : Integer.valueOf(price))));
    }

    @SuppressFBWarnings(value={"SF_SWITCH_FALLTHROUGH"})
    public void csEmigrate(int slot, Europe.MigrationType type, Random random, ChangeSet cs) {
        ServerEurope europe = (ServerEurope)this.getEurope();
        AbstractUnit recruit = europe.extractRecruitable(slot, random);
        Game game = this.getGame();
        Specification spec = game.getSpecification();
        Role role = spec.getBoolean("model.option.equipEuropeanRecruits") ? recruit.getRole(spec) : spec.getDefaultRole();
        ServerUnit unit = new ServerUnit(game, europe, this, recruit.getType(spec), role);
        switch (type) {
            case FOUNTAIN: {
                this.setRemainingEmigrants(this.getRemainingEmigrants() - 1);
                break;
            }
            case RECRUIT: {
                this.modifyGold(-europe.getCurrentRecruitPrice());
                cs.addPartial(ChangeSet.See.only(this), this, "gold", String.valueOf(this.getGold()));
                europe.increaseRecruitmentDifficulty();
            }
            case NORMAL: {
                this.reduceImmigration();
                this.updateImmigrationRequired();
                cs.addPartial(ChangeSet.See.only(this), this, "immigration", String.valueOf(this.getImmigration()), "immigrationRequired", String.valueOf(this.getImmigrationRequired()));
                if (Europe.MigrationType.specificMigrantSlot(slot)) break;
                cs.addMessage(this, this.getEmigrationMessage(unit));
                break;
            }
            case SURVIVAL: {
                cs.addMessage(this, (ModelMessage)((StringTemplate)new ModelMessage(ModelMessage.MessageType.UNIT_ADDED, "model.player.autoRecruit", this, unit).addNamed("%europe%", europe)).addStringTemplate("%unit%", unit.getLabel()));
                break;
            }
            default: {
                throw new RuntimeException("Bogus migration type: " + type);
            }
        }
        cs.add(ChangeSet.See.only(this), europe);
    }

    public void csCombat(FreeColGameObject attacker, FreeColGameObject defender, List<CombatModel.CombatResult> crs, Random random, ChangeSet cs) {
        ChangeSet.See vis;
        CombatModel combatModel = this.getGame().getCombatModel();
        boolean isAttack = combatModel.combatIsAttack(attacker, defender);
        boolean isBombard = combatModel.combatIsBombard(attacker, defender);
        Unit attackerUnit = null;
        Settlement attackerSettlement = null;
        Tile attackerTile = null;
        Unit defenderUnit = null;
        Player defenderPlayer = null;
        Tile defenderTile = null;
        if (isAttack) {
            attackerUnit = (Unit)attacker;
            attackerTile = attackerUnit.getTile();
            defenderUnit = (Unit)defender;
            defenderPlayer = defenderUnit.getOwner();
            defenderTile = defenderUnit.getTile();
            boolean bombard = attackerUnit.hasAbility("model.ability.bombard");
            cs.addAttribute(ChangeSet.See.only(this), "sound", attackerUnit.isNaval() ? "sound.attack.naval" : (bombard ? "sound.attack.artillery" : (attackerUnit.isMounted() ? "sound.attack.mounted" : "sound.attack.foot")));
            if (attackerUnit.getOwner().isIndian() && defenderPlayer.isEuropean() && defenderUnit.getLocation().getColony() != null && !defenderPlayer.atWarWith(attackerUnit.getOwner())) {
                StringTemplate attackerNation = attackerUnit.getApparentOwnerName();
                Colony colony = defenderUnit.getLocation().getColony();
                cs.addMessage(defenderPlayer, (ModelMessage)((StringTemplate)new ModelMessage(ModelMessage.MessageType.COMBAT_RESULT, "combat.raid.ours", colony).addName("%colony%", colony.getName())).addStringTemplate("%nation%", attackerNation));
            }
        } else if (isBombard) {
            attackerSettlement = (Settlement)attacker;
            attackerTile = attackerSettlement.getTile();
            defenderUnit = (Unit)defender;
            defenderPlayer = defenderUnit.getOwner();
            defenderTile = defenderUnit.getTile();
            cs.addAttribute(ChangeSet.See.only(this), "sound", "sound.attack.bombard");
        } else {
            throw new RuntimeException("Bogus combat: " + attacker + " v " + defender);
        }
        assert (defenderTile != null);
        if (crs == null) {
            crs = combatModel.generateAttackResult(random, attacker, defender);
        }
        if (crs.isEmpty()) {
            throw new RuntimeException("empty attack result: " + this);
        }
        CombatModel.CombatResult result = crs.remove(0);
        switch (result) {
            case NO_RESULT: {
                vis = ChangeSet.See.perhaps();
                break;
            }
            case WIN: {
                vis = ChangeSet.See.perhaps().always(defenderPlayer);
                if (!isAttack) break;
                if (attackerTile == null || attackerTile == defenderTile || !attackerTile.isAdjacent(defenderTile)) {
                    logger.warning("Bogus attack from " + attackerTile + " to " + defenderTile);
                    break;
                }
                cs.addAttack(vis, attackerUnit, defenderUnit, true);
                break;
            }
            case LOSE: {
                vis = ChangeSet.See.perhaps().always(this);
                if (!isAttack) break;
                if (attackerTile == null || attackerTile == defenderTile || !attackerTile.isAdjacent(defenderTile)) {
                    logger.warning("Bogus attack from " + attackerTile + " to " + defenderTile);
                    break;
                }
                cs.addAttack(vis, attackerUnit, defenderUnit, false);
                break;
            }
            default: {
                throw new IllegalStateException("generateAttackResult returned: " + result);
            }
        }
        boolean attackerTileDirty = false;
        boolean defenderTileDirty = false;
        boolean moveAttacker = false;
        boolean burnedNativeCapital = false;
        Settlement settlement = defenderTile.getSettlement();
        Colony colony = defenderTile.getColony();
        IndianSettlement natives = settlement instanceof IndianSettlement ? (IndianSettlement)settlement : null;
        int attackerTension = 0;
        int defenderTension = 0;
        for (CombatModel.CombatResult cr : crs) {
            boolean ok;
            switch (cr) {
                case AUTOEQUIP_UNIT: {
                    boolean bl = ok = isAttack && settlement != null;
                    if (!ok) break;
                    this.csAutoequipUnit(defenderUnit, settlement, cs);
                    break;
                }
                case BURN_MISSIONS: {
                    boolean bl = ok = isAttack && result == CombatModel.CombatResult.WIN && natives != null && this.isEuropean() && defenderPlayer.isIndian();
                    if (!ok) break;
                    defenderTileDirty |= natives.hasMissionary(this);
                    this.csBurnMissions(attackerUnit, natives, cs);
                    break;
                }
                case CAPTURE_AUTOEQUIP: {
                    boolean bl = ok = isAttack && result == CombatModel.CombatResult.WIN && settlement != null;
                    if (!ok) break;
                    this.csCaptureAutoEquip(attackerUnit, defenderUnit, cs);
                    defenderTileDirty = true;
                    attackerTileDirty = true;
                    break;
                }
                case CAPTURE_COLONY: {
                    boolean bl = ok = isAttack && result == CombatModel.CombatResult.WIN && colony != null && this.isEuropean() && defenderPlayer.isEuropean();
                    if (!ok) break;
                    this.csCaptureColony(attackerUnit, (ServerColony)colony, random, cs);
                    defenderTileDirty = false;
                    attackerTileDirty = false;
                    moveAttacker = true;
                    defenderTension += 300;
                    break;
                }
                case CAPTURE_CONVERT: {
                    boolean bl = ok = isAttack && result == CombatModel.CombatResult.WIN && natives != null && this.isEuropean() && defenderPlayer.isIndian();
                    if (!ok) break;
                    this.csCaptureConvert(attackerUnit, natives, random, cs);
                    attackerTileDirty = true;
                    break;
                }
                case CAPTURE_EQUIP: {
                    boolean bl = ok = isAttack && result != CombatModel.CombatResult.NO_RESULT;
                    if (!ok) break;
                    if (result == CombatModel.CombatResult.WIN) {
                        this.csCaptureEquip(attackerUnit, defenderUnit, cs);
                    } else {
                        this.csCaptureEquip(defenderUnit, attackerUnit, cs);
                    }
                    defenderTileDirty = true;
                    attackerTileDirty = true;
                    break;
                }
                case CAPTURE_UNIT: {
                    boolean bl = ok = isAttack && result != CombatModel.CombatResult.NO_RESULT;
                    if (!ok) break;
                    if (result == CombatModel.CombatResult.WIN) {
                        this.csCaptureUnit(attackerUnit, defenderUnit, cs);
                    } else {
                        this.csCaptureUnit(defenderUnit, attackerUnit, cs);
                    }
                    attackerTileDirty = true;
                    defenderTileDirty = false;
                    break;
                }
                case DAMAGE_COLONY_SHIPS: {
                    boolean bl = ok = isAttack && result == CombatModel.CombatResult.WIN && colony != null;
                    if (!ok) break;
                    this.csDamageColonyShips(attackerUnit, colony, cs);
                    defenderTileDirty = true;
                    break;
                }
                case DAMAGE_SHIP_ATTACK: {
                    boolean bl = isAttack && result != CombatModel.CombatResult.NO_RESULT && (result == CombatModel.CombatResult.WIN ? defenderUnit : attackerUnit).isNaval() ? true : (ok = false);
                    if (!ok) break;
                    if (result == CombatModel.CombatResult.WIN) {
                        this.csDamageShipAttack(attackerUnit, defenderUnit, cs);
                        defenderTileDirty = true;
                        break;
                    }
                    this.csDamageShipAttack(defenderUnit, attackerUnit, cs);
                    attackerTileDirty = true;
                    break;
                }
                case DAMAGE_SHIP_BOMBARD: {
                    boolean bl = ok = isBombard && result == CombatModel.CombatResult.WIN && defenderUnit.isNaval();
                    if (!ok) break;
                    this.csDamageShipBombard(attackerSettlement, defenderUnit, cs);
                    defenderTileDirty = true;
                    break;
                }
                case DEMOTE_UNIT: {
                    boolean bl = ok = isAttack && result != CombatModel.CombatResult.NO_RESULT;
                    if (!ok) break;
                    if (result == CombatModel.CombatResult.WIN) {
                        this.csDemoteUnit(attackerUnit, defenderUnit, cs);
                        defenderTileDirty = true;
                        break;
                    }
                    this.csDemoteUnit(defenderUnit, attackerUnit, cs);
                    attackerTileDirty = true;
                    break;
                }
                case DESTROY_COLONY: {
                    boolean bl = ok = isAttack && result == CombatModel.CombatResult.WIN && colony != null && this.isIndian() && defenderPlayer.isEuropean();
                    if (!ok) break;
                    this.csDestroyColony(attackerUnit, colony, random, cs);
                    defenderTileDirty = true;
                    attackerTileDirty = true;
                    moveAttacker = true;
                    attackerTension -= 200;
                    defenderTension += 300;
                    break;
                }
                case DESTROY_SETTLEMENT: {
                    boolean bl = ok = isAttack && result == CombatModel.CombatResult.WIN && natives != null && defenderPlayer.isIndian();
                    if (!ok) break;
                    burnedNativeCapital = settlement.isCapital();
                    this.csDestroySettlement(attackerUnit, natives, random, cs);
                    defenderTileDirty = true;
                    attackerTileDirty = true;
                    moveAttacker = true;
                    attackerTension -= 200;
                    if (burnedNativeCapital) break;
                    defenderTension += 300;
                    break;
                }
                case EVADE_ATTACK: {
                    boolean bl = ok = isAttack && result == CombatModel.CombatResult.NO_RESULT && defenderUnit.isNaval();
                    if (!ok) break;
                    this.csEvadeAttack(attackerUnit, defenderUnit, cs);
                    break;
                }
                case EVADE_BOMBARD: {
                    boolean bl = ok = isBombard && result == CombatModel.CombatResult.NO_RESULT && defenderUnit.isNaval();
                    if (!ok) break;
                    this.csEvadeBombard(attackerSettlement, defenderUnit, cs);
                    break;
                }
                case LOOT_SHIP: {
                    boolean bl = ok = isAttack && result != CombatModel.CombatResult.NO_RESULT && attackerUnit.isNaval() && defenderUnit.isNaval();
                    if (!ok) break;
                    if (result == CombatModel.CombatResult.WIN) {
                        this.csLootShip(attackerUnit, defenderUnit, cs);
                        break;
                    }
                    this.csLootShip(defenderUnit, attackerUnit, cs);
                    break;
                }
                case LOSE_AUTOEQUIP: {
                    boolean bl = ok = isAttack && result == CombatModel.CombatResult.WIN && settlement != null;
                    if (!ok) break;
                    this.csLoseAutoEquip(attackerUnit, defenderUnit, cs);
                    defenderTileDirty = true;
                    break;
                }
                case LOSE_EQUIP: {
                    boolean bl = ok = isAttack && result != CombatModel.CombatResult.NO_RESULT;
                    if (!ok) break;
                    if (result == CombatModel.CombatResult.WIN) {
                        this.csLoseEquip(attackerUnit, defenderUnit, cs);
                        defenderTileDirty = true;
                        break;
                    }
                    this.csLoseEquip(defenderUnit, attackerUnit, cs);
                    attackerTileDirty = true;
                    break;
                }
                case PILLAGE_COLONY: {
                    boolean bl = ok = isAttack && result == CombatModel.CombatResult.WIN && colony != null && this.isIndian() && defenderPlayer.isEuropean();
                    if (!ok) break;
                    this.csPillageColony(attackerUnit, colony, random, cs);
                    defenderTileDirty = true;
                    attackerTension -= 200;
                    break;
                }
                case PROMOTE_UNIT: {
                    boolean bl = ok = isAttack && result != CombatModel.CombatResult.NO_RESULT;
                    if (!ok) break;
                    if (result == CombatModel.CombatResult.WIN) {
                        this.csPromoteUnit(attackerUnit, cs);
                        attackerTileDirty = true;
                        break;
                    }
                    this.csPromoteUnit(defenderUnit, cs);
                    defenderTileDirty = true;
                    break;
                }
                case SINK_COLONY_SHIPS: {
                    boolean bl = ok = isAttack && result == CombatModel.CombatResult.WIN && colony != null;
                    if (!ok) break;
                    this.csSinkColonyShips(attackerUnit, colony, cs);
                    defenderTileDirty = true;
                    break;
                }
                case SINK_SHIP_ATTACK: {
                    boolean bl = isAttack && result != CombatModel.CombatResult.NO_RESULT && (result == CombatModel.CombatResult.WIN ? defenderUnit : attackerUnit).isNaval() ? true : (ok = false);
                    if (!ok) break;
                    if (result == CombatModel.CombatResult.WIN) {
                        this.csSinkShipAttack(attackerUnit, defenderUnit, cs);
                        defenderTileDirty = true;
                        break;
                    }
                    this.csSinkShipAttack(defenderUnit, attackerUnit, cs);
                    attackerTileDirty = true;
                    break;
                }
                case SINK_SHIP_BOMBARD: {
                    boolean bl = ok = isBombard && result == CombatModel.CombatResult.WIN && defenderUnit.isNaval();
                    if (!ok) break;
                    this.csSinkShipBombard(attackerSettlement, defenderUnit, cs);
                    defenderTileDirty = true;
                    break;
                }
                case SLAUGHTER_UNIT: {
                    boolean bl = ok = isAttack && result != CombatModel.CombatResult.NO_RESULT;
                    if (!ok) break;
                    if (result == CombatModel.CombatResult.WIN) {
                        this.csSlaughterUnit(attackerUnit, defenderUnit, cs);
                        defenderTileDirty = true;
                        attackerTension -= 200;
                        defenderTension += this.getSlaughterTension(defenderUnit);
                        break;
                    }
                    this.csSlaughterUnit(defenderUnit, attackerUnit, cs);
                    attackerTileDirty = true;
                    attackerTension += this.getSlaughterTension(attackerUnit);
                    defenderTension -= 200;
                    break;
                }
                default: {
                    ok = false;
                }
            }
            if (ok) continue;
            throw new IllegalStateException("Attack (result=" + result + ") has bogus subresult: " + cr);
        }
        if (attacker.hasAbility("model.ability.piracy")) {
            if (!defenderPlayer.getAttackedByPrivateers()) {
                defenderPlayer.setAttackedByPrivateers(true);
                cs.addPartial(ChangeSet.See.only(defenderPlayer), defenderPlayer, "attackedByPrivateers", Boolean.TRUE.toString());
            }
        } else if (!defender.hasAbility("model.ability.piracy")) {
            if (burnedNativeCapital) {
                defenderPlayer.getTension(this).setValue(Tension.SURRENDERED);
                cs.add(ChangeSet.See.perhaps().always(this), defenderPlayer);
                this.csChangeStance(Stance.PEACE, defenderPlayer, true, cs);
                for (IndianSettlement is2 : CollectionUtils.transform(defenderPlayer.getIndianSettlements(), is -> is.hasContacted(this))) {
                    is2.getAlarm(this).setValue(Tension.SURRENDERED);
                    if (this.hasExplored(is2.getTile())) {
                        cs.add(ChangeSet.See.perhaps().always(this), is2);
                        continue;
                    }
                    cs.add(ChangeSet.See.only(defenderPlayer), is2);
                }
            } else if (this.isEuropean() && defenderPlayer.isEuropean()) {
                this.csChangeStance(Stance.WAR, defenderPlayer, true, cs);
            } else {
                if (this.isEuropean()) {
                    this.csChangeStance(Stance.WAR, defenderPlayer, true, cs);
                } else if (this.isIndian()) {
                    if (result == CombatModel.CombatResult.WIN) {
                        attackerTension -= 100;
                    } else if (result == CombatModel.CombatResult.LOSE) {
                        attackerTension += 100;
                    }
                }
                if (defenderPlayer.isEuropean()) {
                    ((ServerPlayer)defenderPlayer).csChangeStance(Stance.WAR, this, true, cs);
                } else if (defenderPlayer.isIndian()) {
                    if (result == CombatModel.CombatResult.WIN) {
                        defenderTension += 100;
                    } else if (result == CombatModel.CombatResult.LOSE) {
                        defenderTension -= 100;
                    }
                }
                if (attackerTension != 0) {
                    this.csModifyTension(defenderPlayer, attackerTension, cs);
                }
                if (defenderTension != 0) {
                    ((ServerPlayer)defenderPlayer).csModifyTension(this, defenderTension, cs);
                }
            }
        }
        if (moveAttacker) {
            attackerUnit.setMovesLeft(attackerUnit.getInitialMovesLeft());
            ((ServerUnit)attackerUnit).csMove(defenderTile, random, cs);
            attackerUnit.setMovesLeft(0);
            defenderTileDirty = false;
            attackerTileDirty = false;
            cs.add(ChangeSet.See.only(defenderPlayer), defenderTile);
        } else if (isAttack) {
            if (attacker.hasAbility("model.ability.multipleAttacks")) {
                int movecost = attackerUnit.getMoveCost(defenderTile);
                attackerUnit.setMovesLeft(attackerUnit.getMovesLeft() - movecost);
            } else {
                attackerUnit.setMovesLeft(0);
            }
            if (!attackerTileDirty) {
                cs.addPartial(ChangeSet.See.only(this), attacker, "movesLeft", String.valueOf(attackerUnit.getMovesLeft()));
            }
        }
        if (attackerTileDirty) {
            if (attackerSettlement != null) {
                cs.remove(attackerSettlement);
            }
            cs.add(vis, attackerTile);
        }
        if (defenderTileDirty) {
            if (settlement != null) {
                cs.remove(settlement);
            }
            cs.add(vis, defenderTile);
        }
    }

    private int getSlaughterTension(Unit loser) {
        Settlement settlement = loser.getSettlement();
        if (settlement != null) {
            if (settlement instanceof IndianSettlement) {
                return settlement.isCapital() ? 600 : 500;
            }
            return 200;
        }
        return loser.getHomeIndianSettlement() != null ? 400 : 100;
    }

    private void csAutoequipUnit(Unit unit, Settlement settlement, ChangeSet cs) {
        Player owner = unit.getOwner();
        cs.addMessage(owner, (ModelMessage)((StringTemplate)new ModelMessage(ModelMessage.MessageType.COMBAT_RESULT, "combat.automaticDefence", unit).addStringTemplate("%unit%", unit.getLabel())).addName("%colony%", settlement.getName()));
    }

    private void csBurnMissions(Unit attacker, IndianSettlement is, ChangeSet cs) {
        Player attackerPlayer = attacker.getOwner();
        StringTemplate attackerNation = attackerPlayer.getNationLabel();
        Player nativePlayer = is.getOwner();
        StringTemplate nativeNation = nativePlayer.getNationLabel();
        cs.addMessage(attackerPlayer, (ModelMessage)((StringTemplate)new ModelMessage(ModelMessage.MessageType.COMBAT_RESULT, "combat.burnMissions", attacker, is).addStringTemplate("%nation%", attackerNation)).addStringTemplate("%enemyNation%", nativeNation));
        boolean here = is.hasMissionary(attackerPlayer);
        for (IndianSettlement s : nativePlayer.getIndianSettlementsWithMissionaryList(attackerPlayer)) {
            ((ServerIndianSettlement)s).csKillMissionary(null, cs);
        }
        if (here) {
            cs.remove(is.getTile());
        }
    }

    private void csCaptureAutoEquip(Unit attacker, Unit defender, ChangeSet cs) {
        Role role = defender.getAutomaticRole();
        this.csLoseAutoEquip(attacker, defender, cs);
        this.csCaptureEquipment(attacker, defender, role, cs);
    }

    private void csCaptureColony(Unit attacker, ServerColony colony, Random random, ChangeSet cs) {
        Game game = attacker.getGame();
        Player attackerPlayer = attacker.getOwner();
        StringTemplate attackerNation = attacker.getApparentOwnerName();
        Player colonyPlayer = colony.getOwner();
        StringTemplate colonyNation = colonyPlayer.getNationLabel();
        Tile tile = colony.getTile();
        int plunder = colony.getPlunder(attacker, random);
        cs.addHistory(attackerPlayer, (HistoryEvent)((StringTemplate)new HistoryEvent(game.getTurn(), HistoryEvent.HistoryEventType.CONQUER_COLONY, attackerPlayer).addStringTemplate("%nation%", colonyNation)).addName("%colony%", colony.getName()));
        cs.addHistory(colonyPlayer, (HistoryEvent)((StringTemplate)new HistoryEvent(game.getTurn(), HistoryEvent.HistoryEventType.COLONY_CONQUERED, attackerPlayer).addStringTemplate("%nation%", attackerNation)).addName("%colony%", colony.getName()));
        cs.addMessage(attackerPlayer, (ModelMessage)((StringTemplate)((StringTemplate)((StringTemplate)new ModelMessage(ModelMessage.MessageType.COMBAT_RESULT, "combat.colonyCaptured.enemy", colony).addName("%colony%", colony.getName())).addStringTemplate("%unit%", attacker.getLabel())).addStringTemplate("%enemyNation%", colonyNation)).addAmount("%amount%", plunder));
        cs.addMessage(colonyPlayer, (ModelMessage)((StringTemplate)((StringTemplate)((StringTemplate)new ModelMessage(ModelMessage.MessageType.COMBAT_RESULT, "combat.colonyCaptured.ours", tile).addName("%colony%", colony.getName())).addStringTemplate("%enemyUnit%", attacker.getLabel())).addStringTemplate("%enemyNation%", attackerNation)).addAmount("%amount%", plunder));
        ((ServerPlayer)colonyPlayer).csLoseLocation(colony, cs);
        if (plunder > 0) {
            attackerPlayer.modifyGold(plunder);
            colonyPlayer.modifyGold(-plunder);
            cs.addPartial(ChangeSet.See.only(attackerPlayer), attackerPlayer, "gold", String.valueOf(attackerPlayer.getGold()));
            cs.addPartial(ChangeSet.See.only(colonyPlayer), colonyPlayer, "gold", String.valueOf(colonyPlayer.getGold()));
        }
        for (Modifier m : CollectionUtils.transform(colony.getModifiers(), CollectionUtils.matchKey(Specification.COLONY_GOODS_PARTY_SOURCE, Feature::getSource))) {
            colony.removeModifier(m);
        }
        colony.csChangeOwner(attackerPlayer, true, "model.unitChange.capture", cs);
        cs.addAttribute(ChangeSet.See.only(attackerPlayer), "sound", "sound.event.captureColony");
        attackerPlayer.invalidateCanSeeTiles();
        colonyPlayer.invalidateCanSeeTiles();
    }

    private void csCaptureConvert(Unit attacker, IndianSettlement is, Random random, ChangeSet cs) {
        Specification spec = this.getGame().getSpecification();
        Player attackerPlayer = attacker.getOwner();
        Player nativePlayer = is.getOwner();
        StringTemplate convertNation = nativePlayer.getNationLabel();
        ServerUnit convert = (ServerUnit)RandomUtils.getRandomMember(logger, "Choose convert", is.getAllUnitsList(), random);
        if (((ServerPlayer)nativePlayer).csChangeOwner(convert, attackerPlayer, "model.unitChange.conversion", attacker.getTile(), cs)) {
            convert.changeRole(spec.getDefaultRole(), 0);
            for (Goods g : convert.getCompactGoodsList()) {
                convert.removeGoods(g);
            }
            convert.setMovesLeft(0);
            convert.setState(Unit.UnitState.ACTIVE);
            cs.add(ChangeSet.See.only(nativePlayer), is.getTile());
            cs.addMessage(attackerPlayer, (ModelMessage)((StringTemplate)((StringTemplate)new ModelMessage(ModelMessage.MessageType.COMBAT_RESULT, "combat.newConvertFromAttack", convert).addStringTemplate("%unit%", attacker.getLabel())).addStringTemplate("%enemyNation%", convertNation)).addStringTemplate("%enemyUnit%", convert.getLabel()));
            attackerPlayer.invalidateCanSeeTiles();
        }
    }

    private void csCaptureEquip(Unit winner, Unit loser, ChangeSet cs) {
        Role role = loser.getRole();
        this.csLoseEquip(winner, loser, cs);
        this.csCaptureEquipment(winner, loser, role, cs);
    }

    private void csCaptureEquipment(Unit winner, Unit loser, Role role, ChangeSet cs) {
        Player winnerPlayer = winner.getOwner();
        Player loserPlayer = loser.getOwner();
        Role newRole = winner.canCaptureEquipment(role);
        if (newRole != null) {
            List<AbstractGoods> newGoods = winner.getGoodsDifference(newRole, 1);
            GoodsType goodsType = newGoods.get(0).getType();
            winner.changeRole(newRole, 1);
            if (winnerPlayer.isIndian()) {
                StringTemplate winnerNation = winner.getApparentOwnerName();
                cs.addMessage(loserPlayer, (ModelMessage)((StringTemplate)new ModelMessage(ModelMessage.MessageType.COMBAT_RESULT, "combat.equipmentCaptured", winnerPlayer).addStringTemplate("%nation%", winnerNation)).addNamed("%equipment%", goodsType));
                IndianSettlement is = winner.getHomeIndianSettlement();
                if (is != null) {
                    for (AbstractGoods ag : newGoods) {
                        is.addGoods(ag);
                        winnerPlayer.logCheat("teleported " + ag + " back to " + is.getName());
                    }
                    cs.add(ChangeSet.See.only(winnerPlayer), is);
                }
            }
        }
    }

    private void csCaptureUnit(Unit winner, Unit loser, ChangeSet cs) {
        String key;
        Player loserPlayer = loser.getOwner();
        StringTemplate loserNation = loserPlayer.getNationLabel();
        StringTemplate loserLocation = loser.getLocation().getLocationLabelFor(loserPlayer);
        StringTemplate loserLabel = loser.getLabel();
        Player winnerPlayer = winner.getOwner();
        StringTemplate winnerNation = winner.getApparentOwnerName();
        StringTemplate winnerLocation = winner.getLocation().getLocationLabelFor(winnerPlayer);
        Tile oldTile = loser.getTile();
        if (((ServerPlayer)loserPlayer).csChangeOwner(loser, winnerPlayer, "model.unitChange.capture", winner.getTile(), cs)) {
            loser.setMovesLeft(0);
            loser.setState(Unit.UnitState.ACTIVE);
            cs.add(ChangeSet.See.perhaps().always(loserPlayer), oldTile);
            key = "combat.unitCaptured.enemy." + loser.getType().getSuffix();
            cs.addMessage(winnerPlayer, (ModelMessage)((StringTemplate)((StringTemplate)((StringTemplate)new ModelMessage(ModelMessage.MessageType.COMBAT_RESULT, key, loser).addDefaultId("combat.unitCaptured.enemy").addStringTemplate("%location%", winnerLocation)).addStringTemplate("%unit%", winner.getLabel())).addStringTemplate("%enemyNation%", loserNation)).addStringTemplate("%enemyUnit%", loserLabel));
        }
        key = "combat.unitCaptured.ours." + loser.getType().getSuffix();
        cs.addMessage(loserPlayer, (ModelMessage)((StringTemplate)((StringTemplate)((StringTemplate)new ModelMessage(ModelMessage.MessageType.COMBAT_RESULT, key, oldTile).addDefaultId("combat.unitCaptured.ours").addStringTemplate("%location%", loserLocation)).addStringTemplate("%unit%", loserLabel)).addStringTemplate("%enemyNation%", winnerNation)).addStringTemplate("%enemyUnit%", winner.getLabel()));
        winnerPlayer.invalidateCanSeeTiles();
        loserPlayer.invalidateCanSeeTiles();
    }

    private void csDamageColonyShips(Unit attacker, Colony colony, ChangeSet cs) {
        boolean captureRepairing = this.getSpecification().getBoolean("model.option.captureUnitsUnderRepair");
        List<Unit> units = CollectionUtils.transform(colony.getTile().getUnits(), u -> u.isNaval() && (!captureRepairing || !u.isDamaged()));
        if (!units.isEmpty()) {
            Player shipPlayer = colony.getOwner();
            Unit ship = units.get(0);
            Location repairLocation = ship.getRepairLocation();
            StringTemplate t = StringTemplate.label(", ");
            for (Unit u2 : units) {
                this.csDamageShip(u2, repairLocation, cs);
                t.addStringTemplate(u2.getLabel());
            }
            cs.addMessage(shipPlayer, (ModelMessage)((StringTemplate)((StringTemplate)new ModelMessage(ModelMessage.MessageType.COMBAT_RESULT, "combat.shipsDamaged", shipPlayer).addStringTemplate("%ships%", t)).addAmount("%number%", units.size())).addStringTemplate("%repairLocation%", repairLocation.getLocationLabelFor(shipPlayer)));
        }
    }

    private void csDamageShipAttack(Unit attacker, Unit ship, ChangeSet cs) {
        Player attackerPlayer = attacker.getOwner();
        StringTemplate attackerNation = attacker.getApparentOwnerName();
        Player shipPlayer = ship.getOwner();
        Location shipLocation = ship.getLocation();
        Location repair = ship.getRepairLocation();
        StringTemplate repairLoc = repair.getLocationLabelFor(shipPlayer);
        StringTemplate shipNation = ship.getApparentOwnerName();
        cs.addMessage(attackerPlayer, (ModelMessage)((StringTemplate)((StringTemplate)((StringTemplate)new ModelMessage(ModelMessage.MessageType.COMBAT_RESULT, "combat.shipDamaged.enemy", attacker).addStringTemplate("%location%", shipLocation.getLocationLabelFor(attackerPlayer))).addStringTemplate("%unit%", attacker.getLabel())).addStringTemplate("%enemyNation%", shipNation)).addStringTemplate("%enemyUnit%", ship.getLabel()));
        cs.addMessage(shipPlayer, (ModelMessage)((StringTemplate)((StringTemplate)((StringTemplate)((StringTemplate)new ModelMessage(ModelMessage.MessageType.COMBAT_RESULT, "combat.shipDamaged.ours", ship).addStringTemplate("%location%", shipLocation.getLocationLabelFor(shipPlayer))).addStringTemplate("%unit%", ship.getLabel())).addStringTemplate("%enemyUnit%", attacker.getLabel())).addStringTemplate("%enemyNation%", attackerNation)).addStringTemplate("%repairLocation%", repairLoc));
        this.csDamageShip(ship, repair, cs);
    }

    private void csDamageShipBombard(Settlement settlement, Unit ship, ChangeSet cs) {
        Player attackerPlayer = settlement.getOwner();
        Player shipPlayer = ship.getOwner();
        Building building = ((Colony)settlement).getStockade();
        Location repair = ship.getRepairLocation();
        StringTemplate repairLoc = repair.getLocationLabelFor(shipPlayer);
        StringTemplate shipNation = ship.getApparentOwnerName();
        cs.addMessage(attackerPlayer, (ModelMessage)((StringTemplate)((StringTemplate)((StringTemplate)new ModelMessage(ModelMessage.MessageType.COMBAT_RESULT, "combat.shipDamagedByBombardment.enemy", settlement).addStringTemplate("%location%", settlement.getLocationLabelFor(attackerPlayer))).addNamed("%building%", building)).addStringTemplate("%enemyNation%", shipNation)).addStringTemplate("%enemyUnit%", ship.getLabel()));
        cs.addMessage(shipPlayer, (ModelMessage)((StringTemplate)((StringTemplate)((StringTemplate)((StringTemplate)new ModelMessage(ModelMessage.MessageType.COMBAT_RESULT, "combat.shipDamagedByBombardment.ours", ship).addStringTemplate("%location%", settlement.getLocationLabelFor(shipPlayer))).addStringTemplate("%unit%", ship.getLabel())).addNamed("%building%", building)).addStringTemplate("%enemyNation%", attackerPlayer.getNationLabel())).addStringTemplate("%repairLocation%", repairLoc));
        this.csDamageShip(ship, repair, cs);
    }

    private void csDamageShip(Unit ship, Location repair, ChangeSet cs) {
        Player owner = ship.getOwner();
        for (Goods g : ship.getCompactGoodsList()) {
            ship.remove(g);
        }
        for (Unit u : ship.getUnitList()) {
            ship.remove(u);
            ((ServerUnit)u).csRemove(ChangeSet.See.only(owner), null, cs);
        }
        Location shipLoc = repair instanceof Colony ? repair.getTile() : repair;
        ship.damageShip(shipLoc);
        cs.add(ChangeSet.See.only(owner), (FreeColGameObject)((Object)shipLoc));
        owner.invalidateCanSeeTiles();
    }

    private void csDemoteUnit(Unit winner, Unit loser, ChangeSet cs) {
        Player loserPlayer = loser.getOwner();
        StringTemplate loserNation = loser.getApparentOwnerName();
        StringTemplate loserLocation = loser.getLocation().getLocationLabelFor(loserPlayer);
        StringTemplate loserLabel = loser.getLabel();
        Player winnerPlayer = winner.getOwner();
        StringTemplate winnerNation = winner.getApparentOwnerName();
        StringTemplate winnerLocation = winner.getLocation().getLocationLabelFor(winnerPlayer);
        String suffix = loser.getType().getSuffix();
        UnitTypeChange uc = loser.getUnitChange("model.unitChange.demotion");
        if (uc == null || uc.to == loser.getType()) {
            logger.warning("Demotion failed, type=" + (String)(uc == null ? "null" : "same type: " + uc.to));
            return;
        }
        loser.changeType(uc.to);
        loserPlayer.invalidateCanSeeTiles();
        String key = "combat.unitDemoted.enemy." + suffix;
        cs.addMessage(winnerPlayer, (ModelMessage)((StringTemplate)((StringTemplate)((StringTemplate)((StringTemplate)new ModelMessage(ModelMessage.MessageType.COMBAT_RESULT, key, winner).addDefaultId("combat.unitDemoted.enemy").addStringTemplate("%location%", winnerLocation)).addStringTemplate("%unit%", winner.getLabel())).addStringTemplate("%enemyNation%", loserNation)).addStringTemplate("%oldName%", loserLabel)).addStringTemplate("%enemyUnit%", loser.getLabel()));
        key = "combat.unitDemoted.ours." + suffix;
        cs.addMessage(loserPlayer, (ModelMessage)((StringTemplate)((StringTemplate)((StringTemplate)((StringTemplate)new ModelMessage(ModelMessage.MessageType.COMBAT_RESULT, key, loser).addDefaultId("combat.unitDemoted.ours").addStringTemplate("%location%", loserLocation)).addStringTemplate("%oldName%", loserLabel)).addStringTemplate("%unit%", loser.getLabel())).addStringTemplate("%enemyNation%", winnerNation)).addStringTemplate("%enemyUnit%", winner.getLabel()));
    }

    private void csDestroyColony(Unit attacker, Colony colony, Random random, ChangeSet cs) {
        Game game = attacker.getGame();
        Player attackerPlayer = attacker.getOwner();
        StringTemplate attackerNation = attacker.getApparentOwnerName();
        Player colonyPlayer = colony.getOwner();
        StringTemplate colonyNation = colonyPlayer.getNationLabel();
        int plunder = colony.getPlunder(attacker, random);
        cs.addHistory(colonyPlayer, (HistoryEvent)((StringTemplate)new HistoryEvent(game.getTurn(), HistoryEvent.HistoryEventType.COLONY_DESTROYED, attackerPlayer).addStringTemplate("%nation%", attackerNation)).addName("%colony%", colony.getName()));
        cs.addMessage(colonyPlayer, (ModelMessage)((StringTemplate)((StringTemplate)((StringTemplate)new ModelMessage(ModelMessage.MessageType.COMBAT_RESULT, "combat.colonyBurned.ours", colony.getTile()).addName("%colony%", colony.getName())).addStringTemplate("%enemyNation%", attackerNation)).addStringTemplate("%enemyUnit%", attacker.getLabel())).addAmount("%amount%", plunder));
        cs.addGlobalMessage(game, colonyPlayer, (ModelMessage)((StringTemplate)((StringTemplate)new ModelMessage(ModelMessage.MessageType.COMBAT_RESULT, "combat.colonyBurned.other", colonyPlayer).addName("%colony%", colony.getName())).addStringTemplate("%nation%", colonyNation)).addStringTemplate("%attackerNation%", attackerNation));
        ((ServerPlayer)colonyPlayer).csLoseLocation(colony, cs);
        if (plunder > 0) {
            attackerPlayer.modifyGold(plunder);
            colonyPlayer.modifyGold(-plunder);
            cs.addPartial(ChangeSet.See.only(attackerPlayer), attackerPlayer, "gold", String.valueOf(attackerPlayer.getGold()));
            cs.addPartial(ChangeSet.See.only(colonyPlayer), colonyPlayer, "gold", String.valueOf(colonyPlayer.getGold()));
        }
        this.csDisposeSettlement(colony, cs);
    }

    private void csDestroySettlement(Unit attacker, IndianSettlement is, Random random, ChangeSet cs) {
        Game game = this.getGame();
        Specification spec = game.getSpecification();
        Tile tile = is.getTile();
        Player attackerPlayer = attacker.getOwner();
        Player nativePlayer = is.getOwner();
        StringTemplate attackerNation = attackerPlayer.getNationLabel();
        StringTemplate nativeNation = nativePlayer.getNationLabel();
        String settlementName = is.getName();
        boolean capital = is.isCapital();
        int plunder = is.getPlunder(attacker, random);
        for (Unit u : is.getOwnedUnitList()) {
            u.changeHomeIndianSettlement(null);
            cs.add(ChangeSet.See.only(nativePlayer), u);
        }
        this.csDisposeSettlement(is, cs);
        if (plunder > 0) {
            List<UnitType> unitTypes = spec.getUnitTypesWithAbility("model.ability.carryTreasure");
            UnitType type = RandomUtils.getRandomMember(logger, "Choose train", unitTypes, random);
            ServerUnit train = new ServerUnit(game, tile, attackerPlayer, type);
            train.setTreasureAmount(plunder);
        }
        int score = spec.getInteger("model.option.destroySettlementScore");
        HistoryEvent h = (HistoryEvent)((StringTemplate)new HistoryEvent(game.getTurn(), HistoryEvent.HistoryEventType.DESTROY_SETTLEMENT, this).addStringTemplate("%nation%", nativeNation)).addName("%settlement%", settlementName);
        h.setScore(score);
        cs.addHistory(attackerPlayer, h);
        cs.addMessage(attackerPlayer, (ModelMessage)((StringTemplate)((StringTemplate)((StringTemplate)new ModelMessage(ModelMessage.MessageType.COMBAT_RESULT, "combat.destroySettlement.enemy", attacker).addName("%settlement%", settlementName)).addStringTemplate("%unit%", attacker.getLabel())).addStringTemplate("%nativeNation%", nativeNation)).addAmount("%amount%", plunder));
        if (capital) {
            cs.addMessage(attackerPlayer, (ModelMessage)new ModelMessage(ModelMessage.MessageType.FOREIGN_DIPLOMACY, "combat.destroySettlement.enemy.capital", attacker).addStringTemplate("%nation%", nativeNation));
        }
        if (((ServerPlayer)nativePlayer).checkForDeath() == DeadCheck.IS_DEAD) {
            h = (HistoryEvent)((StringTemplate)new HistoryEvent(game.getTurn(), HistoryEvent.HistoryEventType.DESTROY_NATION, this).addStringTemplate("%nation%", attackerNation)).addStringTemplate("%nativeNation%", nativeNation);
            h.setScore(-50);
            cs.addGlobalHistory(game, h);
        }
        cs.addAttribute(ChangeSet.See.only(attackerPlayer), "sound", "sound.event.destroySettlement");
    }

    public void csDisposeSettlement(Settlement settlement, ChangeSet cs) {
        ServerIndianSettlement sis;
        Player owner = settlement.getOwner();
        Set<Tile> owned = settlement.getOwnedTiles();
        logger.finest("Disposing of " + settlement.getName());
        for (Tile t2 : owned) {
            t2.cacheUnseen();
        }
        Tile centerTile = settlement.getTile();
        ServerPlayer missionaryOwner = null;
        int radius = 0;
        if (settlement instanceof ServerIndianSettlement && (sis = (ServerIndianSettlement)settlement).hasMissionary()) {
            missionaryOwner = (ServerPlayer)sis.getMissionary().getOwner();
            radius = sis.getMissionaryLineOfSight();
            sis.csKillMissionary(Boolean.TRUE, cs);
        }
        settlement.exciseSettlement();
        owner.removeSettlement(settlement);
        if (owner.hasSettlement(settlement)) {
            throw new IllegalStateException("Still has settlement: " + settlement);
        }
        ((ServerPlayer)owner).reassignTiles(owned, null);
        ChangeSet.See vis = ChangeSet.See.perhaps().always(owner);
        if (missionaryOwner != null) {
            vis.except(missionaryOwner);
        }
        cs.add(vis, owned);
        cs.addRemove(vis, centerTile, settlement);
        settlement.dispose();
        owner.invalidateCanSeeTiles();
        if (missionaryOwner != null) {
            List<Tile> surrounding = CollectionUtils.transform(centerTile.getSurroundingTiles(1, radius), t -> !owned.contains(t));
            cs.add(ChangeSet.See.only(missionaryOwner), owned);
            cs.add(ChangeSet.See.only(missionaryOwner), surrounding);
            cs.addRemove(ChangeSet.See.only(missionaryOwner), centerTile, settlement);
            missionaryOwner.invalidateCanSeeTiles();
            for (Tile t3 : surrounding) {
                t3.cacheUnseen(missionaryOwner);
            }
        }
        for (Tile t4 : owned) {
            t4.cacheUnseen();
        }
        if (settlement instanceof IndianSettlement) {
            centerTile.seeTile();
        }
        if (missionaryOwner != null) {
            centerTile.seeTile(missionaryOwner);
        }
    }

    private void csEvadeAttack(Unit attacker, Unit defender, ChangeSet cs) {
        Player attackerPlayer = attacker.getOwner();
        StringTemplate attackerNation = attacker.getApparentOwnerName();
        Location attackerLocation = attacker.getLocation();
        Player defenderPlayer = defender.getOwner();
        StringTemplate defenderNation = defender.getApparentOwnerName();
        Location defenderLocation = defender.getLocation();
        cs.addMessage(attackerPlayer, (ModelMessage)((StringTemplate)((StringTemplate)((StringTemplate)new ModelMessage(ModelMessage.MessageType.COMBAT_RESULT, "combat.shipEvaded.enemy", attacker).addStringTemplate("%location%", attackerLocation.getLocationLabelFor(attackerPlayer))).addStringTemplate("%unit%", attacker.getLabel())).addStringTemplate("%enemyNation%", defenderNation)).addStringTemplate("%enemyUnit%", defender.getLabel()));
        cs.addMessage(defenderPlayer, (ModelMessage)((StringTemplate)((StringTemplate)((StringTemplate)new ModelMessage(ModelMessage.MessageType.COMBAT_RESULT, "combat.shipEvaded.ours", defender).addStringTemplate("%location%", defenderLocation.getLocationLabelFor(defenderPlayer))).addStringTemplate("%unit%", defender.getLabel())).addStringTemplate("%enemyNation%", attackerNation)).addStringTemplate("%enemyUnit%", attacker.getLabel()));
    }

    private void csEvadeBombard(Settlement settlement, Unit defender, ChangeSet cs) {
        Player attackerPlayer = settlement.getOwner();
        Player defenderPlayer = defender.getOwner();
        StringTemplate defenderNation = defender.getApparentOwnerName();
        Building building = ((Colony)settlement).getStockade();
        cs.addMessage(attackerPlayer, (ModelMessage)((StringTemplate)((StringTemplate)((StringTemplate)new ModelMessage(ModelMessage.MessageType.COMBAT_RESULT, "combat.shipEvadedBombardment.enemy", settlement).addStringTemplate("%location%", settlement.getLocationLabelFor(attackerPlayer))).addNamed("%building%", building)).addStringTemplate("%enemyNation%", defenderNation)).addStringTemplate("%enemyUnit%", defender.getLabel()));
        cs.addMessage(defenderPlayer, (ModelMessage)((StringTemplate)((StringTemplate)((StringTemplate)new ModelMessage(ModelMessage.MessageType.COMBAT_RESULT, "combat.shipEvadedBombardment.ours", defender).addStringTemplate("%location%", settlement.getLocationLabelFor(defenderPlayer))).addStringTemplate("%unit%", defender.getLabel())).addNamed("%building%", building)).addStringTemplate("%enemyNation%", attackerPlayer.getNationLabel()));
    }

    private void csLootShip(Unit winner, Unit loser, ChangeSet cs) {
        Player winnerPlayer = winner.getOwner();
        List<Goods> capture = loser.getGoodsList();
        if (!capture.isEmpty() && winner.hasSpaceLeft()) {
            for (Goods g : capture) {
                g.setLocation(null);
            }
            new LootSession(winner, loser, capture).register();
            cs.add(ChangeSet.See.only(winnerPlayer), new LootCargoMessage(winner, loser.getId(), capture));
        }
        loser.getGoodsContainer().removeAll();
        loser.setState(Unit.UnitState.ACTIVE);
    }

    private void csLoseAutoEquip(Unit attacker, Unit defender, ChangeSet cs) {
        Player defenderPlayer = defender.getOwner();
        StringTemplate defenderNation = defenderPlayer.getNationLabel();
        Settlement settlement = defender.getSettlement();
        Role role = defender.getAutomaticRole();
        StringTemplate defenderLabel = Messages.getUnitLabel(null, defender.getType().getId(), 1, defenderPlayer.getNation().getId(), role.getId(), null);
        Player attackerPlayer = attacker.getOwner();
        StringTemplate attackerNation = attacker.getApparentOwnerName();
        for (AbstractGoods ag : role.getRequiredGoodsList()) {
            settlement.removeGoods(ag);
        }
        cs.addMessage(attackerPlayer, (ModelMessage)((StringTemplate)((StringTemplate)((StringTemplate)((StringTemplate)new ModelMessage(ModelMessage.MessageType.COMBAT_RESULT, "combat.unitDemotedToUnarmed.enemy", attacker).addStringTemplate("%location%", settlement.getLocationLabelFor(attackerPlayer))).addStringTemplate("%unit%", attacker.getLabel())).addStringTemplate("%oldName%", defenderLabel)).addStringTemplate("%enemyNation%", defenderNation)).addStringTemplate("%enemyUnit%", defender.getLabel()));
        cs.addMessage(defenderPlayer, (ModelMessage)((StringTemplate)((StringTemplate)((StringTemplate)new ModelMessage(ModelMessage.MessageType.COMBAT_RESULT, "combat.unitLoseAutoEquip", defender).addStringTemplate("%location%", settlement.getLocationLabelFor(defenderPlayer))).addStringTemplate("%unit%", defender.getLabel())).addStringTemplate("%enemyNation%", attackerNation)).addStringTemplate("%enemyUnit%", attacker.getLabel()));
    }

    private void csLoseEquip(Unit winner, Unit loser, ChangeSet cs) {
        Specification spec = this.getSpecification();
        Player loserPlayer = loser.getOwner();
        StringTemplate loserNation = loserPlayer.getNationLabel();
        StringTemplate loserLocation = loser.getLocation().getLocationLabelFor(loserPlayer);
        StringTemplate loserLabel = loser.getLabel();
        Player winnerPlayer = winner.getOwner();
        StringTemplate winnerNation = winner.getApparentOwnerName();
        StringTemplate winnerLocation = winner.getLocation().getLocationLabelFor(winnerPlayer);
        Role role = loser.getRole();
        Role downgrade = role.getDowngrade();
        if (downgrade != null) {
            loser.changeRole(downgrade, 1);
        } else {
            loser.changeRole(spec.getDefaultRole(), 0);
        }
        loser.setMovesLeft(Math.min(loser.getMovesLeft(), loser.getInitialMovesLeft()));
        if (!loser.isArmed()) {
            cs.addMessage(winnerPlayer, (ModelMessage)((StringTemplate)((StringTemplate)((StringTemplate)((StringTemplate)new ModelMessage(ModelMessage.MessageType.COMBAT_RESULT, "combat.unitDemotedToUnarmed.enemy", winner).addStringTemplate("%location%", winnerLocation)).addStringTemplate("%unit%", winner.getLabel())).addStringTemplate("%oldName%", loserLabel)).addStringTemplate("%enemyNation%", loserNation)).addStringTemplate("%enemyUnit%", loser.getLabel()));
            cs.addMessage(loserPlayer, (ModelMessage)((StringTemplate)((StringTemplate)((StringTemplate)((StringTemplate)new ModelMessage(ModelMessage.MessageType.COMBAT_RESULT, "combat.unitDemotedToUnarmed.ours", loser).addStringTemplate("%location%", loserLocation)).addStringTemplate("%oldName%", loserLabel)).addStringTemplate("%unit%", loser.getLabel())).addStringTemplate("%enemyNation%", winnerNation)).addStringTemplate("%enemyUnit%", winner.getLabel()));
            loser.setState(Unit.UnitState.ACTIVE);
        } else {
            String key = "combat.unitDemoted.enemy." + loser.getType().getSuffix();
            cs.addMessage(winnerPlayer, (ModelMessage)((StringTemplate)((StringTemplate)((StringTemplate)((StringTemplate)new ModelMessage(ModelMessage.MessageType.COMBAT_RESULT, key, winner).addDefaultId("combat.unitDemoted.enemy").addStringTemplate("%location%", winnerLocation)).addStringTemplate("%unit%", winner.getLabel())).addStringTemplate("%oldName%", loserLabel)).addStringTemplate("%enemyNation%", loserNation)).addStringTemplate("%enemyUnit%", loser.getLabel()));
            key = "combat.unitDemoted.ours." + loser.getType().getSuffix();
            cs.addMessage(loserPlayer, (ModelMessage)((StringTemplate)((StringTemplate)((StringTemplate)((StringTemplate)new ModelMessage(ModelMessage.MessageType.COMBAT_RESULT, key, loser).addDefaultId("combat.unitDemoted.ours").addStringTemplate("%location%", loserLocation)).addStringTemplate("%oldName%", loserLabel)).addStringTemplate("%unit%", loser.getLabel())).addStringTemplate("%enemyNation%", winnerNation)).addStringTemplate("%enemyUnit%", winner.getLabel()));
        }
    }

    public void csLoseLocation(Location loc, ChangeSet cs) {
        for (TradeRoute tr : CollectionUtils.transform(this.getTradeRoutes(), r -> r.removeMatchingStops(loc))) {
            for (Unit u : tr.getAssignedUnits()) {
                u.setTradeRoute(null);
                cs.add(ChangeSet.See.only(this), u);
            }
            cs.addMessage(this, (ModelMessage)((StringTemplate)new ModelMessage(ModelMessage.MessageType.GOODS_MOVEMENT, "combat.tradeRouteSuspended", this).addName("%route%", tr.getName())).addStringTemplate("%stop%", loc.getLocationLabel()));
            cs.add(ChangeSet.See.only(this), tr);
        }
    }

    private void csPillageColony(Unit attacker, Colony colony, Random random, ChangeSet cs) {
        Player attackerPlayer = attacker.getOwner();
        StringTemplate attackerNation = attacker.getApparentOwnerName();
        Player colonyPlayer = colony.getOwner();
        StringTemplate colonyNation = colonyPlayer.getNationLabel();
        List<Building> buildingList = colony.getBurnableBuildings();
        List<Unit> shipList = colony.getTile().getNavalUnits();
        List<Goods> goodsList = colony.getLootableGoodsList();
        int pillage = RandomUtils.randomInt(logger, "Pillage choice", random, buildingList.size() + shipList.size() + goodsList.size() + (colony.canBePlundered() ? 1 : 0));
        if (pillage < buildingList.size()) {
            Building building = buildingList.get(pillage);
            this.csDamageBuilding(building, cs);
            cs.addMessage(colonyPlayer, (ModelMessage)((StringTemplate)((StringTemplate)((StringTemplate)new ModelMessage(ModelMessage.MessageType.COMBAT_RESULT, "combat.raid.building", colony).addName("%colony%", colony.getName())).addNamed("%building%", building)).addStringTemplate("%enemyNation%", attackerNation)).addStringTemplate("%enemyUnit%", attacker.getLabel()));
        } else if (pillage < buildingList.size() + shipList.size()) {
            Unit ship = shipList.get(pillage - buildingList.size());
            if (ship.getRepairLocation() == null) {
                this.csSinkShipAttack(attacker, ship, cs);
            } else {
                this.csDamageShipAttack(attacker, ship, cs);
            }
        } else if (pillage < buildingList.size() + shipList.size() + goodsList.size()) {
            Goods goods = goodsList.get(pillage - buildingList.size() - shipList.size());
            goods.setAmount(Math.min(goods.getAmount() / 2, 50));
            colony.removeGoods(goods);
            if (attacker.canAdd(goods)) {
                attacker.add(goods);
            }
            cs.addMessage(colonyPlayer, (ModelMessage)((StringTemplate)((StringTemplate)((StringTemplate)((StringTemplate)new ModelMessage(ModelMessage.MessageType.COMBAT_RESULT, "combat.raid.goods", colony, goods).addName("%colony%", colony.getName())).addAmount("%amount%", goods.getAmount())).addNamed("%goods%", goods.getType())).addStringTemplate("%enemyNation%", attackerNation)).addStringTemplate("%enemyUnit%", attacker.getLabel()));
        } else {
            int plunder = Math.max(1, colony.getPlunder(attacker, random) / 5);
            colonyPlayer.modifyGold(-plunder);
            attackerPlayer.modifyGold(plunder);
            cs.addPartial(ChangeSet.See.only(colonyPlayer), colonyPlayer, "gold", String.valueOf(colonyPlayer.getGold()));
            cs.addMessage(colonyPlayer, (ModelMessage)((StringTemplate)((StringTemplate)((StringTemplate)new ModelMessage(ModelMessage.MessageType.COMBAT_RESULT, "combat.raid.plunder", colony).addAmount("%amount%", plunder)).addName("%colony%", colony.getName())).addStringTemplate("%enemyNation%", attackerNation)).addStringTemplate("%enemyUnit%", attacker.getLabel()));
        }
        cs.addGlobalMessage(this.getGame(), colonyPlayer, (ModelMessage)((StringTemplate)((StringTemplate)new ModelMessage(ModelMessage.MessageType.COMBAT_RESULT, "combat.raid.other", colonyPlayer).addName("%colony%", colony.getName())).addStringTemplate("%colonyNation%", colonyNation)).addStringTemplate("%nation%", attackerNation));
    }

    private void csDamageBuilding(Building building, ChangeSet cs) {
        ServerColony colony = (ServerColony)building.getColony();
        Tile copied = colony.getTile().getTileToCache();
        boolean changed = false;
        BuildingType type = building.getType();
        if (type.getUpgradesFrom() == null) {
            changed = colony.ejectUnits(building, building.getUnitList());
            colony.destroyBuilding(building);
            changed |= building.getType().isDefenceType();
            cs.addRemove(ChangeSet.See.only(colony.getOwner()), colony, building);
            building.dispose();
            for (WorkLocation wl : CollectionUtils.transform(colony.getAllWorkLocations(), w -> !w.isEmpty() && !w.canBeWorked())) {
                changed |= colony.ejectUnits(wl, wl.getUnitList());
                logger.info("Units ejected from workLocation " + wl.getId() + " on loss of " + building.getType().getSuffix());
            }
        } else if (building.canBeDamaged()) {
            changed = colony.ejectUnits(building, building.downgrade());
            changed |= building.getType().isDefenceType();
        } else {
            return;
        }
        if (changed) {
            colony.getTile().cacheUnseen(copied);
        }
        if (this.isAI()) {
            colony.firePropertyChange("rearrangeColony", true, false);
        }
    }

    private void csPromoteUnit(Unit winner, ChangeSet cs) {
        Player winnerPlayer = winner.getOwner();
        StringTemplate winnerLabel = winner.getLabel();
        UnitTypeChange uc = winner.getUnitChange("model.unitChange.promotion");
        if (uc == null || uc.to == winner.getType()) {
            logger.warning("Promotion failed, type=" + (String)(uc == null ? "null" : "same type: " + uc.to));
            return;
        }
        winner.changeType(uc.to);
        winnerPlayer.invalidateCanSeeTiles();
        cs.addMessage(winnerPlayer, (ModelMessage)((StringTemplate)new ModelMessage(ModelMessage.MessageType.COMBAT_RESULT, "combat.unitPromoted", winner).addStringTemplate("%oldName%", winnerLabel)).addStringTemplate("%unit%", winner.getLabel()));
    }

    private void csSinkColonyShips(Unit attacker, Colony colony, ChangeSet cs) {
        boolean captureRepairing = this.getSpecification().getBoolean("model.option.captureUnitsUnderRepair");
        List<Unit> units = CollectionUtils.transform(colony.getTile().getUnits(), u -> u.isNaval() && (!captureRepairing || !u.isDamaged()));
        if (!units.isEmpty()) {
            Player shipPlayer = colony.getOwner();
            Player attackerPlayer = attacker.getOwner();
            StringTemplate t = StringTemplate.label(", ");
            for (Unit u2 : units) {
                this.csSinkShip(u2, attackerPlayer, cs);
                t.addStringTemplate(u2.getLabel());
            }
            cs.addMessage(shipPlayer, (ModelMessage)((StringTemplate)new ModelMessage(ModelMessage.MessageType.COMBAT_RESULT, "combat.shipsSunk", shipPlayer).addStringTemplate("%ships%", t)).addAmount("%number%", units.size()));
        }
    }

    private void csSinkShipAttack(Unit attacker, Unit ship, ChangeSet cs) {
        Player shipPlayer = ship.getOwner();
        StringTemplate shipNation = ship.getApparentOwnerName();
        Location shipLocation = ship.getLocation();
        Unit attackerUnit = attacker;
        Player attackerPlayer = attackerUnit.getOwner();
        StringTemplate attackerNation = attackerUnit.getApparentOwnerName();
        cs.addMessage(attackerPlayer, (ModelMessage)((StringTemplate)((StringTemplate)((StringTemplate)new ModelMessage(ModelMessage.MessageType.COMBAT_RESULT, "combat.shipSunk.enemy", attackerUnit).addStringTemplate("%location%", shipLocation.getLocationLabelFor(attackerPlayer))).addStringTemplate("%unit%", attackerUnit.getLabel())).addStringTemplate("%enemyUnit%", ship.getLabel())).addStringTemplate("%enemyNation%", shipNation));
        cs.addMessage(shipPlayer, (ModelMessage)((StringTemplate)((StringTemplate)((StringTemplate)new ModelMessage(ModelMessage.MessageType.COMBAT_RESULT, "combat.shipSunk.ours", ship.getTile()).addStringTemplate("%location%", shipLocation.getLocationLabelFor(shipPlayer))).addStringTemplate("%unit%", ship.getLabel())).addStringTemplate("%enemyUnit%", attackerUnit.getLabel())).addStringTemplate("%enemyNation%", attackerNation));
        this.csSinkShip(ship, attackerPlayer, cs);
    }

    private void csSinkShipBombard(Settlement settlement, Unit ship, ChangeSet cs) {
        Player attackerPlayer = settlement.getOwner();
        Player shipPlayer = ship.getOwner();
        StringTemplate shipNation = ship.getApparentOwnerName();
        Building building = ((Colony)settlement).getStockade();
        cs.addMessage(attackerPlayer, (ModelMessage)((StringTemplate)((StringTemplate)((StringTemplate)new ModelMessage(ModelMessage.MessageType.COMBAT_RESULT, "combat.shipSunkByBombardment.enemy", settlement).addStringTemplate("%location%", settlement.getLocationLabelFor(attackerPlayer))).addNamed("%building%", building)).addStringTemplate("%enemyUnit%", ship.getLabel())).addStringTemplate("%enemyNation%", shipNation));
        cs.addMessage(shipPlayer, (ModelMessage)((StringTemplate)((StringTemplate)((StringTemplate)new ModelMessage(ModelMessage.MessageType.COMBAT_RESULT, "combat.shipSunkByBombardment", ship.getTile()).addStringTemplate("%location%", settlement.getLocationLabelFor(shipPlayer))).addStringTemplate("%unit%", ship.getLabel())).addNamed("%building%", building)).addStringTemplate("%enemyNation%", attackerPlayer.getNationLabel()));
        this.csSinkShip(ship, attackerPlayer, cs);
    }

    private void csSinkShip(Unit ship, Player attackerPlayer, ChangeSet cs) {
        Player shipPlayer = ship.getOwner();
        ((ServerUnit)ship).csRemove(ChangeSet.See.perhaps().always(shipPlayer), ship.getLocation(), cs);
        shipPlayer.invalidateCanSeeTiles();
        if (attackerPlayer != null) {
            cs.addAttribute(ChangeSet.See.only(attackerPlayer), "sound", "sound.event.shipSunk");
        }
    }

    private void csSlaughterUnit(Unit winner, Unit loser, ChangeSet cs) {
        Player winnerPlayer = winner.getOwner();
        StringTemplate winnerNation = winner.getApparentOwnerName();
        Location winnerLoc = winner.isInColony() ? winner.getColony() : winner.getLocation();
        StringTemplate winnerLocation = winnerLoc.getLocationLabelFor(winnerPlayer);
        Player loserPlayer = loser.getOwner();
        StringTemplate loserNation = loser.getApparentOwnerName();
        Location loserLoc = loser.isInColony() ? loser.getColony() : loser.getLocation();
        StringTemplate loserLocation = loserLoc.getLocationLabelFor(loserPlayer);
        String key = "combat.unitSlaughtered.enemy." + loser.getType().getSuffix();
        cs.addMessage(winnerPlayer, (ModelMessage)((StringTemplate)((StringTemplate)((StringTemplate)new ModelMessage(ModelMessage.MessageType.COMBAT_RESULT, key, winner).addDefaultId("combat.unitSlaughtered.enemy").addStringTemplate("%location%", winnerLocation)).addStringTemplate("%unit%", winner.getLabel())).addStringTemplate("%enemyNation%", loserNation)).addStringTemplate("%enemyUnit%", loser.getLabel()));
        key = "combat.unitSlaughtered.ours." + loser.getType().getSuffix();
        cs.addMessage(loserPlayer, (ModelMessage)((StringTemplate)((StringTemplate)((StringTemplate)new ModelMessage(ModelMessage.MessageType.COMBAT_RESULT, key, loser.getTile()).addDefaultId("combat.unitSlaughtered.ours").addStringTemplate("%location%", loserLocation)).addStringTemplate("%unit%", loser.getLabel())).addStringTemplate("%enemyNation%", winnerNation)).addStringTemplate("%enemyUnit%", winner.getLabel()));
        if (loserPlayer.isIndian() && ((ServerPlayer)loserPlayer).checkForDeath() == DeadCheck.IS_DEAD) {
            StringTemplate nativeNation = loserPlayer.getNationLabel();
            cs.addGlobalHistory(this.getGame(), (HistoryEvent)((StringTemplate)new HistoryEvent(this.getGame().getTurn(), HistoryEvent.HistoryEventType.DESTROY_NATION, winnerPlayer).addStringTemplate("%nation%", winnerPlayer.getNationLabel())).addStringTemplate("%nativeNation%", nativeNation));
        }
        ((ServerUnit)loser).csRemove(loserLoc.getSettlement() != null ? ChangeSet.See.only(loserPlayer) : ChangeSet.See.perhaps().always(loserPlayer), loserLoc, cs);
        loserPlayer.invalidateCanSeeTiles();
    }

    public void csSeeNewTiles(Collection<? extends Tile> newTiles, ChangeSet cs) {
        this.exploreTiles(newTiles);
        cs.add(ChangeSet.See.only(this), newTiles);
    }

    public Modifier makeTeaPartyModifier() {
        Specification spec = this.getGame().getSpecification();
        Turn turn = this.getGame().getTurn();
        Modifier modifier = CollectionUtils.first(spec.getModifiers("model.modifier.colonyGoodsParty"));
        if (modifier != null) {
            modifier = Modifier.makeTimedModifier("model.goods.bells", modifier, turn);
            modifier.setModifierIndex(90);
        }
        return modifier;
    }

    public void csRaiseTax(int tax, Goods goods, boolean accepted, ChangeSet cs) {
        GoodsType goodsType = goods.getType();
        Colony colony = (Colony)goods.getLocation();
        int amount = Math.min(goods.getAmount(), 100);
        if (accepted) {
            this.csSetTax(tax, cs);
            logger.info("Accepted tax raise to: " + tax);
        } else if (colony.getGoodsCount(goodsType) < amount) {
            int extraTax = 3;
            this.csSetTax(tax + 3, cs);
            cs.add(ChangeSet.See.only(this), new MonarchActionMessage(Monarch.MonarchAction.FORCE_TAX, (StringTemplate)StringTemplate.template(Monarch.MonarchAction.FORCE_TAX.getTextKey()).addAmount("%amount%", tax + 3), this.getNationId()));
            logger.info("Forced tax raise to: " + (tax + 3));
        } else {
            Specification spec = this.getGame().getSpecification();
            colony.getGoodsContainer().saveState();
            colony.removeGoods(goodsType, amount);
            int arrears = this.market.getPaidForSale(goodsType) * spec.getInteger("model.option.arrearsFactor");
            Market market = this.getMarket();
            market.setArrears(goodsType, arrears);
            Modifier tpm = this.makeTeaPartyModifier();
            cs.addModifier(this, colony, tpm, true);
            cs.add(ChangeSet.See.only(this), colony.getGoodsContainer());
            cs.add(ChangeSet.See.only(this), market.getMarketData(goodsType));
            Object messageId = "model.player.colonyGoodsParty." + goodsType.getSuffix();
            if (!Messages.containsKey((String)messageId)) {
                messageId = colony.isLandLocked() ? "model.player.colonyGoodsParty.landLocked" : "model.player.colonyGoodsParty.harbour";
            }
            cs.addMessage(this, (ModelMessage)((StringTemplate)((StringTemplate)new ModelMessage(ModelMessage.MessageType.FOREIGN_DIPLOMACY, (String)messageId, this).addName("%colony%", colony.getName())).addAmount("%amount%", amount)).addNamed("%goods%", goodsType));
            cs.addAttribute(ChangeSet.See.only(this), "flush", Boolean.TRUE.toString());
            logger.info("Goods party at " + colony.getName() + " with: " + goods + " arrears: " + arrears);
            if (this.isAI()) {
                colony.firePropertyChange("rearrangeColony", goodsType, null);
            }
        }
    }

    public void ignoreTax(int tax, Goods goods, ChangeSet cs) {
        this.csRaiseTax(tax, goods, true, cs);
        cs.addMessage(this, (ModelMessage)new ModelMessage(ModelMessage.MessageType.FOREIGN_DIPLOMACY, "model.player.ignoredTax", this).addAmount("%amount%", tax));
    }

    public void ignoreMercenaries(ChangeSet cs) {
        cs.addMessage(this, new ModelMessage(ModelMessage.MessageType.FOREIGN_DIPLOMACY, "model.player.ignoredMercenaries", this));
    }

    public void csMercenaries(int price, List<AbstractUnit> mercenaries, Monarch.MonarchAction action, Random random, ChangeSet cs) {
        if (price <= 0 || mercenaries.isEmpty()) {
            return;
        }
        int n = NameCache.getMercenaryLeaderIndex(random);
        cs.add(ChangeSet.See.only(this), new MonarchActionMessage(action, (StringTemplate)((StringTemplate)((StringTemplate)StringTemplate.template(action.getTextKey()).addName("%leader%", NameCache.getMercenaryLeaderName(n))).addAmount("%gold%", price)).addStringTemplate("%mercenaries%", AbstractUnit.getListLabel(", ", mercenaries)), Integer.toString(n)));
        new MonarchSession(this, action, mercenaries, price).register();
    }

    public void csSetTax(int tax, ChangeSet cs) {
        this.setTax(tax);
        if (this.recalculateBellsBonus()) {
            cs.add(ChangeSet.See.only(this), this);
        } else {
            cs.addPartial(ChangeSet.See.only(this), this, "tax", String.valueOf(this.getTax()));
        }
    }

    public void csAddMercenaries(List<AbstractUnit> mercs, int price, Random random, ChangeSet cs) {
        if (this.checkGold(price)) {
            Tile dst;
            Specification spec = this.getSpecification();
            Predicate<AbstractUnit> isNaval = au -> au.getType(spec).isNaval();
            Predicate<AbstractUnit> isLand = au -> !au.getType(spec).isNaval();
            List<AbstractUnit> naval = CollectionUtils.transform(mercs, isNaval);
            if (naval.isEmpty()) {
                dst = CollectionUtils.first(this.getColonies()).getTile();
                this.createUnits(mercs, dst, null);
                cs.add(ChangeSet.See.only(this), dst);
            } else {
                dst = this.getEntryTile();
                this.loadShips(this.createUnits(CollectionUtils.transform(mercs, isLand), null, null), this.createUnits(naval, dst, random), null);
                this.invalidateCanSeeTiles();
                cs.add(ChangeSet.See.perhaps(), dst);
            }
            cs.addMessage(this, (ModelMessage)new ModelMessage(ModelMessage.MessageType.UNIT_ARRIVED, "model.player.mercenariesArrived", this).addStringTemplate("%location%", dst.up().getLocationLabelFor(this)));
            this.modifyGold(-price);
            cs.addPartial(ChangeSet.See.only(this), this, "gold", String.valueOf(this.getGold()));
        } else {
            this.getMonarch().setDispleasure(true);
            cs.add(ChangeSet.See.only(this), new MonarchActionMessage(Monarch.MonarchAction.DISPLEASURE, StringTemplate.template(Monarch.MonarchAction.DISPLEASURE.getTextKey()), this.getNationId()));
        }
    }

    public boolean csContact(Player other, ChangeSet cs) {
        if (this.hasContacted(other)) {
            return false;
        }
        Game game = this.getGame();
        Turn turn = game.getTurn();
        if (this.isIndian()) {
            if (other.isIndian()) {
                return false;
            }
            cs.addHistory(other, (HistoryEvent)new HistoryEvent(turn, HistoryEvent.HistoryEventType.MEET_NATION, other).addStringTemplate("%nation%", this.getNationLabel()));
        } else {
            cs.addHistory(this, (HistoryEvent)new HistoryEvent(turn, HistoryEvent.HistoryEventType.MEET_NATION, other).addStringTemplate("%nation%", other.getNationLabel()));
        }
        logger.finest("First contact between " + this.getId() + " and " + other.getId());
        return true;
    }

    public void csNativeFirstContact(Player other, Tile tile, ChangeSet cs) {
        cs.add(ChangeSet.See.only(this), new FirstContactMessage(this, other, tile));
        this.csChangeStance(Stance.PEACE, other, true, cs);
        if (tile != null) {
            DiplomacySession ds = new DiplomacySession(tile.getFirstUnit(), tile.getOwningSettlement(), FreeCol.getTimeout(false));
            ds.register();
            ds.setAgreement(DiplomaticTrade.makePeaceTreaty(DiplomaticTrade.TradeContext.CONTACT, this, other));
        }
    }

    public void csEuropeanFirstContact(Unit unit, Settlement settlement, Unit otherUnit, ChangeSet cs) {
        DiplomacySession ds;
        Player other;
        if (settlement instanceof Colony) {
            other = settlement.getOwner();
            ds = DiplomacySession.findContactSession(unit, settlement);
        } else if (otherUnit != null) {
            other = otherUnit.getOwner();
            ds = DiplomacySession.findContactSession(unit, otherUnit);
        } else {
            throw new RuntimeException("Non-null settlement (" + settlement + ") or other unit (null) required");
        }
        if (ds != null) {
            return;
        }
        DiplomaticTrade agreement = DiplomaticTrade.makePeaceTreaty(DiplomaticTrade.TradeContext.CONTACT, this, other);
        long timeout = FreeCol.getTimeout(false);
        DiplomacySession session = settlement == null ? new DiplomacySession(unit, otherUnit, timeout) : new DiplomacySession(unit, settlement, timeout);
        session.register();
        session.setAgreement(agreement);
        cs.add(ChangeSet.See.only(this), session.getMessage(this));
        unit.setMovesLeft(0);
        cs.addPartial(ChangeSet.See.only(this), unit, "movesLeft", String.valueOf(unit.getMovesLeft()));
        logger.info("New European contact for " + unit + ", with session: " + session.getKey());
    }

    public boolean csChangeOwner(Unit unit, Player newOwner, String change, Location loc, ChangeSet cs) {
        if (newOwner == this) {
            return true;
        }
        Tile oldTile = unit.getTile();
        if (newOwner.isUndead()) {
            change = "model.unitChange.undead";
        }
        if (change != null) {
            UnitType mainType = unit.getType();
            UnitTypeChange uc = unit.getUnitChange(change, null, newOwner);
            if (uc != null) {
                if (uc.isAvailableTo(newOwner)) {
                    mainType = uc.to;
                } else {
                    logger.warning("Change type/owner failed for " + unit + " -> " + newOwner + "(" + change + "/" + uc + ")");
                    ((ServerUnit)unit).csRemove(ChangeSet.See.perhaps().always(this), oldTile, cs);
                    return false;
                }
            }
            for (Unit u : unit.getUnitList()) {
                uc = u.getUnitChange(change, null, newOwner);
                if (uc == null) continue;
                if (uc.isAvailableTo(newOwner)) {
                    if (uc.to == u.getType() || u.changeType(uc.to)) continue;
                    logger.warning("Type change failure: " + u + " -> " + uc.to);
                    continue;
                }
                logger.warning("Change type/owner failed for cargo " + u + " -> " + newOwner + "(" + change + "/" + uc + ")");
                ((ServerUnit)u).csRemove(ChangeSet.See.only(this), unit, cs);
            }
            if (mainType != unit.getType() && !unit.changeType(mainType)) {
                logger.warning("Type change failure: " + unit + " -> " + mainType);
                return false;
            }
        }
        unit.changeOwner(newOwner);
        if (loc != null) {
            unit.setLocation(loc);
        }
        if (unit.isCarrier()) {
            cs.addRemoves(ChangeSet.See.only(this), unit, unit.getUnitList());
        }
        cs.add(ChangeSet.See.only(newOwner), ((ServerPlayer)newOwner).exploreForUnit(unit));
        return true;
    }

    public void csCompleteNativeDemand(ServerPlayer demandPlayer, Unit unit, Colony colony, GoodsType type, int amount, Constants.IndianDemandAction result, ChangeSet cs) {
        cs.add(ChangeSet.See.only(demandPlayer), new IndianDemandMessage(unit, colony, type, amount).setResult(result));
        if (result == Constants.IndianDemandAction.INDIAN_DEMAND_ACCEPT) {
            if (type == null) {
                this.modifyGold(-amount);
                demandPlayer.modifyGold(amount);
                cs.addPartial(ChangeSet.See.only(this), this, "gold", String.valueOf(this.getGold()));
                cs.addPartial(ChangeSet.See.only(demandPlayer), demandPlayer, "gold", String.valueOf(demandPlayer.getGold()));
            } else {
                GoodsContainer colonyContainer = colony.getGoodsContainer();
                GoodsContainer unitContainer = unit.getGoodsContainer();
                GoodsContainer.moveGoods(colonyContainer, type, amount, unitContainer);
                cs.add(ChangeSet.See.only(this), colonyContainer);
                cs.add(ChangeSet.See.only(demandPlayer), unitContainer);
            }
            int difficulty = this.getSpecification().getInteger("model.option.nativeDemands");
            int tension = -(5 - difficulty) * 50;
            ServerIndianSettlement sis = (ServerIndianSettlement)unit.getHomeIndianSettlement();
            if (sis == null) {
                demandPlayer.csModifyTension(this, tension, cs);
            } else {
                sis.csModifyAlarm(this, tension, true, cs);
            }
        }
    }

    public void csDiplomacy(DiplomacySession session, DiplomaticTrade agreement, ChangeSet cs) {
        agreement.incrementVersion();
        DiplomaticTrade.TradeStatus status = agreement.getStatus();
        switch (status) {
            case PROPOSE_TRADE: {
                session.setAgreement(agreement);
                ServerPlayer otherPlayer = session.getOtherPlayer(this);
                cs.add(ChangeSet.See.only(otherPlayer), session.getMessage(otherPlayer));
                break;
            }
            case ACCEPT_TRADE: {
                session.complete(true, cs);
                break;
            }
            default: {
                session.complete(false, cs);
            }
        }
    }

    public void csEndTurn(ChangeSet cs) {
        for (BuildingType bt : this.getFreeBuildingTypes()) {
            for (Colony c : this.getColonyList()) {
                ((ServerColony)c).csFreeBuilding(bt, cs);
            }
        }
    }

    @Override
    public void csNewTurn(Random random, LogBuilder lb, ChangeSet cs) {
        lb.add("PLAYER ", this.getName(), ": ");
        Game game = this.getGame();
        Specification spec = this.getSpecification();
        int oldImmigration = this.getImmigration();
        int oldLiberty = this.getLiberty();
        int newSoL = 0;
        int newImmigration = 0;
        int newLiberty = 0;
        List<Settlement> settlements = this.getSettlementList();
        for (Settlement settlement : settlements) {
            ((TurnTaker)((Object)settlement)).csNewTurn(random, lb, cs);
            newSoL += settlement.getSoL();
        }
        int numberOfSettlements = settlements.size();
        if (numberOfSettlements > 0) {
            if (this.oldSoL / 10 != (newSoL /= numberOfSettlements) / 10) {
                String key = newSoL > this.oldSoL ? "model.player.soLIncrease" : "model.player.soLDecrease";
                cs.addMessage(this, (ModelMessage)((StringTemplate)new ModelMessage(ModelMessage.MessageType.SONS_OF_LIBERTY, key, this).addAmount("%oldSoL%", this.oldSoL)).addAmount("%newSoL%", newSoL));
            }
            this.oldSoL = newSoL;
        }
        newImmigration = this.getImmigration() - oldImmigration;
        newLiberty = this.getLiberty() - oldLiberty;
        for (Unit unit : this.getUnitSet()) {
            try {
                ((TurnTaker)((Object)unit)).csNewTurn(random, lb, cs);
            }
            catch (ClassCastException cce) {
                logger.log(Level.SEVERE, "Not a ServerUnit: " + unit.getId(), cce);
            }
        }
        if (this.europe != null) {
            ((TurnTaker)((Object)this.europe)).csNewTurn(random, lb, cs);
            this.modifyImmigration(this.europe.getImmigration(newImmigration));
            newImmigration = this.getImmigration() - oldImmigration;
        }
        if (this.isEuropean()) {
            int disaster;
            if (!this.hasAbility("model.ability.selectRecruit")) {
                while (this.checkEmigrate()) {
                    this.csEmigrate(Europe.MigrationType.getUnspecificSlot(), Europe.MigrationType.NORMAL, random, cs);
                }
            }
            if (newImmigration != 0) {
                cs.addPartial(ChangeSet.See.only(this), this, "immigration", String.valueOf(this.getImmigration()));
            }
            if (newLiberty != 0) {
                cs.addPartial(ChangeSet.See.only(this), this, "liberty", String.valueOf(this.getLiberty()));
            }
            if (spec.getBoolean("model.option.enableUpkeep")) {
                this.csPayUpkeep(random, cs);
            }
            if ((disaster = spec.getPercentage("model.option.naturalDisasters")) > 0) {
                this.csNaturalDisasters(random, cs, disaster);
            }
            if (this.isRebel() && this.interventionBells >= spec.getInteger("model.option.interventionBells")) {
                this.interventionBells = Integer.MIN_VALUE;
                List<Colony> ports = this.getConnectedPortList();
                Colony port = (Colony)RandomUtils.getRandomMember(logger, "Intervention port", ports, random);
                Tile portTile = port.getTile();
                Tile entry = game.getMap().searchCircle(portTile, GoalDeciders.getSimpleHighSeasGoalDecider(), portTile.getHighSeasCount() + 1).getSafeTile(this, random);
                Force ivf = this.getMonarch().getInterventionForce();
                List<Unit> land = this.createUnits(ivf.getLandUnitsList(), entry, random);
                List<Unit> naval = this.createUnits(ivf.getNavalUnitsList(), entry, random);
                List<Unit> leftOver = this.loadShips(land, naval, random);
                for (Unit unit : leftOver) {
                    logger.warning("Disposing of left over unit " + unit);
                    unit.setLocationNoUpdate(null);
                    unit.dispose();
                }
                Set<Tile> tiles = this.exploreForUnit(naval.get(0));
                tiles.add(entry);
                this.invalidateCanSeeTiles();
                cs.add(ChangeSet.See.perhaps(), tiles);
                cs.addMessage(this, new ModelMessage(ModelMessage.MessageType.FOREIGN_DIPLOMACY, "model.player.interventionForceArrives", this));
                logger.info("Intervention force (" + naval.size() + " naval, " + land.size() + " land, " + leftOver.size() + " left over) arrives at " + entry + "(for " + port.getName() + ")");
            }
            for (Colony c : this.getColonyList()) {
                ((ServerColony)c).csNewTurnWarnings(random, lb, cs);
            }
        }
        while (!this.stanceDirty.isEmpty()) {
            boolean war;
            Player s = this.stanceDirty.remove(0);
            Stance sta = this.getStance(s);
            boolean bl = war = sta == Stance.WAR;
            if (sta == Stance.UNCONTACTED) continue;
            for (Player p : game.getLiveEuropeanPlayerList(this)) {
                if (p == s || !p.hasContacted(this) || !p.hasContacted(s) || !p.hasAbility("model.ability.betterForeignAffairsReport") && !war) continue;
                cs.addStance(ChangeSet.See.only(p), this, sta, s);
                cs.addMessage(p, (ModelMessage)((StringTemplate)new ModelMessage(ModelMessage.MessageType.FOREIGN_DIPLOMACY, sta.getOtherStanceChangeKey(), this).addStringTemplate("%attacker%", this.getNationLabel())).addStringTemplate("%defender%", s.getNationLabel()));
            }
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(64);
        sb.append("[ServerPlayer ").append(this.getId()).append(' ').append(this.getName()).append(']');
        return sb.toString();
    }

    public static enum DeadCheck {
        IS_DEAD,
        IS_DEFEATED,
        IS_AUTORECRUIT,
        IS_ALIVE;

    }
}

