/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.writers;

import java.util.Arrays;
import java.util.Hashtable;
import javajs.util.BS;
import javajs.util.Lst;
import javajs.util.Measure;
import javajs.util.P3;
import javajs.util.PT;
import javajs.util.Quat;
import javajs.util.SB;
import javajs.util.T3;
import javajs.util.V3;
import org.jmol.modelset.Atom;
import org.jmol.modelset.Bond;
import org.jmol.modelset.ModelSet;
import org.jmol.script.SV;
import org.jmol.script.T;
import org.jmol.util.Elements;
import org.jmol.util.Escape;
import org.jmol.viewer.Viewer;

public class MOLWriter {
    private Viewer vwr;
    private P3 ptTemp;
    private T3 vNorm;
    private T3 vTemp;
    private int[] connections;

    public MOLWriter setViewer(Viewer vwr) {
        this.vwr = vwr;
        return this;
    }

    public boolean addMolFile(int iModel, SB mol, BS bsAtoms, BS bsBonds, boolean asV3000, boolean asJSON, boolean noAromatic, Quat q) {
        String o;
        int nAtoms = bsAtoms.cardinality();
        int nBonds = bsBonds.cardinality();
        if (!(asV3000 || asJSON || nAtoms <= 999 && nBonds <= 999)) {
            return false;
        }
        boolean asSDF = iModel >= 0;
        Hashtable<String, String> molData = asSDF ? (Hashtable<String, String>)this.vwr.ms.getInfo(iModel, "molData") : null;
        Lst<String> _keyList = asSDF ? (Lst<String>)this.vwr.ms.getInfo(iModel, "molDataKeys") : null;
        ModelSet ms = this.vwr.ms;
        int[] atomMap = new int[ms.ac];
        P3 pTemp = new P3();
        if (asV3000) {
            mol.append("  0  0  0  0  0  0            999 V3000");
        } else if (asJSON) {
            mol.append("{\"mol\":{\"createdBy\":\"Jmol " + Viewer.getJmolVersion() + "\",\"a\":[");
        } else {
            PT.rightJustify(mol, "   ", "" + nAtoms);
            PT.rightJustify(mol, "   ", "" + nBonds);
            mol.append("  0  0  0  0            999 V2000");
        }
        if (!asJSON) {
            mol.append("\n");
        }
        if (asV3000) {
            mol.append("M  V30 BEGIN CTAB\nM  V30 COUNTS ").appendI(nAtoms).append(" ").appendI(nBonds).append(" 0 0 0\n").append("M  V30 BEGIN ATOM\n");
        }
        String string = o = molData == null ? null : (String)molData.get("atom_value_name");
        if (o instanceof SV) {
            o = ((SV)((Object)o)).asString();
        }
        int valueType = o == null ? 0 : T.getTokFromName("" + o);
        SB atomValues = valueType == 0 && !asSDF ? null : new SB();
        int i = bsAtoms.nextSetBit(0);
        int n = 0;
        while (i >= 0) {
            atomMap[i] = ++n;
            this.getAtomRecordMOL(iModel, ms, mol, atomMap[i], ms.at[i], q, pTemp, asV3000, asJSON, atomValues, valueType, asSDF);
            i = bsAtoms.nextSetBit(i + 1);
        }
        if (asV3000) {
            mol.append("M  V30 END ATOM\nM  V30 BEGIN BOND\n");
        } else if (asJSON) {
            mol.append("],\"b\":[");
        }
        i = bsBonds.nextSetBit(0);
        n = 0;
        while (i >= 0) {
            this.getBondRecordMOL(mol, ++n, ms.bo[i], atomMap, asV3000, asJSON, noAromatic);
            i = bsBonds.nextSetBit(i + 1);
        }
        if (asV3000) {
            mol.append("M  V30 END BOND\nM  V30 END CTAB\n");
        }
        if (asJSON) {
            mol.append("]}}");
        } else {
            if (atomValues != null && atomValues.length() > 0) {
                mol.append(atomValues.toString());
            }
            mol.append("M  END\n");
        }
        if (asSDF) {
            try {
                int n2;
                int i2;
                float[] pc = ms.getPartialCharges();
                if (molData == null) {
                    molData = new Hashtable<String, String>();
                }
                SB sb = new SB();
                if (pc != null) {
                    sb.appendI(nAtoms).appendC('\n');
                    i2 = bsAtoms.nextSetBit(0);
                    n2 = 0;
                    while (i2 >= 0) {
                        sb.appendI(++n2).append(" ").appendF(pc[i2]).appendC('\n');
                        i2 = bsAtoms.nextSetBit(i2 + 1);
                    }
                    molData.put("jmol_partial_charges", sb.toString());
                }
                sb.setLength(0);
                sb.appendI(nAtoms).appendC('\n');
                i2 = bsAtoms.nextSetBit(0);
                n2 = 0;
                while (i2 >= 0) {
                    String name = ms.at[i2].getAtomName().trim();
                    if (name.length() == 0) {
                        name = ".";
                    }
                    sb.appendI(++n2).append(" ").append(name.replace(' ', '_')).appendC('\n');
                    i2 = bsAtoms.nextSetBit(i2 + 1);
                }
                molData.put("jmol_atom_names", sb.toString());
                if (_keyList == null) {
                    _keyList = new Lst<String>();
                }
                for (String key : molData.keySet()) {
                    if (_keyList.contains(key)) continue;
                    _keyList.addLast(key);
                }
                n2 = _keyList.size();
                for (i = 0; i < n2; ++i) {
                    String key = (String)_keyList.get(i);
                    if (key.startsWith(">")) continue;
                    o = molData.get(key);
                    if (o instanceof SV) {
                        o = ((SV)((Object)o)).asString();
                    }
                    mol.append("> <" + key.toUpperCase() + ">\n");
                    this.output80CharWrap(mol, o.toString(), 80);
                    mol.append("\n\n");
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            mol.append("$$$$\n");
        }
        return true;
    }

    private void getAtomRecordMOL(int iModel, ModelSet ms, SB mol, int n, Atom a, Quat q, P3 pTemp, boolean asV3000, boolean asJSON, SB atomValues, int tokValue, boolean asSDF) {
        ms.getPointTransf(iModel, a, q, pTemp);
        int elemNo = a.getElementNumber();
        String sym = a.isDeleted() ? "Xx" : Elements.elementSymbolFromNumber(elemNo);
        int isotope = a.getIsotopeNumber();
        int charge = a.getFormalCharge();
        Object[] o = new Object[]{pTemp};
        if (asV3000) {
            mol.append("M  V30 ").appendI(n).append(" ").append(sym).append(PT.sprintf(" %12.5p %12.5p %12.5p 0", "p", o));
            if (charge != 0) {
                mol.append(" CHG=").appendI(charge);
            }
            if (isotope != 0) {
                mol.append(" MASS=").appendI(isotope);
            }
            mol.append("\n");
        } else if (asJSON) {
            if (n != 1) {
                mol.append(",");
            }
            mol.append("{");
            if (a.getElementNumber() != 6) {
                mol.append("\"l\":\"").append(a.getElementSymbol()).append("\",");
            }
            if (charge != 0) {
                mol.append("\"c\":").appendI(charge).append(",");
            }
            if (isotope != 0) {
                mol.append("\"m\":").appendI(isotope).append(",");
            }
            mol.append("\"x\":").appendF(a.x).append(",\"y\":").appendF(a.y).append(",\"z\":").appendF(a.z).append("}");
        } else {
            String label;
            mol.append(PT.sprintf("%10.4p%10.4p%10.4p", "p", o));
            mol.append(" ").append(sym);
            if (sym.length() == 1) {
                mol.append(" ");
            }
            PT.rightJustify(mol, "   ", "" + (isotope > 0 ? isotope - Elements.getNaturalIsotope(a.getElementNumber()) : 0));
            if (asSDF && isotope > 0) {
                atomValues.append("M  ISO  1");
                PT.rightJustify(atomValues, "    ", "" + n);
                PT.rightJustify(atomValues, "    ", "" + isotope);
                atomValues.append("\n");
            }
            PT.rightJustify(mol, "   ", "" + (charge == 0 ? 0 : 4 - charge));
            mol.append("  ").append(this.getAtomParity(a));
            mol.append("  0  0  0\n");
            String string = label = tokValue == 0 || asV3000 ? null : this.getAtomPropertyAsString(a, tokValue);
            if (label != null && (label = label.trim()).length() > 0) {
                String sn = "   " + n + " ";
                atomValues.append("V  ").append(sn.substring(sn.length() - 4));
                this.output80CharWrap(atomValues, label, 73);
            }
        }
    }

    private String getAtomParity(Atom a) {
        if (a.getCovalentBondCount() == 4) {
            if (this.connections == null) {
                this.connections = new int[4];
                this.vTemp = new V3();
                this.vNorm = new V3();
            }
            Bond[] bonds = a.bonds;
            int nH = 0;
            int pt = 0;
            int i = bonds.length;
            while (--i >= 0) {
                if (!bonds[i].isCovalent()) continue;
                Atom b = bonds[i].getOtherAtom(a);
                if (b.getAtomicAndIsotopeNumber() == 1) {
                    ++nH;
                }
                this.connections[pt++] = b.i;
            }
            if (nH < 3) {
                Arrays.sort(this.connections);
                Atom[] atoms = this.vwr.ms.at;
                Measure.getNormalThroughPoints(atoms[this.connections[0]], atoms[this.connections[1]], atoms[this.connections[2]], this.vNorm, this.vTemp);
                this.vTemp.sub2(atoms[this.connections[3]], atoms[this.connections[0]]);
                return this.vTemp.dot(this.vNorm) > 0.0f ? "1" : "2";
            }
        }
        return "0";
    }

    private String getAtomPropertyAsString(Atom a, int tok) {
        switch (tok & 0x43C00000) {
            case 0x41400000: {
                int i = a.atomPropertyInt(tok);
                return tok == 1765808134 ? PT.trim(Escape.escapeColor(i), "[x]").toUpperCase() : "" + i;
            }
            case 0x40C00000: {
                return a.atomPropertyString(this.vwr, tok);
            }
            case 0x42400000: {
                float f = a.atomPropertyFloat(this.vwr, tok, null);
                return Float.isNaN(f) ? null : "" + f;
            }
        }
        if (this.ptTemp == null) {
            this.ptTemp = new P3();
        }
        a.atomPropertyTuple(this.vwr, tok, this.ptTemp);
        return this.ptTemp == null ? null : this.ptTemp.toString();
    }

    private void getBondRecordMOL(SB mol, int n, Bond b, int[] atomMap, boolean asV3000, boolean asJSON, boolean noAromatic) {
        int a1 = atomMap[b.atom1.i];
        int a2 = atomMap[b.atom2.i];
        int order = b.getValence();
        if (order > 3) {
            order = 1;
        }
        switch (b.order & 0x1FFFF) {
            case 515: {
                order = asJSON ? -3 : 4;
                break;
            }
            case 66: {
                order = asJSON ? -3 : 5;
                break;
            }
            case 513: {
                order = asJSON || noAromatic ? 1 : 6;
                break;
            }
            case 514: {
                order = asJSON || noAromatic ? 2 : 7;
                break;
            }
            case 33: {
                int n2 = order = asJSON ? -1 : 8;
            }
        }
        if (asV3000) {
            mol.append("M  V30 ").appendI(n).append(" ").appendI(order).append(" ").appendI(a1).append(" ").appendI(a2).appendC('\n');
        } else if (asJSON) {
            if (n != 1) {
                mol.append(",");
            }
            mol.append("{\"b\":").appendI(a1 - 1).append(",\"e\":").appendI(a2 - 1);
            if (order != 1) {
                mol.append(",\"o\":");
                if (order < 0) {
                    mol.appendF((float)(-order) / 2.0f);
                } else {
                    mol.appendI(order);
                }
            }
            mol.append("}");
        } else {
            PT.rightJustify(mol, "   ", "" + a1);
            PT.rightJustify(mol, "   ", "" + a2);
            mol.append("  ").appendI(order).append("  0  0  0\n");
        }
    }

    private void output80CharWrap(SB mol, String data, int maxN) {
        if (maxN < 80) {
            data = PT.rep(data, "\n", "|");
        }
        String[] lines = PT.split(PT.trim(PT.rep(data, "\n\n", "\n"), "\n"), "\n");
        for (int i = 0; i < lines.length; ++i) {
            this.outputLines(mol, lines[i], maxN);
        }
    }

    private void outputLines(SB mol, String data, int maxN) {
        boolean done = false;
        int n = data.length();
        for (int i = 0; i < n && !done; i += 80) {
            mol.append(data.substring(i, Math.min(i + maxN, n)));
            done = maxN != 80;
            if (!done && i + 80 < n) {
                mol.append("+");
            }
            mol.append("\n");
        }
    }
}

