/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.symmetry;

import java.util.Hashtable;
import java.util.Map;
import javajs.util.Lst;
import javajs.util.M3;
import javajs.util.M4;
import javajs.util.Matrix;
import javajs.util.P3;
import javajs.util.PT;
import javajs.util.SB;
import javajs.util.T3;
import javajs.util.V3;
import org.jmol.symmetry.Symmetry;
import org.jmol.symmetry.UnitCell;
import org.jmol.util.Logger;
import org.jmol.util.Parser;

public class SymmetryOperation
extends M4 {
    String xyzOriginal;
    String xyzCanonical;
    String xyz;
    private boolean doNormalize = true;
    boolean isFinalized;
    private int opId;
    private V3 centering;
    private String[] myLabels;
    int modDim;
    float[] linearRotTrans;
    Matrix rsvs;
    boolean isBio;
    Matrix sigma;
    int number;
    String subsystemCode;
    int timeReversal;
    private boolean unCentered;
    boolean isCenteringOp;
    private float magOp = Float.MAX_VALUE;
    int divisor = 12;
    private static final int DIVISOR_MASK = 255;
    private static final int DIVISOR_OFFSET = 8;
    private static final String[] twelfths = new String[]{"0", "1/12", "1/6", "1/4", "1/3", "5/12", "1/2", "7/12", "2/3", "3/4", "5/6", "11/12"};
    static final String[] labelsXYZ = new String[]{"x", "y", "z"};
    static final String[] labelsXn = new String[]{"x1", "x2", "x3", "x4", "x5", "x6", "x7", "x8", "x9", "x10", "x11", "x12", "x13"};
    static final String[] labelsXnSub = new String[]{"x", "y", "z", "a", "b", "c", "d", "e", "f", "g", "h", "i", "j"};
    private Hashtable<String, Object> info;
    static P3 atomTest;

    void setSigma(String subsystemCode, Matrix sigma) {
        this.subsystemCode = subsystemCode;
        this.sigma = sigma;
    }

    SymmetryOperation(SymmetryOperation op, int id, boolean doNormalize) {
        this.doNormalize = doNormalize;
        if (op == null) {
            this.opId = id;
            return;
        }
        this.xyzOriginal = op.xyzOriginal;
        this.xyz = op.xyz;
        this.divisor = op.divisor;
        this.opId = op.opId;
        this.modDim = op.modDim;
        this.myLabels = op.myLabels;
        this.number = op.number;
        this.linearRotTrans = op.linearRotTrans;
        this.sigma = op.sigma;
        this.subsystemCode = op.subsystemCode;
        this.timeReversal = op.timeReversal;
        this.setMatrix(false);
        if (!op.isFinalized) {
            this.doFinalize();
        }
    }

    private void setGamma(boolean isReverse) {
        int j;
        int i;
        int n = 3 + this.modDim;
        this.rsvs = new Matrix(null, n + 1, n + 1);
        double[][] a = this.rsvs.getArray();
        double[] t = new double[n];
        int pt = 0;
        for (i = 0; i < n; ++i) {
            for (j = 0; j < n; ++j) {
                a[i][j] = this.linearRotTrans[pt++];
            }
            t[i] = (float)(isReverse ? -1 : 1) * this.linearRotTrans[pt++];
        }
        a[n][n] = 1.0;
        if (isReverse) {
            this.rsvs = this.rsvs.inverse();
        }
        for (i = 0; i < n; ++i) {
            a[i][n] = t[i];
        }
        a = this.rsvs.getSubmatrix(0, 0, 3, 3).getArray();
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < 4; ++j) {
                this.setElement(i, j, (float)(j < 3 ? a[i][j] : t[i]));
            }
        }
        this.setElement(3, 3, 1.0f);
    }

    void doFinalize() {
        SymmetryOperation.div12(this, this.divisor);
        if (this.modDim > 0) {
            double[][] a = this.rsvs.getArray();
            int i = a.length - 1;
            while (--i >= 0) {
                a[i][3 + this.modDim] = SymmetryOperation.finalizeD(a[i][3 + this.modDim], this.divisor);
            }
        }
        this.isFinalized = true;
    }

    private static M4 div12(M4 op, int divisor) {
        op.m03 = SymmetryOperation.finalizeF(op.m03, divisor);
        op.m13 = SymmetryOperation.finalizeF(op.m13, divisor);
        op.m23 = SymmetryOperation.finalizeF(op.m23, divisor);
        return op;
    }

    private static float finalizeF(float m, int divisor) {
        if (divisor == 0) {
            if (m == 0.0f) {
                return 0.0f;
            }
            int n = (int)m;
            return (float)(n >> 8) * 1.0f / (float)(n & 0xFF);
        }
        return m / (float)divisor;
    }

    private static double finalizeD(double m, int divisor) {
        if (divisor == 0) {
            if (m == 0.0) {
                return 0.0;
            }
            int n = (int)m;
            return (float)(n >> 8) * 1.0f / (float)(n & 0xFF);
        }
        return m / (double)divisor;
    }

    String getXyz(boolean normalized) {
        return normalized && this.modDim == 0 || this.xyzOriginal == null ? this.xyz : this.xyzOriginal;
    }

    public String getxyzTrans(P3 t) {
        M4 m = SymmetryOperation.newM4(this);
        m.add(t);
        return SymmetryOperation.getXYZFromMatrix(m, false, false, false);
    }

    String dumpInfo() {
        return "\n" + this.xyz + "\ninternal matrix representation:\n" + this.toString();
    }

    static final String dumpSeitz(M4 s, boolean isCanonical) {
        SB sb = new SB();
        float[] r = new float[4];
        for (int i = 0; i < 3; ++i) {
            s.getRow(i, r);
            sb.append("[\t");
            for (int j = 0; j < 3; ++j) {
                sb.appendI((int)r[j]).append("\t");
            }
            float trans = r[3];
            if (trans != (float)((int)trans)) {
                trans = 12.0f * trans;
            }
            sb.append(SymmetryOperation.twelfthsOf(isCanonical ? SymmetryOperation.normalizeTwelfths(trans / 12.0f, 12, true) : (float)((int)trans))).append("\t]\n");
        }
        return sb.toString();
    }

    boolean setMatrixFromXYZ(String xyz, int modDim, boolean allowScaling) {
        if (xyz == null) {
            return false;
        }
        this.xyzOriginal = xyz;
        this.divisor = SymmetryOperation.setDivisor(xyz);
        xyz = xyz.toLowerCase();
        this.setModDim(modDim);
        boolean isReverse = xyz.startsWith("!");
        if (isReverse) {
            xyz = xyz.substring(1);
        }
        if (xyz.indexOf("xyz matrix:") == 0) {
            this.xyz = xyz;
            Parser.parseStringInfestedFloatArray(xyz, null, this.linearRotTrans);
            return this.setFromMatrix(null, isReverse);
        }
        if (xyz.indexOf("[[") == 0) {
            xyz = xyz.replace('[', ' ').replace(']', ' ').replace(',', ' ');
            Parser.parseStringInfestedFloatArray(xyz, null, this.linearRotTrans);
            int i = this.linearRotTrans.length;
            while (--i >= 0) {
                if (!Float.isNaN(this.linearRotTrans[i])) continue;
                return false;
            }
            this.setMatrix(isReverse);
            this.isFinalized = true;
            this.isBio = xyz.indexOf("bio") >= 0;
            this.xyz = this.isBio ? (this.xyzOriginal = super.toString()) : SymmetryOperation.getXYZFromMatrix(this, false, false, false);
            return true;
        }
        if (modDim == 0 && xyz.indexOf("x4") >= 0) {
            int i = 14;
            while (--i >= 4) {
                if (xyz.indexOf("x" + i) < 0) continue;
                this.setModDim(i - 3);
                break;
            }
        }
        String mxyz = null;
        if (xyz.endsWith("m")) {
            this.timeReversal = xyz.indexOf("-m") >= 0 ? -1 : 1;
            allowScaling = true;
        } else if (xyz.indexOf("mz)") >= 0) {
            int pt = xyz.indexOf("(");
            mxyz = xyz.substring(pt + 1, xyz.length() - 1);
            xyz = xyz.substring(0, pt);
            allowScaling = false;
        }
        String strOut = SymmetryOperation.getMatrixFromString(this, xyz, this.linearRotTrans, allowScaling);
        if (strOut == null) {
            return false;
        }
        this.xyzCanonical = strOut;
        if (mxyz != null) {
            boolean isProper = M4.newA16(this.linearRotTrans).determinant3() == 1.0f;
            this.timeReversal = xyz.indexOf("-x") < 0 == mxyz.indexOf("-mx") < 0 == isProper ? 1 : -1;
        }
        this.setMatrix(isReverse);
        String string = isReverse ? SymmetryOperation.getXYZFromMatrix(this, true, false, false) : (this.xyz = this.doNormalize ? strOut : xyz);
        if (this.timeReversal != 0) {
            this.xyz = this.xyz + (this.timeReversal == 1 ? ",m" : ",-m");
        }
        if (Logger.debugging) {
            Logger.debug("" + this);
        }
        return true;
    }

    private static int setDivisor(String xyz) {
        int pt = xyz.indexOf(47);
        int len = xyz.length();
        while (pt > 0 && pt < len - 1) {
            char c = xyz.charAt(pt + 1);
            if ("2346".indexOf(c) < 0 || pt < len - 2 && Character.isDigit(xyz.charAt(pt + 2))) {
                return 0;
            }
            pt = xyz.indexOf(47, pt + 1);
        }
        return 12;
    }

    private void setModDim(int dim) {
        int n = (dim + 4) * (dim + 4);
        this.modDim = dim;
        if (dim > 0) {
            this.myLabels = labelsXn;
        }
        this.linearRotTrans = new float[n];
    }

    private void setMatrix(boolean isReverse) {
        if (this.linearRotTrans.length > 16) {
            this.setGamma(isReverse);
        } else {
            this.setA(this.linearRotTrans);
            if (isReverse) {
                P3 p3 = P3.new3(this.m03, this.m13, this.m23);
                this.invert();
                this.rotate(p3);
                p3.scale(-1.0f);
                this.setTranslation(p3);
            }
        }
    }

    boolean setFromMatrix(float[] offset, boolean isReverse) {
        float v = 0.0f;
        int pt = 0;
        this.myLabels = this.modDim == 0 ? labelsXYZ : labelsXn;
        int rowPt = 0;
        int n = 3 + this.modDim;
        int i = 0;
        while (rowPt < n) {
            boolean isTrans;
            if (Float.isNaN(this.linearRotTrans[i])) {
                return false;
            }
            v = this.linearRotTrans[i];
            if (Math.abs(v) < 1.0E-5f) {
                v = 0.0f;
            }
            boolean bl = isTrans = (i + 1) % (n + 1) == 0;
            if (isTrans) {
                int denom;
                int n2 = denom = this.divisor == 0 ? (int)v & 0xFF : this.divisor;
                if (denom == 0) {
                    denom = 12;
                }
                v = SymmetryOperation.finalizeF(v, this.divisor);
                if (offset != null && pt < offset.length) {
                    v += offset[pt++];
                }
                v = SymmetryOperation.normalizeTwelfths((float)(v < 0.0f ? -1 : 1) * Math.abs(v * (float)denom) / (float)denom, denom, this.doNormalize);
                if (this.divisor == 0) {
                    v = SymmetryOperation.toDivisor(v, denom);
                }
                ++rowPt;
            }
            this.linearRotTrans[i] = v;
            ++i;
        }
        this.linearRotTrans[this.linearRotTrans.length - 1] = this.divisor;
        this.setMatrix(isReverse);
        this.isFinalized = offset == null;
        this.xyz = SymmetryOperation.getXYZFromMatrix(this, true, false, false);
        return true;
    }

    public static M4 getMatrixFromXYZ(String xyz) {
        float[] linearRotTrans = new float[16];
        xyz = SymmetryOperation.getMatrixFromString(null, "!" + xyz, linearRotTrans, false);
        return xyz == null ? null : SymmetryOperation.div12(M4.newA16(linearRotTrans), SymmetryOperation.setDivisor(xyz));
    }

    static String getJmolCanonicalXYZ(String xyz) {
        try {
            return SymmetryOperation.getMatrixFromString(null, xyz, null, false);
        }
        catch (Exception e) {
            return null;
        }
    }

    static String getMatrixFromString(SymmetryOperation op, String xyz, float[] linearRotTrans, boolean allowScaling) {
        String[] myLabels;
        int transPt;
        int dimOffset;
        int divisor;
        boolean isDenominator = false;
        boolean isDecimal = false;
        boolean isNegative = false;
        xyz = PT.rep(xyz, "[bio[", "");
        int modDim = op == null ? 0 : op.modDim;
        int nRows = 4 + modDim;
        int n = divisor = op == null ? SymmetryOperation.setDivisor(xyz) : op.divisor;
        boolean doNormalize = op == null ? !xyz.startsWith("!") : op.doNormalize;
        int n2 = dimOffset = modDim > 0 ? 3 : 0;
        if (linearRotTrans != null) {
            linearRotTrans[linearRotTrans.length - 1] = 1.0f;
        }
        if ((transPt = xyz.indexOf(59) + 1) != 0) {
            allowScaling = true;
            if (transPt == xyz.length()) {
                xyz = xyz + "0,0,0";
            }
        }
        int rotPt = -1;
        String[] stringArray = myLabels = op == null || modDim == 0 ? null : op.myLabels;
        if (myLabels == null) {
            myLabels = labelsXYZ;
        }
        xyz = xyz.toLowerCase() + ",";
        xyz = xyz.replace('(', ',');
        if (modDim > 0) {
            xyz = SymmetryOperation.replaceXn(xyz, modDim + 3);
        }
        int xpt = 0;
        int tpt0 = 0;
        int rowPt = 0;
        float iValue = 0.0f;
        int denom = 0;
        int numer = 0;
        float decimalMultiplier = 1.0f;
        String strT = "";
        String strOut = "";
        int[] ret = new int[1];
        int len = xyz.length();
        block11: for (int i = 0; i < len; ++i) {
            char ch = xyz.charAt(i);
            switch (ch) {
                case ';': {
                    break;
                }
                case ' ': 
                case '!': 
                case '\'': 
                case '{': 
                case '}': {
                    continue block11;
                }
                case '-': {
                    isNegative = true;
                    continue block11;
                }
                case '+': {
                    isNegative = false;
                    continue block11;
                }
                case '/': {
                    denom = 0;
                    isDenominator = true;
                    continue block11;
                }
                case 'a': 
                case 'b': 
                case 'c': 
                case 'd': 
                case 'e': 
                case 'f': 
                case 'g': 
                case 'h': 
                case 'x': 
                case 'y': 
                case 'z': {
                    int val;
                    tpt0 = rowPt * nRows;
                    int ipt = ch >= 'x' ? ch - 120 : ch - 97 + dimOffset;
                    xpt = tpt0 + ipt;
                    int n3 = val = isNegative ? -1 : 1;
                    if (allowScaling && iValue != 0.0f) {
                        if (linearRotTrans != null) {
                            linearRotTrans[xpt] = iValue;
                        }
                        val = (int)iValue;
                        iValue = 0.0f;
                    } else if (linearRotTrans != null) {
                        linearRotTrans[xpt] = val;
                    }
                    strT = strT + SymmetryOperation.plusMinus(strT, val, myLabels[ipt]);
                    break;
                }
                case ',': {
                    if (transPt != 0) {
                        if (transPt > 0) {
                            rotPt = i;
                            i = transPt - 1;
                            transPt = -i;
                            iValue = 0.0f;
                            denom = 0;
                            continue block11;
                        }
                        transPt = i + 1;
                        i = rotPt;
                    }
                    iValue = SymmetryOperation.normalizeTwelfths(iValue, denom == 0 ? 12 : (divisor == 0 ? denom : divisor), doNormalize);
                    if (linearRotTrans != null) {
                        linearRotTrans[tpt0 + nRows - 1] = divisor == 0 && denom > 0 ? (iValue = (float)SymmetryOperation.toDivisor(numer, denom)) : iValue;
                    }
                    strT = strT + SymmetryOperation.xyzFraction12(iValue, divisor == 0 ? denom : divisor, false, true);
                    strOut = strOut + (strOut == "" ? "" : ",") + strT;
                    if (rowPt == nRows - 2) {
                        return strOut;
                    }
                    iValue = 0.0f;
                    numer = 0;
                    denom = 0;
                    strT = "";
                    if (rowPt++ <= 2 || modDim != 0) break;
                    Logger.warn("Symmetry Operation? " + xyz);
                    return null;
                }
                case '.': {
                    isDecimal = true;
                    decimalMultiplier = 1.0f;
                    continue block11;
                }
                case '0': {
                    if (!isDecimal && divisor == 12 && (isDenominator || !allowScaling)) continue block11;
                }
                default: {
                    int ich = ch - 48;
                    if (ich >= 0 && ich <= 9) {
                        if (isDecimal) {
                            decimalMultiplier /= 10.0f;
                            if (iValue < 0.0f) {
                                isNegative = true;
                            }
                            iValue += decimalMultiplier * (float)ich * (float)(isNegative ? -1 : 1);
                            continue block11;
                        }
                        if (isDenominator) {
                            ret[0] = i;
                            denom = PT.parseIntNext(xyz, ret);
                            if (denom < 0) {
                                return null;
                            }
                            i = ret[0] - 1;
                            if (iValue == 0.0f) {
                                if (linearRotTrans == null) break;
                                int n4 = xpt;
                                linearRotTrans[n4] = linearRotTrans[n4] / (float)denom;
                                break;
                            }
                            numer = (int)iValue;
                            iValue /= (float)denom;
                            break;
                        }
                        iValue = iValue * 10.0f + (float)((isNegative ? -1 : 1) * ich);
                        isNegative = false;
                        break;
                    }
                    Logger.warn("symmetry character?" + ch);
                }
            }
            isNegative = false;
            isDenominator = false;
            isDecimal = false;
        }
        return null;
    }

    static String replaceXn(String xyz, int n) {
        int i = n;
        while (--i >= 0) {
            xyz = PT.rep(xyz, labelsXn[i], labelsXnSub[i]);
        }
        return xyz;
    }

    private static final int toDivisor(float numer, int denom) {
        int n = (int)numer;
        if ((float)n != numer) {
            float f = numer - (float)n;
            denom = (int)Math.abs((float)denom / f);
            n = (int)(Math.abs(numer) / f);
        }
        return (n << 8) + denom;
    }

    private static final String xyzFraction12(float n12ths, int denom, boolean allPositive, boolean halfOrLess) {
        String s;
        float n = n12ths;
        if (denom != 12) {
            int in = (int)n;
            denom = in & 0xFF;
            n = in >> 8;
        }
        int half = denom / 2;
        if (allPositive) {
            while (n < 0.0f) {
                n += (float)denom;
            }
        } else if (halfOrLess) {
            while (n > (float)half) {
                n -= (float)denom;
            }
            while (n < (float)(-half)) {
                n += (float)denom;
            }
        }
        String string = denom == 12 ? SymmetryOperation.twelfthsOf(n) : (s = n == 0.0f ? "0" : n + "/" + denom);
        return s.charAt(0) == '0' ? "" : (n > 0.0f ? "+" + s : s);
    }

    static final String twelfthsOf(float n12ths) {
        String str = "";
        if (n12ths < 0.0f) {
            n12ths = -n12ths;
            str = "-";
        }
        int m = 12;
        int n = Math.round(n12ths);
        if (Math.abs((float)n - n12ths) > 0.01f) {
            float fm;
            float f = n12ths / 12.0f;
            int max = 20;
            for (m = 3; m < max && !(Math.abs((float)(n = Math.round(fm = f * (float)m)) - fm) < 0.01f); ++m) {
            }
            if (m == max) {
                return str + f;
            }
        } else {
            if (n == 12) {
                return str + "1";
            }
            if (n < 12) {
                return str + twelfths[n % 12];
            }
            switch (n % 12) {
                case 0: {
                    return "" + n / 12;
                }
                case 2: 
                case 10: {
                    m = 6;
                    break;
                }
                case 3: 
                case 9: {
                    m = 4;
                    break;
                }
                case 4: 
                case 8: {
                    m = 3;
                    break;
                }
                case 6: {
                    m = 2;
                    break;
                }
            }
            n = n * m / 12;
        }
        return str + n + "/" + m;
    }

    private static String plusMinus(String strT, float x, String sx) {
        return x == 0.0f ? "" : (x < 0.0f ? "-" : (strT.length() == 0 ? "" : "+")) + (x == 1.0f || x == -1.0f ? "" : "" + (int)Math.abs(x)) + sx;
    }

    private static float normalizeTwelfths(float iValue, int divisor, boolean doNormalize) {
        iValue *= (float)divisor;
        int half = divisor / 2;
        if (doNormalize) {
            while (iValue > (float)half) {
                iValue -= (float)divisor;
            }
            while (iValue <= (float)(-half)) {
                iValue += (float)divisor;
            }
        }
        return iValue;
    }

    public static final String getXYZFromMatrix(M4 mat, boolean is12ths, boolean allPositive, boolean halfOrLess) {
        SymmetryOperation op;
        String str = "";
        SymmetryOperation symmetryOperation = op = mat instanceof SymmetryOperation ? (SymmetryOperation)mat : null;
        if (op != null && op.modDim > 0) {
            return SymmetryOperation.getXYZFromRsVs(op.rsvs.getRotation(), op.rsvs.getTranslation(), is12ths);
        }
        float[] row = new float[4];
        int denom = (int)mat.getElement(3, 3);
        if (denom == 1) {
            denom = 12;
        } else {
            mat.setElement(3, 3, 1.0f);
        }
        for (int i = 0; i < 3; ++i) {
            int lpt = i < 3 ? 0 : 3;
            mat.getRow(i, row);
            String term = "";
            for (int j = 0; j < 3; ++j) {
                if (SymmetryOperation.approxF(row[j]) == 0.0f) continue;
                term = term + SymmetryOperation.plusMinus(term, row[j], labelsXYZ[j + lpt]);
            }
            if (SymmetryOperation.approxF(row[3]) != 0.0f) {
                term = term + SymmetryOperation.xyzFraction12(is12ths ? row[3] : row[3] * (float)denom, denom, allPositive, halfOrLess);
            }
            str = str + "," + term;
        }
        return str.substring(1);
    }

    V3[] rotateAxes(V3[] vectors, UnitCell unitcell, P3 ptTemp, M3 mTemp) {
        V3[] vRot = new V3[3];
        this.getRotationScale(mTemp);
        int i = vectors.length;
        while (--i >= 0) {
            ptTemp.setT(vectors[i]);
            unitcell.toFractional(ptTemp, true);
            mTemp.rotate(ptTemp);
            unitcell.toCartesian(ptTemp, true);
            vRot[i] = V3.newV(ptTemp);
        }
        return vRot;
    }

    public String fcoord2(T3 p) {
        if (this.divisor == 12) {
            return SymmetryOperation.fcoord(p);
        }
        return this.fc2(this.linearRotTrans[3]) + " " + this.fc2(this.linearRotTrans[7]) + " " + this.fc2(this.linearRotTrans[11]);
    }

    private String fc2(float f) {
        int num = (int)f;
        int denom = num & 0xFF;
        return (num >>= 8) == 0 ? "0" : num + "/" + denom;
    }

    static String fcoord(T3 p) {
        return SymmetryOperation.fc(p.x) + " " + SymmetryOperation.fc(p.y) + " " + SymmetryOperation.fc(p.z);
    }

    private static String fc(float x) {
        float xabs = Math.abs(x);
        String m = x < 0.0f ? "-" : "";
        int x24 = (int)SymmetryOperation.approxF(xabs * 24.0f);
        if ((float)x24 / 24.0f == (float)((int)((float)x24 / 24.0f))) {
            return m + x24 / 24;
        }
        if (x24 % 8 != 0) {
            return m + SymmetryOperation.twelfthsOf(x24 >> 1);
        }
        return x24 == 0 ? "0" : (x24 == 24 ? m + "1" : m + x24 / 8 + "/3");
    }

    static float approxF(float f) {
        return PT.approx(f, 100.0f);
    }

    static String getXYZFromRsVs(Matrix rs, Matrix vs, boolean is12ths) {
        double[][] ra = rs.getArray();
        double[][] va = vs.getArray();
        int d = ra.length;
        String s = "";
        for (int i = 0; i < d; ++i) {
            s = s + ",";
            for (int j = 0; j < d; ++j) {
                double r = ra[i][j];
                if (r == 0.0) continue;
                s = s + (r < 0.0 ? "-" : (s.endsWith(",") ? "" : "+")) + (Math.abs(r) == 1.0 ? "" : "" + (int)Math.abs(r)) + "x" + (j + 1);
            }
            s = s + SymmetryOperation.xyzFraction12((int)(va[i][0] * (double)(is12ths ? 1 : 12)), 12, false, true);
        }
        return PT.rep(s.substring(1), ",+", ",");
    }

    @Override
    public String toString() {
        return this.rsvs == null ? super.toString() : super.toString() + " " + this.rsvs.toString();
    }

    float getMagneticOp() {
        return this.magOp == Float.MAX_VALUE ? (this.magOp = this.determinant3() * (float)this.timeReversal) : this.magOp;
    }

    void setTimeReversal(int magRev) {
        this.timeReversal = magRev;
        if (this.xyz.indexOf("m") >= 0) {
            this.xyz = this.xyz.substring(0, this.xyz.indexOf("m"));
        }
        if (magRev != 0) {
            this.xyz = this.xyz + (magRev == 1 ? ",m" : ",-m");
        }
    }

    V3 getCentering() {
        if (!this.isFinalized) {
            this.doFinalize();
        }
        if (this.centering == null && !this.unCentered) {
            if (this.modDim == 0 && this.m00 == 1.0f && this.m11 == 1.0f && this.m22 == 1.0f && this.m01 == 0.0f && this.m02 == 0.0f && this.m10 == 0.0f && this.m12 == 0.0f && this.m20 == 0.0f && this.m21 == 0.0f && (this.m03 != 0.0f || this.m13 != 0.0f || this.m23 != 0.0f)) {
                this.isCenteringOp = true;
                this.centering = V3.new3(this.m03, this.m13, this.m23);
            } else {
                this.unCentered = true;
                this.centering = null;
            }
        }
        return this.centering;
    }

    String fixMagneticXYZ(M4 m, String xyz, boolean addMag) {
        if (this.timeReversal == 0) {
            return xyz;
        }
        int pt = xyz.indexOf("m");
        String string = xyz = (pt -= (3 - this.timeReversal) / 2) < 0 ? xyz : xyz.substring(0, pt);
        if (!addMag) {
            return xyz + (this.timeReversal > 0 ? " +1" : " -1");
        }
        M4 m2 = M4.newM4(m);
        m2.m23 = 0.0f;
        m2.m13 = 0.0f;
        m2.m03 = 0.0f;
        if (this.getMagneticOp() < 0.0f) {
            m2.scale(-1.0f);
        }
        xyz = xyz + "(" + PT.rep(PT.rep(PT.rep(SymmetryOperation.getXYZFromMatrix(m2, false, false, false), "x", "mx"), "y", "my"), "z", "mz") + ")";
        return xyz;
    }

    public Map<String, Object> getInfo() {
        if (this.info == null) {
            this.info = new Hashtable();
            this.info.put("xyz", this.xyz);
            if (this.centering != null) {
                this.info.put("centering", this.centering);
            }
            this.info.put("index", this.number - 1);
            this.info.put("isCenteringOp", this.isCenteringOp);
            if (this.linearRotTrans != null) {
                this.info.put("linearRotTrans", this.linearRotTrans);
            }
            this.info.put("modulationDimension", this.modDim);
            this.info.put("matrix", M4.newM4(this));
            if (this.magOp != Float.MAX_VALUE) {
                this.info.put("magOp", Float.valueOf(this.magOp));
            }
            this.info.put("id", this.opId);
            this.info.put("timeReversal", this.timeReversal);
            if (this.xyzOriginal != null) {
                this.info.put("xyzOriginal", this.xyzOriginal);
            }
        }
        return this.info;
    }

    public static void normalizeOperationToCentroid(int dim, M4 m, P3[] atoms, int atomIndex, int count) {
        int i;
        if (count <= 0) {
            return;
        }
        float x = 0.0f;
        float y = 0.0f;
        float z = 0.0f;
        if (atomTest == null) {
            atomTest = new P3();
        }
        int i2 = i + count;
        for (i = atomIndex; i < i2; ++i) {
            Symmetry.newPoint(m, atoms[i], 0, 0, 0, atomTest);
            x += SymmetryOperation.atomTest.x;
            y += SymmetryOperation.atomTest.y;
            z += SymmetryOperation.atomTest.z;
        }
        x /= (float)count;
        y /= (float)count;
        z /= (float)count;
        while ((double)x < -0.001 || (double)x >= 1.001) {
            m.m03 = m.m03 + (float)(x < 0.0f ? 1 : -1);
            x += (float)(x < 0.0f ? 1 : -1);
        }
        if (dim > 1) {
            while ((double)y < -0.001 || (double)y >= 1.001) {
                m.m13 = m.m13 + (float)(y < 0.0f ? 1 : -1);
                y += (float)(y < 0.0f ? 1 : -1);
            }
        }
        if (dim > 2) {
            while ((double)z < -0.001 || (double)z >= 1.001) {
                m.m23 = m.m23 + (float)(z < 0.0f ? 1 : -1);
                z += (float)(z < 0.0f ? 1 : -1);
            }
        }
    }

    public static Lst<P3> getLatticeCentering(SymmetryOperation[] ops) {
        Lst<P3> list = new Lst<P3>();
        for (int i = 0; i < ops.length; ++i) {
            V3 c;
            V3 v3 = c = ops[i] == null ? null : ops[i].getCentering();
            if (c == null) continue;
            list.addLast(P3.newP(c));
        }
        return list;
    }
}

