/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.util;

import com.formdev.flatlaf.FlatSystemProperties;
import com.formdev.flatlaf.util.Graphics2DProxy;
import com.formdev.flatlaf.util.JavaCompatibility;
import com.formdev.flatlaf.util.SystemInfo;
import com.formdev.flatlaf.util.UIScale;
import java.awt.Graphics2D;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.text.AttributedCharacterIterator;
import javax.swing.JComponent;

public class HiDPIUtils {
    private static Boolean useTextYCorrection;

    public static void paintAtScale1x(Graphics2D g2, JComponent c, Painter painter) {
        HiDPIUtils.paintAtScale1x(g2, 0, 0, c.getWidth(), c.getHeight(), painter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void paintAtScale1x(Graphics2D g2, int x, int y, int width, int height, Painter painter) {
        boolean rotated;
        AffineTransform t = g2.getTransform();
        double scaleX = t.getScaleX();
        double scaleY = t.getScaleY();
        double shearX = t.getShearX();
        double shearY = t.getShearY();
        boolean bl = rotated = shearX != 0.0 || shearY != 0.0 || scaleX <= 0.0 || scaleY <= 0.0;
        if (rotated) {
            scaleX = Math.hypot(scaleX, shearX);
            scaleY = Math.hypot(scaleY, shearY);
        } else {
            scaleX = Math.abs(scaleX);
            scaleY = Math.abs(scaleY);
        }
        if (scaleX == 1.0 && scaleY == 1.0) {
            painter.paint(g2, x, y, width, height, 1.0);
            return;
        }
        Rectangle2D.Double scaledRect = HiDPIUtils.scale(scaleX, scaleY, t, x, y, width, height);
        try {
            AffineTransform t1x;
            if (rotated) {
                t1x = new AffineTransform(t.getScaleX(), t.getShearY(), t.getShearX(), t.getScaleY(), Math.floor(scaledRect.x), Math.floor(scaledRect.y));
                t1x.scale(1.0 / scaleX, 1.0 / scaleY);
            } else {
                t1x = new AffineTransform(1.0, 0.0, 0.0, 1.0, Math.floor(scaledRect.x), Math.floor(scaledRect.y));
            }
            g2.setTransform(t1x);
            int swidth = (int)scaledRect.width;
            int sheight = (int)scaledRect.height;
            painter.paint(g2, 0, 0, swidth, sheight, scaleX);
        }
        finally {
            g2.setTransform(t);
        }
    }

    private static Rectangle2D.Double scale(double scaleX, double scaleY, AffineTransform t, int x, int y, int width, int height) {
        double px = (double)x * scaleX + t.getTranslateX();
        double py = (double)y * scaleY + t.getTranslateY();
        double newX = HiDPIUtils.normalize(px);
        double newY = HiDPIUtils.normalize(py);
        double newWidth = HiDPIUtils.normalize(px + (double)width * scaleX) - newX;
        double newHeight = HiDPIUtils.normalize(py + (double)height * scaleY) - newY;
        return new Rectangle2D.Double(newX, newY, newWidth, newHeight);
    }

    private static double normalize(double value) {
        return Math.floor(value + 0.25) + 0.25;
    }

    private static boolean useTextYCorrection() {
        if (useTextYCorrection == null) {
            useTextYCorrection = FlatSystemProperties.getBoolean("flatlaf.useTextYCorrection", true);
        }
        return useTextYCorrection;
    }

    public static float computeTextYCorrection(Graphics2D g2) {
        if (!HiDPIUtils.useTextYCorrection() || !SystemInfo.isWindows) {
            return 0.0f;
        }
        if (!SystemInfo.isJava_9_orLater) {
            return UIScale.getUserScaleFactor() > 1.0f ? -UIScale.scale(0.625f) : 0.0f;
        }
        AffineTransform t = g2.getTransform();
        double scaleY = t.getScaleY();
        if (scaleY < 1.25) {
            return 0.0f;
        }
        if (scaleY <= 1.25) {
            return -0.875f;
        }
        if (scaleY <= 1.5) {
            return -0.625f;
        }
        if (scaleY <= 1.75) {
            return -0.875f;
        }
        if (scaleY <= 2.0) {
            return -0.75f;
        }
        if (scaleY <= 2.25) {
            return -0.875f;
        }
        if (scaleY <= 3.5) {
            return -0.75f;
        }
        return -0.875f;
    }

    public static void drawStringWithYCorrection(JComponent c, Graphics2D g2, String text, int x, int y) {
        HiDPIUtils.drawStringUnderlineCharAtWithYCorrection(c, g2, text, -1, x, y);
    }

    public static void drawStringUnderlineCharAtWithYCorrection(JComponent c, Graphics2D g2, String text, int underlinedIndex, int x, int y) {
        float yCorrection = HiDPIUtils.computeTextYCorrection(g2);
        if (yCorrection != 0.0f) {
            g2.translate(0.0, yCorrection);
            JavaCompatibility.drawStringUnderlineCharAt(c, g2, text, underlinedIndex, x, y);
            g2.translate(0.0, -yCorrection);
        } else {
            JavaCompatibility.drawStringUnderlineCharAt(c, g2, text, underlinedIndex, x, y);
        }
    }

    public static Graphics2D createGraphicsTextYCorrection(Graphics2D g2) {
        final float yCorrection = HiDPIUtils.computeTextYCorrection(g2);
        if (yCorrection == 0.0f) {
            return g2;
        }
        return new Graphics2DProxy(g2){

            @Override
            public void drawString(String str, int x, int y) {
                super.drawString(str, (float)x, (float)y + yCorrection);
            }

            @Override
            public void drawString(String str, float x, float y) {
                super.drawString(str, x, y + yCorrection);
            }

            @Override
            public void drawString(AttributedCharacterIterator iterator2, int x, int y) {
                super.drawString(iterator2, (float)x, (float)y + yCorrection);
            }

            @Override
            public void drawString(AttributedCharacterIterator iterator2, float x, float y) {
                super.drawString(iterator2, x, y + yCorrection);
            }

            @Override
            public void drawChars(char[] data, int offset, int length, int x, int y) {
                super.drawChars(data, offset, length, x, Math.round((float)y + yCorrection));
            }

            @Override
            public void drawBytes(byte[] data, int offset, int length, int x, int y) {
                super.drawBytes(data, offset, length, x, Math.round((float)y + yCorrection));
            }

            @Override
            public void drawGlyphVector(GlyphVector g2, float x, float y) {
                super.drawGlyphVector(g2, x, y + yCorrection);
            }
        };
    }

    public static interface Painter {
        public void paint(Graphics2D var1, int var2, int var3, int var4, int var5, double var6);
    }
}

