/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.fx.countries;

import eu.hansolo.fx.countries.DemoRegionPane;
import eu.hansolo.fx.countries.tools.Helper;
import eu.hansolo.fx.countries.tools.OperatingSystem;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Properties;

public enum PropertyManager {
    INSTANCE;

    public static final String VERSION_PROPERTIES = "version.properties";
    public static final String FXMODULES_PROPERTIES = "fxmodules.properties";
    public static final String VERSION = "version";
    public static final String OPERATING_SYSTEM = "operating_system";
    private Properties properties = new Properties();
    private Properties versionProperties;

    private PropertyManager() {
        String propertiesFilePath = System.getProperty("user.home") + File.separator + FXMODULES_PROPERTIES;
        Path path = Paths.get(propertiesFilePath, new String[0]);
        if (!Files.exists(path, new LinkOption[0])) {
            this.createProperties(this.properties);
        }
        try (FileInputStream propertiesFile = new FileInputStream(propertiesFilePath);){
            this.properties.load(propertiesFile);
        }
        catch (IOException ex) {
            System.out.println("Error reading properties file. " + ex);
        }
        if (this.properties.isEmpty()) {
            this.createProperties(this.properties);
        }
        this.versionProperties = new Properties();
        try {
            this.versionProperties.load(DemoRegionPane.class.getResourceAsStream(VERSION_PROPERTIES));
        }
        catch (IOException ex) {
            System.out.println("Error reading version properties file. " + ex);
        }
    }

    public Properties getProperties() {
        return this.properties;
    }

    public Object get(String KEY) {
        return this.properties.getOrDefault((Object)KEY, "");
    }

    public void set(String KEY, String VALUE) {
        this.properties.setProperty(KEY, VALUE);
        try {
            this.properties.store(new FileOutputStream(String.join((CharSequence)File.separator, System.getProperty("user.dir"), FXMODULES_PROPERTIES)), null);
        }
        catch (IOException exception) {
            System.out.println("Error writing properties file: " + exception);
        }
    }

    public String getString(String key) {
        return this.properties.getOrDefault((Object)key, "").toString();
    }

    public double getDouble(String key) {
        return Double.parseDouble(this.properties.getOrDefault((Object)key, "0").toString());
    }

    public float getFloat(String key) {
        return Float.parseFloat(this.properties.getOrDefault((Object)key, "0").toString());
    }

    public int getInt(String key) {
        return Integer.parseInt(this.properties.getOrDefault((Object)key, "0").toString());
    }

    public long getLong(String key) {
        return Long.parseLong(this.properties.getOrDefault((Object)key, "0").toString());
    }

    public boolean getBoolean(String key) {
        return Boolean.parseBoolean(this.properties.getOrDefault((Object)key, Boolean.FALSE).toString());
    }

    public boolean hasKey(String key) {
        return this.properties.containsKey(key);
    }

    public void storeProperties() {
        if (null == this.properties) {
            return;
        }
        String propFilePath = System.getProperty("user.home") + File.separator + FXMODULES_PROPERTIES;
        try (FileOutputStream output = new FileOutputStream(propFilePath);){
            this.properties.store(output, null);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public void resetProperties() {
        String propFilePath = System.getProperty("user.home") + File.separator + FXMODULES_PROPERTIES;
        try (FileOutputStream output = new FileOutputStream(propFilePath);){
            this.properties.put(OPERATING_SYSTEM, switch (Helper.getOperatingSystem()) {
                case OperatingSystem.MACOS -> OperatingSystem.MACOS.getApiString();
                case OperatingSystem.WINDOWS -> OperatingSystem.WINDOWS.getApiString();
                case OperatingSystem.LINUX -> OperatingSystem.LINUX.getApiString();
                default -> "";
            });
            this.properties.store(output, null);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public String getVersionNumber() {
        return this.versionProperties.getProperty(VERSION);
    }

    private void createProperties(Properties properties) {
        String propFilePath = System.getProperty("user.home") + File.separator + FXMODULES_PROPERTIES;
        try (FileOutputStream output = new FileOutputStream(propFilePath);){
            properties.put(OPERATING_SYSTEM, switch (Helper.getOperatingSystem()) {
                case OperatingSystem.MACOS -> OperatingSystem.MACOS.getApiString();
                case OperatingSystem.WINDOWS -> OperatingSystem.WINDOWS.getApiString();
                case OperatingSystem.LINUX -> OperatingSystem.LINUX.getApiString();
                default -> "";
            });
            properties.store(output, null);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }
}

