/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.toolbox.unit;

import eu.hansolo.toolbox.unit.Category;
import java.math.BigDecimal;

public class Unit {
    private Category category;
    private String unitShort;
    private String unitName;
    private volatile BigDecimal factor;
    private volatile BigDecimal offset;
    private volatile boolean active;

    public Unit(Category category, String unitShort, String unitName, double factor) {
        this(category, unitShort, unitName, factor, 0.0);
    }

    public Unit(Category category, String unitShort, String unitName, double factor, boolean active) {
        this(category, unitShort, unitName, factor, 0.0, active);
    }

    public Unit(Category category, String unitShort, String unitName, BigDecimal factor) {
        this(category, unitShort, unitName, factor, new BigDecimal("0.0"), true);
    }

    public Unit(Category category, String unitShort, String unitName, BigDecimal factor, boolean active) {
        this(category, unitShort, unitName, factor, new BigDecimal("0.0"), active);
    }

    public Unit(Category category, String unitShort, String unitName, double factor, double offset) {
        this(category, unitShort, unitName, new BigDecimal(Double.toString(factor)), new BigDecimal(Double.toString(offset)), true);
    }

    public Unit(Category category, String unitShort, String unitName, double factor, double offset, boolean active) {
        this(category, unitShort, unitName, new BigDecimal(Double.toString(factor)), new BigDecimal(Double.toString(offset)), active);
    }

    public Unit(Category category, String unitShort, String unitName, BigDecimal factorBd, BigDecimal offsetBd) {
        this(category, unitShort, unitName, factorBd, offsetBd, true);
    }

    public Unit(Category category, String unitShort, String unitName, BigDecimal factorBd, BigDecimal offsetBd, boolean active) {
        this.category = category;
        this.unitShort = unitShort;
        this.unitName = unitName;
        this.factor = factorBd;
        this.offset = offsetBd;
        this.active = active;
    }

    public final Category getCategory() {
        return this.category;
    }

    public final String getUnitShort() {
        return this.unitShort;
    }

    public final String getUnitName() {
        return this.unitName;
    }

    public final BigDecimal getFactor() {
        return this.factor;
    }

    public final void setFactor(BigDecimal factor) {
        this.factor = factor;
    }

    public final void setFactor(double factor) {
        this.factor = new BigDecimal(Double.toString(factor));
    }

    public final BigDecimal getOffset() {
        return this.offset;
    }

    public final void setOffset(BigDecimal offset) {
        this.offset = offset;
    }

    public final void setOffset(double offset) {
        this.offset = new BigDecimal(Double.toString(offset));
    }

    public final boolean isActive() {
        return this.active;
    }

    public final void setActive(boolean active) {
        this.active = active;
    }

    public final String toString() {
        return "{" + (Object)((Object)this.category) + "\"" + "unit_short" + "\"" + ":" + "\"" + this.unitShort + "\"" + "," + "\"" + "unit_name" + "\"" + ":" + "\"" + this.unitName + "\"" + "," + "\"" + "factor" + "\"" + ":" + this.factor + "," + "\"" + "offset" + "\"" + ":" + this.getOffset() + "}";
    }
}

