/*
 * Decompiled with CFR 0.152.
 */
package mediathek.tool.cellrenderer;

import com.formdev.flatlaf.util.ScaledImageIcon;
import java.awt.Dimension;
import java.awt.Image;
import java.util.Optional;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import mediathek.tool.cellrenderer.SelfEvictingSenderIconCache;
import mediathek.tool.cellrenderer.SenderCacheKey;
import mediathek.tool.sender_icon_cache.MVSenderIconCache;
import org.apache.commons.lang3.SystemUtils;
import org.jetbrains.annotations.NotNull;

public class CellRendererBase
extends DefaultTableCellRenderer {
    private final SelfEvictingSenderIconCache senderCellIconCache = new SelfEvictingSenderIconCache();

    protected void setSenderIcon(@NotNull String sender, @NotNull Dimension targetDim) {
        Optional<ImageIcon> origIcon;
        SenderCacheKey key = new SenderCacheKey(sender, targetDim);
        Icon cachedIcon = this.senderCellIconCache.getOrDefault(key, null);
        if (cachedIcon == null && (origIcon = MVSenderIconCache.get(sender)).isPresent()) {
            Icon imgIcon;
            ImageIcon icon = origIcon.get();
            Dimension iconDim = new Dimension(icon.getIconWidth(), icon.getIconHeight());
            Dimension scaleDim = this.getScaledDimension(iconDim, targetDim);
            if (SystemUtils.IS_OS_WINDOWS) {
                imgIcon = new ScaledImageIcon(new ImageIcon(icon.getImage()), scaleDim.width, scaleDim.height);
            } else {
                Image newimg = icon.getImage().getScaledInstance(scaleDim.width, scaleDim.height, 4);
                imgIcon = new ImageIcon(newimg);
            }
            cachedIcon = imgIcon;
            this.senderCellIconCache.put(key, cachedIcon);
        }
        if (cachedIcon != null) {
            this.setHorizontalAlignment(0);
            this.setText("");
            this.setIcon(cachedIcon);
        }
    }

    protected Dimension getSenderCellDimension(@NotNull JTable table, int row, int columnModelIndex) {
        Dimension targetDim = new Dimension();
        targetDim.height = table.getRowHeight(row);
        targetDim.width = table.getColumnModel().getColumn(columnModelIndex).getWidth();
        targetDim.height -= 4;
        targetDim.width -= 4;
        return targetDim;
    }

    protected Dimension getScaledDimension(@NotNull Dimension imageSize, @NotNull Dimension boundary) {
        double widthRatio = boundary.getWidth() / imageSize.getWidth();
        double heightRatio = boundary.getHeight() / imageSize.getHeight();
        double ratio = Math.min(widthRatio, heightRatio);
        return new Dimension((int)((double)imageSize.width * ratio), (int)((double)imageSize.height * ratio));
    }
}

