/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ad.ratelimit;

import java.time.Clock;
import java.time.Duration;
import java.util.ArrayDeque;
import java.util.Locale;
import java.util.Optional;
import java.util.Random;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.ActionListener;
import org.opensearch.ad.NodeStateManager;
import org.opensearch.ad.breaker.ADCircuitBreakerService;
import org.opensearch.ad.ml.EntityColdStarter;
import org.opensearch.ad.ml.EntityModel;
import org.opensearch.ad.ml.ModelManager;
import org.opensearch.ad.ml.ModelState;
import org.opensearch.ad.ratelimit.EntityRequest;
import org.opensearch.ad.ratelimit.SingleRequestWorker;
import org.opensearch.ad.settings.AnomalyDetectorSettings;
import org.opensearch.ad.util.ExceptionUtil;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.settings.Setting;
import org.opensearch.common.settings.Settings;
import org.opensearch.threadpool.ThreadPool;

public class EntityColdStartWorker
extends SingleRequestWorker<EntityRequest> {
    private static final Logger LOG = LogManager.getLogger(EntityColdStartWorker.class);
    public static final String WORKER_NAME = "cold-start";
    private final EntityColdStarter entityColdStarter;

    public EntityColdStartWorker(long heapSizeInBytes, int singleRequestSizeInBytes, Setting<Float> maxHeapPercentForQueueSetting, ClusterService clusterService, Random random, ADCircuitBreakerService adCircuitBreakerService, ThreadPool threadPool, Settings settings, float maxQueuedTaskRatio, Clock clock, float mediumSegmentPruneRatio, float lowSegmentPruneRatio, int maintenanceFreqConstant, Duration executionTtl, EntityColdStarter entityColdStarter, Duration stateTtl, NodeStateManager nodeStateManager) {
        super(WORKER_NAME, heapSizeInBytes, singleRequestSizeInBytes, maxHeapPercentForQueueSetting, clusterService, random, adCircuitBreakerService, threadPool, settings, maxQueuedTaskRatio, clock, mediumSegmentPruneRatio, lowSegmentPruneRatio, maintenanceFreqConstant, AnomalyDetectorSettings.ENTITY_COLD_START_QUEUE_CONCURRENCY, executionTtl, stateTtl, nodeStateManager);
        this.entityColdStarter = entityColdStarter;
    }

    @Override
    protected void executeRequest(EntityRequest coldStartRequest, ActionListener<Void> listener) {
        String detectorId = coldStartRequest.getDetectorId();
        Optional<String> modelId = coldStartRequest.getModelId();
        if (!modelId.isPresent()) {
            String error = String.format(Locale.ROOT, "Fail to get model id for request %s", coldStartRequest);
            LOG.warn(error);
            listener.onFailure((Exception)new RuntimeException(error));
            return;
        }
        ModelState<EntityModel> modelState = new ModelState<EntityModel>(new EntityModel(coldStartRequest.getEntity(), new ArrayDeque<double[]>(), null), modelId.get(), detectorId, ModelManager.ModelType.ENTITY.getName(), this.clock, 0.0f);
        ActionListener failureListener = ActionListener.delegateResponse(listener, (delegateListener, e) -> {
            if (ExceptionUtil.isOverloaded(e)) {
                LOG.error("OpenSearch is overloaded");
                this.setCoolDownStart();
            }
            this.nodeStateManager.setException(detectorId, (Exception)e);
            delegateListener.onFailure(e);
        });
        this.entityColdStarter.trainModel(coldStartRequest.getEntity(), detectorId, modelState, (ActionListener<Void>)failureListener);
    }
}

