/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.asynchronous.context.permits;

import java.io.Closeable;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.opensearch.action.ActionListener;
import org.opensearch.common.lease.Releasable;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.common.util.concurrent.AbstractRunnable;
import org.opensearch.common.util.concurrent.RunOnce;
import org.opensearch.search.asynchronous.context.AsynchronousSearchContextId;
import org.opensearch.search.asynchronous.context.active.AsynchronousSearchContextClosedException;
import org.opensearch.threadpool.ThreadPool;

public class AsynchronousSearchContextPermits
implements Closeable {
    private static final int TOTAL_PERMITS = Integer.MAX_VALUE;
    final Semaphore semaphore;
    protected final AsynchronousSearchContextId asynchronousSearchContextId;
    private volatile String lockDetails;
    private final ThreadPool threadPool;
    protected volatile boolean closed;
    protected static final Logger logger = LogManager.getLogger(AsynchronousSearchContextPermits.class);

    public AsynchronousSearchContextPermits(AsynchronousSearchContextId asynchronousSearchContextId, ThreadPool threadPool) {
        this.asynchronousSearchContextId = asynchronousSearchContextId;
        this.threadPool = threadPool;
        this.semaphore = new Semaphore(Integer.MAX_VALUE, true);
    }

    public AsynchronousSearchContextPermits(AsynchronousSearchContextId asynchronousSearchContextId, ThreadPool threadPool, Semaphore semaphore) {
        this.asynchronousSearchContextId = asynchronousSearchContextId;
        this.threadPool = threadPool;
        this.semaphore = semaphore;
    }

    private Releasable acquirePermits(int permits, TimeValue timeout, String details) throws AsynchronousSearchContextClosedException, TimeoutException {
        RunOnce release = new RunOnce(() -> {});
        if (this.closed) {
            logger.debug("Trying to acquire permit for closed context [{}]", (Object)this.asynchronousSearchContextId);
            throw new AsynchronousSearchContextClosedException(this.asynchronousSearchContextId);
        }
        try {
            if (this.semaphore.tryAcquire(permits, timeout.getMillis(), TimeUnit.MILLISECONDS)) {
                this.lockDetails = details;
                release = new RunOnce(() -> {
                    logger.debug("Releasing permit(s) [{}] with reason [{}]", (Object)permits, (Object)this.lockDetails);
                    this.semaphore.release(permits);
                });
                if (this.closed) {
                    release.run();
                    logger.debug("Trying to acquire permit for closed context [{}]", (Object)this.asynchronousSearchContextId);
                    throw new AsynchronousSearchContextClosedException(this.asynchronousSearchContextId);
                }
                return () -> ((RunOnce)release).run();
            }
            throw new TimeoutException("obtaining context lock" + this.asynchronousSearchContextId + "timed out after " + timeout.getMillis() + "ms, previous lock details: [" + this.lockDetails + "] trying to lock for [" + details + "]");
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            release.run();
            throw new RuntimeException("thread interrupted while trying to obtain context lock", e);
        }
    }

    private void asyncAcquirePermit(final int permits, final ActionListener<Releasable> onAcquired, final TimeValue timeout, final String reason) {
        this.threadPool.executor("opensearch_asynchronous_search_generic").execute((Runnable)new AbstractRunnable(){

            public void onFailure(Exception e) {
                logger.debug(() -> new ParameterizedMessage("Failed to acquire permit [{}] for [{}]", (Object)permits, (Object)reason), (Throwable)e);
                onAcquired.onFailure(e);
            }

            protected void doRun() throws TimeoutException, AsynchronousSearchContextClosedException {
                Releasable releasable = AsynchronousSearchContextPermits.this.acquirePermits(permits, timeout, reason);
                logger.debug("Successfully acquired context permit [{}] for [{}]", (Object)permits, (Object)reason);
                onAcquired.onResponse((Object)releasable);
            }
        });
    }

    public void asyncAcquirePermit(ActionListener<Releasable> onAcquired, TimeValue timeout, String reason) {
        this.asyncAcquirePermit(1, onAcquired, timeout, reason);
    }

    public void asyncAcquireAllPermits(ActionListener<Releasable> onAcquired, TimeValue timeout, String reason) {
        this.asyncAcquirePermit(Integer.MAX_VALUE, onAcquired, timeout, reason);
    }

    @Override
    public void close() {
        this.closed = true;
    }
}

