/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indexmanagement.indexstatemanagement.validation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.opensearch.cluster.metadata.AliasMetadata;
import org.opensearch.cluster.metadata.IndexAbstraction;
import org.opensearch.cluster.metadata.IndexMetadata;
import org.opensearch.cluster.metadata.MetadataCreateIndexService;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.collect.ImmutableOpenMap;
import org.opensearch.common.settings.Settings;
import org.opensearch.indexmanagement.indexstatemanagement.opensearchapi.OpenSearchExtensionsKt;
import org.opensearch.indexmanagement.indexstatemanagement.validation.ValidateDelete;
import org.opensearch.indexmanagement.spi.indexstatemanagement.Validate;
import org.opensearch.indexmanagement.util.OpenForTesting;
import org.opensearch.monitor.jvm.JvmService;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@OpenForTesting
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0017\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0012J\u0010\u0010\u0010\u001a\u00020\u00012\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u001e\u0010\u0011\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u000f\u0012\u0004\u0012\u00020\r0\u00122\u0006\u0010\u000e\u001a\u00020\u000fH\u0012J\u001a\u0010\u0013\u001a\u00020\r2\b\u0010\u0014\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0012J\u0010\u0010\u0015\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0012R\u0016\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/opensearch/indexmanagement/indexstatemanagement/validation/ValidateDelete;", "Lorg/opensearch/indexmanagement/spi/indexstatemanagement/Validate;", "settings", "Lorg/opensearch/common/settings/Settings;", "clusterService", "Lorg/opensearch/cluster/service/ClusterService;", "jvmService", "Lorg/opensearch/monitor/jvm/JvmService;", "(Lorg/opensearch/common/settings/Settings;Lorg/opensearch/cluster/service/ClusterService;Lorg/opensearch/monitor/jvm/JvmService;)V", "logger", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "deleteIndexExists", "", "indexName", "", "execute", "getRolloverTargetOrUpdateInfo", "Lkotlin/Pair;", "notWriteIndexForDataStream", "alias", "validIndex", "Companion", "opensearch-index-management"})
public class ValidateDelete
extends Validate {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final Logger logger;
    @NotNull
    public static final String name = "validate_delete";

    public ValidateDelete(@NotNull Settings settings, @NotNull ClusterService clusterService, @NotNull JvmService jvmService) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)clusterService, (String)"clusterService");
        Intrinsics.checkNotNullParameter((Object)jvmService, (String)"jvmService");
        super(settings, clusterService, jvmService);
        this.logger = LogManager.getLogger(((Object)((Object)this)).getClass());
    }

    @NotNull
    public Validate execute(@NotNull String indexName) {
        Intrinsics.checkNotNullParameter((Object)indexName, (String)"indexName");
        if (!this.deleteIndexExists(indexName) || !this.validIndex(indexName)) {
            return this;
        }
        Pair<String, Boolean> pair = this.getRolloverTargetOrUpdateInfo(indexName);
        String rolloverTarget = (String)pair.component1();
        boolean isDataStream = (Boolean)pair.component2();
        if (rolloverTarget != null && !this.notWriteIndexForDataStream(rolloverTarget, indexName)) {
            return this;
        }
        this.setValidationMessage(Companion.getValidationPassedMessage(indexName));
        return this;
    }

    private Pair<String, Boolean> getRolloverTargetOrUpdateInfo(String indexName) {
        String string;
        IndexAbstraction indexAbstraction;
        org.opensearch.cluster.metadata.Metadata metadata2 = this.getClusterService().state().metadata();
        IndexAbstraction indexAbstraction2 = indexAbstraction = (IndexAbstraction)metadata2.getIndicesLookup().get(indexName);
        boolean isDataStreamIndex = (indexAbstraction2 == null ? null : indexAbstraction2.getParentDataStream()) != null;
        if (isDataStreamIndex) {
            IndexAbstraction indexAbstraction3 = indexAbstraction;
            if (indexAbstraction3 == null) {
                string = null;
            } else {
                IndexAbstraction.DataStream dataStream = indexAbstraction3.getParentDataStream();
                string = dataStream == null ? null : dataStream.getName();
            }
        } else {
            IndexMetadata indexMetadata2 = metadata2.index(indexName);
            Intrinsics.checkNotNullExpressionValue((Object)indexMetadata2, (String)"metadata.index(indexName)");
            string = OpenSearchExtensionsKt.getRolloverAlias(indexMetadata2);
        }
        String rolloverTarget = string;
        return TuplesKt.to((Object)rolloverTarget, (Object)isDataStreamIndex);
    }

    /*
     * WARNING - void declaration
     */
    private boolean notWriteIndexForDataStream(String alias, String indexName) {
        Boolean isWriteIndex;
        AliasMetadata indexAlias;
        AliasMetadata aliasMetadata;
        org.opensearch.cluster.metadata.Metadata metadata2 = this.getClusterService().state().getMetadata();
        IndexMetadata indexMetadata2 = metadata2.index(indexName);
        if (indexMetadata2 == null) {
            aliasMetadata = null;
        } else {
            ImmutableOpenMap immutableOpenMap = indexMetadata2.getAliases();
            aliasMetadata = immutableOpenMap == null ? null : (AliasMetadata)immutableOpenMap.get((Object)alias);
        }
        AliasMetadata aliasMetadata2 = indexAlias = aliasMetadata;
        Boolean bl = isWriteIndex = aliasMetadata2 == null ? null : aliasMetadata2.writeIndex();
        if (Intrinsics.areEqual((Object)isWriteIndex, (Object)true)) {
            List list;
            IndexAbstraction indexAbstraction = (IndexAbstraction)metadata2.getIndicesLookup().get(alias);
            if (indexAbstraction == null) {
                list = null;
            } else {
                List list2 = indexAbstraction.getIndices();
                if (list2 == null) {
                    list = null;
                } else {
                    void $this$mapTo$iv$iv;
                    Iterable $this$map$iv = list2;
                    boolean $i$f$map = false;
                    Iterable iterable = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        IndexMetadata indexMetadata3 = (IndexMetadata)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl2 = false;
                        collection.add(it.getIndex());
                    }
                    list = (List)destination$iv$iv;
                }
            }
            List aliasIndices = list;
            this.logger.debug("Alias " + alias + " contains indices " + aliasIndices);
            if (aliasIndices != null) {
                String message = Companion.getFailedIsWriteIndexMessage(indexName);
                this.logger.warn(message);
                this.setValidationStatus(Validate.ValidationStatus.RE_VALIDATING);
                this.setValidationMessage(message);
                return false;
            }
        }
        return true;
    }

    private boolean deleteIndexExists(String indexName) {
        boolean indexExists = this.getClusterService().state().getMetadata().getIndices().containsKey((Object)indexName);
        if (!indexExists) {
            String message = Companion.getNoIndexMessage(indexName);
            this.logger.warn(message);
            this.setValidationStatus(Validate.ValidationStatus.RE_VALIDATING);
            this.setValidationMessage(message);
            return false;
        }
        return true;
    }

    private boolean validIndex(String indexName) {
        Function2 exceptionGenerator2 = validIndex.exceptionGenerator.1.INSTANCE;
        try {
            MetadataCreateIndexService.validateIndexOrAliasName((String)indexName, (arg_0, arg_1) -> ValidateDelete.validIndex$lambda-1(exceptionGenerator2, arg_0, arg_1));
        }
        catch (Exception e) {
            String message = Companion.getIndexNotValidMessage(indexName);
            this.logger.warn(message);
            this.setValidationStatus(Validate.ValidationStatus.RE_VALIDATING);
            this.setValidationMessage(message);
        }
        return true;
    }

    private static final RuntimeException validIndex$lambda-1(Function2 $tmp0, String p0, String p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (RuntimeException)$tmp0.invoke((Object)p0, (Object)p1);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004J\u000e\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004J\u000e\u0010\b\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004J\u000e\u0010\t\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/opensearch/indexmanagement/indexstatemanagement/validation/ValidateDelete$Companion;", "", "()V", "name", "", "getFailedIsWriteIndexMessage", "index", "getIndexNotValidMessage", "getNoIndexMessage", "getValidationPassedMessage", "opensearch-index-management"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getNoIndexMessage(@NotNull String index2) {
            Intrinsics.checkNotNullParameter((Object)index2, (String)"index");
            return "no such index [index=" + index2 + "]";
        }

        @NotNull
        public final String getIndexNotValidMessage(@NotNull String index2) {
            Intrinsics.checkNotNullParameter((Object)index2, (String)"index");
            return "delete index [index=" + index2 + "] not valid";
        }

        @NotNull
        public final String getFailedIsWriteIndexMessage(@NotNull String index2) {
            Intrinsics.checkNotNullParameter((Object)index2, (String)"index");
            return "Index [index=" + index2 + "] is the write index for data stream and cannot be deleted";
        }

        @NotNull
        public final String getValidationPassedMessage(@NotNull String index2) {
            Intrinsics.checkNotNullParameter((Object)index2, (String)"index");
            return "Delete validation passed for [index=" + index2 + "]";
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

