/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indexmanagement.transform.util;

import java.time.Instant;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.action.ActionListener;
import org.opensearch.action.bulk.BackoffPolicy;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.indexmanagement.opensearchapi.OpenSearchExtensionsKt;
import org.opensearch.indexmanagement.transform.model.Transform;
import org.opensearch.indexmanagement.transform.util.TransformLockManager;
import org.opensearch.indexmanagement.util.OpenForTesting;
import org.opensearch.jobscheduler.spi.JobExecutionContext;
import org.opensearch.jobscheduler.spi.LockModel;
import org.opensearch.jobscheduler.spi.ScheduledJobParameter;
import org.opensearch.jobscheduler.spi.utils.LockService;

@OpenForTesting
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u0017\u0018\u0000 !2\u00020\u0001:\u0001!B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0011\u0010\u0015\u001a\u00020\u0016H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0017J\u000f\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0016\u00a2\u0006\u0002\u0010\u001aJ\u0011\u0010\u001b\u001a\u00020\u001cH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0017J\u0019\u0010\u001d\u001a\u00020\u00162\u0006\u0010\u001e\u001a\u00020\u0019H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001fJ\u0013\u0010 \u001a\u0004\u0018\u00010\rH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0017R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0016\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0092\u0004\u00a2\u0006\u0002\n\u0000R(\u0010\u000e\u001a\u0004\u0018\u00010\r2\b\u0010\f\u001a\u0004\u0018\u00010\r@TX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u0016\u0010\u0013\u001a\n \u000b*\u0004\u0018\u00010\u00140\u0014X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\""}, d2={"Lorg/opensearch/indexmanagement/transform/util/TransformLockManager;", "", "transformJob", "Lorg/opensearch/indexmanagement/transform/model/Transform;", "context", "Lorg/opensearch/jobscheduler/spi/JobExecutionContext;", "(Lorg/opensearch/indexmanagement/transform/model/Transform;Lorg/opensearch/jobscheduler/spi/JobExecutionContext;)V", "getContext", "()Lorg/opensearch/jobscheduler/spi/JobExecutionContext;", "exponentialBackoffPolicy", "Lorg/opensearch/action/bulk/BackoffPolicy;", "kotlin.jvm.PlatformType", "<set-?>", "Lorg/opensearch/jobscheduler/spi/LockModel;", "lock", "getLock", "()Lorg/opensearch/jobscheduler/spi/LockModel;", "setLock", "(Lorg/opensearch/jobscheduler/spi/LockModel;)V", "logger", "Lorg/apache/logging/log4j/Logger;", "acquireLockForScheduledJob", "", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "lockExpirationInSeconds", "", "()Ljava/lang/Long;", "releaseLockForScheduledJob", "", "renewLockForLongSearch", "timeSpentOnSearch", "(JLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "renewLockForScheduledJob", "Companion", "opensearch-index-management"})
public class TransformLockManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Transform transformJob;
    @NotNull
    private final JobExecutionContext context;
    private final Logger logger;
    private final BackoffPolicy exponentialBackoffPolicy;
    @Nullable
    private LockModel lock;
    private static final int TIMEOUT_UPPER_BOUND_IN_SECONDS = 600;
    private static final int MAXIMUM_LOCK_EXPIRATION_IN_SECONDS = 1200;

    public TransformLockManager(@NotNull Transform transformJob, @NotNull JobExecutionContext context) {
        Intrinsics.checkNotNullParameter((Object)transformJob, (String)"transformJob");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.transformJob = transformJob;
        this.context = context;
        this.logger = LogManager.getLogger(this.getClass());
        this.exponentialBackoffPolicy = BackoffPolicy.exponentialBackoff((TimeValue)TimeValue.timeValueMillis((long)1000L), (int)3);
    }

    @NotNull
    public JobExecutionContext getContext() {
        return this.context;
    }

    @Nullable
    public LockModel getLock() {
        return this.lock;
    }

    protected void setLock(@Nullable LockModel lockModel) {
        this.lock = lockModel;
    }

    @Nullable
    public Long lockExpirationInSeconds() {
        Long l;
        LockModel lockModel = this.getLock();
        if (lockModel == null) {
            l = null;
        } else {
            LockModel it = lockModel;
            boolean bl = false;
            l = it.getLockTime().getEpochSecond() + it.getLockDurationSeconds() - Instant.now().getEpochSecond();
        }
        return l;
    }

    @Nullable
    public Object acquireLockForScheduledJob(@NotNull Continuation<? super Unit> $completion) {
        return TransformLockManager.acquireLockForScheduledJob$suspendImpl(this, $completion);
    }

    /*
     * Unable to fully structure code
     */
    static /* synthetic */ Object acquireLockForScheduledJob$suspendImpl(TransformLockManager var0, Continuation var1_1) {
        if (!(var1_1 instanceof acquireLockForScheduledJob.1)) ** GOTO lbl-1000
        var4_2 = var1_1;
        if ((var4_2.label & -2147483648) != 0) {
            var4_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(var0, (Continuation<? super acquireLockForScheduledJob.1>)var1_1){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ TransformLockManager this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return TransformLockManager.acquireLockForScheduledJob$suspendImpl(this.this$0, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var5_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                var2_5 = this.exponentialBackoffPolicy;
                Intrinsics.checkNotNullExpressionValue((Object)var2_5, (String)"exponentialBackoffPolicy");
                v0 = var2_5;
                var2_5 = this.logger;
                Intrinsics.checkNotNullExpressionValue((Object)var2_5, (String)"logger");
                $continuation.L$0 = this;
                $continuation.label = 1;
                v1 = OpenSearchExtensionsKt.retry$default(v0, (Logger)var2_5, null, (Function2)new Function2<TimeValue, Continuation<? super Unit>, Object>(this, null){
                    Object L$0;
                    int label;
                    final /* synthetic */ TransformLockManager this$0;
                    {
                        this.this$0 = $receiver;
                        super(2, $completion);
                    }

                    /*
                     * Unable to fully structure code
                     */
                    @Nullable
                    public final Object invokeSuspend(@NotNull Object var1_1) {
                        var4_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)var1_1);
                                var3_3 = this.this$0;
                                var2_4 = this.this$0.getContext().getLockService();
                                Intrinsics.checkNotNullExpressionValue((Object)var2_4, (String)"context.lockService");
                                this.L$0 = var3_3;
                                this.label = 1;
                                v0 = OpenSearchExtensionsKt.suspendUntil(var2_4, (Function2)new Function2<LockService, ActionListener<LockModel>, Unit>(this.this$0){
                                    final /* synthetic */ TransformLockManager this$0;
                                    {
                                        this.this$0 = $receiver;
                                        super(2);
                                    }

                                    public final void invoke(@NotNull LockService $this$suspendUntil, @NotNull ActionListener<LockModel> it) {
                                        Intrinsics.checkNotNullParameter((Object)$this$suspendUntil, (String)"$this$suspendUntil");
                                        Intrinsics.checkNotNullParameter(it, (String)"it");
                                        $this$suspendUntil.acquireLock((ScheduledJobParameter)TransformLockManager.access$getTransformJob$p(this.this$0), this.this$0.getContext(), it);
                                    }
                                }, (Continuation)this);
                                if (v0 == var4_2) {
                                    return var4_2;
                                }
                                ** GOTO lbl18
                            }
                            case 1: {
                                var3_3 = (TransformLockManager)this.L$0;
                                ResultKt.throwOnFailure((Object)$result);
                                v0 = $result;
lbl18:
                                // 2 sources

                                var3_3.setLock((LockModel)v0);
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    @Nullable
                    public final Object invoke(@NotNull TimeValue p1, @Nullable Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }, (Continuation)$continuation, 2, null);
                ** if (v1 != var5_4) goto lbl24
lbl23:
                // 1 sources

                return var5_4;
lbl24:
                // 1 sources

                ** GOTO lbl34
            }
            case 1: {
                this = (TransformLockManager)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v1 = $result;
                }
                catch (Exception e) {
                    this.logger.error("Failed to acquireLock for job " + this.transformJob.getName(), (Throwable)e);
                }
lbl34:
                // 3 sources

                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @Nullable
    public Object renewLockForScheduledJob(@NotNull Continuation<? super LockModel> $completion) {
        return TransformLockManager.renewLockForScheduledJob$suspendImpl(this, $completion);
    }

    /*
     * Unable to fully structure code
     */
    static /* synthetic */ Object renewLockForScheduledJob$suspendImpl(TransformLockManager var0, Continuation var1_1) {
        if (!(var1_1 instanceof renewLockForScheduledJob.1)) ** GOTO lbl-1000
        var5_2 = var1_1;
        if ((var5_2.label & -2147483648) != 0) {
            var5_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(var0, (Continuation<? super renewLockForScheduledJob.1>)var1_1){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                final /* synthetic */ TransformLockManager this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return TransformLockManager.renewLockForScheduledJob$suspendImpl(this.this$0, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var6_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                updatedLock = new Ref.ObjectRef();
                var3_6 = this.exponentialBackoffPolicy;
                Intrinsics.checkNotNullExpressionValue((Object)var3_6, (String)"exponentialBackoffPolicy");
                v0 = var3_6;
                var3_6 = this.logger;
                Intrinsics.checkNotNullExpressionValue((Object)var3_6, (String)"logger");
                $continuation.L$0 = this;
                $continuation.L$1 = updatedLock;
                $continuation.label = 1;
                v1 = OpenSearchExtensionsKt.retry$default(v0, (Logger)var3_6, null, (Function2)new Function2<TimeValue, Continuation<? super Unit>, Object>((Ref.ObjectRef<LockModel>)updatedLock, this, null){
                    Object L$0;
                    int label;
                    final /* synthetic */ Ref.ObjectRef<LockModel> $updatedLock;
                    final /* synthetic */ TransformLockManager this$0;
                    {
                        this.$updatedLock = $updatedLock;
                        this.this$0 = $receiver;
                        super(2, $completion);
                    }

                    /*
                     * Unable to fully structure code
                     */
                    @Nullable
                    public final Object invokeSuspend(@NotNull Object var1_1) {
                        var4_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)var1_1);
                                var3_3 = this.$updatedLock;
                                var2_4 = this.this$0.getContext().getLockService();
                                Intrinsics.checkNotNullExpressionValue((Object)var2_4, (String)"context.lockService");
                                this.L$0 = var3_3;
                                this.label = 1;
                                v0 = OpenSearchExtensionsKt.suspendUntil(var2_4, (Function2)new Function2<LockService, ActionListener<LockModel>, Unit>(this.this$0){
                                    final /* synthetic */ TransformLockManager this$0;
                                    {
                                        this.this$0 = $receiver;
                                        super(2);
                                    }

                                    public final void invoke(@NotNull LockService $this$suspendUntil, @NotNull ActionListener<LockModel> it) {
                                        Intrinsics.checkNotNullParameter((Object)$this$suspendUntil, (String)"$this$suspendUntil");
                                        Intrinsics.checkNotNullParameter(it, (String)"it");
                                        $this$suspendUntil.renewLock(this.this$0.getLock(), it);
                                    }
                                }, (Continuation)this);
                                if (v0 == var4_2) {
                                    return var4_2;
                                }
                                ** GOTO lbl18
                            }
                            case 1: {
                                var3_3 = (Ref.ObjectRef<LockModel>)this.L$0;
                                ResultKt.throwOnFailure((Object)$result);
                                v0 = $result;
lbl18:
                                // 2 sources

                                var3_3.element = v0;
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    @Nullable
                    public final Object invoke(@NotNull TimeValue p1, @Nullable Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }, (Continuation)$continuation, 2, null);
                ** if (v1 != var6_4) goto lbl26
lbl25:
                // 1 sources

                return var6_4;
lbl26:
                // 1 sources

                ** GOTO lbl37
            }
            case 1: {
                updatedLock = (Ref.ObjectRef)$continuation.L$1;
                this = (TransformLockManager)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v1 = $result;
                }
                catch (Exception e) {
                    this.logger.warn("Failed trying to renew lock on " + this.getLock() + ", releasing the existing lock", (Throwable)e);
                }
lbl37:
                // 3 sources

                if (updatedLock.element == null) {
                    $continuation.L$0 = this;
                    $continuation.L$1 = updatedLock;
                    $continuation.label = 2;
                    v2 = this.releaseLockForScheduledJob((Continuation<? super Boolean>)$continuation);
                    if (v2 == var6_4) {
                        return var6_4;
                    }
                }
                ** GOTO lbl50
            }
            case 2: {
                updatedLock = (Ref.ObjectRef)$continuation.L$1;
                this = (TransformLockManager)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v2 = $result;
lbl50:
                // 2 sources

                this.setLock((LockModel)updatedLock.element);
                return this.getLock();
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @Nullable
    public Object releaseLockForScheduledJob(@NotNull Continuation<? super Boolean> $completion) {
        return TransformLockManager.releaseLockForScheduledJob$suspendImpl(this, $completion);
    }

    /*
     * Unable to fully structure code
     */
    static /* synthetic */ Object releaseLockForScheduledJob$suspendImpl(TransformLockManager var0, Continuation var1_1) {
        if (!(var1_1 instanceof releaseLockForScheduledJob.1)) ** GOTO lbl-1000
        var5_2 = var1_1;
        if ((var5_2.label & -2147483648) != 0) {
            var5_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(var0, (Continuation<? super releaseLockForScheduledJob.1>)var1_1){
                Object L$0;
                int I$0;
                /* synthetic */ Object result;
                final /* synthetic */ TransformLockManager this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return TransformLockManager.releaseLockForScheduledJob$suspendImpl(this.this$0, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var6_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                released = 0;
                var3_6 = this.getContext().getLockService();
                Intrinsics.checkNotNullExpressionValue((Object)var3_6, (String)"context.lockService");
                $continuation.L$0 = this;
                $continuation.I$0 = released;
                $continuation.label = 1;
                v0 = OpenSearchExtensionsKt.suspendUntil(var3_6, (Function2)new Function2<LockService, ActionListener<Boolean>, Unit>(this){
                    final /* synthetic */ TransformLockManager this$0;
                    {
                        this.this$0 = $receiver;
                        super(2);
                    }

                    public final void invoke(@NotNull LockService $this$suspendUntil, @NotNull ActionListener<Boolean> it) {
                        Intrinsics.checkNotNullParameter((Object)$this$suspendUntil, (String)"$this$suspendUntil");
                        Intrinsics.checkNotNullParameter(it, (String)"it");
                        $this$suspendUntil.release(this.this$0.getLock(), it);
                    }
                }, $continuation);
                ** if (v0 != var6_4) goto lbl23
lbl22:
                // 1 sources

                return var6_4;
lbl23:
                // 1 sources

                ** GOTO lbl31
            }
            case 1: {
                released = $continuation.I$0;
                this = (TransformLockManager)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl31:
                    // 2 sources

                    if ((released = (int)((Boolean)v0).booleanValue()) == 0) {
                        v1 = this.getLock();
                        Intrinsics.checkNotNull((Object)v1);
                        this.logger.warn("Could not release lock for job " + v1.getJobId());
                    }
                }
                catch (Exception e) {
                    v2 = this.getLock();
                    Intrinsics.checkNotNull((Object)v2);
                    this.logger.error("Failed to release lock for job " + v2.getJobId(), (Throwable)e);
                }
                return Boxing.boxBoolean((boolean)(released != 0));
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @Nullable
    public Object renewLockForLongSearch(long timeSpentOnSearch, @NotNull Continuation<? super Unit> $completion) {
        return TransformLockManager.renewLockForLongSearch$suspendImpl(this, timeSpentOnSearch, $completion);
    }

    static /* synthetic */ Object renewLockForLongSearch$suspendImpl(TransformLockManager this_, long timeSpentOnSearch, Continuation $completion) {
        if (timeSpentOnSearch > 600L) {
            Long l = this_.lockExpirationInSeconds();
            if ((l == null ? 0L : l) < 1200L) {
                Object object = this_.renewLockForScheduledJob((Continuation<? super LockModel>)$completion);
                if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                    return object;
                }
                return Unit.INSTANCE;
            }
        }
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ Transform access$getTransformJob$p(TransformLockManager $this) {
        return $this.transformJob;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/opensearch/indexmanagement/transform/util/TransformLockManager$Companion;", "", "()V", "MAXIMUM_LOCK_EXPIRATION_IN_SECONDS", "", "TIMEOUT_UPPER_BOUND_IN_SECONDS", "opensearch-index-management"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

