/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.fetch.subphase.highlight;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.search.highlight.Encoder;
import org.apache.lucene.search.uhighlight.Passage;
import org.apache.lucene.search.uhighlight.PassageFormatter;
import org.apache.lucene.search.uhighlight.Snippet;
import org.opensearch.index.mapper.annotatedtext.AnnotatedTextFieldMapper;

public class AnnotatedPassageFormatter
extends PassageFormatter {
    public static final String SEARCH_HIT_TYPE = "_hit_term";
    private final Encoder encoder;
    AnnotatedTextFieldMapper.AnnotatedText[] annotations;

    public AnnotatedPassageFormatter(Encoder encoder) {
        this.encoder = encoder;
    }

    void setAnnotations(AnnotatedTextFieldMapper.AnnotatedText[] annotations) {
        this.annotations = annotations;
    }

    static MarkupPassage mergeAnnotations(AnnotatedTextFieldMapper.AnnotatedText.AnnotationToken[] annotations, Passage passage) {
        try {
            MarkupPassage markupPassage = new MarkupPassage();
            for (int i = 0; i < passage.getNumMatches(); ++i) {
                int start = passage.getMatchStarts()[i];
                int end = passage.getMatchEnds()[i];
                String searchTerm = passage.getMatchTerms()[i].utf8ToString();
                Markup markup = new Markup(start, end, "_hit_term=" + URLEncoder.encode(searchTerm, StandardCharsets.UTF_8.name()));
                markupPassage.addUnlessOverlapping(markup);
            }
            for (AnnotatedTextFieldMapper.AnnotatedText.AnnotationToken token : annotations) {
                int start = token.offset;
                int end = token.endOffset;
                if (start < passage.getStartOffset() || end > passage.getEndOffset()) continue;
                String escapedValue = URLEncoder.encode(token.value, StandardCharsets.UTF_8.name());
                Markup markup = new Markup(start, end, escapedValue);
                markupPassage.addUnlessOverlapping(markup);
            }
            return markupPassage;
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
    }

    public Snippet[] format(Passage[] passages, String content) {
        Snippet[] snippets = new Snippet[passages.length];
        int j = 0;
        for (Passage passage : passages) {
            AnnotatedTextFieldMapper.AnnotatedText.AnnotationToken[] annotations = this.getIntersectingAnnotations(passage.getStartOffset(), passage.getEndOffset());
            MarkupPassage mergedMarkup = AnnotatedPassageFormatter.mergeAnnotations(annotations, passage);
            StringBuilder sb = new StringBuilder();
            int pos = passage.getStartOffset();
            for (Markup markup : mergedMarkup.markups) {
                int start = markup.start;
                int end = markup.end;
                if (start > pos) {
                    this.append(sb, content, pos, start);
                }
                if (end <= pos) continue;
                sb.append("[");
                this.append(sb, content, Math.max(pos, start), end);
                sb.append("](");
                sb.append(markup.metadata);
                sb.append(")");
                pos = end;
            }
            this.append(sb, content, pos, Math.max(pos, passage.getEndOffset()));
            if (sb.charAt(sb.length() - 1) == '\u2029') {
                sb.deleteCharAt(sb.length() - 1);
            } else if (sb.charAt(sb.length() - 1) == '\u0000') {
                sb.deleteCharAt(sb.length() - 1);
            }
            snippets[j++] = new Snippet(sb.toString().trim(), passage.getScore(), passage.getNumMatches() > 0);
        }
        return snippets;
    }

    public AnnotatedTextFieldMapper.AnnotatedText.AnnotationToken[] getIntersectingAnnotations(int start, int end) {
        ArrayList<AnnotatedTextFieldMapper.AnnotatedText.AnnotationToken> intersectingAnnotations = new ArrayList<AnnotatedTextFieldMapper.AnnotatedText.AnnotationToken>();
        int fieldValueOffset = 0;
        for (AnnotatedTextFieldMapper.AnnotatedText fieldValueAnnotations : this.annotations) {
            for (int i = 0; i < fieldValueAnnotations.numAnnotations(); ++i) {
                AnnotatedTextFieldMapper.AnnotatedText.AnnotationToken token = fieldValueAnnotations.getAnnotation(i);
                if (!token.intersects(start - fieldValueOffset, end - fieldValueOffset)) continue;
                intersectingAnnotations.add(new AnnotatedTextFieldMapper.AnnotatedText.AnnotationToken(token.offset + fieldValueOffset, token.endOffset + fieldValueOffset, token.value));
            }
            fieldValueOffset += fieldValueAnnotations.textMinusMarkup.length() + 1;
        }
        return intersectingAnnotations.toArray(new AnnotatedTextFieldMapper.AnnotatedText.AnnotationToken[intersectingAnnotations.size()]);
    }

    private void append(StringBuilder dest, String content, int start, int end) {
        dest.append(this.encoder.encodeText(content.substring(start, end)));
    }

    static class Markup {
        int start;
        int end;
        String metadata;

        Markup(int start, int end, String metadata) {
            this.start = start;
            this.end = end;
            this.metadata = metadata;
        }

        boolean isAfter(Markup other) {
            return this.start > other.end;
        }

        void merge(Markup newMarkup) {
            assert (this.samePosition(newMarkup));
            this.metadata = this.metadata + "&" + newMarkup.metadata;
        }

        boolean samePosition(Markup other) {
            return this.start == other.start && this.end == other.end;
        }

        boolean overlaps(Markup other) {
            return this.start <= other.start && this.end >= other.start || this.start <= other.end && this.end >= other.end || this.start >= other.start && this.end <= other.end;
        }

        public String toString() {
            return "Markup [start=" + this.start + ", end=" + this.end + ", metadata=" + this.metadata + "]";
        }
    }

    static class MarkupPassage {
        List<Markup> markups = new ArrayList<Markup>();
        int lastMarkupEnd = -1;

        MarkupPassage() {
        }

        public void addUnlessOverlapping(Markup newMarkup) {
            if (newMarkup.start > this.lastMarkupEnd) {
                this.markups.add(newMarkup);
                this.lastMarkupEnd = newMarkup.end;
                return;
            }
            int index = 0;
            for (Markup existingMarkup : this.markups) {
                if (existingMarkup.samePosition(newMarkup)) {
                    existingMarkup.merge(newMarkup);
                    return;
                }
                if (existingMarkup.overlaps(newMarkup)) {
                    return;
                }
                if (existingMarkup.isAfter(newMarkup)) {
                    this.markups.add(index, newMarkup);
                    return;
                }
                ++index;
            }
            this.markups.add(newMarkup);
            this.lastMarkupEnd = newMarkup.end;
        }
    }
}

