/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.opensearch.planner.logical.rule;

import com.facebook.presto.matching.Capture;
import com.facebook.presto.matching.Captures;
import com.facebook.presto.matching.Pattern;
import org.opensearch.sql.opensearch.planner.logical.OpenSearchLogicalIndexScan;
import org.opensearch.sql.opensearch.planner.logical.rule.OptimizationRuleUtils;
import org.opensearch.sql.planner.logical.LogicalPlan;
import org.opensearch.sql.planner.logical.LogicalRelation;
import org.opensearch.sql.planner.logical.LogicalSort;
import org.opensearch.sql.planner.optimizer.Rule;
import org.opensearch.sql.planner.optimizer.pattern.Patterns;

public class MergeSortAndRelation
implements Rule<LogicalSort> {
    private final Capture<LogicalRelation> relationCapture = Capture.newCapture();
    private final Pattern<LogicalSort> pattern = Pattern.typeOf(LogicalSort.class).matching(OptimizationRuleUtils::sortByFieldsOnly).with(Patterns.source().matching(Pattern.typeOf(LogicalRelation.class).capturedAs(this.relationCapture)));

    public Pattern<LogicalSort> pattern() {
        return this.pattern;
    }

    public LogicalPlan apply(LogicalSort sort, Captures captures) {
        LogicalRelation relation = (LogicalRelation)captures.get(this.relationCapture);
        return OpenSearchLogicalIndexScan.builder().relationName(relation.getRelationName()).sortList(sort.getSortList()).build();
    }
}

