/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.analysis;

import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.opensearch.sql.analysis.AnalysisContext;
import org.opensearch.sql.analysis.ExpressionAnalyzer;
import org.opensearch.sql.ast.AbstractNodeVisitor;
import org.opensearch.sql.ast.expression.Alias;
import org.opensearch.sql.ast.expression.UnresolvedExpression;
import org.opensearch.sql.ast.expression.WindowFunction;
import org.opensearch.sql.ast.tree.Sort;
import org.opensearch.sql.expression.Expression;
import org.opensearch.sql.expression.NamedExpression;
import org.opensearch.sql.expression.window.WindowDefinition;
import org.opensearch.sql.planner.logical.LogicalPlan;
import org.opensearch.sql.planner.logical.LogicalSort;
import org.opensearch.sql.planner.logical.LogicalWindow;

public class WindowExpressionAnalyzer
extends AbstractNodeVisitor<LogicalPlan, AnalysisContext> {
    private final ExpressionAnalyzer expressionAnalyzer;
    private final LogicalPlan child;

    public LogicalPlan analyze(UnresolvedExpression projectItem, AnalysisContext context) {
        LogicalPlan window = projectItem.accept(this, context);
        return window == null ? this.child : window;
    }

    @Override
    public LogicalPlan visitAlias(Alias node, AnalysisContext context) {
        if (!(node.getDelegated() instanceof WindowFunction)) {
            return null;
        }
        WindowFunction unresolved = (WindowFunction)node.getDelegated();
        Expression windowFunction = this.expressionAnalyzer.analyze(unresolved, context);
        List<Expression> partitionByList = this.analyzePartitionList(unresolved, context);
        List<Pair<Sort.SortOption, Expression>> sortList = this.analyzeSortList(unresolved, context);
        WindowDefinition windowDefinition = new WindowDefinition(partitionByList, sortList);
        NamedExpression namedWindowFunction = new NamedExpression(node.getName(), windowFunction, node.getAlias());
        List<Pair<Sort.SortOption, Expression>> allSortItems = windowDefinition.getAllSortItems();
        if (allSortItems.isEmpty()) {
            return new LogicalWindow(this.child, namedWindowFunction, windowDefinition);
        }
        return new LogicalWindow(new LogicalSort(this.child, allSortItems), namedWindowFunction, windowDefinition);
    }

    private List<Expression> analyzePartitionList(WindowFunction node, AnalysisContext context) {
        return node.getPartitionByList().stream().map(expr -> this.expressionAnalyzer.analyze((UnresolvedExpression)expr, context)).collect(Collectors.toList());
    }

    private List<Pair<Sort.SortOption, Expression>> analyzeSortList(WindowFunction node, AnalysisContext context) {
        return node.getSortList().stream().map(pair -> ImmutablePair.of((Object)this.analyzeSortOption((Sort.SortOption)pair.getLeft()), (Object)this.expressionAnalyzer.analyze((UnresolvedExpression)pair.getRight(), context))).collect(Collectors.toList());
    }

    private Sort.SortOption analyzeSortOption(Sort.SortOption option) {
        if (option.getNullOrder() == null) {
            return option.getSortOrder() == Sort.SortOrder.DESC ? Sort.SortOption.DEFAULT_DESC : Sort.SortOption.DEFAULT_ASC;
        }
        return new Sort.SortOption(option.getSortOrder() == Sort.SortOrder.DESC ? Sort.SortOrder.DESC : Sort.SortOrder.ASC, option.getNullOrder());
    }

    @Generated
    public WindowExpressionAnalyzer(ExpressionAnalyzer expressionAnalyzer, LogicalPlan child) {
        this.expressionAnalyzer = expressionAnalyzer;
        this.child = child;
    }
}

