B.1 Using Shortcuts

# Using Shortcuts

Sonic Pi is as much an instrument as a coding environment. Shortcuts can
therefore make playing Sonic Pi much more *efficient and natural* -
especially when you're playing live in front of an audience.

Much of Sonic Pi can be controlled through the keyboard. As you gain
more familiarity working and performing with Sonic Pi, you'll likely
start using the shortcuts more and more. *I personally touch-type* (I
recommend you consider learning too) and find myself frustrated whenever
I need to reach for the mouse as it slows me down. I therefore use all
of these shortcuts on a very regular basis! 

Therefore, if you learn the shortcuts, you'll learn to use your keyboard
effectively and you'll be live coding like a pro in no time.

However, *don't try and learn them all at once*, just try and remember the
ones you use most and then keep adding more to your practice.

## Consistency across Platforms

Imagine you're learning the clarinet. You'd expect all clarinets of
all makes to have similar controls and fingerings. If they didn't, you'd
have a tough time switching between different clarinets and you'd be
stuck to using just one make.

Unfortunately the three major operating systems (Linux, Mac OS X and
Windows) come with their own standard defaults for actions such as cut
and paste etc. Sonic Pi will try and honour these standards. However
*priority is placed on consistency across platforms* within Sonic Pi
rather than attempting to conform to a given platform's standards. This
means that when you learn the shortcuts whilst playing with Sonic Pi on
your Raspberry Pi, you can move to the Mac or PC and feel right at home.

## Control and Meta

Part of the notion of consistency is the naming of shortcuts. In Sonic
Pi we use the names *Control* and *Meta* to refer to the two main
combination keys. On all platforms *Control* is the same. However, on
Linux and Windows, *Meta* is actually the *Alt* key while on Mac *Meta* is
the *Command* key. For consistency we'll use the term *Meta* - just
remember to map that to the appropriate key on your operating system.

## Abbreviations

To help keep things simple and readable, we'll use the abbreviations *C-*
for *Control* plus another key and *M-* for *Meta* plus another key. For
example, if a shortcut requires you to hold down both *Meta* and *r*
we'll write that as `M-r`. The *-* just means "at the same time as."

The following are some of the shortcuts I find most useful.

## Stopping and starting

Instead of always reaching for the mouse to run your code, you can
simply press `M-r`. Similarly, to stop running code you can press `M-s`.

## Navigation

I'm really lost without the navigation shortcuts. I therefore highly
recommend you spend the time to learn them. These shortcuts also work
extremely well when you've learned to touch type as they use the
standard letters rather than requiring you to move your hand to the
mouse or the arrow keys on your keyboard.

You can move to the beginning of the line with `C-a`, the end of the
line with `C-e`, up a line with `C-p`, down a line with `C-n`, forward a
character with `C-f`, and back a character with `C-b`. You can even
delete all the characters from the cursor to the end of the line with
`C-k`.

## Tidy Code

To auto-align your code simply press `M-m`.

## Help System

To toggle the help system you can press `M-i`. However, a much more
useful shortcut to know is `C-i` which will look up the word underneath
the cursor and display the docs if it finds anything. Instant help!

For a full list take a look at section B.2 Shortcut Cheatsheet.
