/*
 * Decompiled with CFR 0.152.
 */
package org.sunflow.image;

import org.sunflow.image.XYZColor;

public abstract class SpectralCurve {
    private static final int WAVELENGTH_MIN = 360;
    private static final int WAVELENGTH_MAX = 830;
    private static final double[] CIE_xbar = new double[]{1.299E-4, 2.321E-4, 4.149E-4, 7.416E-4, 0.001368, 0.002236, 0.004243, 0.00765, 0.01431, 0.02319, 0.04351, 0.07763, 0.13438, 0.21477, 0.2839, 0.3285, 0.34828, 0.34806, 0.3362, 0.3187, 0.2908, 0.2511, 0.19536, 0.1421, 0.09564, 0.05795001, 0.03201, 0.0147, 0.0049, 0.0024, 0.0093, 0.0291, 0.06327, 0.1096, 0.1655, 0.2257499, 0.2904, 0.3597, 0.4334499, 0.5120501, 0.5945, 0.6784, 0.7621, 0.8425, 0.9163, 0.9786, 1.0263, 1.0567, 1.0622, 1.0456, 1.0026, 0.9384, 0.8544499, 0.7514, 0.6424, 0.5419, 0.4479, 0.3608, 0.2835, 0.2187, 0.1649, 0.1212, 0.0874, 0.0636, 0.04677, 0.0329, 0.0227, 0.01584, 0.01135916, 0.008110916, 0.005790346, 0.004106457, 0.002899327, 0.00204919, 0.001439971, 9.999493E-4, 6.900786E-4, 4.760213E-4, 3.323011E-4, 2.348261E-4, 1.661505E-4, 1.17413E-4, 8.307527E-5, 5.870652E-5, 4.150994E-5, 2.935326E-5, 2.067383E-5, 1.455977E-5, 1.025398E-5, 7.221456E-6, 5.085868E-6, 3.581652E-6, 2.522525E-6, 1.776509E-6, 1.251141E-6};
    private static final double[] CIE_ybar = new double[]{3.917E-6, 6.965E-6, 1.239E-5, 2.202E-5, 3.9E-5, 6.4E-5, 1.2E-4, 2.17E-4, 3.96E-4, 6.4E-4, 0.00121, 0.00218, 0.004, 0.0073, 0.0116, 0.01684, 0.023, 0.0298, 0.038, 0.048, 0.06, 0.0739, 0.09098, 0.1126, 0.13902, 0.1693, 0.20802, 0.2586, 0.323, 0.4073, 0.503, 0.6082, 0.71, 0.7932, 0.862, 0.9148501, 0.954, 0.9803, 0.9949501, 1.0, 0.995, 0.9786, 0.952, 0.9154, 0.87, 0.8163, 0.757, 0.6949, 0.631, 0.5668, 0.503, 0.4412, 0.381, 0.321, 0.265, 0.217, 0.175, 0.1382, 0.107, 0.0816, 0.061, 0.04458, 0.032, 0.0232, 0.017, 0.01192, 0.00821, 0.005723, 0.004102, 0.002929, 0.002091, 0.001484, 0.001047, 7.4E-4, 5.2E-4, 3.611E-4, 2.492E-4, 1.719E-4, 1.2E-4, 8.48E-5, 6.0E-5, 4.24E-5, 3.0E-5, 2.12E-5, 1.499E-5, 1.06E-5, 7.4657E-6, 5.2578E-6, 3.7029E-6, 2.6078E-6, 1.8366E-6, 1.2934E-6, 9.1093E-7, 6.4153E-7, 4.5181E-7};
    private static final double[] CIE_zbar = new double[]{6.061E-4, 0.001086, 0.001946, 0.003486, 0.006450001, 0.01054999, 0.02005001, 0.03621, 0.06785001, 0.1102, 0.2074, 0.3713, 0.6456, 1.0390501, 1.3856, 1.62296, 1.74706, 1.7826, 1.77211, 1.7441, 1.6692, 1.5281, 1.28764, 1.0419, 0.8129501, 0.6162, 0.46518, 0.3533, 0.272, 0.2123, 0.1582, 0.1117, 0.07824999, 0.05725001, 0.04216, 0.02984, 0.0203, 0.0134, 0.008749999, 0.005749999, 0.0039, 0.002749999, 0.0021, 0.0018, 0.001650001, 0.0014, 0.0011, 0.001, 8.0E-4, 6.0E-4, 3.4E-4, 2.4E-4, 1.9E-4, 1.0E-4, 4.999999E-5, 3.0E-5, 2.0E-5, 1.0E-5, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
    private static final int WAVELENGTH_STEP = 470 / (CIE_xbar.length - 1);

    public abstract float sample(float var1);

    public final XYZColor toXYZ() {
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        int n = 0;
        int n2 = 360;
        while (n < CIE_xbar.length) {
            float f4 = this.sample(n2);
            f = (float)((double)f + (double)f4 * CIE_xbar[n]);
            f2 = (float)((double)f2 + (double)f4 * CIE_ybar[n]);
            f3 = (float)((double)f3 + (double)f4 * CIE_zbar[n]);
            ++n;
            n2 += WAVELENGTH_STEP;
        }
        return new XYZColor(f, f2, f3).mul(WAVELENGTH_STEP);
    }

    static {
        if (WAVELENGTH_STEP * (CIE_xbar.length - 1) != 470) {
            String string = String.format("Internal error - spectrum static data is inconsistent!\n  * min = %d\n  * max = %d\n  * step = %d\n  * num = %d", 360, 830, WAVELENGTH_STEP, CIE_xbar.length);
            throw new RuntimeException(string);
        }
    }
}

