import * as lsp from 'vscode-languageserver';
import * as lspcalls from './lsp-protocol.calls.proposed.js';
import * as lspinlayHints from './lsp-protocol.inlayHints.proposed.js';
import { LspDocument } from './document.js';
import { tsp, TypeScriptInitializeParams } from './ts-protocol.js';
import { TypeScriptServiceConfiguration } from './utils/configuration.js';
export declare class LspServer {
    private options;
    private _tspClient;
    private initializeParams;
    private diagnosticQueue?;
    private configurationManager;
    private logger;
    private workspaceRoot;
    private typeScriptAutoFixProvider;
    private features;
    private readonly documents;
    constructor(options: TypeScriptServiceConfiguration);
    closeAll(): void;
    shutdown(): void;
    private get tspClient();
    initialize(params: TypeScriptInitializeParams): Promise<lsp.InitializeResult>;
    private findTypescriptVersion;
    private getLogDirectoryPath;
    private setCompilerOptionsForInferredProjects;
    didChangeConfiguration(params: lsp.DidChangeConfigurationParams): void;
    protected diagnosticsTokenSource: lsp.CancellationTokenSource | undefined;
    protected interuptDiagnostics<R>(f: () => R): R;
    pendingDebouncedRequest: boolean;
    requestDiagnostics(): Promise<void>;
    readonly doRequestDiagnosticsDebounced: () => Promise<tsp.RequestCompletedEvent>;
    protected doRequestDiagnostics(): Promise<tsp.RequestCompletedEvent>;
    protected cancelDiagnostics(): void;
    didOpenTextDocument(params: lsp.DidOpenTextDocumentParams): void;
    protected getScriptKindName(languageId: string): tsp.ScriptKindName | undefined;
    didCloseTextDocument(params: lsp.DidCloseTextDocumentParams): void;
    protected closeDocument(file: string): void;
    didChangeTextDocument(params: lsp.DidChangeTextDocumentParams): void;
    didSaveTextDocument(_params: lsp.DidSaveTextDocumentParams): void;
    definition(params: lsp.DefinitionParams): Promise<lsp.Definition | lsp.DefinitionLink[] | undefined>;
    implementation(params: lsp.TextDocumentPositionParams): Promise<lsp.Definition | undefined>;
    typeDefinition(params: lsp.TextDocumentPositionParams): Promise<lsp.Definition | undefined>;
    private getDefinition;
    private getSymbolLocations;
    documentSymbol(params: lsp.DocumentSymbolParams): Promise<lsp.DocumentSymbol[] | lsp.SymbolInformation[]>;
    protected get supportHierarchicalDocumentSymbol(): boolean;
    completion(params: lsp.CompletionParams): Promise<lsp.CompletionList | null>;
    completionResolve(item: lsp.CompletionItem): Promise<lsp.CompletionItem>;
    hover(params: lsp.TextDocumentPositionParams): Promise<lsp.Hover>;
    protected getQuickInfo(file: string, position: lsp.Position): Promise<tsp.QuickInfoResponse | undefined>;
    prepareRename(params: lsp.PrepareRenameParams): Promise<lsp.Range | {
        range: lsp.Range;
        placeholder: string;
    } | undefined | null>;
    rename(params: lsp.RenameParams): Promise<lsp.WorkspaceEdit | undefined | null>;
    references(params: lsp.ReferenceParams): Promise<lsp.Location[]>;
    documentFormatting(params: lsp.DocumentFormattingParams): Promise<lsp.TextEdit[]>;
    documentRangeFormatting(params: lsp.DocumentRangeFormattingParams): Promise<lsp.TextEdit[]>;
    signatureHelp(params: lsp.SignatureHelpParams): Promise<lsp.SignatureHelp | undefined>;
    protected getSignatureHelp(file: string, params: lsp.SignatureHelpParams): Promise<tsp.SignatureHelpResponse | undefined>;
    codeAction(params: lsp.CodeActionParams): Promise<lsp.CodeAction[]>;
    protected getCodeFixes(fileRangeArgs: tsp.FileRangeRequestArgs, context: lsp.CodeActionContext): Promise<tsp.GetCodeFixesResponse | undefined>;
    protected getRefactors(fileRangeArgs: tsp.FileRangeRequestArgs, context: lsp.CodeActionContext): Promise<tsp.GetApplicableRefactorsResponse | undefined>;
    protected getOrganizeImports(args: tsp.OrganizeImportsRequestArgs): Promise<tsp.OrganizeImportsResponse | undefined>;
    executeCommand(arg: lsp.ExecuteCommandParams, token?: lsp.CancellationToken, workDoneProgress?: lsp.WorkDoneProgressReporter): Promise<any>;
    protected applyFileCodeEdits(edits: ReadonlyArray<tsp.FileCodeEdits>): Promise<boolean>;
    protected applyRenameFile(sourceUri: string, targetUri: string): Promise<void>;
    protected getEditsForFileRename(sourceUri: string, targetUri: string): Promise<ReadonlyArray<tsp.FileCodeEdits>>;
    documentHighlight(arg: lsp.TextDocumentPositionParams): Promise<lsp.DocumentHighlight[]>;
    private lastFileOrDummy;
    workspaceSymbol(params: lsp.WorkspaceSymbolParams): Promise<lsp.SymbolInformation[]>;
    /**
     * implemented based on https://github.com/Microsoft/vscode/blob/master/extensions/typescript-language-features/src/features/folding.ts
     */
    foldingRanges(params: lsp.FoldingRangeParams): Promise<lsp.FoldingRange[] | undefined>;
    protected asFoldingRange(span: tsp.OutliningSpan, document: LspDocument): lsp.FoldingRange | undefined;
    protected asFoldingRangeKind(span: tsp.OutliningSpan): lsp.FoldingRangeKind | undefined;
    protected onTsEvent(event: tsp.Event): Promise<void>;
    calls(params: lspcalls.CallsParams): Promise<lspcalls.CallsResult>;
    inlayHints(params: lsp.InlayHintParams): Promise<lsp.InlayHint[] | undefined>;
    inlayHintsLegacy(params: lspinlayHints.InlayHintsParams): Promise<lspinlayHints.InlayHintsResult>;
    semanticTokensFull(params: lsp.SemanticTokensParams): Promise<lsp.SemanticTokens>;
    semanticTokensRange(params: lsp.SemanticTokensRangeParams): Promise<lsp.SemanticTokens>;
    getSemanticTokens(doc: LspDocument, file: string, startOffset: number, endOffset: number): Promise<lsp.SemanticTokens>;
}
//# sourceMappingURL=lsp-server.d.ts.map