import * as lsp from 'vscode-languageserver';
import { WorkspaceConfiguration } from './configuration-manager.js';
import { LspClient, WithProgressOptions } from './lsp-client.js';
import { LspServer } from './lsp-server.js';
import { ConsoleLogger } from './utils/logger.js';
export declare const PACKAGE_ROOT: string;
export declare function uri(...components: string[]): string;
export declare function filePath(...components: string[]): string;
export declare function readContents(path: string): string;
export declare function positionAt(document: lsp.TextDocumentItem, idx: number): lsp.Position;
export declare function position(document: lsp.TextDocumentItem, match: string): lsp.Position;
export declare function positionAfter(document: lsp.TextDocumentItem, match: string): lsp.Position;
export declare function lastPosition(document: lsp.TextDocumentItem, match: string): lsp.Position;
export declare function toPlatformEOL(text: string): string;
export declare class TestLspClient implements LspClient {
    protected options: TestLspServerOptions;
    protected logger: ConsoleLogger;
    private workspaceEditsListener;
    constructor(options: TestLspServerOptions, logger: ConsoleLogger);
    createProgressReporter(_token?: lsp.CancellationToken, _workDoneProgress?: lsp.WorkDoneProgressReporter): Promise<lsp.WorkDoneProgressReporter>;
    withProgress<R = void>(_options: WithProgressOptions, task: (progress: lsp.WorkDoneProgressReporter) => Promise<R>): Promise<R>;
    publishDiagnostics(args: lsp.PublishDiagnosticsParams): void;
    showErrorMessage(message: string): void;
    logMessage(args: lsp.LogMessageParams): void;
    addApplyWorkspaceEditListener(listener: (args: lsp.ApplyWorkspaceEditParams) => void): void;
    applyWorkspaceEdit(args: lsp.ApplyWorkspaceEditParams): Promise<lsp.ApplyWorkspaceEditResult>;
    rename(): Promise<void>;
}
export declare class TestLspServer extends LspServer {
    workspaceEdits: lsp.ApplyWorkspaceEditParams[];
    updateWorkspaceSettings(settings: WorkspaceConfiguration): void;
}
interface TestLspServerOptions {
    rootUri: string | null;
    tsserverLogVerbosity?: string;
    publishDiagnostics: (args: lsp.PublishDiagnosticsParams) => void;
    clientCapabilitiesOverride?: lsp.ClientCapabilities;
}
export declare function createServer(options: TestLspServerOptions): Promise<TestLspServer>;
export {};
//# sourceMappingURL=test-utils.d.ts.map