import * as LSP from 'vscode-languageserver';
import * as Parser from 'web-tree-sitter';
/**
 * Analysis the given file content and returns a set of URIs that are
 * sourced. Note that the URIs are resolved.
 */
export declare function getSourcedUris({ fileContent, fileUri, rootPath, tree, }: {
    fileContent: string;
    fileUri: string;
    rootPath: string | null;
    tree: Parser.Tree;
}): Set<string>;
/**
 * Investigates if the given position is a path to a sourced file and maps it
 * to a location. Useful for jump to definition.
 * @returns an optional location
 */
export declare function getSourcedLocation({ position, rootPath, tree, uri, word, }: {
    position: {
        line: number;
        character: number;
    };
    rootPath: string | null;
    tree: Parser.Tree;
    uri: string;
    word: string;
}): LSP.Location | null;
