import { z } from 'zod';
export declare const ConfigSchema: z.ZodObject<{
    backgroundAnalysisMaxFiles: z.ZodDefault<z.ZodNumber>;
    globPattern: z.ZodDefault<z.ZodString>;
    explainshellEndpoint: z.ZodDefault<z.ZodString>;
    highlightParsingErrors: z.ZodDefault<z.ZodBoolean>;
    includeAllWorkspaceSymbols: z.ZodDefault<z.ZodBoolean>;
    shellcheckArguments: z.ZodDefault<z.ZodEffects<z.ZodArray<z.ZodString, "many">, string[], unknown>>;
    shellcheckPath: z.ZodDefault<z.ZodString>;
}, "strict", z.ZodTypeAny, {
    globPattern: string;
    includeAllWorkspaceSymbols: boolean;
    backgroundAnalysisMaxFiles: number;
    explainshellEndpoint: string;
    highlightParsingErrors: boolean;
    shellcheckArguments: string[];
    shellcheckPath: string;
}, {
    globPattern?: string | undefined;
    includeAllWorkspaceSymbols?: boolean | undefined;
    backgroundAnalysisMaxFiles?: number | undefined;
    explainshellEndpoint?: string | undefined;
    highlightParsingErrors?: boolean | undefined;
    shellcheckArguments?: unknown;
    shellcheckPath?: string | undefined;
}>;
export type Config = z.infer<typeof ConfigSchema>;
export declare function getConfigFromEnvironmentVariables(): {
    config: z.infer<typeof ConfigSchema>;
    environmentVariablesUsed: string[];
};
export declare function getDefaultConfiguration(): z.infer<typeof ConfigSchema>;
