{
    This file is part of the Free Pascal FCL
    Copyright (c) 2009 by Paul Ishenin

    See the file COPYING.FPC, included in this distribution,
    for details about the copyright.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
   
    As a special exception, you can also use these sources under the MPL 1.1,
    this to ensure compatibility with Jedi APILIB

}
{-------------------------------------------------------------------------// }
{  VisualStyle Style Guide symbols                                           }
{-------------------------------------------------------------------------// }

// property symbol definitions

const
  TMTVS_RESERVEDLOW  = 100000;
  TMTVS_RESERVEDHIGH = 19999;

// AEROWIZARDSTYLE class parts and states

  VSCLASS_AEROWIZARDSTYLE = 'AEROWIZARDSTYLE';
  VSCLASS_AEROWIZARD      = 'AEROWIZARD';

type
  AEROWIZARDPARTS = longint;

const
  AW_TITLEBAR    = 1;
  AW_HEADERAREA  = 2;
  AW_CONTENTAREA = 3;
  AW_COMMANDAREA = 4;
  AW_BUTTON      = 5;

type
  AEROWIZARDSTYLEPARTS = AEROWIZARDPARTS;

type
  TITLEBARSTATES = longint;

const
  AW_S_TITLEBAR_ACTIVE   = 1;
  AW_S_TITLEBAR_INACTIVE = 2;


type
  HEADERAREASTATES = longint;

const
  AW_S_HEADERAREA_NOMARGIN = 1;


type
  CONTENTAREASTATES = longint;

const
  AW_S_CONTENTAREA_NOMARGIN = 1;


// BUTTONSTYLE class parts and states

  VSCLASS_BUTTONSTYLE = 'BUTTONSTYLE';
  VSCLASS_BUTTON      = 'BUTTON';

type
  BUTTONPARTS = longint;

const
  BP_PUSHBUTTON  = 1;
  BP_RADIOBUTTON = 2;
  BP_CHECKBOX    = 3;
  BP_GROUPBOX    = 4;
  BP_USERBUTTON  = 5;
  BP_COMMANDLINK = 6;
  BP_COMMANDLINKGLYPH = 7;

type
  BUTTONSTYLEPARTS = BUTTONPARTS;

type
  PUSHBUTTONSTATES = longint;

const
  PBS_NORMAL   = 1;
  PBS_HOT      = 2;
  PBS_PRESSED  = 3;
  PBS_DISABLED = 4;
  PBS_DEFAULTED = 5;
  PBS_DEFAULTED_ANIMATING = 6;


type
  RADIOBUTTONSTATES = longint;

const
  RBS_UNCHECKEDNORMAL = 1;
  RBS_UNCHECKEDHOT    = 2;
  RBS_UNCHECKEDPRESSED = 3;
  RBS_UNCHECKEDDISABLED = 4;
  RBS_CHECKEDNORMAL   = 5;
  RBS_CHECKEDHOT      = 6;
  RBS_CHECKEDPRESSED  = 7;
  RBS_CHECKEDDISABLED = 8;


type
  CHECKBOXSTATES = longint;

const
  CBS_UNCHECKEDNORMAL = 1;
  CBS_UNCHECKEDHOT  = 2;
  CBS_UNCHECKEDPRESSED = 3;
  CBS_UNCHECKEDDISABLED = 4;
  CBS_CHECKEDNORMAL = 5;
  CBS_CHECKEDHOT    = 6;
  CBS_CHECKEDPRESSED = 7;
  CBS_CHECKEDDISABLED = 8;
  CBS_MIXEDNORMAL   = 9;
  CBS_MIXEDHOT      = 10;
  CBS_MIXEDPRESSED  = 11;
  CBS_MIXEDDISABLED = 12;
  CBS_IMPLICITNORMAL = 13;
  CBS_IMPLICITHOT   = 14;
  CBS_IMPLICITPRESSED = 15;
  CBS_IMPLICITDISABLED = 16;
  CBS_EXCLUDEDNORMAL = 17;
  CBS_EXCLUDEDHOT   = 18;
  CBS_EXCLUDEDPRESSED = 19;
  CBS_EXCLUDEDDISABLED = 20;


type
  GROUPBOXSTATES = longint;

const
  GBS_NORMAL   = 1;
  GBS_DISABLED = 2;


type
  COMMANDLINKSTATES = longint;

const
  CMDLS_NORMAL   = 1;
  CMDLS_HOT      = 2;
  CMDLS_PRESSED  = 3;
  CMDLS_DISABLED = 4;
  CMDLS_DEFAULTED = 5;
  CMDLS_DEFAULTED_ANIMATING = 6;


type
  COMMANDLINKGLYPHSTATES = longint;

const
  CMDLGS_NORMAL   = 1;
  CMDLGS_HOT      = 2;
  CMDLGS_PRESSED  = 3;
  CMDLGS_DISABLED = 4;
  CMDLGS_DEFAULTED = 5;


// COMBOBOXSTYLE class parts and states

  VSCLASS_COMBOBOXSTYLE = 'COMBOBOXSTYLE';
  VSCLASS_COMBOBOX      = 'COMBOBOX';

type
  COMBOBOXPARTS = longint;

const
  CP_DROPDOWNBUTTON = 1;
  CP_BACKGROUND = 2;
  CP_TRANSPARENTBACKGROUND = 3;
  CP_BORDER    = 4;
  CP_READONLY  = 5;
  CP_DROPDOWNBUTTONRIGHT = 6;
  CP_DROPDOWNBUTTONLEFT = 7;
  CP_CUEBANNER = 8;

type
  COMBOBOXSTYLEPARTS = COMBOBOXPARTS;

type
  COMBOBOXSTYLESTATES = longint;

const
  CBXS_NORMAL   = 1;
  CBXS_HOT      = 2;
  CBXS_PRESSED  = 3;
  CBXS_DISABLED = 4;


type
  DROPDOWNBUTTONRIGHTSTATES = longint;

const
  CBXSR_NORMAL   = 1;
  CBXSR_HOT      = 2;
  CBXSR_PRESSED  = 3;
  CBXSR_DISABLED = 4;


type
  DROPDOWNBUTTONLEFTSTATES = longint;

const
  CBXSL_NORMAL   = 1;
  CBXSL_HOT      = 2;
  CBXSL_PRESSED  = 3;
  CBXSL_DISABLED = 4;


type
  TRANSPARENTBACKGROUNDSTATES = longint;

const
  CBTBS_NORMAL   = 1;
  CBTBS_HOT      = 2;
  CBTBS_DISABLED = 3;
  CBTBS_FOCUSED  = 4;


type
  BORDERSTATES = longint;

const
  CBB_NORMAL   = 1;
  CBB_HOT      = 2;
  CBB_FOCUSED  = 3;
  CBB_DISABLED = 4;


type
  READONLYSTATES = longint;

const
  CBRO_NORMAL   = 1;
  CBRO_HOT      = 2;
  CBRO_PRESSED  = 3;
  CBRO_DISABLED = 4;


type
  CUEBANNERSTATES = longint;

const
  CBCB_NORMAL   = 1;
  CBCB_HOT      = 2;
  CBCB_PRESSED  = 3;
  CBCB_DISABLED = 4;


//  COMMUNICATIONSSTYLE class parts and states

  VSCLASS_COMMUNICATIONSSTYLE = 'COMMUNICATIONSSTYLE';
  VSCLASS_COMMUNICATIONS      = 'COMMUNICATIONS';

type
  COMMUNICATIONSPARTS = longint;

const
  CSST_TAB = 1;

type
  COMMUNICATIONSSTYLEPARTS = COMMUNICATIONSPARTS;

type
  TABSTATES = longint;

const
  CSTB_NORMAL   = 1;
  CSTB_HOT      = 2;
  CSTB_SELECTED = 3;


// CONTROLPANELSTYLE class parts and states

  VSCLASS_CONTROLPANELSTYLE = 'CONTROLPANELSTYLE';
  VSCLASS_CONTROLPANEL      = 'CONTROLPANEL';

type
  CONTROLPANELPARTS = longint;

const
  CPANEL_NAVIGATIONPANE = 1;
  CPANEL_CONTENTPANE = 2;
  CPANEL_NAVIGATIONPANELABEL = 3;
  CPANEL_CONTENTPANELABEL = 4;
  CPANEL_TITLE      = 5;
  CPANEL_BODYTEXT   = 6;
  CPANEL_HELPLINK   = 7;
  CPANEL_TASKLINK   = 8;
  CPANEL_GROUPTEXT  = 9;
  CPANEL_CONTENTLINK = 10;
  CPANEL_SECTIONTITLELINK = 11;
  CPANEL_LARGECOMMANDAREA = 12;
  CPANEL_SMALLCOMMANDAREA = 13;
  CPANEL_BUTTON     = 14;
  CPANEL_MESSAGETEXT = 15;
  CPANEL_NAVIGATIONPANELINE = 16;
  CPANEL_CONTENTPANELINE = 17;
  CPANEL_BANNERAREA = 18;
  CPANEL_BODYTITLE  = 19;

type
  CONTROLPANELSTYLEPARTS = CONTROLPANELPARTS;

type
  HELPLINKSTATES = longint;

const
  CPHL_NORMAL   = 1;
  CPHL_HOT      = 2;
  CPHL_PRESSED  = 3;
  CPHL_DISABLED = 4;


type
  TASKLINKSTATES = longint;

const
  CPTL_NORMAL   = 1;
  CPTL_HOT      = 2;
  CPTL_PRESSED  = 3;
  CPTL_DISABLED = 4;
  CPTL_PAGE     = 5;


type
  CONTENTLINKSTATES = longint;

const
  CPCL_NORMAL   = 1;
  CPCL_HOT      = 2;
  CPCL_PRESSED  = 3;
  CPCL_DISABLED = 4;


type
  SECTIONTITLELINKSTATES = longint;

const
  CPSTL_NORMAL = 1;
  CPSTL_HOT    = 2;


// DATEPICKERSTYLE class parts and states

  VSCLASS_DATEPICKERSTYLE = 'DATEPICKERSTYLE';
  VSCLASS_DATEPICKER      = 'DATEPICKER';

type
  DATEPICKERPARTS = longint;

const
  DP_DATETEXT   = 1;
  DP_DATEBORDER = 2;
  DP_SHOWCALENDARBUTTONRIGHT = 3;

type
  DATEPICKERSTYLEPARTS = DATEPICKERPARTS;

type
  DATETEXTSTATES = longint;

const
  DPDT_NORMAL   = 1;
  DPDT_DISABLED = 2;
  DPDT_SELECTED = 3;


type
  DATEBORDERSTATES = longint;

const
  DPDB_NORMAL   = 1;
  DPDB_HOT      = 2;
  DPDB_FOCUSED  = 3;
  DPDB_DISABLED = 4;


type
  SHOWCALENDARBUTTONRIGHTSTATES = longint;

const
  DPSCBR_NORMAL   = 1;
  DPSCBR_HOT      = 2;
  DPSCBR_PRESSED  = 3;
  DPSCBR_DISABLED = 4;


// DRAGDROPSTYLE class parts and states

  VSCLASS_DRAGDROPSTYLE = 'DRAGDROPSTYLE';
  VSCLASS_DRAGDROP      = 'DRAGDROP';

type
  DRAGDROPPARTS = longint;

const
  DD_COPY    = 1;
  DD_MOVE    = 2;
  DD_UPDATEMETADATA = 3;
  DD_CREATELINK = 4;
  DD_WARNING = 5;
  DD_NONE    = 6;
  DD_IMAGEBG = 7;
  DD_TEXTBG  = 8;

type
  DRAGDROPSTYLEPARTS = DRAGDROPPARTS;

type
  COPYSTATES = longint;

const
  DDCOPY_HIGHLIGHT   = 1;
  DDCOPY_NOHIGHLIGHT = 2;


type
  MOVESTATES = longint;

const
  DDMOVE_HIGHLIGHT   = 1;
  DDMOVE_NOHIGHLIGHT = 2;


type
  UPDATEMETADATASTATES = longint;

const
  DDUPDATEMETADATA_HIGHLIGHT   = 1;
  DDUPDATEMETADATA_NOHIGHLIGHT = 2;


type
  CREATELINKSTATES = longint;

const
  DDCREATELINK_HIGHLIGHT   = 1;
  DDCREATELINK_NOHIGHLIGHT = 2;


type
  WARNINGSTATES = longint;

const
  DDWARNING_HIGHLIGHT   = 1;
  DDWARNING_NOHIGHLIGHT = 2;


type
  NONESTATES = longint;

const
  DDNONE_HIGHLIGHT   = 1;
  DDNONE_NOHIGHLIGHT = 2;


// EDITSTYLE class parts and states

  VSCLASS_EDITSTYLE = 'EDITSTYLE';
  VSCLASS_EDIT      = 'EDIT';

type
  EDITPARTS = longint;

const
  EP_EDITTEXT   = 1;
  EP_CARET      = 2;
  EP_BACKGROUND = 3;
  EP_PASSWORD   = 4;
  EP_BACKGROUNDWITHBORDER = 5;
  EP_EDITBORDER_NOSCROLL = 6;
  EP_EDITBORDER_HSCROLL = 7;
  EP_EDITBORDER_VSCROLL = 8;
  EP_EDITBORDER_HVSCROLL = 9;

type
  EDITSTYLEPARTS = EDITPARTS;

type
  EDITTEXTSTATES = longint;

const
  ETS_NORMAL   = 1;
  ETS_HOT      = 2;
  ETS_SELECTED = 3;
  ETS_DISABLED = 4;
  ETS_FOCUSED  = 5;
  ETS_READONLY = 6;
  ETS_ASSIST   = 7;
  ETS_CUEBANNER = 8;


type
  BACKGROUNDSTATES = longint;

const
  EBS_NORMAL   = 1;
  EBS_HOT      = 2;
  EBS_DISABLED = 3;
  EBS_FOCUSED  = 4;
  EBS_READONLY = 5;
  EBS_ASSIST   = 6;


type
  BACKGROUNDWITHBORDERSTATES = longint;

const
  EBWBS_NORMAL   = 1;
  EBWBS_HOT      = 2;
  EBWBS_DISABLED = 3;
  EBWBS_FOCUSED  = 4;


type
  EDITBORDER_NOSCROLLSTATES = longint;

const
  EPSN_NORMAL   = 1;
  EPSN_HOT      = 2;
  EPSN_FOCUSED  = 3;
  EPSN_DISABLED = 4;


type
  EDITBORDER_HSCROLLSTATES = longint;

const
  EPSH_NORMAL   = 1;
  EPSH_HOT      = 2;
  EPSH_FOCUSED  = 3;
  EPSH_DISABLED = 4;


type
  EDITBORDER_VSCROLLSTATES = longint;

const
  EPSV_NORMAL   = 1;
  EPSV_HOT      = 2;
  EPSV_FOCUSED  = 3;
  EPSV_DISABLED = 4;


type
  EDITBORDER_HVSCROLLSTATES = longint;

const
  EPSHV_NORMAL   = 1;
  EPSHV_HOT      = 2;
  EPSHV_FOCUSED  = 3;
  EPSHV_DISABLED = 4;


// EXPLORERBARSTYLE class parts and states

  VSCLASS_EXPLORERBARSTYLE = 'EXPLORERBARSTYLE';
  VSCLASS_EXPLORERBAR      = 'EXPLORERBAR';

type
  EXPLORERBARPARTS = longint;

const
  EBP_HEADERBACKGROUND = 1;
  EBP_HEADERCLOSE = 2;
  EBP_HEADERPIN = 3;
  EBP_IEBARMENU = 4;
  EBP_NORMALGROUPBACKGROUND = 5;
  EBP_NORMALGROUPCOLLAPSE = 6;
  EBP_NORMALGROUPEXPAND = 7;
  EBP_NORMALGROUPHEAD = 8;
  EBP_SPECIALGROUPBACKGROUND = 9;
  EBP_SPECIALGROUPCOLLAPSE = 10;
  EBP_SPECIALGROUPEXPAND = 11;
  EBP_SPECIALGROUPHEAD = 12;

type
  EXPLORERBARSTYLEPARTS = EXPLORERBARPARTS;

type
  HEADERCLOSESTATES = longint;

const
  EBHC_NORMAL  = 1;
  EBHC_HOT     = 2;
  EBHC_PRESSED = 3;


type
  HEADERPINSTATES = longint;

const
  EBHP_NORMAL  = 1;
  EBHP_HOT     = 2;
  EBHP_PRESSED = 3;
  EBHP_SELECTEDNORMAL = 4;
  EBHP_SELECTEDHOT = 5;
  EBHP_SELECTEDPRESSED = 6;


type
  IEBARMENUSTATES = longint;

const
  EBM_NORMAL  = 1;
  EBM_HOT     = 2;
  EBM_PRESSED = 3;


type
  NORMALGROUPCOLLAPSESTATES = longint;

const
  EBNGC_NORMAL  = 1;
  EBNGC_HOT     = 2;
  EBNGC_PRESSED = 3;


type
  NORMALGROUPEXPANDSTATES = longint;

const
  EBNGE_NORMAL  = 1;
  EBNGE_HOT     = 2;
  EBNGE_PRESSED = 3;


type
  SPECIALGROUPCOLLAPSESTATES = longint;

const
  EBSGC_NORMAL  = 1;
  EBSGC_HOT     = 2;
  EBSGC_PRESSED = 3;


type
  SPECIALGROUPEXPANDSTATES = longint;

const
  EBSGE_NORMAL  = 1;
  EBSGE_HOT     = 2;
  EBSGE_PRESSED = 3;


// FLYOUTSTYLE class parts and states

  VSCLASS_FLYOUTSTYLE = 'FLYOUTSTYLE';
  VSCLASS_FLYOUT      = 'FLYOUT';

type
  FLYOUTPARTS = longint;

const
  FLYOUT_HEADER   = 1;
  FLYOUT_BODY     = 2;
  FLYOUT_LABEL    = 3;
  FLYOUT_LINK     = 4;
  FLYOUT_DIVIDER  = 5;
  FLYOUT_WINDOW   = 6;
  FLYOUT_LINKAREA = 7;
  FLYOUT_LINKHEADER = 8;

type
  FLYOUTSTYLEPARTS = FLYOUTPARTS;

type
  LABELSTATES = longint;

const
  FLS_NORMAL     = 1;
  FLS_SELECTED   = 2;
  FLS_EMPHASIZED = 3;
  FLS_DISABLED   = 4;


type
  LINKSTATES = longint;

const
  FLYOUTLINK_NORMAL = 1;
  FLYOUTLINK_HOVER  = 2;


type
  BODYSTATES = longint;

const
  FBS_NORMAL     = 1;
  FBS_EMPHASIZED = 2;


type
  LINKHEADERSTATES = longint;

const
  FLH_NORMAL = 1;
  FLH_HOVER  = 2;


// HEADERSTYLE class parts and states

  VSCLASS_HEADERSTYLE = 'HEADERSTYLE';
  VSCLASS_HEADER      = 'HEADER';

type
  HEADERPARTS = longint;

const
  HP_HEADERITEM      = 1;
  HP_HEADERITEMLEFT  = 2;
  HP_HEADERITEMRIGHT = 3;
  HP_HEADERSORTARROW = 4;
  HP_HEADERDROPDOWN  = 5;
  HP_HEADERDROPDOWNFILTER = 6;
  HP_HEADEROVERFLOW  = 7;

type
  HEADERSTYLEPARTS = HEADERPARTS;

type
  HEADERSTYLESTATES = longint;

const
  HBG_DETAILS = 1;
  HBG_ICON    = 2;


type
  HEADERITEMSTATES = longint;

const
  HIS_NORMAL  = 1;
  HIS_HOT     = 2;
  HIS_PRESSED = 3;
  HIS_SORTEDNORMAL = 4;
  HIS_SORTEDHOT = 5;
  HIS_SORTEDPRESSED = 6;
  HIS_ICONNORMAL = 7;
  HIS_ICONHOT = 8;
  HIS_ICONPRESSED = 9;
  HIS_ICONSORTEDNORMAL = 10;
  HIS_ICONSORTEDHOT = 11;
  HIS_ICONSORTEDPRESSED = 12;


type
  HEADERITEMLEFTSTATES = longint;

const
  HILS_NORMAL  = 1;
  HILS_HOT     = 2;
  HILS_PRESSED = 3;


type
  HEADERITEMRIGHTSTATES = longint;

const
  HIRS_NORMAL  = 1;
  HIRS_HOT     = 2;
  HIRS_PRESSED = 3;


type
  HEADERSORTARROWSTATES = longint;

const
  HSAS_SORTEDUP   = 1;
  HSAS_SORTEDDOWN = 2;


type
  HEADERDROPDOWNSTATES = longint;

const
  HDDS_NORMAL  = 1;
  HDDS_SOFTHOT = 2;
  HDDS_HOT     = 3;


type
  HEADERDROPDOWNFILTERSTATES = longint;

const
  HDDFS_NORMAL  = 1;
  HDDFS_SOFTHOT = 2;
  HDDFS_HOT     = 3;


type
  HEADEROVERFLOWSTATES = longint;

const
  HOFS_NORMAL = 1;
  HOFS_HOT    = 2;


// LISTBOXSTYLE class parts and states

  VSCLASS_LISTBOXSTYLE = 'LISTBOXSTYLE';
  VSCLASS_LISTBOX      = 'LISTBOX';

type
  LISTBOXPARTS = longint;

const
  LBCP_BORDER_HSCROLL = 1;
  LBCP_BORDER_HVSCROLL = 2;
  LBCP_BORDER_NOSCROLL = 3;
  LBCP_BORDER_VSCROLL = 4;
  LBCP_ITEM = 5;

type
  LISTBOXSTYLEPARTS = LISTBOXPARTS;

type
  BORDER_HSCROLLSTATES = longint;

const
  LBPSH_NORMAL   = 1;
  LBPSH_FOCUSED  = 2;
  LBPSH_HOT      = 3;
  LBPSH_DISABLED = 4;


type
  BORDER_HVSCROLLSTATES = longint;

const
  LBPSHV_NORMAL   = 1;
  LBPSHV_FOCUSED  = 2;
  LBPSHV_HOT      = 3;
  LBPSHV_DISABLED = 4;


type
  BORDER_NOSCROLLSTATES = longint;

const
  LBPSN_NORMAL   = 1;
  LBPSN_FOCUSED  = 2;
  LBPSN_HOT      = 3;
  LBPSN_DISABLED = 4;


type
  BORDER_VSCROLLSTATES = longint;

const
  LBPSV_NORMAL   = 1;
  LBPSV_FOCUSED  = 2;
  LBPSV_HOT      = 3;
  LBPSV_DISABLED = 4;


type
  ITEMSTATES = longint;

const
  LBPSI_HOT      = 1;
  LBPSI_HOTSELECTED = 2;
  LBPSI_SELECTED = 3;
  LBPSI_SELECTEDNOTFOCUS = 4;


// LISTVIEWSTYLE class parts and states

  VSCLASS_LISTVIEWSTYLE = 'LISTVIEWSTYLE';
  VSCLASS_LISTVIEW      = 'LISTVIEW';

type
  LISTVIEWPARTS = longint;

const
  LVP_LISTITEM     = 1;
  LVP_LISTGROUP    = 2;
  LVP_LISTDETAIL   = 3;
  LVP_LISTSORTEDDETAIL = 4;
  LVP_EMPTYTEXT    = 5;
  LVP_GROUPHEADER  = 6;
  LVP_GROUPHEADERLINE = 7;
  LVP_EXPANDBUTTON = 8;
  LVP_COLLAPSEBUTTON = 9;
  LVP_COLUMNDETAIL = 10;

type
  LISTVIEWSTYLEPARTS = LISTVIEWPARTS;

type
  LISTITEMSTATES = longint;

const
  LISS_NORMAL   = 1;
  LISS_HOT      = 2;
  LISS_SELECTED = 3;
  LISS_DISABLED = 4;
  LISS_SELECTEDNOTFOCUS = 5;
  LISS_HOTSELECTED = 6;


type
  GROUPHEADERSTATES = longint;

const
  LVGH_OPEN     = 1;
  LVGH_OPENHOT  = 2;
  LVGH_OPENSELECTED = 3;
  LVGH_OPENSELECTEDHOT = 4;
  LVGH_OPENSELECTEDNOTFOCUSED = 5;
  LVGH_OPENSELECTEDNOTFOCUSEDHOT = 6;
  LVGH_OPENMIXEDSELECTION = 7;
  LVGH_OPENMIXEDSELECTIONHOT = 8;
  LVGH_CLOSE    = 9;
  LVGH_CLOSEHOT = 10;
  LVGH_CLOSESELECTED = 11;
  LVGH_CLOSESELECTEDHOT = 12;
  LVGH_CLOSESELECTEDNOTFOCUSED = 13;
  LVGH_CLOSESELECTEDNOTFOCUSEDHOT = 14;
  LVGH_CLOSEMIXEDSELECTION = 15;
  LVGH_CLOSEMIXEDSELECTIONHOT = 16;


type
  GROUPHEADERLINESTATES = longint;

const
  LVGHL_OPEN     = 1;
  LVGHL_OPENHOT  = 2;
  LVGHL_OPENSELECTED = 3;
  LVGHL_OPENSELECTEDHOT = 4;
  LVGHL_OPENSELECTEDNOTFOCUSED = 5;
  LVGHL_OPENSELECTEDNOTFOCUSEDHOT = 6;
  LVGHL_OPENMIXEDSELECTION = 7;
  LVGHL_OPENMIXEDSELECTIONHOT = 8;
  LVGHL_CLOSE    = 9;
  LVGHL_CLOSEHOT = 10;
  LVGHL_CLOSESELECTED = 11;
  LVGHL_CLOSESELECTEDHOT = 12;
  LVGHL_CLOSESELECTEDNOTFOCUSED = 13;
  LVGHL_CLOSESELECTEDNOTFOCUSEDHOT = 14;
  LVGHL_CLOSEMIXEDSELECTION = 15;
  LVGHL_CLOSEMIXEDSELECTIONHOT = 16;


type
  EXPANDBUTTONSTATES = longint;

const
  LVEB_NORMAL = 1;
  LVEB_HOVER  = 2;
  LVEB_PUSHED = 3;


type
  COLLAPSEBUTTONSTATES = longint;

const
  LVCB_NORMAL = 1;
  LVCB_HOVER  = 2;
  LVCB_PUSHED = 3;


// MENUSTYLE class parts and states

  VSCLASS_MENUSTYLE = 'MENUSTYLE';
  VSCLASS_MENU      = 'MENU';

type
  MENUPARTS = longint;

const
  MENU_MENUITEM_TMSCHEMA = 1;
  MENU_MENUDROPDOWN_TMSCHEMA = 2;
  MENU_MENUBARITEM_TMSCHEMA = 3;
  MENU_MENUBARDROPDOWN_TMSCHEMA = 4;
  MENU_CHEVRON_TMSCHEMA = 5;
  MENU_SEPARATOR_TMSCHEMA = 6;
  MENU_BARBACKGROUND = 7;
  MENU_BARITEM      = 8;
  MENU_POPUPBACKGROUND = 9;
  MENU_POPUPBORDERS = 10;
  MENU_POPUPCHECK   = 11;
  MENU_POPUPCHECKBACKGROUND = 12;
  MENU_POPUPGUTTER  = 13;
  MENU_POPUPITEM    = 14;
  MENU_POPUPSEPARATOR = 15;
  MENU_POPUPSUBMENU = 16;
  MENU_SYSTEMCLOSE  = 17;
  MENU_SYSTEMMAXIMIZE = 18;
  MENU_SYSTEMMINIMIZE = 19;
  MENU_SYSTEMRESTORE = 20;

type
  MENUSTYLEPARTS = MENUPARTS;

type
  BARBACKGROUNDSTATES = longint;

const
  MB_ACTIVE   = 1;
  MB_INACTIVE = 2;


type
  BARITEMSTATES = longint;

const
  MBI_NORMAL   = 1;
  MBI_HOT      = 2;
  MBI_PUSHED   = 3;
  MBI_DISABLED = 4;
  MBI_DISABLEDHOT = 5;
  MBI_DISABLEDPUSHED = 6;


type
  POPUPCHECKSTATES = longint;

const
  MC_CHECKMARKNORMAL   = 1;
  MC_CHECKMARKDISABLED = 2;
  MC_BULLETNORMAL      = 3;
  MC_BULLETDISABLED    = 4;


type
  POPUPCHECKBACKGROUNDSTATES = longint;

const
  MCB_DISABLED = 1;
  MCB_NORMAL   = 2;
  MCB_BITMAP   = 3;


type
  POPUPITEMSTATES = longint;

const
  MPI_NORMAL   = 1;
  MPI_HOT      = 2;
  MPI_DISABLED = 3;
  MPI_DISABLEDHOT = 4;


type
  POPUPSUBMENUSTATES = longint;

const
  MSM_NORMAL   = 1;
  MSM_DISABLED = 2;


type
  SYSTEMCLOSESTATES = longint;

const
  MSYSC_NORMAL   = 1;
  MSYSC_DISABLED = 2;


type
  SYSTEMMAXIMIZESTATES = longint;

const
  MSYSMX_NORMAL   = 1;
  MSYSMX_DISABLED = 2;


type
  SYSTEMMINIMIZESTATES = longint;

const
  MSYSMN_NORMAL   = 1;
  MSYSMN_DISABLED = 2;


type
  SYSTEMRESTORESTATES = longint;

const
  MSYSR_NORMAL   = 1;
  MSYSR_DISABLED = 2;


// NAVIGATION class parts and states

  VSCLASS_NAVIGATION = 'NAVIGATION';

type
  NAVIGATIONPARTS = longint;

const
  NAV_BACKBUTTON    = 1;
  NAV_FORWARDBUTTON = 2;
  NAV_MENUBUTTON    = 3;


type
  NAV_BACKBUTTONSTATES = longint;

const
  NAV_BB_NORMAL   = 1;
  NAV_BB_HOT      = 2;
  NAV_BB_PRESSED  = 3;
  NAV_BB_DISABLED = 4;


type
  NAV_FORWARDBUTTONSTATES = longint;

const
  NAV_FB_NORMAL   = 1;
  NAV_FB_HOT      = 2;
  NAV_FB_PRESSED  = 3;
  NAV_FB_DISABLED = 4;


type
  NAV_MENUBUTTONSTATES = longint;

const
  NAV_MB_NORMAL   = 1;
  NAV_MB_HOT      = 2;
  NAV_MB_PRESSED  = 3;
  NAV_MB_DISABLED = 4;


// PROGRESSSTYLE class parts and states

  VSCLASS_PROGRESSSTYLE = 'PROGRESSSTYLE';
  VSCLASS_PROGRESS      = 'PROGRESS';

type
  PROGRESSPARTS = longint;

const
  PP_BAR      = 1;
  PP_BARVERT  = 2;
  PP_CHUNK    = 3;
  PP_CHUNKVERT = 4;
  PP_FILL     = 5;
  PP_FILLVERT = 6;
  PP_PULSEOVERLAY = 7;
  PP_MOVEOVERLAY = 8;
  PP_PULSEOVERLAYVERT = 9;
  PP_MOVEOVERLAYVERT = 10;
  PP_TRANSPARENTBAR = 11;
  PP_TRANSPARENTBARVERT = 12;

type
  PROGRESSSTYLEPARTS = PROGRESSPARTS;

type
  TRANSPARENTBARSTATES = longint;

const
  PBBS_NORMAL  = 1;
  PBBS_PARTIAL = 2;


type
  TRANSPARENTBARVERTSTATES = longint;

const
  PBBVS_NORMAL  = 1;
  PBBVS_PARTIAL = 2;


type
  FILLSTATES = longint;

const
  PBFS_NORMAL  = 1;
  PBFS_ERROR   = 2;
  PBFS_PAUSED  = 3;
  PBFS_PARTIAL = 4;


type
  FILLVERTSTATES = longint;

const
  PBFVS_NORMAL  = 1;
  PBFVS_ERROR   = 2;
  PBFVS_PAUSED  = 3;
  PBFVS_PARTIAL = 4;


// REBARSTYLE class parts and states

  VSCLASS_REBARSTYLE = 'REBARSTYLE';
  VSCLASS_REBAR      = 'REBAR';

type
  REBARPARTS = longint;

const
  RP_GRIPPER  = 1;
  RP_GRIPPERVERT = 2;
  RP_BAND     = 3;
  RP_CHEVRON  = 4;
  RP_CHEVRONVERT = 5;
  RP_BACKGROUND = 6;
  RP_SPLITTER = 7;
  RP_SPLITTERVERT = 8;

type
  REBARSTYLEPARTS = REBARPARTS;

type
  CHEVRONSTATES = longint;

const
  CHEVS_NORMAL  = 1;
  CHEVS_HOT     = 2;
  CHEVS_PRESSED = 3;


type
  CHEVRONVERTSTATES = longint;

const
  CHEVSV_NORMAL  = 1;
  CHEVSV_HOT     = 2;
  CHEVSV_PRESSED = 3;


type
  SPLITTERSTATES = longint;

const
  SPLITS_NORMAL  = 1;
  SPLITS_HOT     = 2;
  SPLITS_PRESSED = 3;


type
  SPLITTERVERTSTATES = longint;

const
  SPLITSV_NORMAL  = 1;
  SPLITSV_HOT     = 2;
  SPLITSV_PRESSED = 3;


// SCROLLBARSTYLE class parts and states

  VSCLASS_SCROLLBARSTYLE = 'SCROLLBARSTYLE';
  VSCLASS_SCROLLBAR      = 'SCROLLBAR';

type
  SCROLLBARPARTS = longint;

const
  SBP_ARROWBTN     = 1;
  SBP_THUMBBTNHORZ = 2;
  SBP_THUMBBTNVERT = 3;
  SBP_LOWERTRACKHORZ = 4;
  SBP_UPPERTRACKHORZ = 5;
  SBP_LOWERTRACKVERT = 6;
  SBP_UPPERTRACKVERT = 7;
  SBP_GRIPPERHORZ  = 8;
  SBP_GRIPPERVERT  = 9;
  SBP_SIZEBOX      = 10;

type
  SCROLLBARSTYLEPARTS = SCROLLBARPARTS;

type
  ARROWBTNSTATES = longint;

const
  ABS_UPNORMAL   = 1;
  ABS_UPHOT      = 2;
  ABS_UPPRESSED  = 3;
  ABS_UPDISABLED = 4;
  ABS_DOWNNORMAL = 5;
  ABS_DOWNHOT    = 6;
  ABS_DOWNPRESSED = 7;
  ABS_DOWNDISABLED = 8;
  ABS_LEFTNORMAL = 9;
  ABS_LEFTHOT    = 10;
  ABS_LEFTPRESSED = 11;
  ABS_LEFTDISABLED = 12;
  ABS_RIGHTNORMAL = 13;
  ABS_RIGHTHOT   = 14;
  ABS_RIGHTPRESSED = 15;
  ABS_RIGHTDISABLED = 16;
  ABS_UPHOVER    = 17;
  ABS_DOWNHOVER  = 18;
  ABS_LEFTHOVER  = 19;
  ABS_RIGHTHOVER = 20;


type
  SCROLLBARSTYLESTATES = longint;

const
  SCRBS_NORMAL   = 1;
  SCRBS_HOT      = 2;
  SCRBS_PRESSED  = 3;
  SCRBS_DISABLED = 4;
  SCRBS_HOVER    = 5;


type
  SIZEBOXSTATES = longint;

const
  SZB_RIGHTALIGN    = 1;
  SZB_LEFTALIGN     = 2;
  SZB_TOPRIGHTALIGN = 3;
  SZB_TOPLEFTALIGN  = 4;
  SZB_HALFBOTTOMRIGHTALIGN = 5;
  SZB_HALFBOTTOMLEFTALIGN = 6;
  SZB_HALFTOPRIGHTALIGN = 7;
  SZB_HALFTOPLEFTALIGN = 8;


// SPINSTYLE class parts and states

  VSCLASS_SPINSTYLE = 'SPINSTYLE';
  VSCLASS_SPIN      = 'SPIN';

type
  SPINPARTS = longint;

const
  SPNP_UP     = 1;
  SPNP_DOWN   = 2;
  SPNP_UPHORZ = 3;
  SPNP_DOWNHORZ = 4;

type
  SPINSTYLEPARTS = SPINPARTS;

type
  UPSTATES = longint;

const
  UPS_NORMAL   = 1;
  UPS_HOT      = 2;
  UPS_PRESSED  = 3;
  UPS_DISABLED = 4;


type
  DOWNSTATES = longint;

const
  DNS_NORMAL   = 1;
  DNS_HOT      = 2;
  DNS_PRESSED  = 3;
  DNS_DISABLED = 4;


type
  UPHORZSTATES = longint;

const
  UPHZS_NORMAL   = 1;
  UPHZS_HOT      = 2;
  UPHZS_PRESSED  = 3;
  UPHZS_DISABLED = 4;


type
  DOWNHORZSTATES = longint;

const
  DNHZS_NORMAL   = 1;
  DNHZS_HOT      = 2;
  DNHZS_PRESSED  = 3;
  DNHZS_DISABLED = 4;


// STATUSSTYLE class parts and states

  VSCLASS_STATUSSTYLE = 'STATUSSTYLE';
  VSCLASS_STATUS      = 'STATUS';

type
  STATUSPARTS = longint;

const
  SP_PANE    = 1;
  SP_GRIPPERPANE = 2;
  SP_GRIPPER = 3;

type
  STATUSSTYLEPARTS = STATUSPARTS;

// TABSTYLE class parts and states
const
  VSCLASS_TABSTYLE = 'TABSTYLE';
  VSCLASS_TAB      = 'TAB';

type
  TABPARTS = longint;

const
  TABP_TABITEM = 1;
  TABP_TABITEMLEFTEDGE = 2;
  TABP_TABITEMRIGHTEDGE = 3;
  TABP_TABITEMBOTHEDGE = 4;
  TABP_TOPTABITEM = 5;
  TABP_TOPTABITEMLEFTEDGE = 6;
  TABP_TOPTABITEMRIGHTEDGE = 7;
  TABP_TOPTABITEMBOTHEDGE = 8;
  TABP_PANE = 9;
  TABP_BODY = 10;
  TABP_AEROWIZARDBODY = 11;

type
  TABSTYLEPARTS = TABPARTS;

type
  TABITEMSTATES = longint;

const
  TIS_NORMAL   = 1;
  TIS_HOT      = 2;
  TIS_SELECTED = 3;
  TIS_DISABLED = 4;
  TIS_FOCUSED  = 5;


type
  TABITEMLEFTEDGESTATES = longint;

const
  TILES_NORMAL   = 1;
  TILES_HOT      = 2;
  TILES_SELECTED = 3;
  TILES_DISABLED = 4;
  TILES_FOCUSED  = 5;


type
  TABITEMRIGHTEDGESTATES = longint;

const
  TIRES_NORMAL   = 1;
  TIRES_HOT      = 2;
  TIRES_SELECTED = 3;
  TIRES_DISABLED = 4;
  TIRES_FOCUSED  = 5;


type
  TABITEMBOTHEDGESTATES = longint;

const
  TIBES_NORMAL   = 1;
  TIBES_HOT      = 2;
  TIBES_SELECTED = 3;
  TIBES_DISABLED = 4;
  TIBES_FOCUSED  = 5;


type
  TOPTABITEMSTATES = longint;

const
  TTIS_NORMAL   = 1;
  TTIS_HOT      = 2;
  TTIS_SELECTED = 3;
  TTIS_DISABLED = 4;
  TTIS_FOCUSED  = 5;


type
  TOPTABITEMLEFTEDGESTATES = longint;

const
  TTILES_NORMAL   = 1;
  TTILES_HOT      = 2;
  TTILES_SELECTED = 3;
  TTILES_DISABLED = 4;
  TTILES_FOCUSED  = 5;


type
  TOPTABITEMRIGHTEDGESTATES = longint;

const
  TTIRES_NORMAL   = 1;
  TTIRES_HOT      = 2;
  TTIRES_SELECTED = 3;
  TTIRES_DISABLED = 4;
  TTIRES_FOCUSED  = 5;


type
  TOPTABITEMBOTHEDGESTATES = longint;

const
  TTIBES_NORMAL   = 1;
  TTIBES_HOT      = 2;
  TTIBES_SELECTED = 3;
  TTIBES_DISABLED = 4;
  TTIBES_FOCUSED  = 5;


// TASKDIALOGSTYLE class parts and states

  VSCLASS_TASKDIALOGSTYLE = 'TASKDIALOGSTYLE';
  VSCLASS_TASKDIALOG      = 'TASKDIALOG';

type
  TASKDIALOGPARTS = longint;

const
  TDLG_PRIMARYPANEL  = 1;
  TDLG_MAININSTRUCTIONPANE = 2;
  TDLG_MAINICON      = 3;
  TDLG_CONTENTPANE   = 4;
  TDLG_CONTENTICON   = 5;
  TDLG_EXPANDEDCONTENT = 6;
  TDLG_COMMANDLINKPANE = 7;
  TDLG_SECONDARYPANEL = 8;
  TDLG_CONTROLPANE   = 9;
  TDLG_BUTTONSECTION = 10;
  TDLG_BUTTONWRAPPER = 11;
  TDLG_EXPANDOTEXT   = 12;
  TDLG_EXPANDOBUTTON = 13;
  TDLG_VERIFICATIONTEXT = 14;
  TDLG_FOOTNOTEPANE  = 15;
  TDLG_FOOTNOTEAREA  = 16;
  TDLG_FOOTNOTESEPARATOR = 17;
  TDLG_EXPANDEDFOOTERAREA = 18;
  TDLG_PROGRESSBAR   = 19;
  TDLG_IMAGEALIGNMENT = 20;
  TDLG_RADIOBUTTONPANE = 21;

type
  TASKDIALOGSTYLEPARTS = TASKDIALOGPARTS;

type
  CONTENTPANESTATES = longint;

const
  TDLGCPS_STANDALONE = 1;


type
  EXPANDOBUTTONSTATES = longint;

const
  TDLGEBS_NORMAL  = 1;
  TDLGEBS_HOVER   = 2;
  TDLGEBS_PRESSED = 3;
  TDLGEBS_EXPANDEDNORMAL = 4;
  TDLGEBS_EXPANDEDHOVER = 5;
  TDLGEBS_EXPANDEDPRESSED = 6;


// TEXTSTYLE class parts and states

  VSCLASS_TEXTSTYLE = 'TEXTSTYLE';

type
  TEXTSTYLEPARTS = longint;

const
  TEXT_MAININSTRUCTION = 1;
  TEXT_INSTRUCTION = 2;
  TEXT_BODYTITLE = 3;
  TEXT_BODYTEXT = 4;
  TEXT_SECONDARYTEXT = 5;
  TEXT_HYPERLINKTEXT = 6;
  TEXT_EXPANDED = 7;
  TEXT_LABEL = 8;
  TEXT_CONTROLLABEL = 9;


type
  HYPERLINKTEXTSTATES = longint;

const
  TS_HYPERLINK_NORMAL   = 1;
  TS_HYPERLINK_HOT      = 2;
  TS_HYPERLINK_PRESSED  = 3;
  TS_HYPERLINK_DISABLED = 4;


type
  CONTROLLABELSTATES = longint;

const
  TS_CONTROLLABEL_NORMAL   = 1;
  TS_CONTROLLABEL_DISABLED = 2;


// TOOLBARSTYLE class parts and states

  VSCLASS_TOOLBARSTYLE = 'TOOLBARSTYLE';
  VSCLASS_TOOLBAR      = 'TOOLBAR';

type
  TOOLBARPARTS = longint;

const
  TP_BUTTON      = 1;
  TP_DROPDOWNBUTTON = 2;
  TP_SPLITBUTTON = 3;
  TP_SPLITBUTTONDROPDOWN = 4;
  TP_SEPARATOR   = 5;
  TP_SEPARATORVERT = 6;
  TP_DROPDOWNBUTTONGLYPH = 7;

type
  TOOLBARSTYLEPARTS = TOOLBARPARTS;

type
  TOOLBARSTYLESTATES = longint;

const
  TS_NORMAL   = 1;
  TS_HOT      = 2;
  TS_PRESSED  = 3;
  TS_DISABLED = 4;
  TS_CHECKED  = 5;
  TS_HOTCHECKED = 6;
  TS_NEARHOT  = 7;
  TS_OTHERSIDEHOT = 8;


// TOOLTIPSTYLE class parts and states

  VSCLASS_TOOLTIPSTYLE = 'TOOLTIPSTYLE';
  VSCLASS_TOOLTIP      = 'TOOLTIP';

type
  TOOLTIPPARTS = longint;

const
  TTP_STANDARD = 1;
  TTP_STANDARDTITLE = 2;
  TTP_BALLOON = 3;
  TTP_BALLOONTITLE = 4;
  TTP_CLOSE  = 5;
  TTP_BALLOONSTEM = 6;
  TTP_WRENCH = 7;

type
  TOOLTIPSTYLEPARTS = TOOLTIPPARTS;

type
  CLOSESTATES = longint;

const
  TTCS_NORMAL  = 1;
  TTCS_HOT     = 2;
  TTCS_PRESSED = 3;


type
  STANDARDSTATES = longint;

const
  TTSS_NORMAL = 1;
  TTSS_LINK   = 2;


type
  BALLOONSTATES = longint;

const
  TTBS_NORMAL = 1;
  TTBS_LINK   = 2;


type
  BALLOONSTEMSTATES = longint;

const
  TTBSS_POINTINGUPLEFTWALL    = 1;
  TTBSS_POINTINGUPCENTERED    = 2;
  TTBSS_POINTINGUPRIGHTWALL   = 3;
  TTBSS_POINTINGDOWNRIGHTWALL = 4;
  TTBSS_POINTINGDOWNCENTERED  = 5;
  TTBSS_POINTINGDOWNLEFTWALL  = 6;


type
  WRENCHSTATES = longint;

const
  TTWS_NORMAL  = 1;
  TTWS_HOT     = 2;
  TTWS_PRESSED = 3;


// TRACKBARSTYLE class parts and states

  VSCLASS_TRACKBARSTYLE = 'TRACKBARSTYLE';
  VSCLASS_TRACKBAR      = 'TRACKBAR';

type
  TRACKBARPARTS = longint;

const
  TKP_TRACK    = 1;
  TKP_TRACKVERT = 2;
  TKP_THUMB    = 3;
  TKP_THUMBBOTTOM = 4;
  TKP_THUMBTOP = 5;
  TKP_THUMBVERT = 6;
  TKP_THUMBLEFT = 7;
  TKP_THUMBRIGHT = 8;
  TKP_TICS     = 9;
  TKP_TICSVERT = 10;

type
  TRACKBARSTYLEPARTS = TRACKBARPARTS;

type
  TRACKBARSTYLESTATES = longint;

const
  TKS_NORMAL = 1;


type
  TRACKSTATES = longint;

const
  TRS_NORMAL = 1;


type
  TRACKVERTSTATES = longint;

const
  TRVS_NORMAL = 1;


type
  THUMBSTATES = longint;

const
  TUS_NORMAL   = 1;
  TUS_HOT      = 2;
  TUS_PRESSED  = 3;
  TUS_FOCUSED  = 4;
  TUS_DISABLED = 5;


type
  THUMBBOTTOMSTATES = longint;

const
  TUBS_NORMAL   = 1;
  TUBS_HOT      = 2;
  TUBS_PRESSED  = 3;
  TUBS_FOCUSED  = 4;
  TUBS_DISABLED = 5;


type
  THUMBTOPSTATES = longint;

const
  TUTS_NORMAL   = 1;
  TUTS_HOT      = 2;
  TUTS_PRESSED  = 3;
  TUTS_FOCUSED  = 4;
  TUTS_DISABLED = 5;


type
  THUMBVERTSTATES = longint;

const
  TUVS_NORMAL   = 1;
  TUVS_HOT      = 2;
  TUVS_PRESSED  = 3;
  TUVS_FOCUSED  = 4;
  TUVS_DISABLED = 5;


type
  THUMBLEFTSTATES = longint;

const
  TUVLS_NORMAL   = 1;
  TUVLS_HOT      = 2;
  TUVLS_PRESSED  = 3;
  TUVLS_FOCUSED  = 4;
  TUVLS_DISABLED = 5;


type
  THUMBRIGHTSTATES = longint;

const
  TUVRS_NORMAL   = 1;
  TUVRS_HOT      = 2;
  TUVRS_PRESSED  = 3;
  TUVRS_FOCUSED  = 4;
  TUVRS_DISABLED = 5;


type
  TICSSTATES = longint;

const
  TSS_NORMAL = 1;


type
  TICSVERTSTATES = longint;

const
  TSVS_NORMAL = 1;


// TREEVIEWSTYLE class parts and states

  VSCLASS_TREEVIEWSTYLE = 'TREEVIEWSTYLE';
  VSCLASS_TREEVIEW      = 'TREEVIEW';

type
  TREEVIEWPARTS = longint;

const
  TVP_TREEITEM = 1;
  TVP_GLYPH    = 2;
  TVP_BRANCH   = 3;
  TVP_HOTGLYPH = 4;

type
  TREEVIEWSTYLEPARTS = TREEVIEWPARTS;

type
  TREEITEMSTATES = longint;

const
  TREIS_NORMAL   = 1;
  TREIS_HOT      = 2;
  TREIS_SELECTED = 3;
  TREIS_DISABLED = 4;
  TREIS_SELECTEDNOTFOCUS = 5;
  TREIS_HOTSELECTED = 6;


type
  GLYPHSTATES = longint;

const
  GLPS_CLOSED = 1;
  GLPS_OPENED = 2;


type
  HOTGLYPHSTATES = longint;

const
  HGLPS_CLOSED = 1;
  HGLPS_OPENED = 2;


// WINDOWSTYLE class parts and states

  VSCLASS_WINDOWSTYLE = 'WINDOWSTYLE';
  VSCLASS_WINDOW      = 'WINDOW';

type
  WINDOWPARTS = longint;

const
  WP_CAPTION = 1;
  WP_SMALLCAPTION = 2;
  WP_MINCAPTION = 3;
  WP_SMALLMINCAPTION = 4;
  WP_MAXCAPTION = 5;
  WP_SMALLMAXCAPTION = 6;
  WP_FRAMELEFT = 7;
  WP_FRAMERIGHT = 8;
  WP_FRAMEBOTTOM = 9;
  WP_SMALLFRAMELEFT = 10;
  WP_SMALLFRAMERIGHT = 11;
  WP_SMALLFRAMEBOTTOM = 12;
  WP_SYSBUTTON = 13;
  WP_MDISYSBUTTON = 14;
  WP_MINBUTTON = 15;
  WP_MDIMINBUTTON = 16;
  WP_MAXBUTTON = 17;
  WP_CLOSEBUTTON = 18;
  WP_SMALLCLOSEBUTTON = 19;
  WP_MDICLOSEBUTTON = 20;
  WP_RESTOREBUTTON = 21;
  WP_MDIRESTOREBUTTON = 22;
  WP_HELPBUTTON = 23;
  WP_MDIHELPBUTTON = 24;
  WP_HORZSCROLL = 25;
  WP_HORZTHUMB = 26;
  WP_VERTSCROLL = 27;
  WP_VERTTHUMB = 28;
  WP_DIALOG = 29;
  WP_CAPTIONSIZINGTEMPLATE = 30;
  WP_SMALLCAPTIONSIZINGTEMPLATE = 31;
  WP_FRAMELEFTSIZINGTEMPLATE = 32;
  WP_SMALLFRAMELEFTSIZINGTEMPLATE = 33;
  WP_FRAMERIGHTSIZINGTEMPLATE = 34;
  WP_SMALLFRAMERIGHTSIZINGTEMPLATE = 35;
  WP_FRAMEBOTTOMSIZINGTEMPLATE = 36;
  WP_SMALLFRAMEBOTTOMSIZINGTEMPLATE = 37;
  WP_FRAME  = 38;

type
  WINDOWSTYLEPARTS = WINDOWPARTS;

type
  FRAMESTATES = longint;

const
  FS_ACTIVE   = 1;
  FS_INACTIVE = 2;


type
  CAPTIONSTATES = longint;

const
  CS_ACTIVE   = 1;
  CS_INACTIVE = 2;
  CS_DISABLED = 3;


type
  MAXCAPTIONSTATES = longint;

const
  MXCS_ACTIVE   = 1;
  MXCS_INACTIVE = 2;
  MXCS_DISABLED = 3;


type
  MINCAPTIONSTATES = longint;

const
  MNCS_ACTIVE   = 1;
  MNCS_INACTIVE = 2;
  MNCS_DISABLED = 3;


type
  HORZSCROLLSTATES = longint;

const
  HSS_NORMAL   = 1;
  HSS_HOT      = 2;
  HSS_PUSHED   = 3;
  HSS_DISABLED = 4;


type
  HORZTHUMBSTATES = longint;

const
  HTS_NORMAL   = 1;
  HTS_HOT      = 2;
  HTS_PUSHED   = 3;
  HTS_DISABLED = 4;


type
  VERTSCROLLSTATES = longint;

const
  VSS_NORMAL   = 1;
  VSS_HOT      = 2;
  VSS_PUSHED   = 3;
  VSS_DISABLED = 4;


type
  VERTTHUMBSTATES = longint;

const
  VTS_NORMAL   = 1;
  VTS_HOT      = 2;
  VTS_PUSHED   = 3;
  VTS_DISABLED = 4;


type
  SYSBUTTONSTATES = longint;

const
  SBS_NORMAL   = 1;
  SBS_HOT      = 2;
  SBS_PUSHED   = 3;
  SBS_DISABLED = 4;


type
  MINBUTTONSTATES = longint;

const
  MINBS_NORMAL   = 1;
  MINBS_HOT      = 2;
  MINBS_PUSHED   = 3;
  MINBS_DISABLED = 4;


type
  MAXBUTTONSTATES = longint;

const
  MAXBS_NORMAL   = 1;
  MAXBS_HOT      = 2;
  MAXBS_PUSHED   = 3;
  MAXBS_DISABLED = 4;


type
  RESTOREBUTTONSTATES = longint;

const
  RBS_NORMAL   = 1;
  RBS_HOT      = 2;
  RBS_PUSHED   = 3;
  RBS_DISABLED = 4;


type
  HELPBUTTONSTATES = longint;

const
  HBS_NORMAL   = 1;
  HBS_HOT      = 2;
  HBS_PUSHED   = 3;
  HBS_DISABLED = 4;


type
  CLOSEBUTTONSTATES = longint;

const
  CBS_NORMAL   = 1;
  CBS_HOT      = 2;
  CBS_PUSHED   = 3;
  CBS_DISABLED = 4;

{-------------------------------------------------------------------------// }
{  VisualStyle Core Win32/ComCtl32 symbols                                   }
{-------------------------------------------------------------------------// }

// include above

// enumerated property values


type
  BGTYPE = longint;

const
  BT_IMAGEFILE = 0;
  BT_BORDERFILL = 1;
  BT_NONE = 2;

// enumerated property values


type
  IMAGELAYOUT = longint;

const
  IL_VERTICAL   = 0;
  IL_HORIZONTAL = 1;

//  enumerated property values


type
  BORDERTYPE = longint;

const
  BT_RECT      = 0;
  BT_ROUNDRECT = 1;
  BT_ELLIPSE   = 2;

// enumerated property values


type
  FILLTYPE = longint;

const
  FT_SOLID     = 0;
  FT_VERTGRADIENT = 1;
  FT_HORZGRADIENT = 2;
  FT_RADIALGRADIENT = 3;
  FT_TILEIMAGE = 4;


// enumerated property values


type
  SIZINGTYPE = longint;

const
  ST_TRUESIZE = 0;
  ST_STRETCH  = 1;
  ST_TILE     = 2;


// enumerated property values


type
  HALIGN = longint;

const
  HA_LEFT   = 0;
  HA_CENTER = 1;
  HA_RIGHT  = 2;


// enumerated property values


type
  CONTENTALIGNMENT = longint;

const
  CA_LEFT   = 0;
  CA_CENTER = 1;
  CA_RIGHT  = 2;


// enumerated property values


type
  VALIGN = longint;

const
  VA_TOP    = 0;
  VA_CENTER = 1;
  VA_BOTTOM = 2;


// enumerated property values


type
  OFFSETTYPE = longint;

const
  OT_TOPLEFT      = 0;
  OT_TOPRIGHT     = 1;
  OT_TOPMIDDLE    = 2;
  OT_BOTTOMLEFT   = 3;
  OT_BOTTOMRIGHT  = 4;
  OT_BOTTOMMIDDLE = 5;
  OT_MIDDLELEFT   = 6;
  OT_MIDDLERIGHT  = 7;
  OT_LEFTOFCAPTION = 8;
  OT_RIGHTOFCAPTION = 9;
  OT_LEFTOFLASTBUTTON = 10;
  OT_RIGHTOFLASTBUTTON = 11;
  OT_ABOVELASTBUTTON = 12;
  OT_BELOWLASTBUTTON = 13;


// enumerated property values


type
  ICONEFFECT = longint;

const
  ICE_NONE   = 0;
  ICE_GLOW   = 1;
  ICE_SHADOW = 2;
  ICE_PULSE  = 3;
  ICE_ALPHA  = 4;


// enumerated property values


type
  TEXTSHADOWTYPE = longint;

const
  TST_NONE   = 0;
  TST_SINGLE = 1;
  TST_CONTINUOUS = 2;


// enumerated property values


type
  GLYPHTYPE = longint;

const
  GT_NONE      = 0;
  GT_IMAGEGLYPH = 1;
  GT_FONTGLYPH = 2;


// enumerated property values


type
  IMAGESELECTTYPE = longint;

const
  IST_NONE = 0;
  IST_SIZE = 1;
  IST_DPI  = 2;


// enumerated property values


type
  TRUESIZESCALINGTYPE = longint;

const
  TSST_NONE = 0;
  TSST_SIZE = 1;
  TSST_DPI  = 2;


// enumerated property values


type
  GLYPHFONTSIZINGTYPE = longint;

const
  GFST_NONE = 0;
  GFST_SIZE = 1;
  GFST_DPI  = 2;


// property symbol definitions

  TMT_RESERVEDLOW = 0;
  TMT_RESERVEDHIGH = 7999;
  TMT_DIBDATA  = 2;
  TMT_GLYPHDIBDATA = 8;
  TMT_ENUM     = 200;
  TMT_STRING   = 201;
  TMT_INT      = 202;
  TMT_BOOL     = 203;
  TMT_COLOR    = 204;
  TMT_MARGINS  = 205;
  TMT_FILENAME = 206;
  TMT_SIZE     = 207;
  TMT_POSITION = 208;
  TMT_RECT     = 209;
  TMT_FONT     = 210;
  TMT_INTLIST  = 211;
  TMT_HBITMAP  = 212;
  TMT_DISKSTREAM = 213;
  TMT_STREAM   = 214;
  TMT_BITMAPREF = 215;
  TMT_COLORSCHEMES = 401;
  TMT_SIZES    = 402;
  TMT_CHARSET  = 403;
  TMT_NAME     = 600;
  TMT_DISPLAYNAME = 601;
  TMT_TOOLTIP  = 602;
  TMT_COMPANY  = 603;
  TMT_AUTHOR   = 604;
  TMT_COPYRIGHT = 605;
  TMT_URL      = 606;
  TMT_VERSION  = 607;
  TMT_DESCRIPTION = 608;
  TMT_FIRST_RCSTRING_NAME = TMT_DISPLAYNAME;
  TMT_LAST_RCSTRING_NAME = TMT_DESCRIPTION;
  TMT_CAPTIONFONT = 801;
  TMT_SMALLCAPTIONFONT = 802;
  TMT_MENUFONT = 803;
  TMT_STATUSFONT = 804;
  TMT_MSGBOXFONT = 805;
  TMT_ICONTITLEFONT = 806;
  TMT_HEADING1FONT = 807;
  TMT_HEADING2FONT = 808;
  TMT_BODYFONT = 809;
  TMT_FIRSTFONT = TMT_CAPTIONFONT;
  TMT_LASTFONT = TMT_BODYFONT;
  TMT_FLATMENUS = 1001;
  TMT_FIRSTBOOL = TMT_FLATMENUS;
  TMT_LASTBOOL = TMT_FLATMENUS;
  TMT_SIZINGBORDERWIDTH = 1201;
  TMT_SCROLLBARWIDTH = 1202;
  TMT_SCROLLBARHEIGHT = 1203;
  TMT_CAPTIONBARWIDTH = 1204;
  TMT_CAPTIONBARHEIGHT = 1205;
  TMT_SMCAPTIONBARWIDTH = 1206;
  TMT_SMCAPTIONBARHEIGHT = 1207;
  TMT_MENUBARWIDTH = 1208;
  TMT_MENUBARHEIGHT = 1209;
  TMT_PADDEDBORDERWIDTH = 1210;
  TMT_FIRSTSIZE = TMT_SIZINGBORDERWIDTH;
  TMT_LASTSIZE = TMT_PADDEDBORDERWIDTH;
  TMT_MINCOLORDEPTH = 1301;
  TMT_FIRSTINT = TMT_MINCOLORDEPTH;
  TMT_LASTINT  = TMT_MINCOLORDEPTH;
  TMT_CSSNAME  = 1401;
  TMT_XMLNAME  = 1402;
  TMT_LASTUPDATED = 1403;
  TMT_ALIAS    = 1404;
  TMT_FIRSTSTRING = TMT_CSSNAME;
  TMT_LASTSTRING = TMT_ALIAS;
  TMT_SCROLLBAR = 1601;
  TMT_BACKGROUND = 1602;
  TMT_ACTIVECAPTION = 1603;
  TMT_INACTIVECAPTION = 1604;
  TMT_MENU     = 1605;
  TMT_WINDOW   = 1606;
  TMT_WINDOWFRAME = 1607;
  TMT_MENUTEXT = 1608;
  TMT_WINDOWTEXT = 1609;
  TMT_CAPTIONTEXT = 1610;
  TMT_ACTIVEBORDER = 1611;
  TMT_INACTIVEBORDER = 1612;
  TMT_APPWORKSPACE = 1613;
  TMT_HIGHLIGHT = 1614;
  TMT_HIGHLIGHTTEXT = 1615;
  TMT_BTNFACE  = 1616;
  TMT_BTNSHADOW = 1617;
  TMT_GRAYTEXT = 1618;
  TMT_BTNTEXT  = 1619;
  TMT_INACTIVECAPTIONTEXT = 1620;
  TMT_BTNHIGHLIGHT = 1621;
  TMT_DKSHADOW3D = 1622;
  TMT_LIGHT3D  = 1623;
  TMT_INFOTEXT = 1624;
  TMT_INFOBK   = 1625;
  TMT_BUTTONALTERNATEFACE = 1626;
  TMT_HOTTRACKING = 1627;
  TMT_GRADIENTACTIVECAPTION = 1628;
  TMT_GRADIENTINACTIVECAPTION = 1629;
  TMT_MENUHILIGHT = 1630;
  TMT_MENUBAR  = 1631;
  TMT_FIRSTCOLOR = TMT_SCROLLBAR;
  TMT_LASTCOLOR = TMT_MENUBAR;
  TMT_FROMHUE1 = 1801;
  TMT_FROMHUE2 = 1802;
  TMT_FROMHUE3 = 1803;
  TMT_FROMHUE4 = 1804;
  TMT_FROMHUE5 = 1805;
  TMT_TOHUE1   = 1806;
  TMT_TOHUE2   = 1807;
  TMT_TOHUE3   = 1808;
  TMT_TOHUE4   = 1809;
  TMT_TOHUE5   = 1810;
  TMT_FROMCOLOR1 = 2001;
  TMT_FROMCOLOR2 = 2002;
  TMT_FROMCOLOR3 = 2003;
  TMT_FROMCOLOR4 = 2004;
  TMT_FROMCOLOR5 = 2005;
  TMT_TOCOLOR1 = 2006;
  TMT_TOCOLOR2 = 2007;
  TMT_TOCOLOR3 = 2008;
  TMT_TOCOLOR4 = 2009;
  TMT_TOCOLOR5 = 2010;
  TMT_TRANSPARENT = 2201;
  TMT_AUTOSIZE = 2202;
  TMT_BORDERONLY = 2203;
  TMT_COMPOSITED = 2204;
  TMT_BGFILL   = 2205;
  TMT_GLYPHTRANSPARENT = 2206;
  TMT_GLYPHONLY = 2207;
  TMT_ALWAYSSHOWSIZINGBAR = 2208;
  TMT_MIRRORIMAGE = 2209;
  TMT_UNIFORMSIZING = 2210;
  TMT_INTEGRALSIZING = 2211;
  TMT_SOURCEGROW = 2212;
  TMT_SOURCESHRINK = 2213;
  TMT_DRAWBORDERS = 2214;
  TMT_NOETCHEDEFFECT = 2215;
  TMT_TEXTAPPLYOVERLAY = 2216;
  TMT_TEXTGLOW = 2217;
  TMT_TEXTITALIC = 2218;
  TMT_COMPOSITEDOPAQUE = 2219;
  TMT_LOCALIZEDMIRRORIMAGE = 2220;
  TMT_IMAGECOUNT = 2401;
  TMT_ALPHALEVEL = 2402;
  TMT_BORDERSIZE = 2403;
  TMT_ROUNDCORNERWIDTH = 2404;
  TMT_ROUNDCORNERHEIGHT = 2405;
  TMT_GRADIENTRATIO1 = 2406;
  TMT_GRADIENTRATIO2 = 2407;
  TMT_GRADIENTRATIO3 = 2408;
  TMT_GRADIENTRATIO4 = 2409;
  TMT_GRADIENTRATIO5 = 2410;
  TMT_PROGRESSCHUNKSIZE = 2411;
  TMT_PROGRESSSPACESIZE = 2412;
  TMT_SATURATION = 2413;
  TMT_TEXTBORDERSIZE = 2414;
  TMT_ALPHATHRESHOLD = 2415;
  TMT_WIDTH    = 2416;
  TMT_HEIGHT   = 2417;
  TMT_GLYPHINDEX = 2418;
  TMT_TRUESIZESTRETCHMARK = 2419;
  TMT_MINDPI1  = 2420;
  TMT_MINDPI2  = 2421;
  TMT_MINDPI3  = 2422;
  TMT_MINDPI4  = 2423;
  TMT_MINDPI5  = 2424;
  TMT_TEXTGLOWSIZE = 2425;
  TMT_FRAMESPERSECOND = 2426;
  TMT_PIXELSPERFRAME = 2427;
  TMT_ANIMATIONDELAY = 2428;
  TMT_GLOWINTENSITY = 2429;
  TMT_OPACITY  = 2430;
  TMT_COLORIZATIONCOLOR = 2431;
  TMT_COLORIZATIONOPACITY = 2432;
  TMT_GLYPHFONT = 2601;
  TMT_IMAGEFILE = 3001;
  TMT_IMAGEFILE1 = 3002;
  TMT_IMAGEFILE2 = 3003;
  TMT_IMAGEFILE3 = 3004;
  TMT_IMAGEFILE4 = 3005;
  TMT_IMAGEFILE5 = 3006;
  TMT_GLYPHIMAGEFILE = 3008;
  TMT_TEXT     = 3201;
  TMT_CLASSICVALUE = 3202;
  TMT_OFFSET   = 3401;
  TMT_TEXTSHADOWOFFSET = 3402;
  TMT_MINSIZE  = 3403;
  TMT_MINSIZE1 = 3404;
  TMT_MINSIZE2 = 3405;
  TMT_MINSIZE3 = 3406;
  TMT_MINSIZE4 = 3407;
  TMT_MINSIZE5 = 3408;
  TMT_NORMALSIZE = 3409;
  TMT_SIZINGMARGINS = 3601;
  TMT_CONTENTMARGINS = 3602;
  TMT_CAPTIONMARGINS = 3603;
  TMT_BORDERCOLOR = 3801;
  TMT_FILLCOLOR = 3802;
  TMT_TEXTCOLOR = 3803;
  TMT_EDGELIGHTCOLOR = 3804;
  TMT_EDGEHIGHLIGHTCOLOR = 3805;
  TMT_EDGESHADOWCOLOR = 3806;
  TMT_EDGEDKSHADOWCOLOR = 3807;
  TMT_EDGEFILLCOLOR = 3808;
  TMT_TRANSPARENTCOLOR = 3809;
  TMT_GRADIENTCOLOR1 = 3810;
  TMT_GRADIENTCOLOR2 = 3811;
  TMT_GRADIENTCOLOR3 = 3812;
  TMT_GRADIENTCOLOR4 = 3813;
  TMT_GRADIENTCOLOR5 = 3814;
  TMT_SHADOWCOLOR = 3815;
  TMT_GLOWCOLOR = 3816;
  TMT_TEXTBORDERCOLOR = 3817;
  TMT_TEXTSHADOWCOLOR = 3818;
  TMT_GLYPHTEXTCOLOR = 3819;
  TMT_GLYPHTRANSPARENTCOLOR = 3820;
  TMT_FILLCOLORHINT = 3821;
  TMT_BORDERCOLORHINT = 3822;
  TMT_ACCENTCOLORHINT = 3823;
  TMT_TEXTCOLORHINT = 3824;
  TMT_HEADING1TEXTCOLOR = 3825;
  TMT_HEADING2TEXTCOLOR = 3826;
  TMT_BODYTEXTCOLOR = 3827;
  TMT_BGTYPE   = 4001;
  TMT_BORDERTYPE = 4002;
  TMT_FILLTYPE = 4003;
  TMT_SIZINGTYPE = 4004;
  TMT_HALIGN   = 4005;
  TMT_CONTENTALIGNMENT = 4006;
  TMT_VALIGN   = 4007;
  TMT_OFFSETTYPE = 4008;
  TMT_ICONEFFECT = 4009;
  TMT_TEXTSHADOWTYPE = 4010;
  TMT_IMAGELAYOUT = 4011;
  TMT_GLYPHTYPE = 4012;
  TMT_IMAGESELECTTYPE = 4013;
  TMT_GLYPHFONTSIZINGTYPE = 4014;
  TMT_TRUESIZESCALINGTYPE = 4015;
  TMT_USERPICTURE = 5001;
  TMT_DEFAULTPANESIZE = 5002;
  TMT_BLENDCOLOR = 5003;
  TMT_CUSTOMSPLITRECT = 5004;
  TMT_ANIMATIONBUTTONRECT = 5005;
  TMT_ANIMATIONDURATION = 5006;
  TMT_TRANSITIONDURATIONS = 6000;
  TMT_SCALEDBACKGROUND = 7001;
  TMT_ATLASIMAGE = 8000;
  TMT_ATLASINPUTIMAGE = 8001;
  TMT_ATLASRECT = 8002;

// LINK class parts and states

  VSCLASS_LINK = 'LINK';

type
  LINKPARTS = longint;

const
  LP_HYPERLINK = 1;


type
  HYPERLINKSTATES = longint;

const
  HLS_NORMALTEXT = 1;
  HLS_LINKTEXT   = 2;


// EMPTYMARKUP class parts and states

  VSCLASS_EMPTYMARKUP = 'EMPTYMARKUP';

type
  EMPTYMARKUPPARTS = longint;

const
  EMP_MARKUPTEXT = 1;


type
  MARKUPTEXTSTATES = longint;

const
  EMT_NORMALTEXT = 1;
  EMT_LINKTEXT   = 2;


// STATIC class parts and states

  VSCLASS_STATIC = 'STATIC';

type
  STATICPARTS = longint;

const
  STAT_TEXT = 1;


// PAGE class parts and states

  VSCLASS_PAGE = 'PAGE';

type
  PAGEPARTS = longint;

const
  PGRP_UP     = 1;
  PGRP_DOWN   = 2;
  PGRP_UPHORZ = 3;
  PGRP_DOWNHORZ = 4;


// MONTHCAL class parts and states

  VSCLASS_MONTHCAL = 'MONTHCAL';

type
  MONTHCALPARTS = longint;

const
  MC_BACKGROUND = 1;
  MC_BORDERS    = 2;
  MC_GRIDBACKGROUND = 3;
  MC_COLHEADERSPLITTER = 4;
  MC_GRIDCELLBACKGROUND = 5;
  MC_GRIDCELL   = 6;
  MC_GRIDCELLUPPER = 7;
  MC_TRAILINGGRIDCELL = 8;
  MC_TRAILINGGRIDCELLUPPER = 9;
  MC_NAVNEXT    = 10;
  MC_NAVPREV    = 11;


type
  GRIDCELLBACKGROUNDSTATES = longint;

const
  MCGCB_SELECTED = 1;
  MCGCB_HOT      = 2;
  MCGCB_SELECTEDHOT = 3;
  MCGCB_SELECTEDNOTFOCUSED = 4;
  MCGCB_TODAY    = 5;


type
  GRIDCELLSTATES = longint;

const
  MCGC_HOT      = 1;
  MCGC_HASSTATE = 2;
  MCGC_HASSTATEHOT = 3;
  MCGC_TODAY    = 4;


type
  GRIDCELLUPPERSTATES = longint;

const
  MCGCU_HOT      = 1;
  MCGCU_HASSTATE = 2;
  MCGCU_HASSTATEHOT = 3;


type
  TRAILINGGRIDCELLSTATES = longint;

const
  MCTGC_HOT      = 1;
  MCTGC_HASSTATE = 2;
  MCTGC_HASSTATEHOT = 3;
  MCTGC_TODAY    = 4;


type
  TRAILINGGRIDCELLUPPERSTATES = longint;

const
  MCTGCU_HOT      = 1;
  MCTGCU_HASSTATE = 2;
  MCTGCU_HASSTATEHOT = 3;


type
  NAVNEXTSTATES = longint;

const
  MCNN_NORMAL   = 1;
  MCNN_HOT      = 2;
  MCNN_PRESSED  = 3;
  MCNN_DISABLED = 4;


type
  NAVPREVSTATES = longint;

const
  MCNP_NORMAL   = 1;
  MCNP_HOT      = 2;
  MCNP_PRESSED  = 3;
  MCNP_DISABLED = 4;


// CLOCK class parts and states

  VSCLASS_CLOCK = 'CLOCK';

type
  CLOCKPARTS = longint;

const
  CLP_TIME = 1;


type
  CLOCKSTATES = longint;

const
  CLS_NORMAL  = 1;
  CLS_HOT     = 2;
  CLS_PRESSED = 3;


// TRAYNOTIFY class parts and states

  VSCLASS_TRAYNOTIFY = 'TRAYNOTIFY';

type
  TRAYNOTIFYPARTS = longint;

const
  TNP_BACKGROUND     = 1;
  TNP_ANIMBACKGROUND = 2;


// TASKBAR class parts and states

  VSCLASS_TASKBAR = 'TASKBAR';

type
  TASKBARPARTS = longint;

const
  TBP_BACKGROUNDBOTTOM = 1;
  TBP_BACKGROUNDRIGHT  = 2;
  TBP_BACKGROUNDTOP    = 3;
  TBP_BACKGROUNDLEFT   = 4;
  TBP_SIZINGBARBOTTOM  = 5;
  TBP_SIZINGBARRIGHT   = 6;
  TBP_SIZINGBARTOP     = 7;
  TBP_SIZINGBARLEFT    = 8;


// TASKBAND class parts and states

  VSCLASS_TASKBAND = 'TASKBAND';

type
  TASKBANDPARTS = longint;

const
  TDP_GROUPCOUNT  = 1;
  TDP_FLASHBUTTON = 2;
  TDP_FLASHBUTTONGROUPMENU = 3;


// STARTPANEL class parts and states

  VSCLASS_STARTPANEL = 'STARTPANEL';

type
  STARTPANELPARTS = longint;

const
  SPP_USERPANE    = 1;
  SPP_MOREPROGRAMS = 2;
  SPP_MOREPROGRAMSARROW = 3;
  SPP_PROGLIST    = 4;
  SPP_PROGLISTSEPARATOR = 5;
  SPP_PLACESLIST  = 6;
  SPP_PLACESLISTSEPARATOR = 7;
  SPP_LOGOFF      = 8;
  SPP_LOGOFFBUTTONS = 9;
  SPP_USERPICTURE = 10;
  SPP_PREVIEW     = 11;
  SPP_MOREPROGRAMSTAB = 12;
  SPP_NSCHOST     = 13;
  SPP_SOFTWAREEXPLORER = 14;
  SPP_OPENBOX     = 15;
  SPP_SEARCHVIEW  = 16;
  SPP_MOREPROGRAMSARROWBACK = 17;
  SPP_TOPMATCH    = 18;
  SPP_LOGOFFSPLITBUTTONDROPDOWN = 19;


type
  MOREPROGRAMSTABSTATES = longint;

const
  SPMPT_NORMAL   = 1;
  SPMPT_HOT      = 2;
  SPMPT_SELECTED = 3;
  SPMPT_DISABLED = 4;
  SPMPT_FOCUSED  = 5;


type
  SOFTWAREEXPLORERSTATES = longint;

const
  SPSE_NORMAL   = 1;
  SPSE_HOT      = 2;
  SPSE_SELECTED = 3;
  SPSE_DISABLED = 4;
  SPSE_FOCUSED  = 5;


type
  OPENBOXSTATES = longint;

const
  SPOB_NORMAL   = 1;
  SPOB_HOT      = 2;
  SPOB_SELECTED = 3;
  SPOB_DISABLED = 4;
  SPOB_FOCUSED  = 5;


type
  MOREPROGRAMSARROWSTATES = longint;

const
  SPS_NORMAL  = 1;
  SPS_HOT     = 2;
  SPS_PRESSED = 3;


type
  MOREPROGRAMSARROWBACKSTATES = longint;

const
  SPSB_NORMAL  = 1;
  SPSB_HOT     = 2;
  SPSB_PRESSED = 3;


type
  LOGOFFBUTTONSSTATES = longint;

const
  SPLS_NORMAL  = 1;
  SPLS_HOT     = 2;
  SPLS_PRESSED = 3;


// MENUBAND class parts and states

  VSCLASS_MENUBAND = 'MENUBAND';

type
  MENUBANDPARTS = longint;

const
  MDP_NEWAPPBUTTON = 1;
  MDP_SEPERATOR    = 2;


type
  MENUBANDSTATES = longint;

const
  MDS_NORMAL   = 1;
  MDS_HOT      = 2;
  MDS_PRESSED  = 3;
  MDS_DISABLED = 4;
  MDS_CHECKED  = 5;
  MDS_HOTCHECKED = 6;
