/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.networking;

import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Role;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.networking.AttributeMessage;
import net.sf.freecol.common.networking.ChangeSet;
import net.sf.freecol.common.networking.Message;
import net.sf.freecol.server.FreeColServer;
import net.sf.freecol.server.model.ServerGame;
import net.sf.freecol.server.model.ServerPlayer;

public class EquipForRoleMessage
extends AttributeMessage {
    public static final String TAG = "equipForRole";
    private static final String COUNT_TAG = "count";
    private static final String ROLE_TAG = "role";
    private static final String UNIT_TAG = "unit";

    public EquipForRoleMessage(Unit unit, Role role, int roleCount) {
        super(TAG, UNIT_TAG, unit.getId(), ROLE_TAG, role.getId(), COUNT_TAG, String.valueOf(roleCount));
    }

    public EquipForRoleMessage(Game game, FreeColXMLReader xr) throws XMLStreamException {
        super(TAG, xr, UNIT_TAG, ROLE_TAG, COUNT_TAG);
    }

    @Override
    public boolean currentPlayerMessage() {
        return true;
    }

    @Override
    public Message.MessagePriority getPriority() {
        return Message.MessagePriority.NORMAL;
    }

    @Override
    public ChangeSet serverHandler(FreeColServer freeColServer, ServerPlayer serverPlayer) {
        int count;
        Role role;
        Unit unit;
        ServerGame game = freeColServer.getGame();
        String unitId = this.getStringAttribute(UNIT_TAG);
        String roleId = this.getStringAttribute(ROLE_TAG);
        String countString = this.getStringAttribute(COUNT_TAG);
        try {
            unit = serverPlayer.getOurFreeColGameObject(unitId, Unit.class);
        }
        catch (Exception e) {
            return serverPlayer.clientError(e.getMessage());
        }
        if (!unit.isInEurope()) {
            if (!unit.hasTile()) {
                return serverPlayer.clientError("Unit is not on the map: " + unitId);
            }
            if (unit.getSettlement() == null) {
                return serverPlayer.clientError("Unit is not in a settlement: " + unitId);
            }
        }
        if ((role = game.getSpecification().getRole(roleId)) == null) {
            return serverPlayer.clientError("Not a role: " + roleId);
        }
        try {
            count = Integer.parseInt(countString);
        }
        catch (NumberFormatException nfe) {
            return serverPlayer.clientError("Role count is not an integer: " + countString);
        }
        if (count < 0 || count > role.getMaximumCount()) {
            return serverPlayer.clientError("Invalid role count: " + countString);
        }
        return this.igc(freeColServer).equipForRole(serverPlayer, unit, role, count);
    }
}

