/* application.c generated by valac 0.56.3, the Vala compiler
 * generated from application.vala, do not modify */

/* application.vala
 *
 * Copyright (C) Red Hat, Inc
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Author: Felipe Borges <felipeborges@gnome.org>
 *
 */

#include <gtk/gtk.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include "config.h"
#include <handy.h>
#include <gdk-pixbuf/gdk-pixbuf.h>

#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define CONNECTIONS_TYPE_APPLICATION (connections_application_get_type ())
#define CONNECTIONS_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONNECTIONS_TYPE_APPLICATION, ConnectionsApplication))
#define CONNECTIONS_APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONNECTIONS_TYPE_APPLICATION, ConnectionsApplicationClass))
#define CONNECTIONS_IS_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONNECTIONS_TYPE_APPLICATION))
#define CONNECTIONS_IS_APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONNECTIONS_TYPE_APPLICATION))
#define CONNECTIONS_APPLICATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONNECTIONS_TYPE_APPLICATION, ConnectionsApplicationClass))

typedef struct _ConnectionsApplication ConnectionsApplication;
typedef struct _ConnectionsApplicationClass ConnectionsApplicationClass;
typedef struct _ConnectionsApplicationPrivate ConnectionsApplicationPrivate;

#define CONNECTIONS_TYPE_WINDOW (connections_window_get_type ())
#define CONNECTIONS_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONNECTIONS_TYPE_WINDOW, ConnectionsWindow))
#define CONNECTIONS_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONNECTIONS_TYPE_WINDOW, ConnectionsWindowClass))
#define CONNECTIONS_IS_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONNECTIONS_TYPE_WINDOW))
#define CONNECTIONS_IS_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONNECTIONS_TYPE_WINDOW))
#define CONNECTIONS_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONNECTIONS_TYPE_WINDOW, ConnectionsWindowClass))

typedef struct _ConnectionsWindow ConnectionsWindow;
typedef struct _ConnectionsWindowClass ConnectionsWindowClass;
enum  {
	CONNECTIONS_APPLICATION_0_PROPERTY,
	CONNECTIONS_APPLICATION_MAIN_WINDOW_PROPERTY,
	CONNECTIONS_APPLICATION_NUM_PROPERTIES
};
static GParamSpec* connections_application_properties[CONNECTIONS_APPLICATION_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define CONNECTIONS_TYPE_ONBOARDING_DIALOG (connections_onboarding_dialog_get_type ())
#define CONNECTIONS_ONBOARDING_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONNECTIONS_TYPE_ONBOARDING_DIALOG, ConnectionsOnboardingDialog))
#define CONNECTIONS_ONBOARDING_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONNECTIONS_TYPE_ONBOARDING_DIALOG, ConnectionsOnboardingDialogClass))
#define CONNECTIONS_IS_ONBOARDING_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONNECTIONS_TYPE_ONBOARDING_DIALOG))
#define CONNECTIONS_IS_ONBOARDING_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONNECTIONS_TYPE_ONBOARDING_DIALOG))
#define CONNECTIONS_ONBOARDING_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONNECTIONS_TYPE_ONBOARDING_DIALOG, ConnectionsOnboardingDialogClass))

typedef struct _ConnectionsOnboardingDialog ConnectionsOnboardingDialog;
typedef struct _ConnectionsOnboardingDialogClass ConnectionsOnboardingDialogClass;

#define CONNECTIONS_TYPE_CONNECTION (connections_connection_get_type ())
#define CONNECTIONS_CONNECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONNECTIONS_TYPE_CONNECTION, ConnectionsConnection))
#define CONNECTIONS_CONNECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONNECTIONS_TYPE_CONNECTION, ConnectionsConnectionClass))
#define CONNECTIONS_IS_CONNECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONNECTIONS_TYPE_CONNECTION))
#define CONNECTIONS_IS_CONNECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONNECTIONS_TYPE_CONNECTION))
#define CONNECTIONS_CONNECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONNECTIONS_TYPE_CONNECTION, ConnectionsConnectionClass))

typedef struct _ConnectionsConnection ConnectionsConnection;
typedef struct _ConnectionsConnectionClass ConnectionsConnectionClass;

#define CONNECTIONS_TYPE_DATABASE (connections_database_get_type ())
#define CONNECTIONS_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONNECTIONS_TYPE_DATABASE, ConnectionsDatabase))
#define CONNECTIONS_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONNECTIONS_TYPE_DATABASE, ConnectionsDatabaseClass))
#define CONNECTIONS_IS_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONNECTIONS_TYPE_DATABASE))
#define CONNECTIONS_IS_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONNECTIONS_TYPE_DATABASE))
#define CONNECTIONS_DATABASE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONNECTIONS_TYPE_DATABASE, ConnectionsDatabaseClass))

typedef struct _ConnectionsDatabase ConnectionsDatabase;
typedef struct _ConnectionsDatabaseClass ConnectionsDatabaseClass;

#define CONNECTIONS_TYPE_VNC_CONNECTION (connections_vnc_connection_get_type ())
#define CONNECTIONS_VNC_CONNECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONNECTIONS_TYPE_VNC_CONNECTION, ConnectionsVncConnection))
#define CONNECTIONS_VNC_CONNECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONNECTIONS_TYPE_VNC_CONNECTION, ConnectionsVncConnectionClass))
#define CONNECTIONS_IS_VNC_CONNECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONNECTIONS_TYPE_VNC_CONNECTION))
#define CONNECTIONS_IS_VNC_CONNECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONNECTIONS_TYPE_VNC_CONNECTION))
#define CONNECTIONS_VNC_CONNECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONNECTIONS_TYPE_VNC_CONNECTION, ConnectionsVncConnectionClass))

typedef struct _ConnectionsVncConnection ConnectionsVncConnection;
typedef struct _ConnectionsVncConnectionClass ConnectionsVncConnectionClass;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block1Data Block1Data;
typedef void (*ConnectionsNotificationOKFunc) (gpointer user_data);
typedef void (*ConnectionsNotificationDismissFunc) (gpointer user_data);
typedef struct _ConnectionsWindowPrivate ConnectionsWindowPrivate;

#define CONNECTIONS_TYPE_COLLECTION_VIEW (connections_collection_view_get_type ())
#define CONNECTIONS_COLLECTION_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONNECTIONS_TYPE_COLLECTION_VIEW, ConnectionsCollectionView))
#define CONNECTIONS_COLLECTION_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONNECTIONS_TYPE_COLLECTION_VIEW, ConnectionsCollectionViewClass))
#define CONNECTIONS_IS_COLLECTION_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONNECTIONS_TYPE_COLLECTION_VIEW))
#define CONNECTIONS_IS_COLLECTION_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONNECTIONS_TYPE_COLLECTION_VIEW))
#define CONNECTIONS_COLLECTION_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONNECTIONS_TYPE_COLLECTION_VIEW, ConnectionsCollectionViewClass))

typedef struct _ConnectionsCollectionView ConnectionsCollectionView;
typedef struct _ConnectionsCollectionViewClass ConnectionsCollectionViewClass;

#define CONNECTIONS_TYPE_NOTIFICATIONS_BAR (connections_notifications_bar_get_type ())
#define CONNECTIONS_NOTIFICATIONS_BAR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONNECTIONS_TYPE_NOTIFICATIONS_BAR, ConnectionsNotificationsBar))
#define CONNECTIONS_NOTIFICATIONS_BAR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONNECTIONS_TYPE_NOTIFICATIONS_BAR, ConnectionsNotificationsBarClass))
#define CONNECTIONS_IS_NOTIFICATIONS_BAR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONNECTIONS_TYPE_NOTIFICATIONS_BAR))
#define CONNECTIONS_IS_NOTIFICATIONS_BAR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONNECTIONS_TYPE_NOTIFICATIONS_BAR))
#define CONNECTIONS_NOTIFICATIONS_BAR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONNECTIONS_TYPE_NOTIFICATIONS_BAR, ConnectionsNotificationsBarClass))

typedef struct _ConnectionsNotificationsBar ConnectionsNotificationsBar;
typedef struct _ConnectionsNotificationsBarClass ConnectionsNotificationsBarClass;
typedef struct _ConnectionsConnectionPrivate ConnectionsConnectionPrivate;
#define _g_option_context_free0(var) ((var == NULL) ? NULL : (var = (g_option_context_free (var), NULL)))

struct _ConnectionsApplication {
	GtkApplication parent_instance;
	ConnectionsApplicationPrivate * priv;
	GListStore* model;
};

struct _ConnectionsApplicationClass {
	GtkApplicationClass parent_class;
};

struct _ConnectionsApplicationPrivate {
	GList* windows;
	GSettings* settings;
};

struct _Block1Data {
	int _ref_count_;
	ConnectionsApplication* self;
	ConnectionsConnection* connection;
};

struct _ConnectionsWindow {
	GtkApplicationWindow parent_instance;
	ConnectionsWindowPrivate * priv;
	ConnectionsCollectionView* collection_view;
	ConnectionsNotificationsBar* notifications_bar;
};

struct _ConnectionsWindowClass {
	GtkApplicationWindowClass parent_class;
};

struct _ConnectionsConnection {
	GObject parent_instance;
	ConnectionsConnectionPrivate * priv;
	gchar* uuid;
	gboolean connected;
	gboolean need_password;
	gboolean need_username;
};

struct _ConnectionsConnectionClass {
	GObjectClass parent_class;
	void (*send_keys) (ConnectionsConnection* self, guint* keys, gint keys_length1);
	void (*connect_it) (ConnectionsConnection* self);
	void (*disconnect_it) (ConnectionsConnection* self);
	void (*dispose_display) (ConnectionsConnection* self);
	GtkWidget* (*get_widget) (ConnectionsConnection* self);
	void (*set_widget) (ConnectionsConnection* self, GtkWidget* value);
	gboolean (*get_scaling) (ConnectionsConnection* self);
	void (*set_scaling) (ConnectionsConnection* self, gboolean value);
	gint (*get_port) (ConnectionsConnection* self);
	void (*set_port) (ConnectionsConnection* self, gint value);
	GdkPixbuf* (*get_thumbnail) (ConnectionsConnection* self);
	void (*set_thumbnail) (ConnectionsConnection* self, GdkPixbuf* value);
};

static gint ConnectionsApplication_private_offset;
static gpointer connections_application_parent_class = NULL;
static gchar** connections_application_opt_uris;
static gint connections_application_opt_uris_length1;
static gchar* connections_application_opt_file_import_uri;
static gboolean connections_application_opt_fullscreen;
VALA_EXTERN ConnectionsApplication* connections_application_application;
ConnectionsApplication* connections_application_application = NULL;
static gboolean connections_application_opt_fullscreen = FALSE;
static gchar** connections_application_opt_uris = NULL;
static gint connections_application_opt_uris_length1 = 0;
static gint _connections_application_opt_uris_size_ = 0;
static gchar* connections_application_opt_file_import_uri = NULL;

VALA_EXTERN GType connections_application_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ConnectionsApplication, g_object_unref)
VALA_EXTERN GType connections_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ConnectionsWindow, g_object_unref)
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
VALA_EXTERN ConnectionsApplication* connections_application_new (void);
VALA_EXTERN ConnectionsApplication* connections_application_construct (GType object_type);
static void connections_application_show_help (ConnectionsApplication* self);
static void _connections_application_show_help_g_simple_action_activate (GSimpleAction* _sender,
                                                                  GVariant* parameter,
                                                                  gpointer self);
static void connections_application_show_about_dialog (ConnectionsApplication* self);
static void _connections_application_show_about_dialog_g_simple_action_activate (GSimpleAction* _sender,
                                                                          GVariant* parameter,
                                                                          gpointer self);
VALA_EXTERN void connections_application_quit_app (ConnectionsApplication* self);
static void _connections_application_quit_app_g_simple_action_activate (GSimpleAction* _sender,
                                                                 GVariant* parameter,
                                                                 gpointer self);
VALA_EXTERN ConnectionsWindow* connections_application_get_main_window (ConnectionsApplication* self);
static void connections_application_real_startup (GApplication* base);
static void connections_application_real_activate (GApplication* base);
VALA_EXTERN ConnectionsWindow* connections_application_add_new_window (ConnectionsApplication* self);
static gboolean connections_application_get_first_run (ConnectionsApplication* self);
VALA_EXTERN ConnectionsOnboardingDialog* connections_onboarding_dialog_new (ConnectionsWindow* window);
VALA_EXTERN ConnectionsOnboardingDialog* connections_onboarding_dialog_construct (GType object_type,
                                                                      ConnectionsWindow* window);
VALA_EXTERN GType connections_onboarding_dialog_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ConnectionsOnboardingDialog, g_object_unref)
static void connections_application_set_first_run (ConnectionsApplication* self,
                                            gboolean value);
VALA_EXTERN void connections_application_load_connections (ConnectionsApplication* self);
VALA_EXTERN ConnectionsWindow* connections_window_new (GtkApplication* app);
VALA_EXTERN ConnectionsWindow* connections_window_construct (GType object_type,
                                                 GtkApplication* app);
VALA_EXTERN void connections_application_add_connection (ConnectionsApplication* self,
                                             const gchar* uri);
VALA_EXTERN GType connections_connection_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ConnectionsConnection, g_object_unref)
VALA_EXTERN GType connections_database_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ConnectionsDatabase, g_object_unref)
VALA_EXTERN ConnectionsDatabase* connections_database_get_default (void);
VALA_EXTERN ConnectionsConnection* connections_database_add_connection (ConnectionsDatabase* self,
                                                            const gchar* _uri);
VALA_EXTERN void connections_application_open_connection (ConnectionsApplication* self,
                                              ConnectionsConnection* connection);
VALA_EXTERN void connections_application_add_connection_from_file (ConnectionsApplication* self,
                                                       const gchar* file_path);
VALA_EXTERN ConnectionsVncConnection* connections_vnc_connection_new_from_vnc_file (const gchar* file_path);
VALA_EXTERN ConnectionsVncConnection* connections_vnc_connection_construct_from_vnc_file (GType object_type,
                                                                              const gchar* file_path);
VALA_EXTERN GType connections_vnc_connection_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ConnectionsVncConnection, g_object_unref)
VALA_EXTERN void connections_application_remove_connection (ConnectionsApplication* self,
                                                ConnectionsConnection* connection);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static void __lambda19_ (Block1Data* _data1_);
static void ___lambda19__connections_notification_ok_func (gpointer self);
static void __lambda20_ (Block1Data* _data1_);
VALA_EXTERN void connections_connection_disconnect_it (ConnectionsConnection* self);
VALA_EXTERN void connections_connection_delete_auth_credentials (ConnectionsConnection* self,
                                                     GAsyncReadyCallback _callback_,
                                                     gpointer _user_data_);
VALA_EXTERN void connections_connection_delete_auth_credentials_finish (ConnectionsConnection* self,
                                                            GAsyncResult* _res_);
VALA_EXTERN void connections_database_delete_connection (ConnectionsDatabase* self,
                                             ConnectionsConnection* connection);
static void ___lambda20__connections_notification_dismiss_func (gpointer self);
VALA_EXTERN const gchar* connections_connection_get_display_name (ConnectionsConnection* self);
VALA_EXTERN gchar* connections_connection_get_uri (ConnectionsConnection* self);
VALA_EXTERN GType connections_collection_view_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ConnectionsCollectionView, g_object_unref)
VALA_EXTERN GType connections_notifications_bar_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ConnectionsNotificationsBar, g_object_unref)
VALA_EXTERN void connections_notifications_bar_display_for_action (ConnectionsNotificationsBar* self,
                                                       const gchar* message,
                                                       const gchar* ok_label,
                                                       ConnectionsNotificationOKFunc ok_func,
                                                       gpointer ok_func_target,
                                                       GDestroyNotify ok_func_target_destroy_notify,
                                                       ConnectionsNotificationDismissFunc dismiss_func,
                                                       gpointer dismiss_func_target,
                                                       GDestroyNotify dismiss_func_target_destroy_notify);
VALA_EXTERN ConnectionsDatabase* connections_database_new (void);
VALA_EXTERN ConnectionsDatabase* connections_database_construct (GType object_type);
VALA_EXTERN GList* connections_database_get_connections (ConnectionsDatabase* self);
VALA_EXTERN void connections_window_open_connection (ConnectionsWindow* self,
                                         ConnectionsConnection* connection);
static void connections_application_real_open (GApplication* base,
                                        GFile** files,
                                        gint files_length1,
                                        const gchar* hint);
static void connections_application_real_shutdown (GApplication* base);
static gint connections_application_real_command_line (GApplication* base,
                                                GApplicationCommandLine* cmdline);
VALA_EXTERN void connections_window_set_fullscreened (ConnectionsWindow* self,
                                          gboolean value);
static GObject * connections_application_constructor (GType type,
                                               guint n_construct_properties,
                                               GObjectConstructParam * construct_properties);
static void connections_application_finalize (GObject * obj);
static GType connections_application_get_type_once (void);
static void _vala_connections_application_get_property (GObject * object,
                                                 guint property_id,
                                                 GValue * value,
                                                 GParamSpec * pspec);
static void _vala_connections_application_set_property (GObject * object,
                                                 guint property_id,
                                                 const GValue * value,
                                                 GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static const GOptionEntry CONNECTIONS_APPLICATION_options[4] = {{"", (gchar) 0, (gint) 0, G_OPTION_ARG_STRING_ARRAY, &connections_application_opt_uris, N_ ("URL to connect"), NULL}, {"file", 'F', (gint) 0, G_OPTION_ARG_FILENAME, &connections_application_opt_file_import_uri, N_ ("Open .vnc or .rdp file at the given PATH"), "PATH"}, {"fullscreen", 'f', (gint) 0, G_OPTION_ARG_NONE, &connections_application_opt_fullscreen, N_ ("Open in full screen"), NULL}, {NULL}};

static inline gpointer
connections_application_get_instance_private (ConnectionsApplication* self)
{
	return G_STRUCT_MEMBER_P (self, ConnectionsApplication_private_offset);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
_connections_application_show_help_g_simple_action_activate (GSimpleAction* _sender,
                                                             GVariant* parameter,
                                                             gpointer self)
{
	connections_application_show_help ((ConnectionsApplication*) self);
}

static void
_connections_application_show_about_dialog_g_simple_action_activate (GSimpleAction* _sender,
                                                                     GVariant* parameter,
                                                                     gpointer self)
{
	connections_application_show_about_dialog ((ConnectionsApplication*) self);
}

static void
_connections_application_quit_app_g_simple_action_activate (GSimpleAction* _sender,
                                                            GVariant* parameter,
                                                            gpointer self)
{
	connections_application_quit_app ((ConnectionsApplication*) self);
}

ConnectionsApplication*
connections_application_construct (GType object_type)
{
	ConnectionsApplication * self = NULL;
	ConnectionsApplication* _tmp0_;
	GApplicationFlags _tmp1_;
	GApplicationFlags _tmp2_;
	GSettings* _tmp3_;
	GSimpleAction* action = NULL;
	GSimpleAction* _tmp4_;
	GSimpleAction* _tmp5_;
	GSimpleAction* _tmp6_;
	GSimpleAction* _tmp7_;
	GSimpleAction* _tmp8_;
	GSimpleAction* _tmp9_;
	GSimpleAction* _tmp10_;
	GSimpleAction* _tmp11_;
	GSimpleAction* _tmp12_;
	self = (ConnectionsApplication*) g_object_new (object_type, NULL);
	_tmp0_ = _g_object_ref0 (self);
	_g_object_unref0 (connections_application_application);
	connections_application_application = _tmp0_;
	g_application_set_application_id ((GApplication*) self, APPLICATION_ID);
	_tmp1_ = g_application_get_flags ((GApplication*) self);
	_tmp2_ = _tmp1_;
	g_application_set_flags ((GApplication*) self, _tmp2_ | (G_APPLICATION_HANDLES_COMMAND_LINE | G_APPLICATION_HANDLES_OPEN));
	_tmp3_ = g_settings_new ("org.gnome.Connections");
	_g_object_unref0 (self->priv->settings);
	self->priv->settings = _tmp3_;
	_tmp4_ = g_simple_action_new ("help", NULL);
	action = _tmp4_;
	_tmp5_ = action;
	g_signal_connect_object (_tmp5_, "activate", (GCallback) _connections_application_show_help_g_simple_action_activate, self, 0);
	_tmp6_ = action;
	g_action_map_add_action ((GActionMap*) self, (GAction*) _tmp6_);
	_tmp7_ = g_simple_action_new ("about", NULL);
	_g_object_unref0 (action);
	action = _tmp7_;
	_tmp8_ = action;
	g_signal_connect_object (_tmp8_, "activate", (GCallback) _connections_application_show_about_dialog_g_simple_action_activate, self, 0);
	_tmp9_ = action;
	g_action_map_add_action ((GActionMap*) self, (GAction*) _tmp9_);
	_tmp10_ = g_simple_action_new ("quit", NULL);
	_g_object_unref0 (action);
	action = _tmp10_;
	_tmp11_ = action;
	g_signal_connect_object (_tmp11_, "activate", (GCallback) _connections_application_quit_app_g_simple_action_activate, self, 0);
	_tmp12_ = action;
	g_action_map_add_action ((GActionMap*) self, (GAction*) _tmp12_);
	_g_object_unref0 (action);
	return self;
}

ConnectionsApplication*
connections_application_new (void)
{
	return connections_application_construct (CONNECTIONS_TYPE_APPLICATION);
}

static void
connections_application_show_help (ConnectionsApplication* self)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	{
		ConnectionsWindow* _tmp0_;
		ConnectionsWindow* _tmp1_;
		_tmp0_ = connections_application_get_main_window (self);
		_tmp1_ = _tmp0_;
		gtk_show_uri_on_window ((GtkWindow*) _tmp1_, "help:gnome-connections", gtk_get_current_event_time (), &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* _error_ = NULL;
		GError* _tmp2_;
		const gchar* _tmp3_;
		_error_ = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp2_ = _error_;
		_tmp3_ = _tmp2_->message;
		g_warning ("application.vala:73: Failed to display help: %s", _tmp3_);
		_g_error_free0 (_error_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
connections_application_show_about_dialog (ConnectionsApplication* self)
{
	gchar** authors = NULL;
	gchar* _tmp0_;
	gchar** _tmp1_;
	gint authors_length1;
	gint _authors_size_;
	gchar** artists = NULL;
	gchar* _tmp2_;
	gchar** _tmp3_;
	gint artists_length1;
	gint _artists_size_;
	ConnectionsWindow* _tmp4_;
	ConnectionsWindow* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup ("Felipe Borges <felipeborges@gnome.org>");
	_tmp1_ = g_new0 (gchar*, 1 + 1);
	_tmp1_[0] = _tmp0_;
	authors = _tmp1_;
	authors_length1 = 1;
	_authors_size_ = authors_length1;
	_tmp2_ = g_strdup ("Jakub Steiner <jsteiner@redhat.com>");
	_tmp3_ = g_new0 (gchar*, 1 + 1);
	_tmp3_[0] = _tmp2_;
	artists = _tmp3_;
	artists_length1 = 1;
	_artists_size_ = artists_length1;
	_tmp4_ = connections_application_get_main_window (self);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_application_get_application_id ((GApplication*) self);
	_tmp7_ = _tmp6_;
	gtk_show_about_dialog ((GtkWindow*) _tmp5_, "artists", artists, "authors", authors, "translator-credits", _ ("translator-credits"), "comments", _ ("A remote desktop client for the GNOME desktop environment"), "copyright", "\xc2\xa9 2020 Red Hat, Inc.", "license-type", GTK_LICENSE_GPL_3_0, "program-name", _ ("Connections"), "wrap-license", TRUE, "logo-icon-name", _tmp7_, "version", VERSION, NULL);
	artists = (_vala_array_free (artists, artists_length1, (GDestroyNotify) g_free), NULL);
	authors = (_vala_array_free (authors, authors_length1, (GDestroyNotify) g_free), NULL);
}

static void
connections_application_real_startup (GApplication* base)
{
	ConnectionsApplication * self;
	HdyStyleManager* _tmp0_;
	self = (ConnectionsApplication*) base;
	G_APPLICATION_CLASS (connections_application_parent_class)->startup ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication));
	hdy_init ();
	_tmp0_ = hdy_style_manager_get_default ();
	hdy_style_manager_set_color_scheme (_tmp0_, HDY_COLOR_SCHEME_PREFER_DARK);
}

static void
connections_application_real_activate (GApplication* base)
{
	ConnectionsApplication * self;
	ConnectionsWindow* _tmp0_;
	ConnectionsWindow* _tmp1_;
	ConnectionsWindow* _tmp2_;
	ConnectionsWindow* _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	self = (ConnectionsApplication*) base;
	G_APPLICATION_CLASS (connections_application_parent_class)->activate ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication));
	_tmp0_ = connections_application_get_main_window (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		return;
	}
	_tmp2_ = connections_application_add_new_window (self);
	_tmp3_ = _tmp2_;
	_g_object_unref0 (_tmp3_);
	_tmp4_ = connections_application_get_first_run (self);
	_tmp5_ = _tmp4_;
	if (_tmp5_) {
		ConnectionsWindow* _tmp6_;
		ConnectionsWindow* _tmp7_;
		ConnectionsOnboardingDialog* _tmp8_;
		ConnectionsOnboardingDialog* _tmp9_;
		gboolean _tmp10_;
		gboolean _tmp11_;
		_tmp6_ = connections_application_get_main_window (self);
		_tmp7_ = _tmp6_;
		_tmp8_ = connections_onboarding_dialog_new (_tmp7_);
		g_object_ref_sink (_tmp8_);
		_tmp9_ = _tmp8_;
		gtk_window_present ((GtkWindow*) _tmp9_);
		_g_object_unref0 (_tmp9_);
		_tmp10_ = connections_application_get_first_run (self);
		_tmp11_ = _tmp10_;
		connections_application_set_first_run (self, !_tmp11_);
	}
	connections_application_load_connections (self);
}

ConnectionsWindow*
connections_application_add_new_window (ConnectionsApplication* self)
{
	ConnectionsWindow* window = NULL;
	ConnectionsWindow* _tmp0_;
	ConnectionsWindow* _tmp1_;
	ConnectionsWindow* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = connections_window_new ((GtkApplication*) self);
	g_object_ref_sink (_tmp0_);
	window = _tmp0_;
	_tmp1_ = _g_object_ref0 (window);
	self->priv->windows = g_list_append (self->priv->windows, _tmp1_);
	gtk_window_present ((GtkWindow*) window);
	result = window;
	return result;
}

void
connections_application_add_connection (ConnectionsApplication* self,
                                        const gchar* uri)
{
	ConnectionsConnection* connection = NULL;
	ConnectionsDatabase* _tmp0_;
	ConnectionsDatabase* _tmp1_;
	ConnectionsConnection* _tmp2_;
	ConnectionsConnection* _tmp3_;
	ConnectionsConnection* _tmp4_;
	GListStore* _tmp5_;
	ConnectionsConnection* _tmp6_;
	ConnectionsConnection* _tmp7_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (uri != NULL);
	_tmp0_ = connections_database_get_default ();
	_tmp1_ = _tmp0_;
	_tmp2_ = connections_database_add_connection (_tmp1_, uri);
	_tmp3_ = _tmp2_;
	_g_object_unref0 (_tmp1_);
	connection = _tmp3_;
	_tmp4_ = connection;
	if (_tmp4_ == NULL) {
		_g_object_unref0 (connection);
		return;
	}
	_tmp5_ = self->model;
	_tmp6_ = connection;
	g_list_store_insert (_tmp5_, (guint) 0, (GObject*) _tmp6_);
	_tmp7_ = connection;
	connections_application_open_connection (self, _tmp7_);
	_g_object_unref0 (connection);
}

void
connections_application_add_connection_from_file (ConnectionsApplication* self,
                                                  const gchar* file_path)
{
	ConnectionsConnection* connection = NULL;
	gchar* mime_type = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	GQuark _tmp4_ = 0U;
	static GQuark _tmp3_label0 = 0;
	ConnectionsConnection* _tmp9_;
	GListStore* _tmp10_;
	ConnectionsConnection* _tmp11_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (file_path != NULL);
	connection = NULL;
	_tmp0_ = g_content_type_guess (file_path, NULL, (gsize) 0, NULL);
	mime_type = _tmp0_;
	_tmp1_ = mime_type;
	_tmp2_ = _tmp1_;
	_tmp4_ = (NULL == _tmp2_) ? 0 : g_quark_from_string (_tmp2_);
	if (_tmp4_ == ((0 != _tmp3_label0) ? _tmp3_label0 : (_tmp3_label0 = g_quark_from_static_string ("application/x-vnc")))) {
		switch (0) {
			default:
			{
				ConnectionsVncConnection* _tmp5_;
				_tmp5_ = connections_vnc_connection_new_from_vnc_file (file_path);
				_g_object_unref0 (connection);
				connection = (ConnectionsConnection*) _tmp5_;
				break;
			}
		}
	} else {
		switch (0) {
			default:
			{
				const gchar* _tmp6_;
				gchar* _tmp7_;
				gchar* _tmp8_;
				_tmp6_ = mime_type;
				_tmp7_ = g_strdup_printf ("Couldn’t open file of unknown mime type %s", _tmp6_);
				_tmp8_ = _tmp7_;
				g_warning ("application.vala:151: %s", _ (_tmp8_));
				_g_free0 (_tmp8_);
				break;
			}
		}
	}
	_tmp9_ = connection;
	if (_tmp9_ == NULL) {
		_g_free0 (mime_type);
		_g_object_unref0 (connection);
		return;
	}
	_tmp10_ = self->model;
	_tmp11_ = connection;
	g_list_store_insert (_tmp10_, (guint) 0, (GObject*) _tmp11_);
	_g_free0 (mime_type);
	_g_object_unref0 (connection);
}

static Block1Data*
block1_data_ref (Block1Data* _data1_)
{
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}

static void
block1_data_unref (void * _userdata_)
{
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		ConnectionsApplication* self;
		self = _data1_->self;
		_g_object_unref0 (_data1_->connection);
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}

static void
__lambda19_ (Block1Data* _data1_)
{
	ConnectionsApplication* self;
	GListStore* _tmp0_;
	self = _data1_->self;
	g_debug ("application.vala:163: Connection deletion cancelled by user. Re-adding" \
" to view");
	_tmp0_ = self->model;
	g_list_store_insert (_tmp0_, (guint) 0, (GObject*) _data1_->connection);
}

static void
___lambda19__connections_notification_ok_func (gpointer self)
{
	__lambda19_ (self);
}

static void
__lambda20_ (Block1Data* _data1_)
{
	ConnectionsApplication* self;
	ConnectionsDatabase* _tmp0_;
	ConnectionsDatabase* _tmp1_;
	self = _data1_->self;
	g_debug ("application.vala:168: User did not cancel deletion. Deleting now...");
	connections_connection_disconnect_it (_data1_->connection);
	connections_connection_delete_auth_credentials (_data1_->connection, NULL, NULL);
	_tmp0_ = connections_database_get_default ();
	_tmp1_ = _tmp0_;
	connections_database_delete_connection (_tmp1_, _data1_->connection);
	_g_object_unref0 (_tmp1_);
}

static void
___lambda20__connections_notification_dismiss_func (gpointer self)
{
	__lambda20_ (self);
}

void
connections_application_remove_connection (ConnectionsApplication* self,
                                           ConnectionsConnection* connection)
{
	Block1Data* _data1_;
	ConnectionsConnection* _tmp0_;
	ConnectionsNotificationOKFunc undo = NULL;
	gpointer undo_target;
	GDestroyNotify undo_target_destroy_notify;
	ConnectionsNotificationDismissFunc really_remove = NULL;
	gpointer really_remove_target;
	GDestroyNotify really_remove_target_destroy_notify;
	gchar* _tmp10_ = NULL;
	gboolean _tmp11_ = FALSE;
	const gchar* _tmp12_;
	const gchar* _tmp13_;
	gchar* message = NULL;
	gchar* _tmp21_;
	ConnectionsWindow* _tmp22_;
	ConnectionsWindow* _tmp23_;
	ConnectionsNotificationsBar* _tmp24_;
	ConnectionsNotificationOKFunc _tmp25_;
	gpointer _tmp25__target;
	GDestroyNotify _tmp25__target_destroy_notify;
	ConnectionsNotificationDismissFunc _tmp26_;
	gpointer _tmp26__target;
	GDestroyNotify _tmp26__target_destroy_notify;
	g_return_if_fail (self != NULL);
	g_return_if_fail (connection != NULL);
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_data1_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (connection);
	_g_object_unref0 (_data1_->connection);
	_data1_->connection = _tmp0_;
	undo = ___lambda19__connections_notification_ok_func;
	undo_target = block1_data_ref (_data1_);
	undo_target_destroy_notify = block1_data_unref;
	really_remove = ___lambda20__connections_notification_dismiss_func;
	really_remove_target = block1_data_ref (_data1_);
	really_remove_target_destroy_notify = block1_data_unref;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				GListStore* _tmp3_;
				GListStore* _tmp4_;
				GObject* _tmp5_;
				ConnectionsConnection* _tmp6_;
				ConnectionsConnection* _tmp7_;
				gboolean _tmp8_;
				if (!_tmp1_) {
					gint _tmp2_;
					_tmp2_ = i;
					i = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				_tmp3_ = self->model;
				if (!(((guint) i) < g_list_model_get_n_items ((GListModel*) _tmp3_))) {
					break;
				}
				_tmp4_ = self->model;
				_tmp5_ = g_list_model_get_item ((GListModel*) _tmp4_, (guint) i);
				_tmp6_ = CONNECTIONS_IS_CONNECTION (_tmp5_) ? ((ConnectionsConnection*) _tmp5_) : NULL;
				if (_tmp6_ == NULL) {
					_g_object_unref0 (_tmp5_);
				}
				_tmp7_ = _tmp6_;
				_tmp8_ = _tmp7_ == _data1_->connection;
				_g_object_unref0 (_tmp7_);
				if (_tmp8_) {
					GListStore* _tmp9_;
					_tmp9_ = self->model;
					g_list_store_remove (_tmp9_, (guint) i);
					break;
				}
			}
		}
	}
	_tmp12_ = connections_connection_get_display_name (_data1_->connection);
	_tmp13_ = _tmp12_;
	if (g_strcmp0 (_tmp13_, "") != 0) {
		const gchar* _tmp14_;
		const gchar* _tmp15_;
		_tmp14_ = connections_connection_get_display_name (_data1_->connection);
		_tmp15_ = _tmp14_;
		_tmp11_ = _tmp15_ != NULL;
	} else {
		_tmp11_ = FALSE;
	}
	if (_tmp11_) {
		const gchar* _tmp16_;
		const gchar* _tmp17_;
		gchar* _tmp18_;
		_tmp16_ = connections_connection_get_display_name (_data1_->connection);
		_tmp17_ = _tmp16_;
		_tmp18_ = g_strdup (_tmp17_);
		_g_free0 (_tmp10_);
		_tmp10_ = _tmp18_;
	} else {
		gchar* _tmp19_;
		gchar* _tmp20_;
		_tmp19_ = connections_connection_get_uri (_data1_->connection);
		_tmp20_ = _tmp19_;
		_g_free0 (_tmp10_);
		_tmp10_ = _tmp20_;
	}
	_tmp21_ = g_strdup_printf (_ ("Connection to “%s” has been deleted"), _tmp10_);
	message = _tmp21_;
	_tmp22_ = connections_application_get_main_window (self);
	_tmp23_ = _tmp22_;
	_tmp24_ = _tmp23_->notifications_bar;
	_tmp25_ = undo;
	_tmp25__target = undo_target;
	_tmp25__target_destroy_notify = undo_target_destroy_notify;
	undo = NULL;
	undo_target = NULL;
	undo_target_destroy_notify = NULL;
	_tmp26_ = really_remove;
	_tmp26__target = really_remove_target;
	_tmp26__target_destroy_notify = really_remove_target_destroy_notify;
	really_remove = NULL;
	really_remove_target = NULL;
	really_remove_target_destroy_notify = NULL;
	connections_notifications_bar_display_for_action (_tmp24_, message, _ ("Undo"), _tmp25_, _tmp25__target, _tmp25__target_destroy_notify, _tmp26_, _tmp26__target, _tmp26__target_destroy_notify);
	_g_free0 (message);
	_g_free0 (_tmp10_);
	(really_remove_target_destroy_notify == NULL) ? NULL : (really_remove_target_destroy_notify (really_remove_target), NULL);
	really_remove = NULL;
	really_remove_target = NULL;
	really_remove_target_destroy_notify = NULL;
	(undo_target_destroy_notify == NULL) ? NULL : (undo_target_destroy_notify (undo_target), NULL);
	undo = NULL;
	undo_target = NULL;
	undo_target_destroy_notify = NULL;
	block1_data_unref (_data1_);
	_data1_ = NULL;
}

void
connections_application_load_connections (ConnectionsApplication* self)
{
	ConnectionsDatabase* db = NULL;
	ConnectionsDatabase* _tmp0_;
	ConnectionsDatabase* _tmp1_;
	GList* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = connections_database_new ();
	db = _tmp0_;
	_tmp1_ = db;
	_tmp2_ = connections_database_get_connections (_tmp1_);
	{
		GList* connection_collection = NULL;
		GList* connection_it = NULL;
		connection_collection = _tmp2_;
		for (connection_it = connection_collection; connection_it != NULL; connection_it = connection_it->next) {
			ConnectionsConnection* _tmp3_;
			ConnectionsConnection* connection = NULL;
			_tmp3_ = _g_object_ref0 ((ConnectionsConnection*) connection_it->data);
			connection = _tmp3_;
			{
				GListStore* _tmp4_;
				ConnectionsConnection* _tmp5_;
				_tmp4_ = self->model;
				_tmp5_ = connection;
				g_list_store_append (_tmp4_, (GObject*) _tmp5_);
				_g_object_unref0 (connection);
			}
		}
		(connection_collection == NULL) ? NULL : (connection_collection = (_g_list_free__g_object_unref0_ (connection_collection), NULL));
	}
	_g_object_unref0 (db);
}

void
connections_application_open_connection (ConnectionsApplication* self,
                                         ConnectionsConnection* connection)
{
	ConnectionsWindow* _tmp0_;
	ConnectionsWindow* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (connection != NULL);
	_tmp0_ = connections_application_get_main_window (self);
	_tmp1_ = _tmp0_;
	connections_window_open_connection (_tmp1_, connection);
}

static void
connections_application_real_open (GApplication* base,
                                   GFile** files,
                                   gint files_length1,
                                   const gchar* hint)
{
	ConnectionsApplication * self;
	self = (ConnectionsApplication*) base;
	g_return_if_fail (hint != NULL);
	g_application_activate ((GApplication*) self);
	{
		GFile** file_collection = NULL;
		gint file_collection_length1 = 0;
		gint _file_collection_size_ = 0;
		gint file_it = 0;
		file_collection = files;
		file_collection_length1 = files_length1;
		for (file_it = 0; file_it < file_collection_length1; file_it = file_it + 1) {
			GFile* _tmp0_;
			GFile* file = NULL;
			_tmp0_ = _g_object_ref0 (file_collection[file_it]);
			file = _tmp0_;
			{
				GFile* _tmp1_;
				gchar* _tmp2_;
				gchar* _tmp3_;
				_tmp1_ = file;
				_tmp2_ = g_file_get_path (_tmp1_);
				_tmp3_ = _tmp2_;
				connections_application_add_connection_from_file (self, _tmp3_);
				_g_free0 (_tmp3_);
				_g_object_unref0 (file);
			}
		}
	}
}

static void
connections_application_real_shutdown (GApplication* base)
{
	ConnectionsApplication * self;
	self = (ConnectionsApplication*) base;
	G_APPLICATION_CLASS (connections_application_parent_class)->shutdown ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication));
	{
		gint idx = 0;
		idx = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				GListStore* _tmp2_;
				ConnectionsConnection* connection = NULL;
				GListStore* _tmp3_;
				GObject* _tmp4_;
				ConnectionsConnection* _tmp5_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = idx;
					idx = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = self->model;
				if (!(((guint) idx) < g_list_model_get_n_items ((GListModel*) _tmp2_))) {
					break;
				}
				_tmp3_ = self->model;
				_tmp4_ = g_list_model_get_item ((GListModel*) _tmp3_, (guint) idx);
				connection = G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, CONNECTIONS_TYPE_CONNECTION, ConnectionsConnection);
				_tmp5_ = connection;
				if (_tmp5_->connected) {
					ConnectionsConnection* _tmp6_;
					_tmp6_ = connection;
					connections_connection_disconnect_it (_tmp6_);
				}
				_g_object_unref0 (connection);
			}
		}
	}
}

void
connections_application_quit_app (ConnectionsApplication* self)
{
	GList* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->windows;
	{
		GList* window_collection = NULL;
		GList* window_it = NULL;
		window_collection = _tmp0_;
		for (window_it = window_collection; window_it != NULL; window_it = window_it->next) {
			ConnectionsWindow* _tmp1_;
			ConnectionsWindow* window = NULL;
			_tmp1_ = _g_object_ref0 ((ConnectionsWindow*) window_it->data);
			window = _tmp1_;
			{
				ConnectionsWindow* _tmp2_;
				_tmp2_ = window;
				gtk_widget_hide ((GtkWidget*) _tmp2_);
				_g_object_unref0 (window);
			}
		}
	}
	g_application_quit ((GApplication*) self);
}

static gint
connections_application_real_command_line (GApplication* base,
                                           GApplicationCommandLine* cmdline)
{
	ConnectionsApplication * self;
	gchar* parameter_string = NULL;
	gchar* _tmp0_;
	GOptionContext* opt_context = NULL;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	GOptionContext* _tmp4_;
	GOptionContext* _tmp5_;
	GOptionContext* _tmp6_;
	gboolean _tmp15_ = FALSE;
	gchar** _tmp16_;
	gint _tmp16__length1;
	gchar** _tmp18_;
	gint _tmp18__length1;
	const gchar* _tmp23_;
	ConnectionsWindow* _tmp25_;
	ConnectionsWindow* _tmp26_;
	GError* _inner_error0_ = NULL;
	gint result;
	self = (ConnectionsApplication*) base;
	g_return_val_if_fail (cmdline != NULL, 0);
	connections_application_opt_uris = (_vala_array_free (connections_application_opt_uris, connections_application_opt_uris_length1, (GDestroyNotify) g_free), NULL);
	connections_application_opt_uris = NULL;
	connections_application_opt_uris_length1 = 0;
	_connections_application_opt_uris_size_ = connections_application_opt_uris_length1;
	_g_free0 (connections_application_opt_file_import_uri);
	connections_application_opt_file_import_uri = NULL;
	connections_application_opt_fullscreen = FALSE;
	_tmp0_ = g_strdup (_ ("A remote desktop client for the GNOME desktop environment"));
	parameter_string = _tmp0_;
	_tmp1_ = parameter_string;
	_tmp2_ = g_strconcat ("— ", _tmp1_, NULL);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_option_context_new (_tmp3_);
	_tmp5_ = _tmp4_;
	_g_free0 (_tmp3_);
	opt_context = _tmp5_;
	_tmp6_ = opt_context;
	g_option_context_add_main_entries (_tmp6_, CONNECTIONS_APPLICATION_options, NULL);
	{
		gchar** args1 = NULL;
		gint _tmp7_ = 0;
		gchar** _tmp8_;
		gint args1_length1;
		gint _args1_size_;
		gchar** args2 = NULL;
		gchar** _tmp9_;
		gint _tmp9__length1;
		gint args2_length1;
		gint _args2_size_;
		GOptionContext* _tmp10_;
		_tmp8_ = g_application_command_line_get_arguments (cmdline, &_tmp7_);
		args1 = _tmp8_;
		args1_length1 = _tmp7_;
		_args1_size_ = args1_length1;
		_tmp9_ = args1;
		_tmp9__length1 = args1_length1;
		args2 = _tmp9_;
		args2_length1 = _tmp9__length1;
		_args2_size_ = args2_length1;
		_tmp10_ = opt_context;
		g_option_context_parse (_tmp10_, (gint*) (&args2_length1), &args2, &_inner_error0_);
		_args2_size_ = args2_length1;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gint _tmp11_ = -1;
			args1 = (_vala_array_free (args1, args1_length1, (GDestroyNotify) g_free), NULL);
			if (_inner_error0_->domain == G_OPTION_ERROR) {
				goto __catch0_g_option_error;
			}
			_g_option_context_free0 (opt_context);
			_g_free0 (parameter_string);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp11_;
		}
		args1 = (_vala_array_free (args1, args1_length1, (GDestroyNotify) g_free), NULL);
	}
	goto __finally0;
	__catch0_g_option_error:
	{
		GError* _error_ = NULL;
		GError* _tmp12_;
		const gchar* _tmp13_;
		_error_ = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp12_ = _error_;
		_tmp13_ = _tmp12_->message;
		g_application_command_line_printerr (cmdline, "%s\n", _tmp13_);
		result = 1;
		_g_error_free0 (_error_);
		_g_option_context_free0 (opt_context);
		_g_free0 (parameter_string);
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gint _tmp14_ = -1;
		_g_option_context_free0 (opt_context);
		_g_free0 (parameter_string);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp14_;
	}
	_tmp16_ = connections_application_opt_uris;
	_tmp16__length1 = connections_application_opt_uris_length1;
	if (_tmp16_ != NULL) {
		gchar** _tmp17_;
		gint _tmp17__length1;
		_tmp17_ = connections_application_opt_uris;
		_tmp17__length1 = connections_application_opt_uris_length1;
		_tmp15_ = _tmp17__length1 > 1;
	} else {
		_tmp15_ = FALSE;
	}
	if (_tmp15_) {
		g_application_command_line_printerr (cmdline, "%s", _ ("Too many command-line arguments specified.\n"));
		result = 1;
		_g_option_context_free0 (opt_context);
		_g_free0 (parameter_string);
		return result;
	}
	g_application_activate ((GApplication*) self);
	_tmp18_ = connections_application_opt_uris;
	_tmp18__length1 = connections_application_opt_uris_length1;
	if (_tmp18_ != NULL) {
		gchar* uri = NULL;
		gchar** _tmp19_;
		gint _tmp19__length1;
		const gchar* _tmp20_;
		gchar* _tmp21_;
		const gchar* _tmp22_;
		_tmp19_ = connections_application_opt_uris;
		_tmp19__length1 = connections_application_opt_uris_length1;
		_tmp20_ = _tmp19_[0];
		_tmp21_ = g_strdup (_tmp20_);
		uri = _tmp21_;
		_tmp22_ = uri;
		connections_application_add_connection (self, _tmp22_);
		_g_free0 (uri);
	}
	_tmp23_ = connections_application_opt_file_import_uri;
	if (_tmp23_ != NULL) {
		const gchar* _tmp24_;
		_tmp24_ = connections_application_opt_file_import_uri;
		connections_application_add_connection_from_file (self, _tmp24_);
	}
	_tmp25_ = connections_application_get_main_window (self);
	_tmp26_ = _tmp25_;
	connections_window_set_fullscreened (_tmp26_, connections_application_opt_fullscreen);
	result = 0;
	_g_option_context_free0 (opt_context);
	_g_free0 (parameter_string);
	return result;
}

ConnectionsWindow*
connections_application_get_main_window (ConnectionsApplication* self)
{
	ConnectionsWindow* result;
	ConnectionsWindow* _tmp0_ = NULL;
	GList* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = self->priv->windows;
	if (g_list_length (_tmp1_) > ((guint) 0)) {
		GList* _tmp2_;
		gconstpointer _tmp3_;
		_tmp2_ = self->priv->windows;
		_tmp3_ = _tmp2_->data;
		_tmp0_ = (ConnectionsWindow*) _tmp3_;
	} else {
		_tmp0_ = NULL;
	}
	result = _tmp0_;
	return result;
}

static gboolean
connections_application_get_first_run (ConnectionsApplication* self)
{
	gboolean result;
	GSettings* _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->settings;
	result = g_settings_get_boolean (_tmp0_, "first-run");
	return result;
}

static void
connections_application_set_first_run (ConnectionsApplication* self,
                                       gboolean value)
{
	GSettings* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->settings;
	g_settings_set_boolean (_tmp0_, "first-run", value);
}

static GObject *
connections_application_constructor (GType type,
                                     guint n_construct_properties,
                                     GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	ConnectionsApplication * self;
	GListStore* _tmp0_;
	parent_class = G_OBJECT_CLASS (connections_application_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CONNECTIONS_TYPE_APPLICATION, ConnectionsApplication);
	(self->priv->windows == NULL) ? NULL : (self->priv->windows = (_g_list_free__g_object_unref0_ (self->priv->windows), NULL));
	self->priv->windows = NULL;
	_tmp0_ = g_list_store_new (CONNECTIONS_TYPE_CONNECTION);
	_g_object_unref0 (self->model);
	self->model = _tmp0_;
	return obj;
}

static void
connections_application_class_init (ConnectionsApplicationClass * klass,
                                    gpointer klass_data)
{
	connections_application_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ConnectionsApplication_private_offset);
	((GApplicationClass *) klass)->startup = (void (*) (GApplication*)) connections_application_real_startup;
	((GApplicationClass *) klass)->activate = (void (*) (GApplication*)) connections_application_real_activate;
	((GApplicationClass *) klass)->open = (void (*) (GApplication*, GFile**, gint, const gchar*)) connections_application_real_open;
	((GApplicationClass *) klass)->shutdown = (void (*) (GApplication*)) connections_application_real_shutdown;
	((GApplicationClass *) klass)->command_line = (gint (*) (GApplication*, GApplicationCommandLine*)) connections_application_real_command_line;
	G_OBJECT_CLASS (klass)->get_property = _vala_connections_application_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_connections_application_set_property;
	G_OBJECT_CLASS (klass)->constructor = connections_application_constructor;
	G_OBJECT_CLASS (klass)->finalize = connections_application_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONNECTIONS_APPLICATION_MAIN_WINDOW_PROPERTY, connections_application_properties[CONNECTIONS_APPLICATION_MAIN_WINDOW_PROPERTY] = g_param_spec_object ("main-window", "main-window", "main-window", CONNECTIONS_TYPE_WINDOW, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
connections_application_instance_init (ConnectionsApplication * self,
                                       gpointer klass)
{
	self->priv = connections_application_get_instance_private (self);
}

static void
connections_application_finalize (GObject * obj)
{
	ConnectionsApplication * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CONNECTIONS_TYPE_APPLICATION, ConnectionsApplication);
	_g_object_unref0 (self->model);
	(self->priv->windows == NULL) ? NULL : (self->priv->windows = (_g_list_free__g_object_unref0_ (self->priv->windows), NULL));
	_g_object_unref0 (self->priv->settings);
	G_OBJECT_CLASS (connections_application_parent_class)->finalize (obj);
}

static GType
connections_application_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ConnectionsApplicationClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) connections_application_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ConnectionsApplication), 0, (GInstanceInitFunc) connections_application_instance_init, NULL };
	GType connections_application_type_id;
	connections_application_type_id = g_type_register_static (gtk_application_get_type (), "ConnectionsApplication", &g_define_type_info, 0);
	ConnectionsApplication_private_offset = g_type_add_instance_private (connections_application_type_id, sizeof (ConnectionsApplicationPrivate));
	return connections_application_type_id;
}

GType
connections_application_get_type (void)
{
	static volatile gsize connections_application_type_id__once = 0;
	if (g_once_init_enter (&connections_application_type_id__once)) {
		GType connections_application_type_id;
		connections_application_type_id = connections_application_get_type_once ();
		g_once_init_leave (&connections_application_type_id__once, connections_application_type_id);
	}
	return connections_application_type_id__once;
}

static void
_vala_connections_application_get_property (GObject * object,
                                            guint property_id,
                                            GValue * value,
                                            GParamSpec * pspec)
{
	ConnectionsApplication * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CONNECTIONS_TYPE_APPLICATION, ConnectionsApplication);
	switch (property_id) {
		case CONNECTIONS_APPLICATION_MAIN_WINDOW_PROPERTY:
		g_value_set_object (value, connections_application_get_main_window (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_connections_application_set_property (GObject * object,
                                            guint property_id,
                                            const GValue * value,
                                            GParamSpec * pspec)
{
	ConnectionsApplication * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CONNECTIONS_TYPE_APPLICATION, ConnectionsApplication);
	switch (property_id) {
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

