/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.command;

import net.sourceforge.plantuml.AbstractPSystem;
import net.sourceforge.plantuml.ErrorUml;
import net.sourceforge.plantuml.ErrorUmlType;
import net.sourceforge.plantuml.ISkinSimple;
import net.sourceforge.plantuml.LineLocation;
import net.sourceforge.plantuml.StringLocated;
import net.sourceforge.plantuml.api.ThemeStyle;
import net.sourceforge.plantuml.command.PSystemAbstractFactory;
import net.sourceforge.plantuml.core.Diagram;
import net.sourceforge.plantuml.core.DiagramType;
import net.sourceforge.plantuml.core.UmlSource;
import net.sourceforge.plantuml.error.PSystemErrorUtils;
import net.sourceforge.plantuml.utils.StartUtils;
import net.sourceforge.plantuml.version.IteratorCounter2;

public abstract class PSystemSingleLineFactory
extends PSystemAbstractFactory {
    protected abstract AbstractPSystem executeLine(UmlSource var1, String var2);

    protected PSystemSingleLineFactory() {
        super(DiagramType.UML);
    }

    @Override
    public final Diagram createSystem(ThemeStyle style, UmlSource source, ISkinSimple skinParam) {
        if (source.getTotalLineCount() != 3) {
            return null;
        }
        IteratorCounter2 it = source.iterator2();
        if (source.isEmpty()) {
            LineLocation location = ((StringLocated)it.next()).getLocation();
            return this.buildEmptyError(source, location, it.getTrace());
        }
        StringLocated startLine = (StringLocated)it.next();
        if (!StartUtils.isArobaseStartDiagram(startLine.getString())) {
            throw new UnsupportedOperationException();
        }
        if (!it.hasNext()) {
            return this.buildEmptyError(source, startLine.getLocation(), it.getTrace());
        }
        StringLocated s = (StringLocated)it.next();
        if (StartUtils.isArobaseEndDiagram(s.getString())) {
            return this.buildEmptyError(source, s.getLocation(), it.getTrace());
        }
        AbstractPSystem sys = this.executeLine(source, s.getString());
        if (sys == null) {
            ErrorUml err = new ErrorUml(ErrorUmlType.SYNTAX_ERROR, "Syntax Error?", 0, s.getLocation());
            return PSystemErrorUtils.buildV2(source, err, null, it.getTrace());
        }
        return sys;
    }
}

