/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.cucadiagram;

import java.util.ArrayList;
import net.sourceforge.plantuml.Guillemet;
import net.sourceforge.plantuml.ISkinSimple;
import net.sourceforge.plantuml.LineBreakStrategy;
import net.sourceforge.plantuml.cucadiagram.BodyEnhancedAbstract;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.graphic.TextBlockVertical2;
import net.sourceforge.plantuml.style.Style;

public class BodyEnhanced2
extends BodyEnhancedAbstract {
    private final Display rawBody;
    private final ISkinSimple skinParam;
    private final LineBreakStrategy lineBreakStrategy;

    BodyEnhanced2(Display rawBody, ISkinSimple skinParam, HorizontalAlignment align, FontConfiguration titleConfig, LineBreakStrategy lineBreakStrategy, Style style) {
        super(align, titleConfig, style);
        this.rawBody = rawBody;
        this.lineBreakStrategy = lineBreakStrategy;
        this.skinParam = skinParam;
    }

    @Override
    protected double getMarginX() {
        return 0.0;
    }

    @Override
    protected TextBlock getArea(StringBounder stringBounder) {
        if (this.area != null) {
            return this.area;
        }
        ArrayList<TextBlock> blocks = new ArrayList<TextBlock>();
        char separator = '\u0000';
        TextBlock title = null;
        Display display = Display.empty();
        for (CharSequence s : this.rawBody) {
            if (BodyEnhanced2.isBlockSeparator(s.toString())) {
                blocks.add(this.decorate(stringBounder, this.getTextBlock(display), separator, title));
                separator = s.charAt(0);
                title = this.getTitle(s.toString(), this.skinParam);
                display = Display.empty();
                continue;
            }
            if (s instanceof String) {
                s = Guillemet.GUILLEMET.manageGuillemet(s.toString());
            }
            display = display.add(s);
        }
        blocks.add(this.decorate(stringBounder, this.getTextBlock(display), separator, title));
        this.area = blocks.size() == 1 ? (TextBlock)blocks.get(0) : new TextBlockVertical2(blocks, this.align);
        if (this.skinParam.minClassWidth() > 0.0) {
            this.area = TextBlockUtils.withMinWidth(this.area, this.skinParam.minClassWidth(), this.align);
        }
        return this.area;
    }

    private TextBlock getTextBlock(Display display) {
        TextBlock result = display.create9(this.titleConfig, this.align, this.skinParam, this.lineBreakStrategy);
        return result;
    }
}

