/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.xmi;

import java.io.IOException;
import java.io.OutputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import net.sourceforge.plantuml.FileFormat;
import net.sourceforge.plantuml.Log;
import net.sourceforge.plantuml.UmlDiagram;
import net.sourceforge.plantuml.classdiagram.ClassDiagram;
import net.sourceforge.plantuml.cucadiagram.CucaDiagram;
import net.sourceforge.plantuml.descdiagram.DescriptionDiagram;
import net.sourceforge.plantuml.log.Logme;
import net.sourceforge.plantuml.statediagram.StateDiagram;
import net.sourceforge.plantuml.xmi.IXmiClassDiagram;
import net.sourceforge.plantuml.xmi.XmiClassDiagramArgo;
import net.sourceforge.plantuml.xmi.XmiClassDiagramStandard;
import net.sourceforge.plantuml.xmi.XmiClassDiagramStar;
import net.sourceforge.plantuml.xmi.XmiDescriptionDiagram;
import net.sourceforge.plantuml.xmi.XmiStateDiagram;

public final class CucaDiagramXmiMaker {
    private final CucaDiagram diagram;
    private final FileFormat fileFormat;

    public CucaDiagramXmiMaker(CucaDiagram diagram, FileFormat fileFormat) throws IOException {
        this.diagram = diagram;
        this.fileFormat = fileFormat;
    }

    public static String getModel(UmlDiagram classDiagram) {
        return "model1";
    }

    public void createFiles(OutputStream fos) throws IOException {
        try {
            IXmiClassDiagram xmi;
            if (this.diagram instanceof StateDiagram) {
                xmi = new XmiStateDiagram((StateDiagram)this.diagram);
            } else if (this.diagram instanceof DescriptionDiagram) {
                xmi = new XmiDescriptionDiagram((DescriptionDiagram)this.diagram);
            } else if (this.fileFormat == FileFormat.XMI_STANDARD) {
                xmi = new XmiClassDiagramStandard((ClassDiagram)this.diagram);
            } else if (this.fileFormat == FileFormat.XMI_ARGO) {
                xmi = new XmiClassDiagramArgo((ClassDiagram)this.diagram);
            } else if (this.fileFormat == FileFormat.XMI_STAR) {
                xmi = new XmiClassDiagramStar((ClassDiagram)this.diagram);
            } else {
                throw new UnsupportedOperationException();
            }
            xmi.transformerXml(fos);
        }
        catch (ParserConfigurationException e) {
            Log.error(e.toString());
            Logme.error(e);
            throw new IOException(e.toString());
        }
        catch (TransformerException e) {
            Log.error(e.toString());
            Logme.error(e);
            throw new IOException(e.toString());
        }
    }
}

