/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.core;

import java.util.HashMap;
import java.util.Map;
import org.protege.editor.core.Disposable;
import org.protege.editor.core.ModelManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractModelManager
implements ModelManager {
    private final Logger logger = LoggerFactory.getLogger(AbstractModelManager.class);
    private Map<Object, Disposable> objects = new HashMap<Object, Disposable>();

    protected AbstractModelManager() {
    }

    @Override
    public <T extends Disposable> void put(Object key, T object) {
        this.objects.put(key, object);
    }

    @Override
    public <T extends Disposable> T get(Object key) {
        return (T)this.objects.get(key);
    }

    @Override
    public void dispose() {
        for (Disposable object : this.objects.values()) {
            try {
                object.dispose();
            }
            catch (Exception e) {
                this.logger.error("An error occurred whilst disposing of a model manager object.  Object: {}", (Object)object, (Object)e);
            }
        }
        this.objects.clear();
    }
}

