/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.rdf.rdfxml.renderer;

import java.util.EnumMap;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.model.parameters.ConfigurationOptions;

public final class XMLWriterPreferences {
    @Nonnull
    private static final XMLWriterPreferences INSTANCE = new XMLWriterPreferences();
    private EnumMap<ConfigurationOptions, Object> overrides = new EnumMap(ConfigurationOptions.class);

    private XMLWriterPreferences() {
    }

    @Nonnull
    public synchronized XMLWriterPreferences copy() {
        XMLWriterPreferences p = new XMLWriterPreferences();
        p.overrides.putAll(this.overrides);
        return p;
    }

    public static XMLWriterPreferences getInstance() {
        return INSTANCE;
    }

    public boolean isUseNamespaceEntities() {
        return ConfigurationOptions.USE_NAMESPACE_ENTITIES.getValue(Boolean.class, this.overrides);
    }

    public void setUseNamespaceEntities(boolean useNamespaceEntities) {
        this.overrides.put(ConfigurationOptions.USE_NAMESPACE_ENTITIES, (Object)useNamespaceEntities);
    }

    public boolean isIndenting() {
        return ConfigurationOptions.INDENTING.getValue(Boolean.class, this.overrides);
    }

    public void setIndenting(boolean indenting) {
        this.overrides.put(ConfigurationOptions.INDENTING, (Object)indenting);
    }

    public int getIndentSize() {
        return ConfigurationOptions.INDENT_SIZE.getValue(Integer.class, this.overrides);
    }

    public void setIndentSize(int indentSize) {
        this.overrides.put(ConfigurationOptions.INDENT_SIZE, (Object)indentSize);
    }

    public void setLabelsAsBanner(boolean labelsAsBanner) {
        this.overrides.put(ConfigurationOptions.LABELS_AS_BANNER, (Object)labelsAsBanner);
    }

    public boolean isLabelsAsBanner() {
        return ConfigurationOptions.LABELS_AS_BANNER.getValue(Boolean.class, this.overrides);
    }

    public void setBannersEnabled(boolean bannersEnabled) {
        this.overrides.put(ConfigurationOptions.BANNERS_ENABLED, (Object)bannersEnabled);
    }

    public boolean isBannersEnabled() {
        return ConfigurationOptions.BANNERS_ENABLED.getValue(Boolean.class, this.overrides);
    }
}

