/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.plugins.parser.m2;

import java.io.BufferedInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.ivy.core.IvyPatternHelper;
import org.apache.ivy.core.module.descriptor.License;
import org.apache.ivy.core.module.id.ModuleId;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.plugins.parser.m2.PomDependencyMgt;
import org.apache.ivy.plugins.repository.Resource;
import org.apache.ivy.util.XMLHelper;
import org.apache.ivy.util.url.URLHandlerRegistry;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class PomReader {
    private HashMap properties = new HashMap();
    private final Element projectElement;
    private final Element parentElement;

    public PomReader(URL object, Resource resource) throws IOException, SAXException {
        AddDTDFilterInputStream addDTDFilterInputStream = new AddDTDFilterInputStream(URLHandlerRegistry.getDefault().openStream((URL)object));
        InputSource inputSource = new InputSource(addDTDFilterInputStream);
        inputSource.setSystemId(XMLHelper.toSystemId((URL)object));
        try {
            object = XMLHelper.parseToDom(inputSource, new EntityResolver(){

                @Override
                public InputSource resolveEntity(String string, String string2) throws SAXException, IOException {
                    if (string2 != null && string2.endsWith("m2-entities.ent")) {
                        return new InputSource(PomReader.class.getResourceAsStream("m2-entities.ent"));
                    }
                    return null;
                }
            });
            this.projectElement = object.getDocumentElement();
            if (!"project".equals(this.projectElement.getNodeName()) && !"model".equals(this.projectElement.getNodeName())) {
                throw new SAXParseException("project must be the root tag", resource.getName(), resource.getName(), 0, 0);
            }
            this.parentElement = PomReader.getFirstChildElement(this.projectElement, "parent");
        }
        catch (Throwable throwable) {
            try {
                ((InputStream)addDTDFilterInputStream).close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            ((InputStream)addDTDFilterInputStream).close();
            return;
        }
        catch (IOException iOException) {
            return;
        }
    }

    public boolean hasParent() {
        return this.parentElement != null;
    }

    public void setProperty(String string, String string2) {
        if (!this.properties.containsKey(string) && string2 != null) {
            this.properties.put(string, string2);
        }
    }

    public String getGroupId() {
        String string = PomReader.getFirstChildText(this.projectElement, "groupId");
        if (string == null) {
            string = PomReader.getFirstChildText(this.parentElement, "groupId");
        }
        return this.replaceProps(string);
    }

    public String getParentGroupId() {
        String string = PomReader.getFirstChildText(this.parentElement, "groupId");
        if (string == null) {
            string = PomReader.getFirstChildText(this.projectElement, "groupId");
        }
        return this.replaceProps(string);
    }

    public String getArtifactId() {
        String string = PomReader.getFirstChildText(this.projectElement, "artifactId");
        if (string == null) {
            string = PomReader.getFirstChildText(this.parentElement, "artifactId");
        }
        return this.replaceProps(string);
    }

    public String getParentArtifactId() {
        String string = PomReader.getFirstChildText(this.parentElement, "artifactId");
        if (string == null) {
            string = PomReader.getFirstChildText(this.projectElement, "artifactId");
        }
        return this.replaceProps(string);
    }

    public String getVersion() {
        String string = PomReader.getFirstChildText(this.projectElement, "version");
        if (string == null) {
            string = PomReader.getFirstChildText(this.parentElement, "version");
        }
        return this.replaceProps(string);
    }

    public String getParentVersion() {
        String string = PomReader.getFirstChildText(this.parentElement, "version");
        if (string == null) {
            string = PomReader.getFirstChildText(this.projectElement, "version");
        }
        return this.replaceProps(string);
    }

    public String getPackaging() {
        String string = PomReader.getFirstChildText(this.projectElement, "packaging");
        if (string == null) {
            string = "jar";
        }
        return string;
    }

    public String getHomePage() {
        String string = PomReader.getFirstChildText(this.projectElement, "url");
        if (string == null) {
            string = "";
        }
        return string;
    }

    public String getDescription() {
        String string = PomReader.getFirstChildText(this.projectElement, "description");
        if (string == null) {
            string = "";
        }
        return string.trim();
    }

    public License[] getLicenses() {
        Element element = PomReader.getFirstChildElement(this.projectElement, "licenses");
        if (element == null) {
            return new License[0];
        }
        element.normalize();
        ArrayList<License> arrayList = new ArrayList<License>();
        for (Object object : PomReader.getAllChilds(element)) {
            if (!"license".equals(object.getNodeName())) continue;
            String string = PomReader.getFirstChildText((Element)object, "name");
            object = PomReader.getFirstChildText((Element)object, "url");
            if (string == null && object == null) continue;
            if (string == null) {
                string = "Unknown License";
            }
            arrayList.add(new License(string, (String)object));
        }
        ArrayList<License> arrayList2 = arrayList;
        return arrayList2.toArray(new License[arrayList2.size()]);
    }

    public ModuleRevisionId getRelocation() {
        Object object = PomReader.getFirstChildElement(this.projectElement, "distributionManagement");
        if ((object = PomReader.getFirstChildElement((Element)object, "relocation")) == null) {
            return null;
        }
        String string = PomReader.getFirstChildText((Element)object, "groupId");
        String string2 = PomReader.getFirstChildText((Element)object, "artifactId");
        object = PomReader.getFirstChildText((Element)object, "version");
        string = string == null ? this.getGroupId() : string;
        string2 = string2 == null ? this.getArtifactId() : string2;
        object = object == null ? this.getVersion() : object;
        return ModuleRevisionId.newInstance(string, string2, (String)object);
    }

    public List getDependencies() {
        Object object = PomReader.getFirstChildElement(this.projectElement, "dependencies");
        LinkedList<PomDependencyData> linkedList = new LinkedList<PomDependencyData>();
        if (object != null) {
            object = object.getChildNodes();
            for (int i = 0; i < object.getLength(); ++i) {
                Node node = object.item(i);
                if (!(node instanceof Element) || !"dependency".equals(node.getNodeName())) continue;
                linkedList.add(new PomDependencyData((Element)node));
            }
        }
        return linkedList;
    }

    public List getDependencyMgt() {
        Object object = PomReader.getFirstChildElement(this.projectElement, "dependencyManagement");
        object = PomReader.getFirstChildElement((Element)object, "dependencies");
        LinkedList<PomDependencyMgtElement> linkedList = new LinkedList<PomDependencyMgtElement>();
        if (object != null) {
            object = object.getChildNodes();
            for (int i = 0; i < object.getLength(); ++i) {
                Node node = object.item(i);
                if (!(node instanceof Element) || !"dependency".equals(node.getNodeName())) continue;
                linkedList.add(new PomDependencyMgtElement((Element)node));
            }
        }
        return linkedList;
    }

    public List getPlugins() {
        LinkedList<PomPluginElement> linkedList = new LinkedList<PomPluginElement>();
        Object object = PomReader.getFirstChildElement(this.projectElement, "build");
        if (object == null) {
            return linkedList;
        }
        if ((object = PomReader.getFirstChildElement((Element)object, "plugins")) != null) {
            object = object.getChildNodes();
            for (int i = 0; i < object.getLength(); ++i) {
                Node node = object.item(i);
                if (!(node instanceof Element) || !"plugin".equals(node.getNodeName())) continue;
                linkedList.add(new PomPluginElement((Element)node));
            }
        }
        return linkedList;
    }

    public Map getPomProperties() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Element element = PomReader.getFirstChildElement(this.projectElement, "properties");
        if (element != null) {
            element.normalize();
        }
        for (Element element2 : PomReader.getAllChilds(element)) {
            hashMap.put(element2.getNodeName(), PomReader.getTextContent(element2));
        }
        return hashMap;
    }

    private String replaceProps(String string) {
        if (string == null) {
            return null;
        }
        return IvyPatternHelper.substituteVariables(string, this.properties).trim();
    }

    private static String getTextContent(Element object) {
        StringBuffer stringBuffer = new StringBuffer();
        object = object.getChildNodes();
        for (int i = 0; i < object.getLength(); ++i) {
            Node node = object.item(i);
            switch (node.getNodeType()) {
                case 3: 
                case 4: {
                    stringBuffer.append(node.getNodeValue());
                }
            }
        }
        return stringBuffer.toString();
    }

    private static String getFirstChildText(Element element, String string) {
        if ((element = PomReader.getFirstChildElement(element, string)) != null) {
            return PomReader.getTextContent(element);
        }
        return null;
    }

    private static Element getFirstChildElement(Element object, String string) {
        if (object == null) {
            return null;
        }
        object = object.getChildNodes();
        for (int i = 0; i < object.getLength(); ++i) {
            Node node = object.item(i);
            if (!(node instanceof Element) || !string.equals(node.getNodeName())) continue;
            return (Element)node;
        }
        return null;
    }

    private static List getAllChilds(Element object) {
        LinkedList<Node> linkedList = new LinkedList<Node>();
        if (object != null) {
            object = object.getChildNodes();
            for (int i = 0; i < object.getLength(); ++i) {
                Node node = object.item(i);
                if (!(node instanceof Element)) continue;
                linkedList.add(node);
            }
        }
        return linkedList;
    }

    private static final class AddDTDFilterInputStream
    extends FilterInputStream {
        private int count;
        private byte[] prefix = "<!DOCTYPE project SYSTEM \"m2-entities.ent\">\n".getBytes();

        private AddDTDFilterInputStream(InputStream inputStream) throws IOException {
            super(new BufferedInputStream(inputStream));
            this.in.mark(10000);
            int n = this.in.read();
            int n2 = this.in.read();
            int n3 = this.in.read();
            if (n == 239 && n2 == 187 && n3 == 191) {
                this.in.mark(10000);
            } else {
                this.in.reset();
            }
            n = 0;
            Object object = new LineNumberReader(new InputStreamReader(this.in, "UTF-8"), 100);
            object = ((LineNumberReader)object).readLine();
            if (object != null) {
                if (((String)(object = ((String)object).trim())).startsWith("<?xml ")) {
                    n = ((String)object).indexOf("?>");
                    String string = ((String)object).substring(0, n + 2);
                    this.prefix = (string + "\n<!DOCTYPE project SYSTEM \"m2-entities.ent\">\n").getBytes();
                    n = string.getBytes().length;
                }
            } else {
                this.prefix = new byte[0];
            }
            this.in.reset();
            for (int i = 0; i < n; ++i) {
                this.in.read();
            }
        }

        @Override
        public final int read() throws IOException {
            if (this.count < this.prefix.length) {
                return this.prefix[this.count++];
            }
            int n = super.read();
            return n;
        }

        @Override
        public final int read(byte[] byArray, int n, int n2) throws IOException {
            if (byArray == null) {
                throw new NullPointerException();
            }
            if (n < 0 || n > byArray.length || n2 < 0 || n + n2 > byArray.length || n + n2 < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (n2 == 0) {
                return 0;
            }
            int n3 = 0;
            if (this.count < this.prefix.length) {
                n3 = Math.min(this.prefix.length - this.count, n2);
                System.arraycopy(this.prefix, this.count, byArray, n, n3);
            }
            if (n3 < n2) {
                n3 += this.in.read(byArray, n + n3, n2 - n3);
            }
            this.count += n3;
            return n3;
        }
    }

    public class PomDependencyData
    extends PomDependencyMgtElement {
        private final Element depElement;

        public PomDependencyData(PomDependencyData pomDependencyData) {
            this(pomDependencyData.depElement);
        }

        PomDependencyData(Element element) {
            super(element);
            this.depElement = element;
        }

        @Override
        public String getScope() {
            String string = PomReader.getFirstChildText(this.depElement, "scope");
            return PomReader.this.replaceProps(string);
        }

        public String getClassifier() {
            String string = PomReader.getFirstChildText(this.depElement, "classifier");
            return PomReader.this.replaceProps(string);
        }

        public String getType() {
            String string = PomReader.getFirstChildText(this.depElement, "type");
            return PomReader.this.replaceProps(string);
        }

        public boolean isOptional() {
            Element element = PomReader.getFirstChildElement(this.depElement, "optional");
            return element != null && "true".equalsIgnoreCase(PomReader.getTextContent(element));
        }
    }

    public class PomPluginElement
    implements PomDependencyMgt {
        private Element pluginElement;

        PomPluginElement(Element element) {
            this.pluginElement = element;
        }

        @Override
        public String getGroupId() {
            String string = PomReader.getFirstChildText(this.pluginElement, "groupId");
            return PomReader.this.replaceProps(string);
        }

        @Override
        public String getArtifactId() {
            String string = PomReader.getFirstChildText(this.pluginElement, "artifactId");
            return PomReader.this.replaceProps(string);
        }

        @Override
        public String getVersion() {
            String string = PomReader.getFirstChildText(this.pluginElement, "version");
            return PomReader.this.replaceProps(string);
        }

        @Override
        public String getScope() {
            return null;
        }

        @Override
        public List getExcludedModules() {
            return Collections.EMPTY_LIST;
        }
    }

    public class PomDependencyMgtElement
    implements PomDependencyMgt {
        private final Element depElement;

        public PomDependencyMgtElement(PomDependencyMgtElement pomDependencyMgtElement) {
            this(pomDependencyMgtElement.depElement);
        }

        PomDependencyMgtElement(Element element) {
            this.depElement = element;
        }

        @Override
        public String getGroupId() {
            String string = PomReader.getFirstChildText(this.depElement, "groupId");
            return PomReader.this.replaceProps(string);
        }

        @Override
        public String getArtifactId() {
            String string = PomReader.getFirstChildText(this.depElement, "artifactId");
            return PomReader.this.replaceProps(string);
        }

        @Override
        public String getVersion() {
            String string = PomReader.getFirstChildText(this.depElement, "version");
            return PomReader.this.replaceProps(string);
        }

        @Override
        public String getScope() {
            String string = PomReader.getFirstChildText(this.depElement, "scope");
            return PomReader.this.replaceProps(string);
        }

        @Override
        public List getExcludedModules() {
            Object object = PomReader.getFirstChildElement(this.depElement, "exclusions");
            LinkedList<ModuleId> linkedList = new LinkedList<ModuleId>();
            if (object != null) {
                object = object.getChildNodes();
                for (int i = 0; i < object.getLength(); ++i) {
                    Object object2 = object.item(i);
                    if (!(object2 instanceof Element) || !"exclusion".equals(object2.getNodeName())) continue;
                    String string = PomReader.getFirstChildText((Element)object2, "groupId");
                    object2 = PomReader.getFirstChildText((Element)object2, "artifactId");
                    if (string == null || object2 == null) continue;
                    linkedList.add(ModuleId.newInstance(string, (String)object2));
                }
            }
            return linkedList;
        }
    }
}

