/*
 * Decompiled with CFR 0.152.
 */
package scala.collection;

import java.io.Serializable;
import java.util.NoSuchElementException;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Tuple2;
import scala.collection.AbstractIterator;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator$;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.immutable.ArraySeq;
import scala.collection.immutable.ArraySeq$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.HashSet;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyBoolean;
import scala.runtime.LazyInt;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

public interface Iterator<A>
extends IterableOnce<A>,
IterableOnceOps<A, Iterator, Iterator<A>> {
    public boolean hasNext();

    public A next() throws NoSuchElementException;

    public static /* synthetic */ Iterator iterator$(Iterator $this) {
        return $this.iterator();
    }

    @Override
    default public Iterator<A> iterator() {
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public static /* synthetic */ GroupedIterator grouped$(Iterator $this, int size) {
        void var1_1;
        return $this.grouped((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    default public <B> GroupedIterator<B> grouped(int size) {
        void var1_1;
        Iterator iterator = this;
        void v1 = var1_1;
        return new GroupedIterator(iterator, iterator, (int)v1, (int)v1);
    }

    /*
     * WARNING - void declaration
     */
    public static /* synthetic */ GroupedIterator sliding$(Iterator $this, int size, int step) {
        void var2_2;
        void var1_1;
        return $this.sliding((int)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    default public <B> GroupedIterator<B> sliding(int size, int step) {
        void var2_2;
        void var1_1;
        Iterator iterator = this;
        return new GroupedIterator(iterator, iterator, (int)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static /* synthetic */ int indexWhere$(Iterator $this, Function1 p, int from) {
        void var2_2;
        void var1_1;
        return $this.indexWhere((Function1)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    default public int indexWhere(Function1<A, Object> p, int from) {
        void var2_2;
        int i = Math.max(from, 0);
        this.drop((int)var2_2);
        while (this.hasNext()) {
            if (BoxesRunTime.unboxToBoolean(p.apply(this.next()))) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static /* synthetic */ boolean isEmpty$(Iterator $this) {
        return $this.isEmpty();
    }

    @Override
    default public boolean isEmpty() {
        return !this.hasNext();
    }

    /*
     * WARNING - void declaration
     */
    public static /* synthetic */ Iterator filter$(Iterator $this, Function1 p) {
        void var1_1;
        return $this.filter((Function1)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    default public Iterator<A> filter(Function1<A, Object> p) {
        void var1_1;
        return this.filterImpl((Function1<A, Object>)var1_1, false);
    }

    /*
     * WARNING - void declaration
     */
    public static /* synthetic */ Iterator filterImpl$(Iterator $this, Function1 p, boolean isFlipped) {
        void var2_2;
        void var1_1;
        return $this.filterImpl((Function1)var1_1, (boolean)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    default public Iterator<A> filterImpl(Function1<A, Object> p, boolean isFlipped) {
        void var2_2;
        void var1_1;
        return new AbstractIterator<A>(this, (Function1)var1_1, (boolean)var2_2){
            private A hd;
            private boolean hdDefined;
            private final /* synthetic */ Iterator $outer;
            private final Function1 p$1;
            private final boolean isFlipped$1;

            public final boolean hasNext() {
                if (!this.hdDefined) {
                    if (!this.$outer.hasNext()) {
                        return false;
                    }
                    this.hd = this.$outer.next();
                    while (BoxesRunTime.unboxToBoolean(this.p$1.apply(this.hd)) == this.isFlipped$1) {
                        if (!this.$outer.hasNext()) {
                            return false;
                        }
                        this.hd = this.$outer.next();
                    }
                    this.hdDefined = true;
                }
                return true;
            }

            public final A next() {
                if (this.hasNext()) {
                    this.hdDefined = false;
                    return this.hd;
                }
                return (A)Iterator$.scala$collection$Iterator$$_empty.next();
            }
            {
                void var3_3;
                void var2_2;
                void var1_1;
                if ($outer == null) {
                    throw null;
                }
                this.$outer = var1_1;
                this.p$1 = var2_2;
                this.isFlipped$1 = var3_3;
                this.hdDefined = false;
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    public static /* synthetic */ Iterator withFilter$(Iterator $this, Function1 p) {
        void var1_1;
        return $this.withFilter((Function1)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    default public Iterator<A> withFilter(Function1<A, Object> p) {
        void var1_1;
        return this.filter((Function1<A, Object>)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static /* synthetic */ Iterator collect$(Iterator $this, PartialFunction pf) {
        void var1_1;
        return $this.collect((PartialFunction)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    default public <B> Iterator<B> collect(PartialFunction<A, B> pf) {
        void var1_1;
        return new AbstractIterator<B>(this, (PartialFunction)var1_1){
            private B hd;
            private int status;
            private final /* synthetic */ Iterator $outer;
            private final PartialFunction pf$1;

            /*
             * WARNING - void declaration
             */
            public final boolean hasNext() {
                Object marker = Statics.pfMarker;
                while (this.status == 0) {
                    if (this.$outer.hasNext()) {
                        void var2_2;
                        A x2 = this.$outer.next();
                        B1 v = this.pf$1.applyOrElse(x2, (Function1<Object, Object> & Serializable)x -> marker);
                        if (marker == v) continue;
                        this.hd = var2_2;
                        this.status = 1;
                        continue;
                    }
                    this.status = -1;
                }
                return this.status == 1;
            }

            public final B next() {
                if (this.hasNext()) {
                    this.status = 0;
                    return this.hd;
                }
                return (B)Iterator$.scala$collection$Iterator$$_empty.next();
            }
            {
                void var2_2;
                void var1_1;
                if ($outer == null) {
                    throw null;
                }
                this.$outer = var1_1;
                this.pf$1 = var2_2;
                this.status = 0;
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    public static /* synthetic */ Iterator distinctBy$(Iterator $this, Function1 f) {
        void var1_1;
        return $this.distinctBy((Function1)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    default public <B> Iterator<A> distinctBy(Function1<A, B> f) {
        void var1_1;
        return new AbstractIterator<A>(this, (Function1)var1_1){
            private final HashSet<B> traversedValues;
            private boolean nextElementDefined;
            private A nextElement;
            private final /* synthetic */ Iterator $outer;
            private final Function1 f$1;

            /*
             * WARNING - void declaration
             */
            public final boolean hasNext() {
                block2: {
                    while (!this.nextElementDefined) {
                        if (this.$outer.hasNext()) {
                            void var1_1;
                            A a = this.$outer.next();
                            if (!this.traversedValues.add(this.f$1.apply(a))) continue;
                            this.nextElement = var1_1;
                            this.nextElementDefined = true;
                            break;
                        }
                        break block2;
                    }
                    return true;
                }
                return false;
            }

            public final A next() {
                if (this.hasNext()) {
                    this.nextElementDefined = false;
                    return this.nextElement;
                }
                return (A)Iterator$.scala$collection$Iterator$$_empty.next();
            }
            {
                void var2_2;
                void var1_1;
                if ($outer == null) {
                    throw null;
                }
                this.$outer = var1_1;
                this.f$1 = var2_2;
                this.traversedValues = new HashSet<A>();
                this.nextElementDefined = false;
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    public static /* synthetic */ Iterator map$(Iterator $this, Function1 f) {
        void var1_1;
        return $this.map((Function1)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    default public <B> Iterator<B> map(Function1<A, B> f) {
        void var1_1;
        return new AbstractIterator<B>(this, (Function1)var1_1){
            private final /* synthetic */ Iterator $outer;
            private final Function1 f$2;

            public final int knownSize() {
                return this.$outer.knownSize();
            }

            public final boolean hasNext() {
                return this.$outer.hasNext();
            }

            public final B next() {
                return (B)this.f$2.apply(this.$outer.next());
            }
            {
                void var2_2;
                void var1_1;
                if ($outer == null) {
                    throw null;
                }
                this.$outer = var1_1;
                this.f$2 = var2_2;
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    public static /* synthetic */ Iterator flatMap$(Iterator $this, Function1 f) {
        void var1_1;
        return $this.flatMap((Function1)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    default public <B> Iterator<B> flatMap(Function1<A, IterableOnce<B>> f) {
        void var1_1;
        return new AbstractIterator<B>(this, (Function1)var1_1){
            private Iterator<B> cur;
            private int _hasNext;
            private final /* synthetic */ Iterator $outer;
            private final Function1 f$3;

            private void nextCur() {
                this.cur = null;
                this.cur = ((IterableOnce)this.f$3.apply(this.$outer.next())).iterator();
                this._hasNext = -1;
            }

            public final boolean hasNext() {
                if (this._hasNext == -1) {
                    while (!this.cur.hasNext()) {
                        if (!this.$outer.hasNext()) {
                            this._hasNext = 0;
                            this.cur = Iterator$.scala$collection$Iterator$$_empty;
                            return false;
                        }
                        this.nextCur();
                    }
                    this._hasNext = 1;
                    return true;
                }
                return this._hasNext == 1;
            }

            public final B next() {
                if (this.hasNext()) {
                    this._hasNext = -1;
                }
                return this.cur.next();
            }
            {
                void var2_2;
                void var1_1;
                if ($outer == null) {
                    throw null;
                }
                this.$outer = var1_1;
                this.f$3 = var2_2;
                this.cur = Iterator$.scala$collection$Iterator$$_empty;
                this._hasNext = -1;
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    public static /* synthetic */ Iterator flatten$(Iterator $this, Function1 ev) {
        void var1_1;
        return $this.flatten((Function1)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    default public <B> Iterator<B> flatten(Function1<A, IterableOnce<B>> ev) {
        void var1_1;
        return this.flatMap((Function1<A, IterableOnce<B>>)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static /* synthetic */ Iterator concat$(Iterator $this, Function0 xs) {
        void var1_1;
        return $this.concat((Function0)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    default public <B> Iterator<B> concat(Function0<IterableOnce<B>> xs) {
        void var1_1;
        return new ConcatIterator(this).concat(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static /* synthetic */ Iterator $plus$plus$(Iterator $this, Function0 xs) {
        void var1_1;
        return $this.$plus$plus((Function0)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    default public <B> Iterator<B> $plus$plus(Function0<IterableOnce<B>> xs) {
        void var1_1;
        return this.concat((Function0<IterableOnce<B>>)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static /* synthetic */ Iterator take$(Iterator $this, int n) {
        void var1_1;
        return $this.take((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    default public Iterator<A> take(int n) {
        void var1_1;
        return this.sliceIterator(0, Math.max((int)var1_1, 0));
    }

    /*
     * WARNING - void declaration
     */
    public static /* synthetic */ Iterator takeWhile$(Iterator $this, Function1 p) {
        void var1_1;
        return $this.takeWhile((Function1)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    default public Iterator<A> takeWhile(Function1<A, Object> p) {
        void var1_1;
        return new AbstractIterator<A>(this, (Function1)var1_1){
            private A hd;
            private boolean hdDefined;
            private Iterator<A> tail;
            private final Function1 p$2;

            public final boolean hasNext() {
                block6: {
                    block5: {
                        if (this.hdDefined) break block5;
                        if (!this.tail.hasNext()) break block6;
                        this.hd = this.tail.next();
                        if (BoxesRunTime.unboxToBoolean(this.p$2.apply(this.hd))) {
                            this.hdDefined = true;
                        } else {
                            this.tail = Iterator$.scala$collection$Iterator$$_empty;
                        }
                        if (!this.hdDefined) break block6;
                    }
                    return true;
                }
                return false;
            }

            public final A next() {
                if (this.hasNext()) {
                    this.hdDefined = false;
                    return this.hd;
                }
                return (A)Iterator$.scala$collection$Iterator$$_empty.next();
            }
            {
                void var1_1;
                void var2_2;
                this.p$2 = var2_2;
                this.hdDefined = false;
                this.tail = var1_1;
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    public static /* synthetic */ Iterator drop$(Iterator $this, int n) {
        void var1_1;
        return $this.drop((int)var1_1);
    }

    default public Iterator<A> drop(int n) {
        for (int i = 0; i < n && this.hasNext(); ++i) {
            this.next();
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public static /* synthetic */ Iterator dropWhile$(Iterator $this, Function1 p) {
        void var1_1;
        return $this.dropWhile((Function1)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    default public Iterator<A> dropWhile(Function1<A, Object> p) {
        void var1_1;
        return new AbstractIterator<A>(this, (Function1)var1_1){
            private int status;
            private A fst;
            private final /* synthetic */ Iterator $outer;
            private final Function1 p$3;

            /*
             * WARNING - void declaration
             */
            public final boolean hasNext() {
                if (this.status == 1) {
                    return this.$outer.hasNext();
                }
                if (this.status == 0) {
                    return true;
                }
                while (this.$outer.hasNext()) {
                    void var1_1;
                    A a = this.$outer.next();
                    if (BoxesRunTime.unboxToBoolean(this.p$3.apply(a))) continue;
                    this.fst = var1_1;
                    this.status = 0;
                    return true;
                }
                this.status = 1;
                return false;
            }

            public final A next() {
                if (this.hasNext()) {
                    if (this.status == 1) {
                        return this.$outer.next();
                    }
                    this.status = 1;
                    return this.fst;
                }
                return (A)Iterator$.scala$collection$Iterator$$_empty.next();
            }
            {
                void var2_2;
                void var1_1;
                if ($outer == null) {
                    throw null;
                }
                this.$outer = var1_1;
                this.p$3 = var2_2;
                this.status = -1;
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    public static /* synthetic */ Iterator sliceIterator$(Iterator $this, int from, int until) {
        void var2_2;
        void var1_1;
        return $this.sliceIterator((int)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    default public Iterator<A> sliceIterator(int from, int until) {
        void var1_1;
        void var2_2;
        int rest;
        int n = Math.max(from, 0);
        if ((until < 0 ? -1 : (rest = until <= n ? 0 : var2_2 - n)) == 0) {
            return Iterator$.scala$collection$Iterator$$_empty;
        }
        return new SliceIterator(this, n, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static /* synthetic */ Iterator zip$(Iterator $this, IterableOnce that) {
        void var1_1;
        return $this.zip((IterableOnce)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    default public <B> Iterator<Tuple2<A, B>> zip(IterableOnce<B> that) {
        void var1_1;
        return new AbstractIterator<Tuple2<A, B>>(this, (IterableOnce)var1_1){
            private final Iterator<B> thatIterator;
            private final /* synthetic */ Iterator $outer;

            private Iterator<B> thatIterator() {
                return this.thatIterator;
            }

            /*
             * WARNING - void declaration
             */
            public final int knownSize() {
                void var2_2;
                int n = this.$outer.knownSize();
                int min$extension_that = this.thatIterator().knownSize();
                return Math.min(n, (int)var2_2);
            }

            public final boolean hasNext() {
                return this.$outer.hasNext() && this.thatIterator().hasNext();
            }

            public final Tuple2<A, B> next() {
                return new Tuple2<A, B>(this.$outer.next(), this.thatIterator().next());
            }
            {
                void var2_2;
                void var1_1;
                if ($outer == null) {
                    throw null;
                }
                this.$outer = var1_1;
                this.thatIterator = var2_2.iterator();
            }
        };
    }

    public static /* synthetic */ Iterator zipWithIndex$(Iterator $this) {
        return $this.zipWithIndex();
    }

    default public Iterator<Tuple2<A, Object>> zipWithIndex() {
        return new AbstractIterator<Tuple2<A, Object>>(this){
            private int idx;
            private final /* synthetic */ Iterator $outer;

            private int idx() {
                return this.idx;
            }

            /*
             * WARNING - void declaration
             */
            private void idx_$eq(int x$1) {
                void var1_1;
                this.idx = var1_1;
            }

            public final int knownSize() {
                return this.$outer.knownSize();
            }

            public final boolean hasNext() {
                return this.$outer.hasNext();
            }

            /*
             * WARNING - void declaration
             */
            public final Tuple2<A, Object> next() {
                void var1_1;
                Tuple2<A, Integer> ret = new Tuple2<A, Integer>(this.$outer.next(), this.idx());
                $anon$16 v0 = this;
                v0.idx_$eq(v0.idx() + 1);
                return var1_1;
            }
            {
                void var1_1;
                if ($outer == null) {
                    throw null;
                }
                this.$outer = var1_1;
                this.idx = 0;
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    public static /* synthetic */ boolean sameElements$(Iterator $this, IterableOnce that) {
        void var1_1;
        return $this.sameElements((IterableOnce)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    default public <B> boolean sameElements(IterableOnce<B> that) {
        void var1_1;
        Iterator<B> those = that.iterator();
        while (this.hasNext() && those.hasNext()) {
            if (BoxesRunTime.equals(this.next(), those.next())) continue;
            return false;
        }
        return this.hasNext() == var1_1.hasNext();
    }

    public static /* synthetic */ String toString$(Iterator $this) {
        return $this.toString();
    }

    default public String toString() {
        return "<iterator>";
    }

    private static final class ConcatIterator<A>
    extends AbstractIterator<A> {
        private Iterator<A> current;
        private ConcatIteratorCell<A> tail;
        private ConcatIteratorCell<A> last;
        private boolean currentHasNextChecked;

        private Iterator<A> current() {
            return this.current;
        }

        /*
         * WARNING - void declaration
         */
        private void current_$eq(Iterator<A> x$1) {
            void var1_1;
            this.current = var1_1;
        }

        private ConcatIteratorCell<A> tail() {
            return this.tail;
        }

        /*
         * WARNING - void declaration
         */
        private void tail_$eq(ConcatIteratorCell<A> x$1) {
            void var1_1;
            this.tail = var1_1;
        }

        private ConcatIteratorCell<A> last() {
            return this.last;
        }

        /*
         * WARNING - void declaration
         */
        private void last_$eq(ConcatIteratorCell<A> x$1) {
            void var1_1;
            this.last = var1_1;
        }

        private boolean currentHasNextChecked() {
            return this.currentHasNextChecked;
        }

        /*
         * WARNING - void declaration
         */
        private void currentHasNextChecked_$eq(boolean x$1) {
            void var1_1;
            this.currentHasNextChecked = var1_1;
        }

        @Override
        public final boolean hasNext() {
            if (this.currentHasNextChecked()) {
                return true;
            }
            if (this.current() == null) {
                return false;
            }
            if (this.current().hasNext()) {
                this.currentHasNextChecked_$eq(true);
                return true;
            }
            return this.advance$1();
        }

        @Override
        public final A next() {
            if (this.hasNext()) {
                this.currentHasNextChecked_$eq(false);
                return this.current().next();
            }
            return (A)Iterator$.scala$collection$Iterator$$_empty.next();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final <B> Iterator<B> concat(Function0<IterableOnce<B>> that) {
            ConcatIteratorCell c = new ConcatIteratorCell(that, null);
            if (this.tail() == null) {
                this.tail_$eq(c);
                this.last_$eq(c);
            } else {
                void var1_1;
                this.last().tail_$eq(c);
                this.last_$eq((ConcatIteratorCell<A>)var1_1);
            }
            if (this.current() == null) {
                this.current_$eq(Iterator$.scala$collection$Iterator$$_empty);
            }
            return this;
        }

        /*
         * WARNING - void declaration
         */
        private final void merge$1() {
            while (this.current() instanceof ConcatIterator) {
                void var1_1;
                ConcatIterator c = (ConcatIterator)this.current();
                this.current_$eq(c.current());
                this.currentHasNextChecked_$eq(c.currentHasNextChecked());
                if (c.tail() == null) continue;
                if (this.last() == null) {
                    this.last_$eq(c.last());
                }
                c.last().tail_$eq(this.tail());
                this.tail_$eq(super.tail());
            }
        }

        private final boolean advance$1() {
            do {
                if (this.tail() == null) {
                    this.current_$eq(null);
                    this.last_$eq(null);
                    return false;
                }
                ConcatIterator concatIterator = this;
                concatIterator.current_$eq(concatIterator.tail().headIterator());
                if (this.last() == this.tail()) {
                    ConcatIterator concatIterator2 = this;
                    concatIterator2.last_$eq(concatIterator2.last().tail());
                }
                ConcatIterator concatIterator3 = this;
                concatIterator3.tail_$eq(concatIterator3.tail().tail());
                this.merge$1();
                if (!this.currentHasNextChecked()) continue;
                return true;
            } while (this.current() == null || !this.current().hasNext());
            this.currentHasNextChecked_$eq(true);
            return true;
        }

        /*
         * WARNING - void declaration
         */
        public ConcatIterator(Iterator<A> current) {
            void var1_1;
            this.current = var1_1;
            this.tail = null;
            this.last = null;
            this.currentHasNextChecked = false;
        }
    }

    private static final class ConcatIteratorCell<A> {
        private final Function0<IterableOnce<A>> head;
        private ConcatIteratorCell<A> tail;

        public final ConcatIteratorCell<A> tail() {
            return this.tail;
        }

        /*
         * WARNING - void declaration
         */
        public final void tail_$eq(ConcatIteratorCell<A> x$1) {
            void var1_1;
            this.tail = var1_1;
        }

        public final Iterator<A> headIterator() {
            return this.head.apply().iterator();
        }

        /*
         * WARNING - void declaration
         */
        public ConcatIteratorCell(Function0<IterableOnce<A>> head, ConcatIteratorCell<A> tail) {
            void var2_2;
            void var1_1;
            this.head = var1_1;
            this.tail = var2_2;
        }
    }

    public class GroupedIterator<B>
    extends AbstractIterator<scala.collection.immutable.Seq<B>> {
        private final Iterator<B> self;
        private final int size;
        private final int step;
        private ArrayBuffer<B> buffer;
        private boolean filled;
        private boolean _partial;
        private Option<Function0<B>> pad;
        public final /* synthetic */ Iterator $outer;

        /*
         * WARNING - void declaration
         */
        private Seq<B> takeDestructively(int size) {
            void var2_2;
            ArrayBuffer<B> buf = new ArrayBuffer<B>();
            for (int i = 0; i < size && this.self.hasNext(); ++i) {
                B $plus$eq_elem = this.self.next();
                buf.addOne($plus$eq_elem);
            }
            return var2_2;
        }

        /*
         * WARNING - void declaration
         */
        private ArraySeq<B> padding(int x) {
            void var1_1;
            return (ArraySeq)ArraySeq$.MODULE$.untagged().fill((int)var1_1, (Function0<Object> & Serializable)() -> $this.pad.get().apply());
        }

        private int gap() {
            int n = this.step - this.size;
            return Math.max(n, 0);
        }

        /*
         * WARNING - void declaration
         */
        private boolean go(int count) {
            void var2_2;
            void var3_5;
            int n;
            void min$extension_that2;
            Seq xs;
            Seq seq;
            LazyInt len$lzy = new LazyInt();
            LazyBoolean incomplete$lzy = new LazyBoolean();
            ArrayBuffer<B> arrayBuffer = this.buffer;
            if (arrayBuffer == null) {
                throw null;
            }
            int n2 = arrayBuffer.length();
            Seq res = this.takeDestructively(count);
            int shortBy = count - res.length();
            if (shortBy > 0 && this.pad.isDefined()) {
                ArraySeq<B> $plus$plus_suffix = this.padding(shortBy);
                seq = (Seq)res.appendedAll($plus$plus_suffix);
            } else {
                seq = xs = res;
            }
            if (seq.isEmpty()) {
                return false;
            }
            if (this._partial) {
                count = GroupedIterator.len$1(len$lzy, xs);
                int min$extension_that2 = this.size;
                return this.deliver$1(Math.min(count, min$extension_that2), n2, xs, len$lzy);
            }
            if (GroupedIterator.incomplete$1((LazyBoolean)min$extension_that2, n, len$lzy, xs)) {
                return false;
            }
            if (GroupedIterator.isFirst$1(n2)) {
                return this.deliver$1(GroupedIterator.len$1(len$lzy, xs), n2, xs, len$lzy);
            }
            n = this.step;
            int min$extension_that2 = this.size;
            return this.deliver$1(Math.min(n, (int)var3_5), n2, xs, (LazyInt)var2_2);
        }

        private boolean fill() {
            if (!this.self.hasNext()) {
                return false;
            }
            if (this.buffer.isEmpty()) {
                GroupedIterator groupedIterator = this;
                return groupedIterator.go(groupedIterator.size);
            }
            GroupedIterator groupedIterator = this;
            return groupedIterator.go(groupedIterator.step);
        }

        @Override
        public boolean hasNext() {
            return this.filled || this.fill();
        }

        @Override
        public scala.collection.immutable.Seq<B> next() throws NoSuchElementException {
            if (!this.filled) {
                this.fill();
            }
            if (!this.filled) {
                throw new NoSuchElementException("next on empty iterator");
            }
            this.filled = false;
            return ArraySeq$.MODULE$.unsafeWrapArray(this.buffer.toArray(ClassTag$.MODULE$.Any()));
        }

        /*
         * WARNING - void declaration
         */
        public static final /* synthetic */ String $anonfun$new$1(GroupedIterator $this) {
            void var0_1;
            void var1_2;
            int arg$macro$1 = $this.size;
            int arg$macro$2 = $this.step;
            return StringOps$.MODULE$.format$extension("size=%d and step=%d, but both must be positive", ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{(int)var1_2, (int)var0_1}));
        }

        private static final boolean isFirst$1(int prevSize$1) {
            return prevSize$1 == 0;
        }

        /*
         * WARNING - void declaration
         */
        private static final /* synthetic */ int len$lzycompute$1(LazyInt len$lzy$1, Seq xs$1) {
            synchronized (len$lzy$1) {
                void var1_1;
                int n = len$lzy$1.initialized() ? len$lzy$1.value() : len$lzy$1.initialize(var1_1.length());
                return n;
            }
        }

        /*
         * WARNING - void declaration
         */
        private static final int len$1(LazyInt len$lzy$1, Seq xs$1) {
            void var1_1;
            LazyInt lazyInt;
            if (len$lzy$1.initialized()) {
                return len$lzy$1.value();
            }
            return GroupedIterator.len$lzycompute$1(lazyInt, (Seq)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        private static final /* synthetic */ boolean incomplete$lzycompute$1(LazyBoolean incomplete$lzy$1, int count$1, LazyInt len$lzy$1, Seq xs$1) {
            synchronized (incomplete$lzy$1) {
                int n;
                void var3_3;
                void var2_2;
                n = incomplete$lzy$1.initialized() ? incomplete$lzy$1.value() : incomplete$lzy$1.initialize(GroupedIterator.len$1((LazyInt)var2_2, (Seq)var3_3) < n);
                return n != 0;
            }
        }

        /*
         * WARNING - void declaration
         */
        private static final boolean incomplete$1(LazyBoolean incomplete$lzy$1, int count$1, LazyInt len$lzy$1, Seq xs$1) {
            void var3_3;
            void var2_2;
            void var1_1;
            LazyBoolean lazyBoolean;
            if (incomplete$lzy$1.initialized()) {
                return incomplete$lzy$1.value();
            }
            return GroupedIterator.incomplete$lzycompute$1(lazyBoolean, (int)var1_1, (LazyInt)var2_2, (Seq)var3_3);
        }

        /*
         * WARNING - void declaration
         */
        private final boolean deliver$1(int howMany, int prevSize$1, Seq xs$1, LazyInt len$lzy$1) {
            if (howMany > 0 && (GroupedIterator.isFirst$1(prevSize$1) || GroupedIterator.len$1(len$lzy$1, xs$1) > this.gap())) {
                void var1_2;
                void var3_4;
                int n;
                if (!GroupedIterator.isFirst$1(prevSize$1)) {
                    int n2 = this.step;
                    this.buffer.dropInPlace(Math.min(n2, prevSize$1));
                }
                if (GroupedIterator.isFirst$1(prevSize$1)) {
                    n = GroupedIterator.len$1(len$lzy$1, xs$1);
                } else {
                    void var2_3;
                    int min$extension_that = GroupedIterator.len$1(len$lzy$1, xs$1) - this.gap();
                    n = Math.min(howMany, (int)var2_3);
                }
                int available22 = n;
                ArrayBuffer<B> arrayBuffer = this.buffer;
                IterableOnce available22 = (IterableOnce)var3_4.takeRight(available22);
                if (arrayBuffer == null) {
                    throw null;
                }
                arrayBuffer.addAll((IterableOnce<B>)var1_2);
                this.filled = true;
                return true;
            }
            return false;
        }

        /*
         * WARNING - void declaration
         */
        public GroupedIterator(Iterator $outer, Iterator<B> self, int size, int step) {
            void var3_3;
            void var1_1;
            void var2_2;
            this.self = var2_2;
            this.size = size;
            this.step = step;
            if ($outer == null) {
                throw null;
            }
            this.$outer = var1_1;
            if (!(var3_3 > 0 && step > 0)) {
                throw new IllegalArgumentException(new StringBuilder(20).append("requirement failed: ").append((Object)GroupedIterator.$anonfun$new$1(this)).toString());
            }
            this.buffer = ArrayBuffer$.MODULE$.from((IterableOnce)Nil$.MODULE$);
            this.filled = false;
            this._partial = true;
            this.pad = None$.MODULE$;
        }
    }

    public static final class SliceIterator<A>
    extends AbstractIterator<A> {
        private final Iterator<A> underlying;
        public int scala$collection$Iterator$SliceIterator$$remaining;
        private int dropping;

        public final Iterator<A> underlying() {
            return this.underlying;
        }

        private void skip() {
            while (this.dropping > 0) {
                if (this.underlying().hasNext()) {
                    this.underlying().next();
                    --this.dropping;
                    continue;
                }
                this.dropping = 0;
            }
        }

        @Override
        public final int knownSize() {
            int n;
            int size = this.underlying().knownSize();
            if (size < 0) {
                return -1;
            }
            int max$extension_that = size - this.dropping;
            int n2 = Math.max(0, n);
            if (this.scala$collection$Iterator$SliceIterator$$remaining < 0) {
                return n2;
            }
            n = this.scala$collection$Iterator$SliceIterator$$remaining;
            return Math.min(n, n2);
        }

        @Override
        public final boolean hasNext() {
            this.skip();
            return this.scala$collection$Iterator$SliceIterator$$remaining != 0 && this.underlying().hasNext();
        }

        @Override
        public final A next() {
            this.skip();
            if (this.scala$collection$Iterator$SliceIterator$$remaining > 0) {
                --this.scala$collection$Iterator$SliceIterator$$remaining;
                return this.underlying().next();
            }
            if (this.scala$collection$Iterator$SliceIterator$$remaining < 0) {
                return this.underlying().next();
            }
            return (A)Iterator$.scala$collection$Iterator$$_empty.next();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final Iterator<A> sliceIterator(int from, int until) {
            void var1_1;
            int n;
            int n2 = Math.max(from, 0);
            if (until < 0) {
                n = this.adjustedBound$1(n2);
            } else if (until <= n2) {
                n = 0;
            } else if (this.scala$collection$Iterator$SliceIterator$$remaining < 0) {
                n = until - n2;
            } else {
                void var2_2;
                int rest;
                from = this.adjustedBound$1(n2);
                int min$extension_that = until - n2;
                n = rest = Math.min(from, (int)var2_2);
            }
            if (n == 0) {
                return Iterator$.scala$collection$Iterator$$_empty;
            }
            this.dropping += n2;
            this.scala$collection$Iterator$SliceIterator$$remaining = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        private final int adjustedBound$1(int lo$1) {
            void var1_1;
            if (this.scala$collection$Iterator$SliceIterator$$remaining < 0) {
                return -1;
            }
            int max$extension_that = this.scala$collection$Iterator$SliceIterator$$remaining - lo$1;
            return Math.max(0, (int)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        public SliceIterator(Iterator<A> underlying, int start, int limit) {
            void var2_2;
            void var3_3;
            void var1_1;
            this.underlying = var1_1;
            this.scala$collection$Iterator$SliceIterator$$remaining = var3_3;
            this.dropping = var2_2;
        }
    }
}

