/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.lang.reflect.Executable;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.logging.runtime.TraceControllerImpl;
import oracle.sql.CharacterBuffer;
import oracle.sql.CharacterSetWithConverter;
import oracle.sql.CharacterWalker;
import oracle.sql.converter.JdbcCharacterConverters;

@DefaultLogger(value="oracle.sql")
@Supports(value={Feature.CHARACTER_PROCESSING})
class CharacterSetZHTEUC
extends CharacterSetWithConverter {
    static final String CHAR_CONV_SUPERCLASS_NAME = "oracle.sql.converter.CharacterConverterZHTEUC";
    static final int MAX_7BIT = 127;
    static final int CHARLENGTH = 4;
    static Class m_charConvSuperclass;
    char[] m_leadingCodes;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;

    CharacterSetZHTEUC(int oracleId, JdbcCharacterConverters charConverter) {
        super(oracleId, charConverter);
        boolean bl = (0x8000000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$3, Level.FINEST, CharacterSetZHTEUC.class, $$$methodRef$$$3, null, oracleId, charConverter);
            }
            this.m_leadingCodes = charConverter.getLeadingCodes();
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$3, Level.FINEST, CharacterSetZHTEUC.class, $$$methodRef$$$3, null);
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, CharacterSetZHTEUC.class, $$$methodRef$$$3, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, CharacterSetZHTEUC.class, $$$methodRef$$$3, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    static CharacterSetZHTEUC getInstance(int n2, JdbcCharacterConverters jdbcCharacterConverters) {
        boolean bl = (0x8000000000L & TraceControllerImpl.feature) != 0L;
        try {
            void charConverter;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$0, Level.FINEST, CharacterSetZHTEUC.class, $$$methodRef$$$0, null, n2, jdbcCharacterConverters);
            }
            if (charConverter.getGroupId() == 5) {
                int oracleId;
                CharacterSetZHTEUC characterSetZHTEUC = new CharacterSetZHTEUC(oracleId, (JdbcCharacterConverters)charConverter);
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, CharacterSetZHTEUC.class, $$$methodRef$$$0, null, characterSetZHTEUC);
                    ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, CharacterSetZHTEUC.class, $$$methodRef$$$0, null, null);
                }
                return characterSetZHTEUC;
            }
            CharacterSetZHTEUC characterSetZHTEUC = null;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, CharacterSetZHTEUC.class, $$$methodRef$$$0, null, characterSetZHTEUC);
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, CharacterSetZHTEUC.class, $$$methodRef$$$0, null, null);
            }
            return null;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, CharacterSetZHTEUC.class, $$$methodRef$$$0, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    int decode(CharacterWalker characterWalker) throws SQLException {
        boolean bl = (0x8000000000L & TraceControllerImpl.feature) != 0L;
        try {
            void walker;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$1, Level.FINEST, CharacterSetZHTEUC.class, $$$methodRef$$$1, this, characterWalker);
            }
            if (walker.next + 1 < walker.bytes.length) {
                int leadingCode = walker.bytes[walker.next] << 8 | walker.bytes[walker.next + 1];
                for (int i2 = 0; i2 < this.m_leadingCodes.length; ++i2) {
                    if (leadingCode != this.m_leadingCodes[i2]) continue;
                    if (walker.bytes.length - walker.next < 4) {
                        SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 182, "destination too small").fillInStackTrace();
                        if (bl) {
                            ClioSupport.throwing($$$loggerRef$$$1, Level.FINEST, CharacterSetZHTEUC.class, $$$methodRef$$$1, this, sQLException);
                        }
                        throw sQLException;
                    }
                    int c2 = 0;
                    for (int j2 = 0; j2 < 4; ++j2) {
                        c2 = c2 << 8 | walker.bytes[walker.next++];
                    }
                    int n2 = c2;
                    if (bl) {
                        ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, CharacterSetZHTEUC.class, $$$methodRef$$$1, this, n2);
                        ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, CharacterSetZHTEUC.class, $$$methodRef$$$1, this, null);
                    }
                    return n2;
                }
            }
            int c3 = walker.bytes[walker.next] & 0xFF;
            ++walker.next;
            if (c3 > 127) {
                if (walker.bytes.length > walker.next) {
                    c3 = c3 << 8 | walker.bytes[walker.next];
                    ++walker.next;
                } else {
                    SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 182).fillInStackTrace();
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$1, Level.FINEST, CharacterSetZHTEUC.class, $$$methodRef$$$1, this, sQLException);
                    }
                    throw sQLException;
                }
            }
            int n3 = c3;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, CharacterSetZHTEUC.class, $$$methodRef$$$1, this, n3);
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, CharacterSetZHTEUC.class, $$$methodRef$$$1, this, null);
            }
            return n3;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, CharacterSetZHTEUC.class, $$$methodRef$$$1, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    void encode(CharacterBuffer characterBuffer, int n2) throws SQLException {
        boolean bl = (0x8000000000L & TraceControllerImpl.feature) != 0L;
        try {
            void c2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$2, Level.FINEST, CharacterSetZHTEUC.class, $$$methodRef$$$2, this, characterBuffer, n2);
            }
            void leadingCode = c2 >> 16;
            for (int i2 = 0; i2 < this.m_leadingCodes.length; ++i2) {
                void buffer;
                if (leadingCode != this.m_leadingCodes[i2]) continue;
                CharacterSetZHTEUC.need((CharacterBuffer)buffer, 4);
                for (int j2 = 0; j2 < 4; ++j2) {
                    buffer.bytes[buffer.next++] = (byte)c2;
                    c2 >>= 8;
                }
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, CharacterSetZHTEUC.class, $$$methodRef$$$2, this);
                    ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, CharacterSetZHTEUC.class, $$$methodRef$$$2, this, null);
                }
                return;
            }
            SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 181, "Failed to find valid leading code").fillInStackTrace();
            if (bl) {
                ClioSupport.throwing($$$loggerRef$$$2, Level.FINEST, CharacterSetZHTEUC.class, $$$methodRef$$$2, this, sQLException);
            }
            throw sQLException;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, CharacterSetZHTEUC.class, $$$methodRef$$$2, this, throwable2);
            }
            throw throwable;
        }
    }

    static {
        try {
            $$$methodRef$$$3 = CharacterSetZHTEUC.class.getDeclaredConstructor(Integer.TYPE, JdbcCharacterConverters.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$2 = CharacterSetZHTEUC.class.getDeclaredMethod("encode", CharacterBuffer.class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$1 = CharacterSetZHTEUC.class.getDeclaredMethod("decode", CharacterWalker.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$0 = CharacterSetZHTEUC.class.getDeclaredMethod("getInstance", Integer.TYPE, JdbcCharacterConverters.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
    }
}

