/* chess-window.c generated by valac 0.56.3, the Vala compiler
 * generated from chess-window.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 *
 * Copyright (C) 2010-2013 Robert Ancell
 * Copyright (C) 2013-2020 Michael Catanzaro
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <gtk/gtk.h>
#include <glib-object.h>
#include <adwaita.h>
#include <glib.h>
#include <cairo-gobject.h>
#include <stdlib.h>
#include <string.h>
#include "libchess.h"
#include <glib/gi18n-lib.h>
#include <float.h>
#include <math.h>
#include <pango/pango.h>
#include <pango/pangocairo.h>

#define HISTORY_GO_FIRST_ACTION_NAME "go-first"
#define HISTORY_GO_PREVIOUS_ACTION_NAME "go-previous"
#define HISTORY_GO_NEXT_ACTION_NAME "go-next"
#define HISTORY_GO_LAST_ACTION_NAME "go-last"
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_CHESS_WINDOW (chess_window_get_type ())
#define CHESS_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_WINDOW, ChessWindow))
#define CHESS_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_WINDOW, ChessWindowClass))
#define IS_CHESS_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_WINDOW))
#define IS_CHESS_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_WINDOW))
#define CHESS_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_WINDOW, ChessWindowClass))

typedef struct _ChessWindow ChessWindow;
typedef struct _ChessWindowClass ChessWindowClass;
typedef struct _ChessWindowPrivate ChessWindowPrivate;
typedef enum  {
	CHESS_WINDOW_LAYOUT_MODE_NORMAL,
	CHESS_WINDOW_LAYOUT_MODE_NARROW
} ChessWindowLayoutMode;

#define CHESS_WINDOW_TYPE_LAYOUT_MODE (chess_window_layout_mode_get_type ())

#define TYPE_CHESS_VIEW (chess_view_get_type ())
#define CHESS_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_VIEW, ChessView))
#define CHESS_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_VIEW, ChessViewClass))
#define IS_CHESS_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_VIEW))
#define IS_CHESS_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_VIEW))
#define CHESS_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_VIEW, ChessViewClass))

typedef struct _ChessView ChessView;
typedef struct _ChessViewClass ChessViewClass;

#define TYPE_CHESS_APPLICATION (chess_application_get_type ())
#define CHESS_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_APPLICATION, ChessApplication))
#define CHESS_APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_APPLICATION, ChessApplicationClass))
#define IS_CHESS_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_APPLICATION))
#define IS_CHESS_APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_APPLICATION))
#define CHESS_APPLICATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_APPLICATION, ChessApplicationClass))

typedef struct _ChessApplication ChessApplication;
typedef struct _ChessApplicationClass ChessApplicationClass;
enum  {
	CHESS_WINDOW_0_PROPERTY,
	CHESS_WINDOW_LAYOUT_MODE_PROPERTY,
	CHESS_WINDOW_VIEW_PROPERTY,
	CHESS_WINDOW_SCENE_PROPERTY,
	CHESS_WINDOW_GAME_PROPERTY,
	CHESS_WINDOW_NUM_PROPERTIES
};
static GParamSpec* chess_window_properties[CHESS_WINDOW_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_CHESS_SCENE (chess_scene_get_type ())
#define CHESS_SCENE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_SCENE, ChessScene))
#define CHESS_SCENE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_SCENE, ChessSceneClass))
#define IS_CHESS_SCENE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_SCENE))
#define IS_CHESS_SCENE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_SCENE))
#define CHESS_SCENE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_SCENE, ChessSceneClass))

typedef struct _ChessScene ChessScene;
typedef struct _ChessSceneClass ChessSceneClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _cairo_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_destroy (var), NULL)))
typedef struct _Block2Data Block2Data;
#define __vala_PangoFontDescription_free0(var) ((var == NULL) ? NULL : (var = (_vala_PangoFontDescription_free (var), NULL)))
#define _pango_attr_list_unref0(var) ((var == NULL) ? NULL : (var = (pango_attr_list_unref (var), NULL)))
typedef struct _Block3Data Block3Data;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _ChessWindow {
	GtkApplicationWindow parent_instance;
	ChessWindowPrivate * priv;
};

struct _ChessWindowClass {
	GtkApplicationWindowClass parent_class;
};

struct _ChessWindowPrivate {
	ChessWindowLayoutMode _layout_mode;
	ChessView* _view;
	ChessApplication* app;
	GtkBox* main_box;
	GtkInfoBar* info_bar;
	GtkLabel* info_bar_label;
	GtkButton* pause_resume_button;
	GtkBox* navigation_box;
	GtkComboBox* history_combo;
	GtkBox* clock_box;
	GtkDrawingArea* white_time_label;
	GtkDrawingArea* black_time_label;
};

struct _Block2Data {
	int _ref_count_;
	ChessWindow* self;
	GtkWidget* widget;
	cairo_t* c;
};

struct _Block3Data {
	int _ref_count_;
	ChessWindow* self;
	ChessWindowLayoutMode value;
};

static gint ChessWindow_private_offset;
static gpointer chess_window_parent_class = NULL;

VALA_EXTERN GType chess_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ChessWindow, g_object_unref)
VALA_EXTERN GType chess_window_layout_mode_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType chess_view_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ChessView, g_object_unref)
VALA_EXTERN GType chess_application_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ChessApplication, g_object_unref)
VALA_EXTERN ChessWindow* chess_window_new (ChessApplication* app);
VALA_EXTERN ChessWindow* chess_window_construct (GType object_type,
                                     ChessApplication* app);
VALA_EXTERN GType chess_scene_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ChessScene, g_object_unref)
VALA_EXTERN ChessScene* chess_scene_new (void);
VALA_EXTERN ChessScene* chess_scene_construct (GType object_type);
static void __lambda41_ (ChessWindow* self);
VALA_EXTERN void chess_window_update_history_panel (ChessWindow* self);
static void ___lambda41__chess_scene_changed (ChessScene* _sender,
                                       gpointer self);
VALA_EXTERN ChessView* chess_view_new (ChessScene* scene);
VALA_EXTERN ChessView* chess_view_construct (GType object_type,
                                 ChessScene* scene);
static void chess_window_set_view (ChessWindow* self,
                            ChessView* value);
VALA_EXTERN ChessView* chess_window_get_view (ChessWindow* self);
VALA_EXTERN void chess_window_update_pause_resume_button (ChessWindow* self);
static void chess_window_draw_white_time_label (ChessWindow* self,
                                         GtkDrawingArea* drawing_area,
                                         cairo_t* c,
                                         gint width,
                                         gint height);
static void _chess_window_draw_white_time_label_gtk_drawing_area_draw_func (GtkDrawingArea* drawing_area,
                                                                     cairo_t* cr,
                                                                     gint width,
                                                                     gint height,
                                                                     gpointer self);
static void chess_window_draw_black_time_label (ChessWindow* self,
                                         GtkDrawingArea* drawing_area,
                                         cairo_t* c,
                                         gint width,
                                         gint height);
static void _chess_window_draw_black_time_label_gtk_drawing_area_draw_func (GtkDrawingArea* drawing_area,
                                                                     cairo_t* cr,
                                                                     gint width,
                                                                     gint height,
                                                                     gpointer self);
static void chess_window_window_state_changed_cb (ChessWindow* self);
static void _chess_window_window_state_changed_cb_g_object_notify (GObject* _sender,
                                                            GParamSpec* pspec,
                                                            gpointer self);
VALA_EXTERN ChessWindowLayoutMode chess_window_get_layout_mode (ChessWindow* self);
static void chess_window_set_layout_mode (ChessWindow* self,
                                   ChessWindowLayoutMode value);
VALA_EXTERN void chess_window_update_game_status (ChessWindow* self,
                                      const gchar* title,
                                      const gchar* info);
VALA_EXTERN gchar* chess_application_compute_current_title (ChessApplication* self);
VALA_EXTERN gchar* chess_application_compute_status_info (ChessApplication* self);
VALA_EXTERN ChessScene* chess_window_get_scene (ChessWindow* self);
VALA_EXTERN ChessGame* chess_scene_get_game (ChessScene* self);
VALA_EXTERN ChessGame* chess_window_get_game (ChessWindow* self);
VALA_EXTERN gint chess_scene_get_move_number (ChessScene* self);
VALA_EXTERN void chess_application_enable_action (ChessApplication* self,
                                      const gchar* name);
VALA_EXTERN void chess_application_disable_action (ChessApplication* self,
                                       const gchar* name);
VALA_EXTERN void chess_window_set_move_text (ChessWindow* self,
                                 GtkTreeIter* iter,
                                 ChessMove* move);
VALA_EXTERN void chess_window_set_clock_visible (ChessWindow* self,
                                     gboolean visible);
static gint chess_window_compute_time_label_width_request (ChessWindow* self,
                                                    cairo_t* c);
static void chess_window_draw_time (ChessWindow* self,
                             GtkWidget* widget,
                             cairo_t* c,
                             gint width,
                             gint height,
                             const gchar* text,
                             gdouble* fg,
                             gint fg_length1,
                             gdouble* bg,
                             gint bg_length1);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static gboolean ___lambda42_ (Block2Data* _data2_);
static gboolean ____lambda42__gsource_func (gpointer self);
static void _vala_PangoFontDescription_free (PangoFontDescription* self);
static gchar* chess_window_make_clock_text (ChessWindow* self,
                                     ChessClock* clock,
                                     Color color);
static void chess_window_history_combo_changed_cb (ChessWindow* self,
                                            GtkComboBox* combo);
VALA_EXTERN void chess_scene_set_move_number (ChessScene* self,
                                  gint value);
static void _chess_window_history_combo_changed_cb_gtk_combo_box_changed (GtkComboBox* _sender,
                                                                   gpointer self);
VALA_EXTERN const gchar* chess_scene_get_move_format (ChessScene* self);
VALA_EXTERN void chess_window_start_game (ChessWindow* self);
static void ___lambda31_ (ChessWindow* self);
static void ____lambda31__chess_clock_tick (ChessClock* _sender,
                                     gpointer self);
VALA_EXTERN void chess_window_move (ChessWindow* self,
                        ChessMove* m);
VALA_EXTERN void chess_window_undo (ChessWindow* self);
VALA_EXTERN void chess_window_end_game (ChessWindow* self);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (void * _userdata_);
static gboolean _chess_window_layout_mode___lambda39_ (Block3Data* _data3_);
static gboolean __chess_window_layout_mode___lambda39__gsource_func (gpointer self);
VALA_EXTERN ChessScene* chess_view_get_scene (ChessView* self);
static void chess_window_finalize (GObject * obj);
static GType chess_window_get_type_once (void);
static void _vala_chess_window_get_property (GObject * object,
                                      guint property_id,
                                      GValue * value,
                                      GParamSpec * pspec);
static void _vala_chess_window_set_property (GObject * object,
                                      guint property_id,
                                      const GValue * value,
                                      GParamSpec * pspec);

static inline gpointer
chess_window_get_instance_private (ChessWindow* self)
{
	return G_STRUCT_MEMBER_P (self, ChessWindow_private_offset);
}

static GType
chess_window_layout_mode_get_type_once (void)
{
	static const GEnumValue values[] = {{CHESS_WINDOW_LAYOUT_MODE_NORMAL, "CHESS_WINDOW_LAYOUT_MODE_NORMAL", "normal"}, {CHESS_WINDOW_LAYOUT_MODE_NARROW, "CHESS_WINDOW_LAYOUT_MODE_NARROW", "narrow"}, {0, NULL, NULL}};
	GType chess_window_layout_mode_type_id;
	chess_window_layout_mode_type_id = g_enum_register_static ("ChessWindowLayoutMode", values);
	return chess_window_layout_mode_type_id;
}

GType
chess_window_layout_mode_get_type (void)
{
	static volatile gsize chess_window_layout_mode_type_id__once = 0;
	if (g_once_init_enter (&chess_window_layout_mode_type_id__once)) {
		GType chess_window_layout_mode_type_id;
		chess_window_layout_mode_type_id = chess_window_layout_mode_get_type_once ();
		g_once_init_leave (&chess_window_layout_mode_type_id__once, chess_window_layout_mode_type_id);
	}
	return chess_window_layout_mode_type_id__once;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
__lambda41_ (ChessWindow* self)
{
	chess_window_update_history_panel (self);
}

static void
___lambda41__chess_scene_changed (ChessScene* _sender,
                                  gpointer self)
{
	__lambda41_ ((ChessWindow*) self);
}

static void
_chess_window_draw_white_time_label_gtk_drawing_area_draw_func (GtkDrawingArea* drawing_area,
                                                                cairo_t* cr,
                                                                gint width,
                                                                gint height,
                                                                gpointer self)
{
	chess_window_draw_white_time_label ((ChessWindow*) self, drawing_area, cr, width, height);
}

static void
_chess_window_draw_black_time_label_gtk_drawing_area_draw_func (GtkDrawingArea* drawing_area,
                                                                cairo_t* cr,
                                                                gint width,
                                                                gint height,
                                                                gpointer self)
{
	chess_window_draw_black_time_label ((ChessWindow*) self, drawing_area, cr, width, height);
}

static void
_chess_window_window_state_changed_cb_g_object_notify (GObject* _sender,
                                                       GParamSpec* pspec,
                                                       gpointer self)
{
	chess_window_window_state_changed_cb ((ChessWindow*) self);
}

ChessWindow*
chess_window_construct (GType object_type,
                        ChessApplication* app)
{
	ChessWindow * self = NULL;
	ChessApplication* _tmp0_;
	ChessScene* scene = NULL;
	ChessScene* _tmp1_;
	ChessView* _tmp2_;
	ChessView* _tmp3_;
	GtkBox* _tmp4_;
	ChessView* _tmp5_;
	GtkInfoBar* _tmp6_;
	GtkDrawingArea* _tmp7_;
	GtkDrawingArea* _tmp8_;
	g_return_val_if_fail (app != NULL, NULL);
	self = (ChessWindow*) g_object_new (object_type, NULL);
	_tmp0_ = _g_object_ref0 (app);
	_g_object_unref0 (self->priv->app);
	self->priv->app = _tmp0_;
	_tmp1_ = chess_scene_new ();
	scene = _tmp1_;
	g_signal_connect_object (scene, "changed", (GCallback) ___lambda41__chess_scene_changed, self, 0);
	_tmp2_ = chess_view_new (scene);
	g_object_ref_sink (_tmp2_);
	_tmp3_ = _tmp2_;
	chess_window_set_view (self, _tmp3_);
	_g_object_unref0 (_tmp3_);
	_tmp4_ = self->priv->main_box;
	_tmp5_ = self->priv->_view;
	_tmp6_ = self->priv->info_bar;
	gtk_box_insert_child_after (_tmp4_, (GtkWidget*) _tmp5_, (GtkWidget*) _tmp6_);
	chess_window_update_pause_resume_button (self);
	_tmp7_ = self->priv->white_time_label;
	gtk_drawing_area_set_draw_func (_tmp7_, _chess_window_draw_white_time_label_gtk_drawing_area_draw_func, g_object_ref (self), g_object_unref);
	_tmp8_ = self->priv->black_time_label;
	gtk_drawing_area_set_draw_func (_tmp8_, _chess_window_draw_black_time_label_gtk_drawing_area_draw_func, g_object_ref (self), g_object_unref);
	g_signal_connect_object ((GObject*) self, "notify::default-height", (GCallback) _chess_window_window_state_changed_cb_g_object_notify, self, 0);
	g_signal_connect_object ((GObject*) self, "notify::default-width", (GCallback) _chess_window_window_state_changed_cb_g_object_notify, self, 0);
	_g_object_unref0 (scene);
	return self;
}

ChessWindow*
chess_window_new (ChessApplication* app)
{
	return chess_window_construct (TYPE_CHESS_WINDOW, app);
}

static void
chess_window_window_state_changed_cb (ChessWindow* self)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp5_ = FALSE;
	gint _tmp6_;
	gint _tmp7_;
	gboolean _tmp10_ = FALSE;
	gint _tmp11_;
	gint _tmp12_;
	g_return_if_fail (self != NULL);
	g_object_get ((GtkWindow*) self, "fullscreened", &_tmp1_, NULL);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		_tmp0_ = TRUE;
	} else {
		gboolean _tmp3_;
		gboolean _tmp4_;
		g_object_get ((GtkWindow*) self, "maximized", &_tmp3_, NULL);
		_tmp4_ = _tmp3_;
		_tmp0_ = _tmp4_;
	}
	if (_tmp0_) {
		return;
	}
	g_object_get ((GtkWindow*) self, "default-width", &_tmp6_, NULL);
	_tmp7_ = _tmp6_;
	if (_tmp7_ == 0) {
		_tmp5_ = TRUE;
	} else {
		gint _tmp8_;
		gint _tmp9_;
		g_object_get ((GtkWindow*) self, "default-height", &_tmp8_, NULL);
		_tmp9_ = _tmp8_;
		_tmp5_ = _tmp9_ == 0;
	}
	if (_tmp5_) {
		return;
	}
	g_object_get ((GtkWindow*) self, "default-width", &_tmp11_, NULL);
	_tmp12_ = _tmp11_;
	if (_tmp12_ <= 500) {
		ChessWindowLayoutMode _tmp13_;
		ChessWindowLayoutMode _tmp14_;
		_tmp13_ = chess_window_get_layout_mode (self);
		_tmp14_ = _tmp13_;
		_tmp10_ = _tmp14_ == CHESS_WINDOW_LAYOUT_MODE_NORMAL;
	} else {
		_tmp10_ = FALSE;
	}
	if (_tmp10_) {
		chess_window_set_layout_mode (self, CHESS_WINDOW_LAYOUT_MODE_NARROW);
	} else {
		gboolean _tmp15_ = FALSE;
		gint _tmp16_;
		gint _tmp17_;
		g_object_get ((GtkWindow*) self, "default-width", &_tmp16_, NULL);
		_tmp17_ = _tmp16_;
		if (_tmp17_ > 500) {
			ChessWindowLayoutMode _tmp18_;
			ChessWindowLayoutMode _tmp19_;
			_tmp18_ = chess_window_get_layout_mode (self);
			_tmp19_ = _tmp18_;
			_tmp15_ = _tmp19_ == CHESS_WINDOW_LAYOUT_MODE_NARROW;
		} else {
			_tmp15_ = FALSE;
		}
		if (_tmp15_) {
			chess_window_set_layout_mode (self, CHESS_WINDOW_LAYOUT_MODE_NORMAL);
		}
	}
}

void
chess_window_update_game_status (ChessWindow* self,
                                 const gchar* title,
                                 const gchar* info)
{
	gchar* _tmp0_ = NULL;
	gchar* _tmp4_ = NULL;
	GtkLabel* _tmp8_;
	GtkInfoBar* _tmp9_;
	GtkLabel* _tmp10_;
	const gchar* _tmp11_;
	const gchar* _tmp12_;
	g_return_if_fail (self != NULL);
	if (title != NULL) {
		gchar* _tmp1_;
		_tmp1_ = g_strdup (title);
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp1_;
	} else {
		ChessApplication* _tmp2_;
		gchar* _tmp3_;
		_tmp2_ = self->priv->app;
		_tmp3_ = chess_application_compute_current_title (_tmp2_);
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp3_;
	}
	gtk_window_set_title ((GtkWindow*) self, _tmp0_);
	if (info != NULL) {
		gchar* _tmp5_;
		_tmp5_ = g_strdup (info);
		_g_free0 (_tmp4_);
		_tmp4_ = _tmp5_;
	} else {
		ChessApplication* _tmp6_;
		gchar* _tmp7_;
		_tmp6_ = self->priv->app;
		_tmp7_ = chess_application_compute_status_info (_tmp6_);
		_g_free0 (_tmp4_);
		_tmp4_ = _tmp7_;
	}
	_tmp8_ = self->priv->info_bar_label;
	gtk_label_set_label (_tmp8_, _tmp4_);
	_tmp9_ = self->priv->info_bar;
	_tmp10_ = self->priv->info_bar_label;
	_tmp11_ = gtk_label_get_label (_tmp10_);
	_tmp12_ = _tmp11_;
	gtk_widget_set_visible ((GtkWidget*) _tmp9_, g_strcmp0 (_tmp12_, "") != 0);
	_g_free0 (_tmp4_);
	_g_free0 (_tmp0_);
}

void
chess_window_update_pause_resume_button (ChessWindow* self)
{
	ChessGame* game = NULL;
	ChessScene* _tmp0_;
	ChessScene* _tmp1_;
	ChessGame* _tmp2_;
	ChessGame* _tmp3_;
	ChessGame* _tmp4_;
	gboolean _tmp5_ = FALSE;
	ChessGame* _tmp6_;
	gboolean _tmp12_ = FALSE;
	ChessGame* _tmp13_;
	g_return_if_fail (self != NULL);
	_tmp0_ = chess_window_get_scene (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = chess_scene_get_game (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = _g_object_ref0 (_tmp3_);
	game = _tmp4_;
	_tmp6_ = game;
	if (_tmp6_ != NULL) {
		ChessGame* _tmp7_;
		ChessClock* _tmp8_;
		ChessClock* _tmp9_;
		_tmp7_ = game;
		_tmp8_ = chess_game_get_clock (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp5_ = _tmp9_ == NULL;
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		GtkButton* _tmp10_;
		_tmp10_ = self->priv->pause_resume_button;
		gtk_widget_hide ((GtkWidget*) _tmp10_);
	} else {
		GtkButton* _tmp11_;
		_tmp11_ = self->priv->pause_resume_button;
		gtk_widget_show ((GtkWidget*) _tmp11_);
	}
	_tmp13_ = game;
	if (_tmp13_ != NULL) {
		ChessGame* _tmp14_;
		gboolean _tmp15_;
		gboolean _tmp16_;
		_tmp14_ = game;
		_tmp15_ = chess_game_get_is_paused (_tmp14_);
		_tmp16_ = _tmp15_;
		_tmp12_ = _tmp16_;
	} else {
		_tmp12_ = FALSE;
	}
	if (_tmp12_) {
		GtkButton* _tmp17_;
		GtkButton* _tmp18_;
		_tmp17_ = self->priv->pause_resume_button;
		gtk_button_set_icon_name (_tmp17_, "media-playback-start-symbolic");
		_tmp18_ = self->priv->pause_resume_button;
		gtk_widget_set_tooltip_text ((GtkWidget*) _tmp18_, _ ("Unpause the game"));
	} else {
		GtkButton* _tmp19_;
		GtkButton* _tmp20_;
		_tmp19_ = self->priv->pause_resume_button;
		gtk_button_set_icon_name (_tmp19_, "media-playback-pause-symbolic");
		_tmp20_ = self->priv->pause_resume_button;
		gtk_widget_set_tooltip_text ((GtkWidget*) _tmp20_, _ ("Pause the game"));
	}
	_g_object_unref0 (game);
}

void
chess_window_update_history_panel (ChessWindow* self)
{
	ChessGame* _tmp0_;
	ChessGame* _tmp1_;
	gint move_number = 0;
	ChessScene* _tmp2_;
	ChessScene* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	gint n_moves = 0;
	ChessGame* _tmp6_;
	ChessGame* _tmp7_;
	guint _tmp8_;
	guint _tmp9_;
	gboolean _tmp10_ = FALSE;
	gboolean _tmp11_ = FALSE;
	gboolean _tmp18_ = FALSE;
	gboolean _tmp25_ = FALSE;
	gboolean _tmp32_ = FALSE;
	gboolean _tmp33_ = FALSE;
	GtkComboBox* _tmp40_;
	ChessGame* _tmp41_;
	ChessGame* _tmp42_;
	gboolean _tmp43_;
	gboolean _tmp44_;
	gint i = 0;
	ChessGame* _tmp45_;
	ChessGame* _tmp46_;
	GList* _tmp47_;
	GtkComboBox* _tmp60_;
	g_return_if_fail (self != NULL);
	_tmp0_ = chess_window_get_game (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == NULL) {
		return;
	}
	_tmp2_ = chess_window_get_scene (self);
	_tmp3_ = _tmp2_;
	_tmp4_ = chess_scene_get_move_number (_tmp3_);
	_tmp5_ = _tmp4_;
	move_number = _tmp5_;
	_tmp6_ = chess_window_get_game (self);
	_tmp7_ = _tmp6_;
	_tmp8_ = chess_game_get_n_moves (_tmp7_);
	_tmp9_ = _tmp8_;
	n_moves = (gint) _tmp9_;
	if (move_number < 0) {
		move_number += 1 + n_moves;
	}
	if (n_moves > 0) {
		_tmp11_ = move_number != 0;
	} else {
		_tmp11_ = FALSE;
	}
	if (_tmp11_) {
		ChessGame* _tmp12_;
		ChessGame* _tmp13_;
		gboolean _tmp14_;
		gboolean _tmp15_;
		_tmp12_ = chess_window_get_game (self);
		_tmp13_ = _tmp12_;
		_tmp14_ = chess_game_get_is_paused (_tmp13_);
		_tmp15_ = _tmp14_;
		_tmp10_ = !_tmp15_;
	} else {
		_tmp10_ = FALSE;
	}
	if (_tmp10_) {
		ChessApplication* _tmp16_;
		_tmp16_ = self->priv->app;
		chess_application_enable_action (_tmp16_, HISTORY_GO_FIRST_ACTION_NAME);
	} else {
		ChessApplication* _tmp17_;
		_tmp17_ = self->priv->app;
		chess_application_disable_action (_tmp17_, HISTORY_GO_FIRST_ACTION_NAME);
	}
	if (move_number > 0) {
		ChessGame* _tmp19_;
		ChessGame* _tmp20_;
		gboolean _tmp21_;
		gboolean _tmp22_;
		_tmp19_ = chess_window_get_game (self);
		_tmp20_ = _tmp19_;
		_tmp21_ = chess_game_get_is_paused (_tmp20_);
		_tmp22_ = _tmp21_;
		_tmp18_ = !_tmp22_;
	} else {
		_tmp18_ = FALSE;
	}
	if (_tmp18_) {
		ChessApplication* _tmp23_;
		_tmp23_ = self->priv->app;
		chess_application_enable_action (_tmp23_, HISTORY_GO_PREVIOUS_ACTION_NAME);
	} else {
		ChessApplication* _tmp24_;
		_tmp24_ = self->priv->app;
		chess_application_disable_action (_tmp24_, HISTORY_GO_PREVIOUS_ACTION_NAME);
	}
	if (move_number < n_moves) {
		ChessGame* _tmp26_;
		ChessGame* _tmp27_;
		gboolean _tmp28_;
		gboolean _tmp29_;
		_tmp26_ = chess_window_get_game (self);
		_tmp27_ = _tmp26_;
		_tmp28_ = chess_game_get_is_paused (_tmp27_);
		_tmp29_ = _tmp28_;
		_tmp25_ = !_tmp29_;
	} else {
		_tmp25_ = FALSE;
	}
	if (_tmp25_) {
		ChessApplication* _tmp30_;
		_tmp30_ = self->priv->app;
		chess_application_enable_action (_tmp30_, HISTORY_GO_NEXT_ACTION_NAME);
	} else {
		ChessApplication* _tmp31_;
		_tmp31_ = self->priv->app;
		chess_application_disable_action (_tmp31_, HISTORY_GO_NEXT_ACTION_NAME);
	}
	if (n_moves > 0) {
		_tmp33_ = move_number != n_moves;
	} else {
		_tmp33_ = FALSE;
	}
	if (_tmp33_) {
		ChessGame* _tmp34_;
		ChessGame* _tmp35_;
		gboolean _tmp36_;
		gboolean _tmp37_;
		_tmp34_ = chess_window_get_game (self);
		_tmp35_ = _tmp34_;
		_tmp36_ = chess_game_get_is_paused (_tmp35_);
		_tmp37_ = _tmp36_;
		_tmp32_ = !_tmp37_;
	} else {
		_tmp32_ = FALSE;
	}
	if (_tmp32_) {
		ChessApplication* _tmp38_;
		_tmp38_ = self->priv->app;
		chess_application_enable_action (_tmp38_, HISTORY_GO_LAST_ACTION_NAME);
	} else {
		ChessApplication* _tmp39_;
		_tmp39_ = self->priv->app;
		chess_application_disable_action (_tmp39_, HISTORY_GO_LAST_ACTION_NAME);
	}
	_tmp40_ = self->priv->history_combo;
	_tmp41_ = chess_window_get_game (self);
	_tmp42_ = _tmp41_;
	_tmp43_ = chess_game_get_is_paused (_tmp42_);
	_tmp44_ = _tmp43_;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp40_, !_tmp44_);
	i = n_moves;
	_tmp45_ = chess_window_get_game (self);
	_tmp46_ = _tmp45_;
	_tmp47_ = _tmp46_->move_stack;
	{
		GList* state_collection = NULL;
		GList* state_it = NULL;
		state_collection = _tmp47_;
		for (state_it = state_collection; state_it != NULL; state_it = state_it->next) {
			ChessState* _tmp48_;
			ChessState* state = NULL;
			_tmp48_ = _g_object_ref0 ((ChessState*) state_it->data);
			state = _tmp48_;
			{
				ChessState* _tmp49_;
				ChessMove* _tmp50_;
				gint _tmp59_;
				_tmp49_ = state;
				_tmp50_ = _tmp49_->last_move;
				if (_tmp50_ != NULL) {
					GtkTreeIter iter = {0};
					GtkComboBox* _tmp51_;
					GtkTreeModel* _tmp52_;
					GtkTreeModel* _tmp53_;
					GtkTreeIter _tmp54_ = {0};
					gboolean _tmp55_;
					_tmp51_ = self->priv->history_combo;
					_tmp52_ = gtk_combo_box_get_model (_tmp51_);
					_tmp53_ = _tmp52_;
					_tmp55_ = gtk_tree_model_iter_nth_child (_tmp53_, &_tmp54_, NULL, i);
					iter = _tmp54_;
					if (_tmp55_) {
						GtkTreeIter _tmp56_;
						ChessState* _tmp57_;
						ChessMove* _tmp58_;
						_tmp56_ = iter;
						_tmp57_ = state;
						_tmp58_ = _tmp57_->last_move;
						chess_window_set_move_text (self, &_tmp56_, _tmp58_);
					}
				}
				_tmp59_ = i;
				i = _tmp59_ - 1;
				_g_object_unref0 (state);
			}
		}
	}
	_tmp60_ = self->priv->history_combo;
	gtk_combo_box_set_active (_tmp60_, move_number);
}

void
chess_window_set_clock_visible (ChessWindow* self,
                                gboolean visible)
{
	GtkBox* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->clock_box;
	gtk_widget_set_visible ((GtkWidget*) _tmp0_, visible);
}

static gint
chess_window_compute_time_label_width_request (ChessWindow* self,
                                               cairo_t* c)
{
	cairo_text_extents_t extents = {0};
	gdouble max = 0.0;
	cairo_text_extents_t _tmp0_ = {0};
	gdouble _tmp1_ = 0.0;
	cairo_text_extents_t _tmp2_;
	cairo_text_extents_t _tmp4_ = {0};
	gdouble _tmp5_ = 0.0;
	cairo_text_extents_t _tmp6_;
	cairo_text_extents_t _tmp8_ = {0};
	gdouble _tmp9_ = 0.0;
	cairo_text_extents_t _tmp10_;
	cairo_text_extents_t _tmp12_ = {0};
	gdouble _tmp13_ = 0.0;
	cairo_text_extents_t _tmp14_;
	cairo_text_extents_t _tmp16_ = {0};
	gdouble _tmp17_ = 0.0;
	cairo_text_extents_t _tmp18_;
	cairo_text_extents_t _tmp20_ = {0};
	gdouble _tmp21_ = 0.0;
	cairo_text_extents_t _tmp22_;
	cairo_text_extents_t _tmp24_ = {0};
	gdouble _tmp25_ = 0.0;
	cairo_text_extents_t _tmp26_;
	cairo_text_extents_t _tmp28_ = {0};
	gdouble _tmp29_ = 0.0;
	cairo_text_extents_t _tmp30_;
	cairo_text_extents_t _tmp32_ = {0};
	gdouble _tmp33_ = 0.0;
	cairo_text_extents_t _tmp34_;
	cairo_text_extents_t _tmp36_ = {0};
	gdouble _tmp37_ = 0.0;
	cairo_text_extents_t _tmp38_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (c != NULL, 0);
	max = (gdouble) 0;
	cairo_text_extents (c, "000∶00", &_tmp0_);
	extents = _tmp0_;
	_tmp2_ = extents;
	if (max > _tmp2_.width) {
		_tmp1_ = max;
	} else {
		cairo_text_extents_t _tmp3_;
		_tmp3_ = extents;
		_tmp1_ = _tmp3_.width;
	}
	max = _tmp1_;
	cairo_text_extents (c, "111∶11", &_tmp4_);
	extents = _tmp4_;
	_tmp6_ = extents;
	if (max > _tmp6_.width) {
		_tmp5_ = max;
	} else {
		cairo_text_extents_t _tmp7_;
		_tmp7_ = extents;
		_tmp5_ = _tmp7_.width;
	}
	max = _tmp5_;
	cairo_text_extents (c, "222∶22", &_tmp8_);
	extents = _tmp8_;
	_tmp10_ = extents;
	if (max > _tmp10_.width) {
		_tmp9_ = max;
	} else {
		cairo_text_extents_t _tmp11_;
		_tmp11_ = extents;
		_tmp9_ = _tmp11_.width;
	}
	max = _tmp9_;
	cairo_text_extents (c, "333∶33", &_tmp12_);
	extents = _tmp12_;
	_tmp14_ = extents;
	if (max > _tmp14_.width) {
		_tmp13_ = max;
	} else {
		cairo_text_extents_t _tmp15_;
		_tmp15_ = extents;
		_tmp13_ = _tmp15_.width;
	}
	max = _tmp13_;
	cairo_text_extents (c, "444∶44", &_tmp16_);
	extents = _tmp16_;
	_tmp18_ = extents;
	if (max > _tmp18_.width) {
		_tmp17_ = max;
	} else {
		cairo_text_extents_t _tmp19_;
		_tmp19_ = extents;
		_tmp17_ = _tmp19_.width;
	}
	max = _tmp17_;
	cairo_text_extents (c, "555∶55", &_tmp20_);
	extents = _tmp20_;
	_tmp22_ = extents;
	if (max > _tmp22_.width) {
		_tmp21_ = max;
	} else {
		cairo_text_extents_t _tmp23_;
		_tmp23_ = extents;
		_tmp21_ = _tmp23_.width;
	}
	max = _tmp21_;
	cairo_text_extents (c, "666∶66", &_tmp24_);
	extents = _tmp24_;
	_tmp26_ = extents;
	if (max > _tmp26_.width) {
		_tmp25_ = max;
	} else {
		cairo_text_extents_t _tmp27_;
		_tmp27_ = extents;
		_tmp25_ = _tmp27_.width;
	}
	max = _tmp25_;
	cairo_text_extents (c, "777∶77", &_tmp28_);
	extents = _tmp28_;
	_tmp30_ = extents;
	if (max > _tmp30_.width) {
		_tmp29_ = max;
	} else {
		cairo_text_extents_t _tmp31_;
		_tmp31_ = extents;
		_tmp29_ = _tmp31_.width;
	}
	max = _tmp29_;
	cairo_text_extents (c, "888∶88", &_tmp32_);
	extents = _tmp32_;
	_tmp34_ = extents;
	if (max > _tmp34_.width) {
		_tmp33_ = max;
	} else {
		cairo_text_extents_t _tmp35_;
		_tmp35_ = extents;
		_tmp33_ = _tmp35_.width;
	}
	max = _tmp33_;
	cairo_text_extents (c, "999∶99", &_tmp36_);
	extents = _tmp36_;
	_tmp38_ = extents;
	if (max > _tmp38_.width) {
		_tmp37_ = max;
	} else {
		cairo_text_extents_t _tmp39_;
		_tmp39_ = extents;
		_tmp37_ = _tmp39_.width;
	}
	max = _tmp37_;
	result = ((gint) ceil (max)) + 6;
	_vala_warn_if_fail (result > 0, "result > 0");
	return result;
}

static gpointer
_cairo_reference0 (gpointer self)
{
	return self ? cairo_reference (self) : NULL;
}

static Block2Data*
block2_data_ref (Block2Data* _data2_)
{
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}

static void
block2_data_unref (void * _userdata_)
{
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		ChessWindow* self;
		self = _data2_->self;
		_g_object_unref0 (_data2_->widget);
		_cairo_destroy0 (_data2_->c);
		_g_object_unref0 (self);
		g_slice_free (Block2Data, _data2_);
	}
}

static gboolean
___lambda42_ (Block2Data* _data2_)
{
	ChessWindow* self;
	gboolean result;
	self = _data2_->self;
	gtk_widget_set_size_request (_data2_->widget, chess_window_compute_time_label_width_request (self, _data2_->c), -1);
	gtk_widget_queue_draw (_data2_->widget);
	result = G_SOURCE_REMOVE;
	return result;
}

static gboolean
____lambda42__gsource_func (gpointer self)
{
	gboolean result;
	result = ___lambda42_ (self);
	return result;
}

static void
_vala_PangoFontDescription_free (PangoFontDescription* self)
{
	g_boxed_free (pango_font_description_get_type (), self);
}

static void
chess_window_draw_time (ChessWindow* self,
                        GtkWidget* widget,
                        cairo_t* c,
                        gint width,
                        gint height,
                        const gchar* text,
                        gdouble* fg,
                        gint fg_length1,
                        gdouble* bg,
                        gint bg_length1)
{
	Block2Data* _data2_;
	GtkWidget* _tmp0_;
	cairo_t* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gdouble alpha = 0.0;
	gdouble _tmp4_;
	gdouble _tmp5_;
	gdouble _tmp6_;
	PangoContext* pango_context = NULL;
	PangoContext* _tmp7_;
	PangoContext* _tmp8_;
	cairo_font_options_t* _tmp9_;
	PangoLayout* layout = NULL;
	PangoContext* _tmp10_;
	PangoLayout* _tmp11_;
	PangoLayout* _tmp12_;
	PangoFontDescription* _tmp13_;
	PangoFontDescription* _tmp14_;
	PangoLayout* _tmp15_;
	PangoAttrList* attributes = NULL;
	PangoAttrList* _tmp16_;
	PangoAttrList* _tmp17_;
	PangoAttrFontFeatures* _tmp18_;
	PangoLayout* _tmp19_;
	PangoAttrList* _tmp20_;
	gint layout_width = 0;
	gint layout_height = 0;
	PangoLayout* _tmp21_;
	gint _tmp22_ = 0;
	gint _tmp23_ = 0;
	gdouble _tmp24_;
	gdouble _tmp25_;
	gdouble _tmp26_;
	PangoLayout* _tmp27_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	g_return_if_fail (c != NULL);
	g_return_if_fail (text != NULL);
	_data2_ = g_slice_new0 (Block2Data);
	_data2_->_ref_count_ = 1;
	_data2_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (widget);
	_g_object_unref0 (_data2_->widget);
	_data2_->widget = _tmp0_;
	_tmp1_ = _cairo_reference0 (c);
	_cairo_destroy0 (_data2_->c);
	_data2_->c = _tmp1_;
	g_object_get (_data2_->widget, "width-request", &_tmp2_, NULL);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == -1) {
		g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ____lambda42__gsource_func, block2_data_ref (_data2_), block2_data_unref);
		block2_data_unref (_data2_);
		_data2_ = NULL;
		return;
	}
	alpha = 1.0;
	if ((gtk_widget_get_state_flags (_data2_->widget) & GTK_STATE_FLAG_INSENSITIVE) != 0) {
		alpha = 0.5;
	}
	_tmp4_ = bg[0];
	_tmp5_ = bg[1];
	_tmp6_ = bg[2];
	cairo_set_source_rgba (_data2_->c, _tmp4_, _tmp5_, _tmp6_, alpha);
	cairo_paint (_data2_->c);
	_tmp7_ = pango_cairo_create_context (_data2_->c);
	pango_context = _tmp7_;
	_tmp8_ = pango_context;
	_tmp9_ = gtk_widget_get_font_options ((GtkWidget*) self);
	pango_cairo_context_set_font_options (_tmp8_, _tmp9_);
	_tmp10_ = pango_context;
	_tmp11_ = pango_layout_new (_tmp10_);
	layout = _tmp11_;
	_tmp12_ = layout;
	_tmp13_ = pango_font_description_from_string ("Sans Bold 14");
	_tmp14_ = _tmp13_;
	pango_layout_set_font_description (_tmp12_, _tmp14_);
	__vala_PangoFontDescription_free0 (_tmp14_);
	_tmp15_ = layout;
	pango_layout_set_text (_tmp15_, text, -1);
	_tmp16_ = pango_attr_list_new ();
	attributes = _tmp16_;
	_tmp17_ = attributes;
	_tmp18_ = (PangoAttrFontFeatures*) pango_attr_font_features_new ("tnum=1");
	pango_attr_list_insert (_tmp17_, (PangoAttribute*) _tmp18_);
	_tmp19_ = layout;
	_tmp20_ = attributes;
	pango_layout_set_attributes (_tmp19_, _tmp20_);
	_tmp21_ = layout;
	pango_layout_get_size (_tmp21_, &_tmp22_, &_tmp23_);
	layout_width = _tmp22_;
	layout_height = _tmp23_;
	layout_width /= PANGO_SCALE;
	layout_height /= PANGO_SCALE;
	cairo_move_to (_data2_->c, (gdouble) ((gtk_widget_get_allocated_width (_data2_->widget) - layout_width) / 2), (gdouble) ((gtk_widget_get_allocated_height (_data2_->widget) - layout_height) / 2));
	_tmp24_ = fg[0];
	_tmp25_ = fg[1];
	_tmp26_ = fg[2];
	cairo_set_source_rgba (_data2_->c, _tmp24_, _tmp25_, _tmp26_, alpha);
	_tmp27_ = layout;
	pango_cairo_show_layout (_data2_->c, _tmp27_);
	_pango_attr_list_unref0 (attributes);
	_g_object_unref0 (layout);
	_g_object_unref0 (pango_context);
	block2_data_unref (_data2_);
	_data2_ = NULL;
}

static gchar*
chess_window_make_clock_text (ChessWindow* self,
                              ChessClock* clock,
                              Color color)
{
	gint time = 0;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_vala_return_val_if_fail (clock != NULL, "clock != null", NULL);
	if (color == COLOR_WHITE) {
		gint _tmp0_;
		gint _tmp1_;
		_tmp0_ = chess_clock_get_white_remaining_seconds (clock);
		_tmp1_ = _tmp0_;
		time = _tmp1_;
	} else {
		gint _tmp2_;
		gint _tmp3_;
		_tmp2_ = chess_clock_get_black_remaining_seconds (clock);
		_tmp3_ = _tmp2_;
		time = _tmp3_;
	}
	if (time >= 60) {
		gchar* _tmp4_;
		_tmp4_ = g_strdup_printf ("%d∶\xE2\x80\x8E%02d", time / 60, time % 60);
		result = _tmp4_;
		return result;
	} else {
		gchar* _tmp5_;
		_tmp5_ = g_strdup_printf ("∶\xE2\x80\x8E%02d", time);
		result = _tmp5_;
		return result;
	}
}

static void
chess_window_draw_white_time_label (ChessWindow* self,
                                    GtkDrawingArea* drawing_area,
                                    cairo_t* c,
                                    gint width,
                                    gint height)
{
	ChessScene* _tmp0_;
	ChessScene* _tmp1_;
	ChessGame* _tmp2_;
	ChessGame* _tmp3_;
	ChessClock* _tmp4_;
	ChessClock* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gdouble* _tmp8_;
	gdouble* _tmp9_;
	gint _tmp9__length1;
	gdouble* _tmp10_;
	gdouble* _tmp11_;
	gint _tmp11__length1;
	g_return_if_fail (self != NULL);
	g_return_if_fail (drawing_area != NULL);
	g_return_if_fail (c != NULL);
	_tmp0_ = chess_window_get_scene (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = chess_scene_get_game (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = chess_game_get_clock (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = chess_window_make_clock_text (self, _tmp5_, COLOR_WHITE);
	_tmp7_ = _tmp6_;
	_tmp8_ = g_new0 (gdouble, 3);
	_tmp8_[0] = 0.0;
	_tmp8_[1] = 0.0;
	_tmp8_[2] = 0.0;
	_tmp9_ = _tmp8_;
	_tmp9__length1 = 3;
	_tmp10_ = g_new0 (gdouble, 3);
	_tmp10_[0] = 1.0;
	_tmp10_[1] = 1.0;
	_tmp10_[2] = 1.0;
	_tmp11_ = _tmp10_;
	_tmp11__length1 = 3;
	chess_window_draw_time (self, (GtkWidget*) drawing_area, c, width, height, _tmp7_, _tmp9_, (gint) 3, _tmp11_, (gint) 3);
	_tmp11_ = (g_free (_tmp11_), NULL);
	_tmp9_ = (g_free (_tmp9_), NULL);
	_g_free0 (_tmp7_);
}

static void
chess_window_draw_black_time_label (ChessWindow* self,
                                    GtkDrawingArea* drawing_area,
                                    cairo_t* c,
                                    gint width,
                                    gint height)
{
	ChessScene* _tmp0_;
	ChessScene* _tmp1_;
	ChessGame* _tmp2_;
	ChessGame* _tmp3_;
	ChessClock* _tmp4_;
	ChessClock* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gdouble* _tmp8_;
	gdouble* _tmp9_;
	gint _tmp9__length1;
	gdouble* _tmp10_;
	gdouble* _tmp11_;
	gint _tmp11__length1;
	g_return_if_fail (self != NULL);
	g_return_if_fail (drawing_area != NULL);
	g_return_if_fail (c != NULL);
	_tmp0_ = chess_window_get_scene (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = chess_scene_get_game (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = chess_game_get_clock (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = chess_window_make_clock_text (self, _tmp5_, COLOR_BLACK);
	_tmp7_ = _tmp6_;
	_tmp8_ = g_new0 (gdouble, 3);
	_tmp8_[0] = 1.0;
	_tmp8_[1] = 1.0;
	_tmp8_[2] = 1.0;
	_tmp9_ = _tmp8_;
	_tmp9__length1 = 3;
	_tmp10_ = g_new0 (gdouble, 3);
	_tmp10_[0] = 0.0;
	_tmp10_[1] = 0.0;
	_tmp10_[2] = 0.0;
	_tmp11_ = _tmp10_;
	_tmp11__length1 = 3;
	chess_window_draw_time (self, (GtkWidget*) drawing_area, c, width, height, _tmp7_, _tmp9_, (gint) 3, _tmp11_, (gint) 3);
	_tmp11_ = (g_free (_tmp11_), NULL);
	_tmp9_ = (g_free (_tmp9_), NULL);
	_g_free0 (_tmp7_);
}

static void
chess_window_history_combo_changed_cb (ChessWindow* self,
                                       GtkComboBox* combo)
{
	GtkTreeIter iter = {0};
	GtkTreeIter _tmp0_ = {0};
	gboolean _tmp1_;
	gint move_number = 0;
	GtkTreeModel* _tmp2_;
	GtkTreeModel* _tmp3_;
	GtkTreeIter _tmp4_;
	gint _tmp5_ = 0;
	gboolean _tmp6_ = FALSE;
	ChessGame* _tmp7_;
	ChessGame* _tmp8_;
	ChessScene* _tmp13_;
	ChessScene* _tmp14_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (combo != NULL);
	_tmp1_ = gtk_combo_box_get_active_iter (combo, &_tmp0_);
	iter = _tmp0_;
	if (!_tmp1_) {
		return;
	}
	_tmp2_ = gtk_combo_box_get_model (combo);
	_tmp3_ = _tmp2_;
	_tmp4_ = iter;
	gtk_tree_model_get (_tmp3_, &_tmp4_, 1, &_tmp5_, -1, -1);
	move_number = _tmp5_;
	_tmp7_ = chess_window_get_game (self);
	_tmp8_ = _tmp7_;
	if (_tmp8_ == NULL) {
		_tmp6_ = TRUE;
	} else {
		ChessGame* _tmp9_;
		ChessGame* _tmp10_;
		guint _tmp11_;
		guint _tmp12_;
		_tmp9_ = chess_window_get_game (self);
		_tmp10_ = _tmp9_;
		_tmp11_ = chess_game_get_n_moves (_tmp10_);
		_tmp12_ = _tmp11_;
		_tmp6_ = ((guint) move_number) == _tmp12_;
	}
	if (_tmp6_) {
		move_number = -1;
	}
	_tmp13_ = chess_window_get_scene (self);
	_tmp14_ = _tmp13_;
	chess_scene_set_move_number (_tmp14_, move_number);
}

static void
_chess_window_history_combo_changed_cb_gtk_combo_box_changed (GtkComboBox* _sender,
                                                              gpointer self)
{
	chess_window_history_combo_changed_cb ((ChessWindow*) self, _sender);
}

void
chess_window_set_move_text (ChessWindow* self,
                            GtkTreeIter* iter,
                            ChessMove* move)
{
	static const gchar* human_descriptions[72] = {N_ ("White pawn moves from %1$s to %2$s"), N_ ("White pawn at %1$s takes the black pawn at %2$s"), N_ ("White pawn at %1$s takes the black rook at %2$s"), N_ ("White pawn at %1$s takes the black knight at %2$s"), N_ ("White pawn at %1$s takes the black bishop at %2$s"), N_ ("White pawn at %1$s takes the black queen at %2$s"), N_ ("White rook moves from %1$s to %2$s"), N_ ("White rook at %1$s takes the black pawn at %2$s"), N_ ("White rook at %1$s takes the black rook at %2$s"), N_ ("White rook at %1$s takes the black knight at %2$s"), N_ ("White rook at %1$s takes the black bishop at %2$s"), N_ ("White rook at %1$s takes the black queen at %2$s"), N_ ("White knight moves from %1$s to %2$s"), N_ ("White knight at %1$s takes the black pawn at %2$s"), N_ ("White knight at %1$s takes the black rook at %2$s"), N_ ("White knight at %1$s takes the black knight at %2$s"), N_ ("White knight at %1$s takes the black bishop at %2$s"), N_ ("White knight at %1$s takes the black queen at %2$s"), N_ ("White bishop moves from %1$s to %2$s"), N_ ("White bishop at %1$s takes the black pawn at %2$s"), N_ ("White bishop at %1$s takes the black rook at %2$s"), N_ ("White bishop at %1$s takes the black knight at %2$s"), N_ ("White bishop at %1$s takes the black bishop at %2$s"), N_ ("White bishop at %1$s takes the black queen at %2$s"), N_ ("White queen moves from %1$s to %2$s"), N_ ("White queen at %1$s takes the black pawn at %2$s"), N_ ("White queen at %1$s takes the black rook at %2$s"), N_ ("White queen at %1$s takes the black knight at %2$s"), N_ ("White queen at %1$s takes the black bishop at %2$s"), N_ ("White queen at %1$s takes the black queen at %2$s"), N_ ("White king moves from %1$s to %2$s"), N_ ("White king at %1$s takes the black pawn at %2$s"), N_ ("White king at %1$s takes the black rook at %2$s"), N_ ("White king at %1$s takes the black knight at %2$s"), N_ ("White king at %1$s takes the black bishop at %2$s"), N_ ("White king at %1$s takes the black queen at %2$s"), N_ ("Black pawn moves from %1$s to %2$s"), N_ ("Black pawn at %1$s takes the white pawn at %2$s"), N_ ("Black pawn at %1$s takes the white rook at %2$s"), N_ ("Black pawn at %1$s takes the white knight at %2$s"), N_ ("Black pawn at %1$s takes the white bishop at %2$s"), N_ ("Black pawn at %1$s takes the white queen at %2$s"), N_ ("Black rook moves from %1$s to %2$s"), N_ ("Black rook at %1$s takes the white pawn at %2$s"), N_ ("Black rook at %1$s takes the white rook at %2$s"), N_ ("Black rook at %1$s takes the white knight at %2$s"), N_ ("Black rook at %1$s takes the white bishop at %2$s"), N_ ("Black rook at %1$s takes the white queen at %2$s"), N_ ("Black knight moves from %1$s to %2$s"), N_ ("Black knight at %1$s takes the white pawn at %2$s"), N_ ("Black knight at %1$s takes the white rook at %2$s"), N_ ("Black knight at %1$s takes the white knight at %2$s"), N_ ("Black knight at %1$s takes the white bishop at %2$s"), N_ ("Black knight at %1$s takes the white queen at %2$s"), N_ ("Black bishop moves from %1$s to %2$s"), N_ ("Black bishop at %1$s takes the white pawn at %2$s"), N_ ("Black bishop at %1$s takes the white rook at %2$s"), N_ ("Black bishop at %1$s takes the white knight at %2$s"), N_ ("Black bishop at %1$s takes the white bishop at %2$s"), N_ ("Black bishop at %1$s takes the white queen at %2$s"), N_ ("Black queen moves from %1$s to %2$s"), N_ ("Black queen at %1$s takes the white pawn at %2$s"), N_ ("Black queen at %1$s takes the white rook at %2$s"), N_ ("Black queen at %1$s takes the white knight at %2$s"), N_ ("Black queen at %1$s takes the white bishop at %2$s"), N_ ("Black queen at %1$s takes the white queen at %2$s"), N_ ("Black king moves from %1$s to %2$s"), N_ ("Black king at %1$s takes the white pawn at %2$s"), N_ ("Black king at %1$s takes the white rook at %2$s"), N_ ("Black king at %1$s takes the white knight at %2$s"), N_ ("Black king at %1$s takes the white bishop at %2$s"), N_ ("Black king at %1$s takes the white queen at %2$s")};
	gchar* move_text = NULL;
	gchar* _tmp0_;
	ChessScene* _tmp1_;
	ChessScene* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	GQuark _tmp7_ = 0U;
	static GQuark _tmp6_label0 = 0;
	static GQuark _tmp6_label1 = 0;
	static GQuark _tmp6_label2 = 0;
	GtkListStore* model = NULL;
	GtkComboBox* _tmp35_;
	GtkTreeModel* _tmp36_;
	GtkTreeModel* _tmp37_;
	GtkListStore* _tmp38_;
	gchar _tmp39_ = '\0';
	gchar* label = NULL;
	const gchar* _tmp40_;
	gchar* _tmp41_;
	GtkListStore* _tmp42_;
	GtkTreeIter _tmp43_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (iter != NULL);
	g_return_if_fail (move != NULL);
	_tmp0_ = g_strdup ("");
	move_text = _tmp0_;
	_tmp1_ = chess_window_get_scene (self);
	_tmp2_ = _tmp1_;
	_tmp3_ = chess_scene_get_move_format (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = _tmp4_;
	_tmp7_ = (NULL == _tmp5_) ? 0 : g_quark_from_string (_tmp5_);
	if (_tmp7_ == ((0 != _tmp6_label0) ? _tmp6_label0 : (_tmp6_label0 = g_quark_from_static_string ("human")))) {
		switch (0) {
			default:
			{
				ChessPiece* _tmp8_;
				_tmp8_ = move->castling_rook;
				if (_tmp8_ != NULL) {
					gboolean _tmp9_ = FALSE;
					if (move->f0 < move->f1) {
						_tmp9_ = move->r0 == 0;
					} else {
						_tmp9_ = FALSE;
					}
					if (_tmp9_) {
						gchar* _tmp10_;
						_tmp10_ = g_strdup (_ ("White castles kingside"));
						_g_free0 (move_text);
						move_text = _tmp10_;
					} else {
						gboolean _tmp11_ = FALSE;
						if (move->f1 < move->f0) {
							_tmp11_ = move->r0 == 0;
						} else {
							_tmp11_ = FALSE;
						}
						if (_tmp11_) {
							gchar* _tmp12_;
							_tmp12_ = g_strdup (_ ("White castles queenside"));
							_g_free0 (move_text);
							move_text = _tmp12_;
						} else {
							gboolean _tmp13_ = FALSE;
							if (move->f0 < move->f1) {
								_tmp13_ = move->r0 == 7;
							} else {
								_tmp13_ = FALSE;
							}
							if (_tmp13_) {
								gchar* _tmp14_;
								_tmp14_ = g_strdup (_ ("Black castles kingside"));
								_g_free0 (move_text);
								move_text = _tmp14_;
							} else {
								gboolean _tmp15_ = FALSE;
								if (move->f1 < move->f0) {
									_tmp15_ = move->r0 == 7;
								} else {
									_tmp15_ = FALSE;
								}
								if (_tmp15_) {
									gchar* _tmp16_;
									_tmp16_ = g_strdup (_ ("Black castles queenside"));
									_g_free0 (move_text);
									move_text = _tmp16_;
								} else {
									g_assert_not_reached ();
								}
							}
						}
					}
				} else {
					gint index = 0;
					ChessPiece* _tmp17_;
					ChessPiece* _tmp19_;
					ChessPiece* _tmp20_;
					ChessPlayer* _tmp21_;
					gchar* start = NULL;
					gchar* _tmp22_;
					gchar* end = NULL;
					gchar* _tmp23_;
					gchar* template = NULL;
					const gchar* _tmp24_;
					gchar* _tmp25_;
					const gchar* _tmp28_;
					const gchar* _tmp29_;
					const gchar* _tmp30_;
					gchar* _tmp31_;
					_tmp17_ = move->victim;
					if (_tmp17_ == NULL) {
						index = 0;
					} else {
						ChessPiece* _tmp18_;
						_tmp18_ = move->victim;
						index = (gint) (_tmp18_->type + 1);
					}
					_tmp19_ = move->piece;
					index += (gint) (_tmp19_->type * 6);
					_tmp20_ = move->piece;
					_tmp21_ = _tmp20_->player;
					if (_tmp21_->color == COLOR_BLACK) {
						index += 36;
					}
					_tmp22_ = g_strdup_printf ("%c%d", 'a' + move->f0, move->r0 + 1);
					start = _tmp22_;
					_tmp23_ = g_strdup_printf ("%c%d", 'a' + move->f1, move->r1 + 1);
					end = _tmp23_;
					_tmp24_ = human_descriptions[index];
					_tmp25_ = g_strdup (_ (_tmp24_));
					template = _tmp25_;
					if (move->en_passant) {
						if (move->r0 < move->r1) {
							gchar* _tmp26_;
							_tmp26_ = g_strdup (_ ("White pawn at %1$s takes the black pawn at %2$s en passant"));
							_g_free0 (template);
							template = _tmp26_;
						} else {
							gchar* _tmp27_;
							_tmp27_ = g_strdup (_ ("Black pawn at %1$s takes white pawn at %2$s en passant"));
							_g_free0 (template);
							template = _tmp27_;
						}
					}
					_tmp28_ = template;
					_tmp29_ = start;
					_tmp30_ = end;
					_tmp31_ = g_strdup_printf (_tmp28_, _tmp29_, _tmp30_);
					_g_free0 (move_text);
					move_text = _tmp31_;
					_g_free0 (template);
					_g_free0 (end);
					_g_free0 (start);
				}
				break;
			}
		}
	} else if (_tmp7_ == ((0 != _tmp6_label1) ? _tmp6_label1 : (_tmp6_label1 = g_quark_from_static_string ("san")))) {
		switch (0) {
			default:
			{
				gchar* _tmp32_;
				_tmp32_ = chess_move_get_san (move);
				_g_free0 (move_text);
				move_text = _tmp32_;
				break;
			}
		}
	} else if (_tmp7_ == ((0 != _tmp6_label2) ? _tmp6_label2 : (_tmp6_label2 = g_quark_from_static_string ("fan")))) {
		switch (0) {
			default:
			{
				gchar* _tmp33_;
				_tmp33_ = chess_move_get_fan (move);
				_g_free0 (move_text);
				move_text = _tmp33_;
				break;
			}
		}
	} else {
		switch (0) {
			default:
			{
				gchar* _tmp34_;
				_tmp34_ = chess_move_get_lan (move);
				_g_free0 (move_text);
				move_text = _tmp34_;
				break;
			}
		}
	}
	_tmp35_ = self->priv->history_combo;
	_tmp36_ = gtk_combo_box_get_model (_tmp35_);
	_tmp37_ = _tmp36_;
	_tmp38_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp37_, gtk_list_store_get_type (), GtkListStore));
	model = _tmp38_;
	if ((move->number % 2) == 0) {
		_tmp39_ = 'b';
	} else {
		_tmp39_ = 'a';
	}
	_tmp40_ = move_text;
	_tmp41_ = g_strdup_printf ("%u%c. %s", (guint) ((move->number + 1) / 2), (gint) _tmp39_, _tmp40_);
	label = _tmp41_;
	_tmp42_ = model;
	_tmp43_ = *iter;
	gtk_list_store_set (_tmp42_, &_tmp43_, 0, label, -1, -1);
	_g_free0 (label);
	_g_object_unref0 (model);
	_g_free0 (move_text);
}

static void
___lambda31_ (ChessWindow* self)
{
	GtkDrawingArea* _tmp0_;
	GtkDrawingArea* _tmp1_;
	_tmp0_ = self->priv->white_time_label;
	gtk_widget_queue_draw ((GtkWidget*) _tmp0_);
	_tmp1_ = self->priv->black_time_label;
	gtk_widget_queue_draw ((GtkWidget*) _tmp1_);
}

static void
____lambda31__chess_clock_tick (ChessClock* _sender,
                                gpointer self)
{
	___lambda31_ ((ChessWindow*) self);
}

void
chess_window_start_game (ChessWindow* self)
{
	GtkListStore* model = NULL;
	GtkComboBox* _tmp0_;
	GtkTreeModel* _tmp1_;
	GtkTreeModel* _tmp2_;
	GtkListStore* _tmp3_;
	GtkListStore* _tmp4_;
	GtkTreeIter iter = {0};
	GtkListStore* _tmp5_;
	GtkTreeIter _tmp6_ = {0};
	GtkListStore* _tmp7_;
	GtkTreeIter _tmp8_;
	GtkComboBox* _tmp9_;
	GtkTreeIter _tmp10_;
	GtkDrawingArea* _tmp11_;
	GtkDrawingArea* _tmp12_;
	ChessGame* _tmp13_;
	ChessGame* _tmp14_;
	ChessClock* _tmp15_;
	ChessClock* _tmp16_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->history_combo;
	_tmp1_ = gtk_combo_box_get_model (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, gtk_list_store_get_type (), GtkListStore));
	model = _tmp3_;
	_tmp4_ = model;
	gtk_list_store_clear (_tmp4_);
	_tmp5_ = model;
	gtk_list_store_append (_tmp5_, &_tmp6_);
	iter = _tmp6_;
	_tmp7_ = model;
	_tmp8_ = iter;
	gtk_list_store_set (_tmp7_, &_tmp8_, 0, _ ("Game Start"), 1, 0, -1, -1);
	_tmp9_ = self->priv->history_combo;
	_tmp10_ = iter;
	gtk_combo_box_set_active_iter (_tmp9_, &_tmp10_);
	_tmp11_ = self->priv->white_time_label;
	gtk_widget_queue_draw ((GtkWidget*) _tmp11_);
	_tmp12_ = self->priv->black_time_label;
	gtk_widget_queue_draw ((GtkWidget*) _tmp12_);
	_tmp13_ = chess_window_get_game (self);
	_tmp14_ = _tmp13_;
	_tmp15_ = chess_game_get_clock (_tmp14_);
	_tmp16_ = _tmp15_;
	if (_tmp16_ != NULL) {
		ChessGame* _tmp17_;
		ChessGame* _tmp18_;
		ChessClock* _tmp19_;
		ChessClock* _tmp20_;
		_tmp17_ = chess_window_get_game (self);
		_tmp18_ = _tmp17_;
		_tmp19_ = chess_game_get_clock (_tmp18_);
		_tmp20_ = _tmp19_;
		g_signal_connect_object (_tmp20_, "tick", (GCallback) ____lambda31__chess_clock_tick, self, 0);
	}
	_g_object_unref0 (model);
}

void
chess_window_move (ChessWindow* self,
                   ChessMove* m)
{
	ChessScene* _tmp0_;
	ChessScene* _tmp1_;
	GtkListStore* model = NULL;
	GtkComboBox* _tmp2_;
	GtkTreeModel* _tmp3_;
	GtkTreeModel* _tmp4_;
	GtkListStore* _tmp5_;
	GtkTreeIter iter = {0};
	GtkListStore* _tmp6_;
	GtkTreeIter _tmp7_ = {0};
	GtkListStore* _tmp8_;
	GtkTreeIter _tmp9_;
	GtkTreeIter _tmp10_;
	ChessGame* _tmp11_;
	ChessGame* _tmp12_;
	guint _tmp13_;
	guint _tmp14_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (m != NULL);
	_tmp0_ = chess_window_get_scene (self);
	_tmp1_ = _tmp0_;
	chess_scene_set_move_number (_tmp1_, -1);
	_tmp2_ = self->priv->history_combo;
	_tmp3_ = gtk_combo_box_get_model (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, gtk_list_store_get_type (), GtkListStore));
	model = _tmp5_;
	_tmp6_ = model;
	gtk_list_store_append (_tmp6_, &_tmp7_);
	iter = _tmp7_;
	_tmp8_ = model;
	_tmp9_ = iter;
	gtk_list_store_set (_tmp8_, &_tmp9_, 1, m->number, -1, -1);
	_tmp10_ = iter;
	chess_window_set_move_text (self, &_tmp10_, m);
	_tmp11_ = chess_window_get_game (self);
	_tmp12_ = _tmp11_;
	_tmp13_ = chess_game_get_n_moves (_tmp12_);
	_tmp14_ = _tmp13_;
	if (((guint) m->number) == _tmp14_) {
		GtkComboBox* _tmp15_;
		GtkTreeIter _tmp16_;
		_tmp15_ = self->priv->history_combo;
		_tmp16_ = iter;
		gtk_combo_box_set_active_iter (_tmp15_, &_tmp16_);
	}
	_g_object_unref0 (model);
}

void
chess_window_undo (ChessWindow* self)
{
	GtkListStore* model = NULL;
	GtkComboBox* _tmp0_;
	GtkTreeModel* _tmp1_;
	GtkTreeModel* _tmp2_;
	GtkListStore* _tmp3_;
	GtkTreeIter iter = {0};
	GtkTreeIter _tmp4_ = {0};
	ChessScene* _tmp5_;
	ChessScene* _tmp6_;
	GtkTreeIter _tmp7_ = {0};
	GtkComboBox* _tmp8_;
	GtkTreeIter _tmp9_;
	ChessView* _tmp10_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->history_combo;
	_tmp1_ = gtk_combo_box_get_model (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, gtk_list_store_get_type (), GtkListStore));
	model = _tmp3_;
	gtk_tree_model_iter_nth_child ((GtkTreeModel*) model, &_tmp4_, NULL, gtk_tree_model_iter_n_children ((GtkTreeModel*) model, NULL) - 1);
	iter = _tmp4_;
	gtk_list_store_remove (model, &iter);
	_tmp5_ = chess_window_get_scene (self);
	_tmp6_ = _tmp5_;
	chess_scene_set_move_number (_tmp6_, -1);
	gtk_tree_model_iter_nth_child ((GtkTreeModel*) model, &_tmp7_, NULL, gtk_tree_model_iter_n_children ((GtkTreeModel*) model, NULL) - 1);
	iter = _tmp7_;
	_tmp8_ = self->priv->history_combo;
	_tmp9_ = iter;
	gtk_combo_box_set_active_iter (_tmp8_, &_tmp9_);
	_tmp10_ = self->priv->_view;
	gtk_widget_queue_draw ((GtkWidget*) _tmp10_);
	_g_object_unref0 (model);
}

void
chess_window_end_game (ChessWindow* self)
{
	GtkDrawingArea* _tmp0_;
	GtkDrawingArea* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->white_time_label;
	gtk_widget_queue_draw ((GtkWidget*) _tmp0_);
	_tmp1_ = self->priv->black_time_label;
	gtk_widget_queue_draw ((GtkWidget*) _tmp1_);
}

ChessWindowLayoutMode
chess_window_get_layout_mode (ChessWindow* self)
{
	ChessWindowLayoutMode result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_layout_mode;
	return result;
}

static Block3Data*
block3_data_ref (Block3Data* _data3_)
{
	g_atomic_int_inc (&_data3_->_ref_count_);
	return _data3_;
}

static void
block3_data_unref (void * _userdata_)
{
	Block3Data* _data3_;
	_data3_ = (Block3Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
		ChessWindow* self;
		self = _data3_->self;
		_g_object_unref0 (self);
		g_slice_free (Block3Data, _data3_);
	}
}

static gboolean
_chess_window_layout_mode___lambda39_ (Block3Data* _data3_)
{
	ChessWindow* self;
	GtkOrientation _tmp0_ = 0;
	GtkBox* _tmp1_;
	gboolean result;
	self = _data3_->self;
	if (_data3_->value == CHESS_WINDOW_LAYOUT_MODE_NORMAL) {
		_tmp0_ = GTK_ORIENTATION_HORIZONTAL;
	} else {
		_tmp0_ = GTK_ORIENTATION_VERTICAL;
	}
	_tmp1_ = self->priv->navigation_box;
	gtk_orientable_set_orientation ((GtkOrientable*) _tmp1_, _tmp0_);
	result = G_SOURCE_REMOVE;
	return result;
}

static gboolean
__chess_window_layout_mode___lambda39__gsource_func (gpointer self)
{
	gboolean result;
	result = _chess_window_layout_mode___lambda39_ (self);
	return result;
}

static void
chess_window_set_layout_mode (ChessWindow* self,
                              ChessWindowLayoutMode value)
{
	Block3Data* _data3_;
	g_return_if_fail (self != NULL);
	_data3_ = g_slice_new0 (Block3Data);
	_data3_->_ref_count_ = 1;
	_data3_->self = g_object_ref (self);
	_data3_->value = value;
	if (self->priv->_layout_mode == _data3_->value) {
		block3_data_unref (_data3_);
		_data3_ = NULL;
		return;
	}
	self->priv->_layout_mode = _data3_->value;
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, __chess_window_layout_mode___lambda39__gsource_func, block3_data_ref (_data3_), block3_data_unref);
	block3_data_unref (_data3_);
	_data3_ = NULL;
	g_object_notify_by_pspec ((GObject *) self, chess_window_properties[CHESS_WINDOW_LAYOUT_MODE_PROPERTY]);
}

ChessView*
chess_window_get_view (ChessWindow* self)
{
	ChessView* result;
	ChessView* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_view;
	result = _tmp0_;
	return result;
}

static void
chess_window_set_view (ChessWindow* self,
                       ChessView* value)
{
	ChessView* old_value;
	g_return_if_fail (self != NULL);
	old_value = chess_window_get_view (self);
	if (old_value != value) {
		ChessView* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_view);
		self->priv->_view = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, chess_window_properties[CHESS_WINDOW_VIEW_PROPERTY]);
	}
}

ChessScene*
chess_window_get_scene (ChessWindow* self)
{
	ChessScene* result;
	ChessView* _tmp0_;
	ChessScene* _tmp1_;
	ChessScene* _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_view;
	_tmp1_ = chess_view_get_scene (_tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

ChessGame*
chess_window_get_game (ChessWindow* self)
{
	ChessGame* result;
	ChessScene* _tmp0_;
	ChessScene* _tmp1_;
	ChessGame* _tmp2_;
	ChessGame* _tmp3_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = chess_window_get_scene (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = chess_scene_get_game (_tmp1_);
	_tmp3_ = _tmp2_;
	result = _tmp3_;
	return result;
}

static void
chess_window_class_init (ChessWindowClass * klass,
                         gpointer klass_data)
{
	chess_window_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ChessWindow_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_chess_window_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_chess_window_set_property;
	G_OBJECT_CLASS (klass)->finalize = chess_window_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), CHESS_WINDOW_LAYOUT_MODE_PROPERTY, chess_window_properties[CHESS_WINDOW_LAYOUT_MODE_PROPERTY] = g_param_spec_enum ("layout-mode", "layout-mode", "layout-mode", CHESS_WINDOW_TYPE_LAYOUT_MODE, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CHESS_WINDOW_VIEW_PROPERTY, chess_window_properties[CHESS_WINDOW_VIEW_PROPERTY] = g_param_spec_object ("view", "view", "view", TYPE_CHESS_VIEW, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CHESS_WINDOW_SCENE_PROPERTY, chess_window_properties[CHESS_WINDOW_SCENE_PROPERTY] = g_param_spec_object ("scene", "scene", "scene", TYPE_CHESS_SCENE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CHESS_WINDOW_GAME_PROPERTY, chess_window_properties[CHESS_WINDOW_GAME_PROPERTY] = g_param_spec_object ("game", "game", "game", TYPE_CHESS_GAME, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/Chess/ui/chess-window.ui");
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "main_box", FALSE, ChessWindow_private_offset + G_STRUCT_OFFSET (ChessWindowPrivate, main_box));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "info_bar", FALSE, ChessWindow_private_offset + G_STRUCT_OFFSET (ChessWindowPrivate, info_bar));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "info_bar_label", FALSE, ChessWindow_private_offset + G_STRUCT_OFFSET (ChessWindowPrivate, info_bar_label));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "pause_resume_button", FALSE, ChessWindow_private_offset + G_STRUCT_OFFSET (ChessWindowPrivate, pause_resume_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "navigation_box", FALSE, ChessWindow_private_offset + G_STRUCT_OFFSET (ChessWindowPrivate, navigation_box));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "history_combo", FALSE, ChessWindow_private_offset + G_STRUCT_OFFSET (ChessWindowPrivate, history_combo));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "clock_box", FALSE, ChessWindow_private_offset + G_STRUCT_OFFSET (ChessWindowPrivate, clock_box));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "white_time_label", FALSE, ChessWindow_private_offset + G_STRUCT_OFFSET (ChessWindowPrivate, white_time_label));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "black_time_label", FALSE, ChessWindow_private_offset + G_STRUCT_OFFSET (ChessWindowPrivate, black_time_label));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "history_combo_changed_cb", G_CALLBACK(_chess_window_history_combo_changed_cb_gtk_combo_box_changed));
}

static void
chess_window_instance_init (ChessWindow * self,
                            gpointer klass)
{
	self->priv = chess_window_get_instance_private (self);
	self->priv->_layout_mode = CHESS_WINDOW_LAYOUT_MODE_NORMAL;
	gtk_widget_init_template (GTK_WIDGET (self));
}

static void
chess_window_finalize (GObject * obj)
{
	ChessWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_CHESS_WINDOW, ChessWindow);
	_g_object_unref0 (self->priv->_view);
	_g_object_unref0 (self->priv->app);
	G_OBJECT_CLASS (chess_window_parent_class)->finalize (obj);
}

static GType
chess_window_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ChessWindowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) chess_window_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ChessWindow), 0, (GInstanceInitFunc) chess_window_instance_init, NULL };
	GType chess_window_type_id;
	chess_window_type_id = g_type_register_static (gtk_application_window_get_type (), "ChessWindow", &g_define_type_info, 0);
	ChessWindow_private_offset = g_type_add_instance_private (chess_window_type_id, sizeof (ChessWindowPrivate));
	return chess_window_type_id;
}

GType
chess_window_get_type (void)
{
	static volatile gsize chess_window_type_id__once = 0;
	if (g_once_init_enter (&chess_window_type_id__once)) {
		GType chess_window_type_id;
		chess_window_type_id = chess_window_get_type_once ();
		g_once_init_leave (&chess_window_type_id__once, chess_window_type_id);
	}
	return chess_window_type_id__once;
}

static void
_vala_chess_window_get_property (GObject * object,
                                 guint property_id,
                                 GValue * value,
                                 GParamSpec * pspec)
{
	ChessWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_CHESS_WINDOW, ChessWindow);
	switch (property_id) {
		case CHESS_WINDOW_LAYOUT_MODE_PROPERTY:
		g_value_set_enum (value, chess_window_get_layout_mode (self));
		break;
		case CHESS_WINDOW_VIEW_PROPERTY:
		g_value_set_object (value, chess_window_get_view (self));
		break;
		case CHESS_WINDOW_SCENE_PROPERTY:
		g_value_set_object (value, chess_window_get_scene (self));
		break;
		case CHESS_WINDOW_GAME_PROPERTY:
		g_value_set_object (value, chess_window_get_game (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_chess_window_set_property (GObject * object,
                                 guint property_id,
                                 const GValue * value,
                                 GParamSpec * pspec)
{
	ChessWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_CHESS_WINDOW, ChessWindow);
	switch (property_id) {
		case CHESS_WINDOW_LAYOUT_MODE_PROPERTY:
		chess_window_set_layout_mode (self, g_value_get_enum (value));
		break;
		case CHESS_WINDOW_VIEW_PROPERTY:
		chess_window_set_view (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

