/*
 * This file is generated by gdbus-codegen, do not modify it.
 *
 * The license of this code is the same as for the D-Bus interface description
 * it was derived from. Note that it links to GLib, so must comply with the
 * LGPL linking clauses.
 */

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include "ipc-agent.h"

#include <string.h>
#ifdef G_OS_UNIX
#  include <gio/gunixfdlist.h>
#endif

typedef struct
{
  GDBusArgInfo parent_struct;
  gboolean use_gvariant;
} _ExtendedGDBusArgInfo;

typedef struct
{
  GDBusMethodInfo parent_struct;
  const gchar *signal_name;
  gboolean pass_fdlist;
} _ExtendedGDBusMethodInfo;

typedef struct
{
  GDBusSignalInfo parent_struct;
  const gchar *signal_name;
} _ExtendedGDBusSignalInfo;

typedef struct
{
  GDBusPropertyInfo parent_struct;
  const gchar *hyphen_name;
  guint use_gvariant : 1;
  guint emits_changed_signal : 1;
} _ExtendedGDBusPropertyInfo;

typedef struct
{
  GDBusInterfaceInfo parent_struct;
  const gchar *hyphen_name;
} _ExtendedGDBusInterfaceInfo;

typedef struct
{
  const _ExtendedGDBusPropertyInfo *info;
  guint prop_id;
  GValue orig_value; /* the value before the change */
} ChangedProperty;

static void
_changed_property_free (ChangedProperty *data)
{
  g_value_unset (&data->orig_value);
  g_free (data);
}

static gboolean
_g_strv_equal0 (gchar **a, gchar **b)
{
  gboolean ret = FALSE;
  guint n;
  if (a == NULL && b == NULL)
    {
      ret = TRUE;
      goto out;
    }
  if (a == NULL || b == NULL)
    goto out;
  if (g_strv_length (a) != g_strv_length (b))
    goto out;
  for (n = 0; a[n] != NULL; n++)
    if (g_strcmp0 (a[n], b[n]) != 0)
      goto out;
  ret = TRUE;
out:
  return ret;
}

static gboolean
_g_variant_equal0 (GVariant *a, GVariant *b)
{
  gboolean ret = FALSE;
  if (a == NULL && b == NULL)
    {
      ret = TRUE;
      goto out;
    }
  if (a == NULL || b == NULL)
    goto out;
  ret = g_variant_equal (a, b);
out:
  return ret;
}

G_GNUC_UNUSED static gboolean
_g_value_equal (const GValue *a, const GValue *b)
{
  gboolean ret = FALSE;
  g_assert (G_VALUE_TYPE (a) == G_VALUE_TYPE (b));
  switch (G_VALUE_TYPE (a))
    {
      case G_TYPE_BOOLEAN:
        ret = (g_value_get_boolean (a) == g_value_get_boolean (b));
        break;
      case G_TYPE_UCHAR:
        ret = (g_value_get_uchar (a) == g_value_get_uchar (b));
        break;
      case G_TYPE_INT:
        ret = (g_value_get_int (a) == g_value_get_int (b));
        break;
      case G_TYPE_UINT:
        ret = (g_value_get_uint (a) == g_value_get_uint (b));
        break;
      case G_TYPE_INT64:
        ret = (g_value_get_int64 (a) == g_value_get_int64 (b));
        break;
      case G_TYPE_UINT64:
        ret = (g_value_get_uint64 (a) == g_value_get_uint64 (b));
        break;
      case G_TYPE_DOUBLE:
        {
          /* Avoid -Wfloat-equal warnings by doing a direct bit compare */
          gdouble da = g_value_get_double (a);
          gdouble db = g_value_get_double (b);
          ret = memcmp (&da, &db, sizeof (gdouble)) == 0;
        }
        break;
      case G_TYPE_STRING:
        ret = (g_strcmp0 (g_value_get_string (a), g_value_get_string (b)) == 0);
        break;
      case G_TYPE_VARIANT:
        ret = _g_variant_equal0 (g_value_get_variant (a), g_value_get_variant (b));
        break;
      default:
        if (G_VALUE_TYPE (a) == G_TYPE_STRV)
          ret = _g_strv_equal0 (g_value_get_boxed (a), g_value_get_boxed (b));
        else
          g_critical ("_g_value_equal() does not handle type %s", g_type_name (G_VALUE_TYPE (a)));
        break;
    }
  return ret;
}

/* ------------------------------------------------------------------------
 * Code for interface org.gnome.Sysprof.Agent
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:IpcAgent
 * @title: IpcAgent
 * @short_description: Generated C code for the org.gnome.Sysprof.Agent D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-gnome-Sysprof-Agent.top_of_page">org.gnome.Sysprof.Agent</link> D-Bus interface in C.
 */

/* ---- Introspection data for org.gnome.Sysprof.Agent ---- */

static const _ExtendedGDBusMethodInfo _ipc_agent_method_info_force_exit =
{
  {
    -1,
    (gchar *) "ForceExit",
    NULL,
    NULL,
    NULL
  },
  "handle-force-exit",
  FALSE
};

static const _ExtendedGDBusArgInfo _ipc_agent_method_info_send_signal_IN_ARG_signum =
{
  {
    -1,
    (gchar *) "signum",
    (gchar *) "i",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _ipc_agent_method_info_send_signal_IN_ARG_pointers[] =
{
  &_ipc_agent_method_info_send_signal_IN_ARG_signum.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _ipc_agent_method_info_send_signal =
{
  {
    -1,
    (gchar *) "SendSignal",
    (GDBusArgInfo **) &_ipc_agent_method_info_send_signal_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-send-signal",
  FALSE
};

static const GDBusMethodInfo * const _ipc_agent_method_info_pointers[] =
{
  &_ipc_agent_method_info_force_exit.parent_struct,
  &_ipc_agent_method_info_send_signal.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _ipc_agent_signal_info_log_ARG_message =
{
  {
    -1,
    (gchar *) "message",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _ipc_agent_signal_info_log_ARG_pointers[] =
{
  &_ipc_agent_signal_info_log_ARG_message.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _ipc_agent_signal_info_log =
{
  {
    -1,
    (gchar *) "Log",
    (GDBusArgInfo **) &_ipc_agent_signal_info_log_ARG_pointers,
    NULL
  },
  "log"
};

static const GDBusSignalInfo * const _ipc_agent_signal_info_pointers[] =
{
  &_ipc_agent_signal_info_log.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _ipc_agent_interface_info =
{
  {
    -1,
    (gchar *) "org.gnome.Sysprof.Agent",
    (GDBusMethodInfo **) &_ipc_agent_method_info_pointers,
    (GDBusSignalInfo **) &_ipc_agent_signal_info_pointers,
    NULL,
    NULL
  },
  "agent",
};


/**
 * ipc_agent_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-gnome-Sysprof-Agent.top_of_page">org.gnome.Sysprof.Agent</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
ipc_agent_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_ipc_agent_interface_info.parent_struct;
}

/**
 * ipc_agent_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #IpcAgent interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
ipc_agent_override_properties (GObjectClass *klass G_GNUC_UNUSED, guint property_id_begin)
{
  return property_id_begin - 1;
}



/**
 * IpcAgent:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-gnome-Sysprof-Agent.top_of_page">org.gnome.Sysprof.Agent</link>.
 */

/**
 * IpcAgentIface:
 * @parent_iface: The parent interface.
 * @handle_force_exit: Handler for the #IpcAgent::handle-force-exit signal.
 * @handle_send_signal: Handler for the #IpcAgent::handle-send-signal signal.
 * @log: Handler for the #IpcAgent::log signal.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-gnome-Sysprof-Agent.top_of_page">org.gnome.Sysprof.Agent</link>.
 */

typedef IpcAgentIface IpcAgentInterface;
G_DEFINE_INTERFACE (IpcAgent, ipc_agent, G_TYPE_OBJECT)

static void
ipc_agent_default_init (IpcAgentIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * IpcAgent::handle-force-exit:
   * @object: A #IpcAgent.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-Sysprof-Agent.ForceExit">ForceExit()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call ipc_agent_complete_force_exit() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-force-exit",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (IpcAgentIface, handle_force_exit),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * IpcAgent::handle-send-signal:
   * @object: A #IpcAgent.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_signum: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-Sysprof-Agent.SendSignal">SendSignal()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call ipc_agent_complete_send_signal() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-send-signal",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (IpcAgentIface, handle_send_signal),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_INT);

  /* GObject signals for received D-Bus signals: */
  /**
   * IpcAgent::log:
   * @object: A #IpcAgent.
   * @arg_message: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-gnome-Sysprof-Agent.Log">"Log"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  g_signal_new ("log",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (IpcAgentIface, log),
    NULL,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_NONE,
    1, G_TYPE_STRING);

}

/**
 * ipc_agent_emit_log:
 * @object: A #IpcAgent.
 * @arg_message: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-gnome-Sysprof-Agent.Log">"Log"</link> D-Bus signal.
 */
void
ipc_agent_emit_log (
    IpcAgent *object,
    const gchar *arg_message)
{
  g_signal_emit_by_name (object, "log", arg_message);
}

/**
 * ipc_agent_call_force_exit:
 * @proxy: A #IpcAgentProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-Sysprof-Agent.ForceExit">ForceExit()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call ipc_agent_call_force_exit_finish() to get the result of the operation.
 *
 * See ipc_agent_call_force_exit_sync() for the synchronous, blocking version of this method.
 */
void
ipc_agent_call_force_exit (
    IpcAgent *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "ForceExit",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * ipc_agent_call_force_exit_finish:
 * @proxy: A #IpcAgentProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to ipc_agent_call_force_exit().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with ipc_agent_call_force_exit().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
ipc_agent_call_force_exit_finish (
    IpcAgent *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * ipc_agent_call_force_exit_sync:
 * @proxy: A #IpcAgentProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-Sysprof-Agent.ForceExit">ForceExit()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See ipc_agent_call_force_exit() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
ipc_agent_call_force_exit_sync (
    IpcAgent *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "ForceExit",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * ipc_agent_call_send_signal:
 * @proxy: A #IpcAgentProxy.
 * @arg_signum: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-Sysprof-Agent.SendSignal">SendSignal()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call ipc_agent_call_send_signal_finish() to get the result of the operation.
 *
 * See ipc_agent_call_send_signal_sync() for the synchronous, blocking version of this method.
 */
void
ipc_agent_call_send_signal (
    IpcAgent *proxy,
    gint arg_signum,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "SendSignal",
    g_variant_new ("(i)",
                   arg_signum),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * ipc_agent_call_send_signal_finish:
 * @proxy: A #IpcAgentProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to ipc_agent_call_send_signal().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with ipc_agent_call_send_signal().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
ipc_agent_call_send_signal_finish (
    IpcAgent *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * ipc_agent_call_send_signal_sync:
 * @proxy: A #IpcAgentProxy.
 * @arg_signum: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-Sysprof-Agent.SendSignal">SendSignal()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See ipc_agent_call_send_signal() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
ipc_agent_call_send_signal_sync (
    IpcAgent *proxy,
    gint arg_signum,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "SendSignal",
    g_variant_new ("(i)",
                   arg_signum),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * ipc_agent_complete_force_exit:
 * @object: A #IpcAgent.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-Sysprof-Agent.ForceExit">ForceExit()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
ipc_agent_complete_force_exit (
    IpcAgent *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * ipc_agent_complete_send_signal:
 * @object: A #IpcAgent.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-Sysprof-Agent.SendSignal">SendSignal()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
ipc_agent_complete_send_signal (
    IpcAgent *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/* ------------------------------------------------------------------------ */

/**
 * IpcAgentProxy:
 *
 * The #IpcAgentProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * IpcAgentProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #IpcAgentProxy.
 */

struct _IpcAgentProxyPrivate
{
  GData *qdata;
};

static void ipc_agent_proxy_iface_init (IpcAgentIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (IpcAgentProxy, ipc_agent_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (IpcAgentProxy)
                         G_IMPLEMENT_INTERFACE (IPC_TYPE_AGENT, ipc_agent_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (IpcAgentProxy, ipc_agent_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (IPC_TYPE_AGENT, ipc_agent_proxy_iface_init))

#endif
static void
ipc_agent_proxy_finalize (GObject *object)
{
  IpcAgentProxy *proxy = IPC_AGENT_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (ipc_agent_proxy_parent_class)->finalize (object);
}

static void
ipc_agent_proxy_get_property (GObject      *object G_GNUC_UNUSED,
  guint         prop_id G_GNUC_UNUSED,
  GValue       *value G_GNUC_UNUSED,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
}

static void
ipc_agent_proxy_set_property (GObject      *object G_GNUC_UNUSED,
  guint         prop_id G_GNUC_UNUSED,
  const GValue *value G_GNUC_UNUSED,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
}

static void
ipc_agent_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_ipc_agent_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], IPC_TYPE_AGENT);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, IPC_TYPE_AGENT);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
ipc_agent_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  IpcAgentProxy *proxy = IPC_AGENT_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_ipc_agent_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_ipc_agent_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static void
ipc_agent_proxy_init (IpcAgentProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = ipc_agent_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, IPC_TYPE_AGENT_PROXY, IpcAgentProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), ipc_agent_interface_info ());
}

static void
ipc_agent_proxy_class_init (IpcAgentProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = ipc_agent_proxy_finalize;
  gobject_class->get_property = ipc_agent_proxy_get_property;
  gobject_class->set_property = ipc_agent_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = ipc_agent_proxy_g_signal;
  proxy_class->g_properties_changed = ipc_agent_proxy_g_properties_changed;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (IpcAgentProxyPrivate));
#endif
}

static void
ipc_agent_proxy_iface_init (IpcAgentIface *iface G_GNUC_UNUSED)
{
}

/**
 * ipc_agent_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-gnome-Sysprof-Agent.top_of_page">org.gnome.Sysprof.Agent</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call ipc_agent_proxy_new_finish() to get the result of the operation.
 *
 * See ipc_agent_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
ipc_agent_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (IPC_TYPE_AGENT_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.gnome.Sysprof.Agent", NULL);
}

/**
 * ipc_agent_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to ipc_agent_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with ipc_agent_proxy_new().
 *
 * Returns: (transfer full) (type IpcAgentProxy): The constructed proxy object or %NULL if @error is set.
 */
IpcAgent *
ipc_agent_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return IPC_AGENT (ret);
  else
    return NULL;
}

/**
 * ipc_agent_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-gnome-Sysprof-Agent.top_of_page">org.gnome.Sysprof.Agent</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See ipc_agent_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type IpcAgentProxy): The constructed proxy object or %NULL if @error is set.
 */
IpcAgent *
ipc_agent_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (IPC_TYPE_AGENT_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.gnome.Sysprof.Agent", NULL);
  if (ret != NULL)
    return IPC_AGENT (ret);
  else
    return NULL;
}


/**
 * ipc_agent_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like ipc_agent_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call ipc_agent_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See ipc_agent_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
ipc_agent_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (IPC_TYPE_AGENT_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.gnome.Sysprof.Agent", NULL);
}

/**
 * ipc_agent_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to ipc_agent_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with ipc_agent_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type IpcAgentProxy): The constructed proxy object or %NULL if @error is set.
 */
IpcAgent *
ipc_agent_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return IPC_AGENT (ret);
  else
    return NULL;
}

/**
 * ipc_agent_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like ipc_agent_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See ipc_agent_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type IpcAgentProxy): The constructed proxy object or %NULL if @error is set.
 */
IpcAgent *
ipc_agent_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (IPC_TYPE_AGENT_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.gnome.Sysprof.Agent", NULL);
  if (ret != NULL)
    return IPC_AGENT (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * IpcAgentSkeleton:
 *
 * The #IpcAgentSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * IpcAgentSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #IpcAgentSkeleton.
 */

struct _IpcAgentSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_ipc_agent_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  IpcAgentSkeleton *skeleton = IPC_AGENT_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], IPC_TYPE_AGENT);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, IPC_TYPE_AGENT);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_ipc_agent_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  IpcAgentSkeleton *skeleton = IPC_AGENT_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_ipc_agent_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_ipc_agent_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  IpcAgentSkeleton *skeleton = IPC_AGENT_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_ipc_agent_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _ipc_agent_skeleton_vtable =
{
  _ipc_agent_skeleton_handle_method_call,
  _ipc_agent_skeleton_handle_get_property,
  _ipc_agent_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
ipc_agent_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return ipc_agent_interface_info ();
}

static GDBusInterfaceVTable *
ipc_agent_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_ipc_agent_skeleton_vtable;
}

static GVariant *
ipc_agent_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  IpcAgentSkeleton *skeleton = IPC_AGENT_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  if (_ipc_agent_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _ipc_agent_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _ipc_agent_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _ipc_agent_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.gnome.Sysprof.Agent", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static void
ipc_agent_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton G_GNUC_UNUSED)
{
}

static void
_ipc_agent_on_signal_log (
    IpcAgent *object,
    const gchar *arg_message)
{
  IpcAgentSkeleton *skeleton = IPC_AGENT_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(s)",
                   arg_message));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.gnome.Sysprof.Agent", "Log",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void ipc_agent_skeleton_iface_init (IpcAgentIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (IpcAgentSkeleton, ipc_agent_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (IpcAgentSkeleton)
                         G_IMPLEMENT_INTERFACE (IPC_TYPE_AGENT, ipc_agent_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (IpcAgentSkeleton, ipc_agent_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (IPC_TYPE_AGENT, ipc_agent_skeleton_iface_init))

#endif
static void
ipc_agent_skeleton_finalize (GObject *object)
{
  IpcAgentSkeleton *skeleton = IPC_AGENT_SKELETON (object);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (ipc_agent_skeleton_parent_class)->finalize (object);
}

static void
ipc_agent_skeleton_init (IpcAgentSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = ipc_agent_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, IPC_TYPE_AGENT_SKELETON, IpcAgentSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
}

static void
ipc_agent_skeleton_class_init (IpcAgentSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = ipc_agent_skeleton_finalize;

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = ipc_agent_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = ipc_agent_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = ipc_agent_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = ipc_agent_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (IpcAgentSkeletonPrivate));
#endif
}

static void
ipc_agent_skeleton_iface_init (IpcAgentIface *iface)
{
  iface->log = _ipc_agent_on_signal_log;
}

/**
 * ipc_agent_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-gnome-Sysprof-Agent.top_of_page">org.gnome.Sysprof.Agent</link>.
 *
 * Returns: (transfer full) (type IpcAgentSkeleton): The skeleton object.
 */
IpcAgent *
ipc_agent_skeleton_new (void)
{
  return IPC_AGENT (g_object_new (IPC_TYPE_AGENT_SKELETON, NULL));
}

