/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.geospatial.action.upload.geojson;

import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.ActionListener;
import org.opensearch.action.StepListener;
import org.opensearch.action.bulk.BulkItemResponse;
import org.opensearch.action.bulk.BulkRequestBuilder;
import org.opensearch.action.bulk.BulkResponse;
import org.opensearch.common.collect.MapBuilder;
import org.opensearch.geospatial.action.upload.geojson.ContentBuilder;
import org.opensearch.geospatial.action.upload.geojson.IndexManager;
import org.opensearch.geospatial.action.upload.geojson.PipelineManager;
import org.opensearch.geospatial.action.upload.geojson.UploadGeoJSONRequestContent;
import org.opensearch.geospatial.action.upload.geojson.UploadGeoJSONResponse;
import org.opensearch.geospatial.stats.upload.UploadMetric;
import org.opensearch.geospatial.stats.upload.UploadStats;

public class Uploader {
    private static final Logger LOGGER = LogManager.getLogger(Uploader.class);
    private static final String GEOJSON = "geojson";
    private final IndexManager indexManager;
    private final PipelineManager pipelineManager;
    private final ContentBuilder contentBuilder;

    public Uploader(IndexManager indexManager, PipelineManager pipelineManager, ContentBuilder contentBuilder) {
        this.indexManager = Objects.requireNonNull(indexManager, "IndexManager instance cannot be null");
        this.pipelineManager = Objects.requireNonNull(pipelineManager, "PipelineManager instance cannot be null");
        this.contentBuilder = Objects.requireNonNull(contentBuilder, "ContentBuilder instance cannot be null");
    }

    public void upload(UploadGeoJSONRequestContent content, boolean isIndexAlreadyExists, ActionListener<UploadGeoJSONResponse> flowListener) {
        Objects.requireNonNull(flowListener, "listener cannot be null");
        Objects.requireNonNull(content, "content cannot be null");
        StepListener createIndexStep = new StepListener();
        StepListener createPipelineStep = new StepListener();
        StepListener indexFeatureStep = new StepListener();
        StepListener deletePipelineStep = new StepListener();
        if (isIndexAlreadyExists) {
            LOGGER.info("Index [ " + content.getIndexName() + " ] is already exists");
            createIndexStep.onResponse(null);
        } else {
            MapBuilder fieldMap = new MapBuilder();
            fieldMap.put((Object)content.getFieldName(), (Object)content.getFieldType());
            this.indexManager.create(content.getIndexName(), fieldMap.immutableMap(), (StepListener<Void>)createIndexStep);
        }
        createIndexStep.whenComplete(notUsed -> this.pipelineManager.create(content.getFieldName(), (StepListener<String>)createPipelineStep), arg_0 -> flowListener.onFailure(arg_0));
        createPipelineStep.whenComplete(pipeline -> this.indexContentAsDocument((String)pipeline, content, (StepListener<BulkResponse>)indexFeatureStep), arg_0 -> flowListener.onFailure(arg_0));
        indexFeatureStep.whenComplete(notUsed -> {
            String pipeline = (String)createPipelineStep.result();
            this.pipelineManager.delete(pipeline, (StepListener<Exception>)deletePipelineStep, () -> null);
        }, uploadFailed -> {
            String pipeline = (String)createPipelineStep.result();
            this.pipelineManager.delete(pipeline, (StepListener<Exception>)deletePipelineStep, () -> uploadFailed);
        });
        deletePipelineStep.whenComplete(uploadFailedException -> {
            if (uploadFailedException != null) {
                throw uploadFailedException;
            }
            BulkResponse response = (BulkResponse)indexFeatureStep.result();
            this.createAndAddMetricToStats((String)createPipelineStep.result(), response);
            flowListener.onResponse((Object)new UploadGeoJSONResponse(response));
        }, deletePipelineFailed -> {
            try {
                BulkResponse response = (BulkResponse)indexFeatureStep.result();
                this.createAndAddMetricToStats((String)createPipelineStep.result(), response);
                flowListener.onResponse((Object)new UploadGeoJSONResponse(response));
            }
            catch (IllegalStateException stepFailed) {
                flowListener.onFailure(deletePipelineFailed);
            }
        });
    }

    private void indexContentAsDocument(String pipeline, UploadGeoJSONRequestContent content, StepListener<BulkResponse> uploadStepListener) {
        Optional<BulkRequestBuilder> contentRequestBuilder = this.contentBuilder.prepare(content, pipeline);
        if (contentRequestBuilder.isEmpty()) {
            uploadStepListener.onFailure((Exception)new IllegalStateException("No valid features are available to index"));
            return;
        }
        contentRequestBuilder.get().execute(ActionListener.wrap(arg_0 -> uploadStepListener.onResponse(arg_0), bulkRequestFailedException -> uploadStepListener.onFailure((Exception)new IllegalStateException("Failed to index document due to " + bulkRequestFailedException.getMessage()))));
    }

    private void createAndAddMetricToStats(String metricID, BulkResponse response) {
        UploadMetric metric = this.createUploadMetric(metricID, response);
        UploadStats.getInstance().addMetric(metric);
    }

    private UploadMetric createUploadMetric(String id, BulkResponse response) {
        UploadMetric.UploadMetricBuilder metricBuilder = new UploadMetric.UploadMetricBuilder(id, GEOJSON);
        BulkItemResponse[] items = response.getItems();
        metricBuilder.uploadCount(items.length);
        metricBuilder.duration(response.getTook().duration());
        if (response.hasFailures()) {
            return this.createFailedUploadMetric(metricBuilder, items);
        }
        return this.createSuccessUploadMetric(metricBuilder, items);
    }

    private UploadMetric createSuccessUploadMetric(UploadMetric.UploadMetricBuilder metricBuilder, BulkItemResponse[] items) {
        Objects.requireNonNull(metricBuilder, "metric builder cannot be null");
        Objects.requireNonNull(items, "BulkItemResponse array cannot be null");
        metricBuilder.successCount(items.length);
        return metricBuilder.build();
    }

    private UploadMetric createFailedUploadMetric(UploadMetric.UploadMetricBuilder metricBuilder, BulkItemResponse[] items) {
        Objects.requireNonNull(metricBuilder, "metric builder cannot be null");
        Objects.requireNonNull(items, "BulkItemResponse cannot be null");
        long failed = Arrays.stream(items).filter(BulkItemResponse::isFailed).count();
        metricBuilder.failedCount(failed);
        long success = (long)items.length - failed;
        metricBuilder.successCount(success);
        return metricBuilder.build();
    }
}

