import type { tsp } from '../ts-protocol.js';
import type { TypeScriptVersion } from './versionProvider.js';
export declare class TypeScriptServerError extends Error {
    readonly serverId: string;
    readonly version: TypeScriptVersion;
    private readonly response;
    readonly serverMessage: string | undefined;
    readonly serverStack: string | undefined;
    static create(serverId: string, version: TypeScriptVersion, response: tsp.Response): TypeScriptServerError;
    private constructor();
    get serverErrorText(): string | undefined;
    get serverCommand(): string;
    /**
     * Given a `errorText` from a tsserver request indicating failure in handling a request.
     */
    private static parseErrorText;
}
//# sourceMappingURL=serverError.d.ts.map