/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.sampler.memory;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.graalvm.visualvm.core.ui.components.DataViewComponent;
import org.graalvm.visualvm.core.ui.components.ScrollableContainer;
import org.graalvm.visualvm.lib.common.ProfilingSettings;
import org.graalvm.visualvm.profiling.presets.PresetSelector;
import org.graalvm.visualvm.profiling.presets.ProfilerPreset;
import org.graalvm.visualvm.profiling.presets.SamplerMemoryPanel;
import org.graalvm.visualvm.sampler.SamplerParameters;
import org.openide.util.NbBundle;

public abstract class MemorySettingsSupport {
    private static final Logger LOGGER = Logger.getLogger(MemorySettingsSupport.class.getName());
    private JPanel container;
    private SamplerMemoryPanel panel;
    private PresetSelector selector;
    private DataViewComponent.DetailsView detailsView;
    private ProfilerPreset requestedPreset;

    public DataViewComponent.DetailsView getDetailsView() {
        if (this.detailsView == null) {
            this.detailsView = new DataViewComponent.DetailsView(NbBundle.getMessage(MemorySettingsSupport.class, (String)"LBL_Memory_settings"), null, 20, (JComponent)new ScrollableContainer((JComponent)this.createPanel()), null);
        }
        return this.detailsView;
    }

    public void setSettings(SamplerParameters settings) {
        ProfilerPreset preset = MemorySettingsSupport.createPreset(settings);
        if (this.panel != null) {
            this.panel.loadFromPreset(preset);
            this.selector.customize(this.presetValid());
        } else {
            this.requestedPreset = preset;
        }
    }

    public ProfilingSettings getSettings() {
        return this.panel.getSettings();
    }

    public int getSamplingRate() {
        return this.panel.getSamplingRate();
    }

    public int getRefreshRate() {
        return this.panel.getRefreshRate();
    }

    public void saveSettings() {
    }

    public abstract boolean presetValid();

    public boolean settingsValid() {
        return this.panel.settingsValid();
    }

    public void showSettings(DataViewComponent dvc) {
        dvc.selectDetailsView(this.getDetailsView());
    }

    public abstract PresetSelector createSelector(Runnable var1);

    public void setEnabled(boolean enabled) {
        if (this.container != null) {
            this.container.setEnabled(enabled);
        }
    }

    private JPanel createPanel() {
        this.panel = new SamplerMemoryPanel(){

            public void settingsChanged() {
                MemorySettingsSupport.this.panel.saveToPreset(MemorySettingsSupport.this.selector.customize(MemorySettingsSupport.this.presetValid()));
            }
        };
        this.selector = this.createSelector(new Runnable(){

            @Override
            public void run() {
                MemorySettingsSupport.this.panel.loadFromPreset(MemorySettingsSupport.this.selector.getSelectedPreset());
            }
        });
        this.selector.setBorder(BorderFactory.createEmptyBorder(10, 10, 5, 10));
        this.container = new JPanel(new BorderLayout()){

            @Override
            public void setEnabled(boolean enabled) {
                super.setEnabled(enabled);
                for (Component c : this.getComponents()) {
                    c.setEnabled(enabled);
                }
            }
        };
        this.container.setOpaque(false);
        this.container.add((Component)this.panel, "Center");
        this.container.add((Component)this.selector, "South");
        if (this.requestedPreset != null) {
            this.panel.loadFromPreset(this.requestedPreset);
            this.selector.customize(this.presetValid());
            this.requestedPreset = null;
        }
        return this.container;
    }

    private static ProfilerPreset createPreset(SamplerParameters settings) {
        ProfilerPreset preset = new ProfilerPreset("Forced Memory Settings", "");
        String refresh = settings.get("sampling-rate");
        if (refresh != null) {
            try {
                preset.setSamplingRefreshRateS(Integer.parseInt(refresh));
            }
            catch (NumberFormatException e) {
                LOGGER.log(Level.WARNING, "Failed to read Sampler sampling-rate", e);
            }
        }
        return preset;
    }
}

