/* util-files.c generated by valac 0.56.3, the Vala compiler
 * generated from util-files.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include <glib.h>
#include <gio/gio.h>
#include "geary-engine.h"
#include <stdlib.h>
#include <string.h>

#define GEARY_FILES_RECURSIVE_DELETE_BATCH_SIZE 50

#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _GearyFilesRecursiveDeleteAsyncData GearyFilesRecursiveDeleteAsyncData;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _GearyFilesQueryExistsAsyncData GearyFilesQueryExistsAsyncData;
typedef struct _GearyFilesQueryFileTypeAsyncData GearyFilesQueryFileTypeAsyncData;
typedef struct _Block118Data Block118Data;
typedef struct _GearyFilesMakeDirectoryWithParentsData GearyFilesMakeDirectoryWithParentsData;

struct _GearyFilesRecursiveDeleteAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GFile* folder;
	gint priority;
	GCancellable* cancellable;
	GFileType type;
	GFileEnumerator* enumerator;
	GFileEnumerator* _tmp0_;
	GFileEnumerator* _tmp1_;
	GList* info_list;
	GFileEnumerator* _tmp2_;
	GList* _tmp3_;
	GList* _tmp4_;
	GList* _tmp5_;
	GList* info_collection;
	GList* info_it;
	GFileInfo* _tmp6_;
	GFileInfo* info;
	GFileInfo* _tmp7_;
	const gchar* _tmp8_;
	GFile* _tmp9_;
	GFile* _tmp10_;
	GError* _inner_error0_;
};

struct _GearyFilesQueryExistsAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GFile* file;
	GCancellable* cancellable;
	gboolean result;
	GError* err;
	GError* _tmp0_;
	GError* _tmp1_;
	GError* _tmp2_;
	GError* _inner_error0_;
};

struct _GearyFilesQueryFileTypeAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GFile* file;
	gboolean follow_symlinks;
	GCancellable* cancellable;
	GFileType result;
	GFileQueryInfoFlags _tmp0_;
	GFileInfo* info;
	GFileInfo* _tmp1_;
	GError* _inner_error0_;
};

struct _Block118Data {
	int _ref_count_;
	GError* create_err;
	GFile* dir;
	GCancellable* cancellable;
	gpointer _async_data_;
};

struct _GearyFilesMakeDirectoryWithParentsData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GFile* dir;
	GCancellable* cancellable;
	gboolean result;
	Block118Data* _data118_;
	gboolean ret;
	GearyNonblockingConcurrent* _tmp0_;
	GearyNonblockingConcurrent* _tmp1_;
	GError* _tmp2_;
	GError* _tmp3_;
	GError* _tmp4_;
	GError* _tmp5_;
	GError* _inner_error0_;
};

static void geary_files_recursive_delete_async_data_free (gpointer _data);
static gboolean geary_files_recursive_delete_async_co (GearyFilesRecursiveDeleteAsyncData* _data_);
static void geary_files_recursive_delete_async_ready (GObject* source_object,
                                               GAsyncResult* _res_,
                                               gpointer _user_data_);
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
static void geary_files_query_exists_async_data_free (gpointer _data);
static gboolean geary_files_query_exists_async_co (GearyFilesQueryExistsAsyncData* _data_);
static void geary_files_query_exists_async_ready (GObject* source_object,
                                           GAsyncResult* _res_,
                                           gpointer _user_data_);
static void geary_files_query_file_type_async_data_free (gpointer _data);
static gboolean geary_files_query_file_type_async_co (GearyFilesQueryFileTypeAsyncData* _data_);
static void geary_files_query_file_type_async_ready (GObject* source_object,
                                              GAsyncResult* _res_,
                                              gpointer _user_data_);
static void geary_files_make_directory_with_parents_data_free (gpointer _data);
static gboolean geary_files_make_directory_with_parents_co (GearyFilesMakeDirectoryWithParentsData* _data_);
static Block118Data* block118_data_ref (Block118Data* _data118_);
static void block118_data_unref (void * _userdata_);
static void __lambda21_ (Block118Data* _data118_,
                  GError** error);
static void ___lambda21__geary_nonblocking_concurrent_concurrent_callback (GCancellable* cancellable,
                                                                    gpointer self,
                                                                    GError** error);
static void geary_files_make_directory_with_parents_ready (GObject* source_object,
                                                    GAsyncResult* _res_,
                                                    gpointer _user_data_);

static void
geary_files_recursive_delete_async_data_free (gpointer _data)
{
	GearyFilesRecursiveDeleteAsyncData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->folder);
	_g_object_unref0 (_data_->cancellable);
	g_slice_free (GearyFilesRecursiveDeleteAsyncData, _data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
geary_files_recursive_delete_async (GFile* folder,
                                    gint priority,
                                    GCancellable* cancellable,
                                    GAsyncReadyCallback _callback_,
                                    gpointer _user_data_)
{
	GearyFilesRecursiveDeleteAsyncData* _data_;
	GFile* _tmp0_;
	GCancellable* _tmp1_;
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (folder, g_file_get_type ()));
	g_return_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()));
	_data_ = g_slice_new0 (GearyFilesRecursiveDeleteAsyncData);
	_data_->_async_result = g_task_new (NULL, cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, geary_files_recursive_delete_async_data_free);
	_tmp0_ = _g_object_ref0 (folder);
	_g_object_unref0 (_data_->folder);
	_data_->folder = _tmp0_;
	_data_->priority = priority;
	_tmp1_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp1_;
	geary_files_recursive_delete_async_co (_data_);
}

void
geary_files_recursive_delete_finish (GAsyncResult* _res_,
                                     GError** error)
{
	GearyFilesRecursiveDeleteAsyncData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

/**
 * Recursively deletes a folder and its children.
 * This method is designed to keep chugging along even if an error occurs.
 * If this method is called with a file, it will simply be deleted.
 */
static void
geary_files_recursive_delete_async_ready (GObject* source_object,
                                          GAsyncResult* _res_,
                                          gpointer _user_data_)
{
	GearyFilesRecursiveDeleteAsyncData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	geary_files_recursive_delete_async_co (_data_);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

static gboolean
geary_files_recursive_delete_async_co (GearyFilesRecursiveDeleteAsyncData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		case 4:
		goto _state_4;
		case 5:
		goto _state_5;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_state_ = 1;
	geary_files_query_file_type_async (_data_->folder, TRUE, _data_->cancellable, geary_files_recursive_delete_async_ready, _data_);
	return FALSE;
	_state_1:
	_data_->type = geary_files_query_file_type_finish (_data_->_res_, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	if (_data_->type == G_FILE_TYPE_DIRECTORY) {
		_data_->_state_ = 2;
		g_file_enumerate_children_async (_data_->folder, G_FILE_ATTRIBUTE_STANDARD_NAME, G_FILE_QUERY_INFO_NOFOLLOW_SYMLINKS, _data_->priority, _data_->cancellable, geary_files_recursive_delete_async_ready, _data_);
		return FALSE;
		_state_2:
		_data_->_tmp0_ = g_file_enumerate_children_finish (_data_->folder, _data_->_res_, &_data_->_inner_error0_);
		_data_->enumerator = _data_->_tmp0_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->_tmp1_ = _data_->enumerator;
		if (_data_->_tmp1_ != NULL) {
			while (TRUE) {
				_data_->_tmp2_ = _data_->enumerator;
				_data_->_state_ = 3;
				g_file_enumerator_next_files_async (_data_->_tmp2_, GEARY_FILES_RECURSIVE_DELETE_BATCH_SIZE, _data_->priority, _data_->cancellable, geary_files_recursive_delete_async_ready, _data_);
				return FALSE;
				_state_3:
				_data_->_tmp3_ = g_file_enumerator_next_files_finish (_data_->_tmp2_, _data_->_res_, &_data_->_inner_error0_);
				_data_->info_list = _data_->_tmp3_;
				if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
					g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
					_g_object_unref0 (_data_->enumerator);
					g_object_unref (_data_->_async_result);
					return FALSE;
				}
				_data_->_tmp4_ = _data_->info_list;
				if (_data_->_tmp4_ == NULL) {
					(_data_->info_list == NULL) ? NULL : (_data_->info_list = (_g_list_free__g_object_unref0_ (_data_->info_list), NULL));
					break;
				}
				_data_->_tmp5_ = _data_->info_list;
				{
					_data_->info_collection = _data_->_tmp5_;
					for (_data_->info_it = _data_->info_collection; _data_->info_it != NULL; _data_->info_it = _data_->info_it->next) {
						_data_->_tmp6_ = _g_object_ref0 ((GFileInfo*) _data_->info_it->data);
						_data_->info = _data_->_tmp6_;
						{
							_data_->_tmp7_ = _data_->info;
							_data_->_tmp8_ = g_file_info_get_name (_data_->_tmp7_);
							_data_->_tmp9_ = g_file_get_child (_data_->folder, _data_->_tmp8_);
							_data_->_tmp10_ = _data_->_tmp9_;
							_data_->_state_ = 4;
							geary_files_recursive_delete_async (_data_->_tmp10_, _data_->priority, _data_->cancellable, geary_files_recursive_delete_async_ready, _data_);
							return FALSE;
							_state_4:
							geary_files_recursive_delete_finish (_data_->_res_, &_data_->_inner_error0_);
							_g_object_unref0 (_data_->_tmp10_);
							if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
								g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
								_g_object_unref0 (_data_->info);
								(_data_->info_list == NULL) ? NULL : (_data_->info_list = (_g_list_free__g_object_unref0_ (_data_->info_list), NULL));
								_g_object_unref0 (_data_->enumerator);
								g_object_unref (_data_->_async_result);
								return FALSE;
							}
							_g_object_unref0 (_data_->info);
						}
					}
				}
				(_data_->info_list == NULL) ? NULL : (_data_->info_list = (_g_list_free__g_object_unref0_ (_data_->info_list), NULL));
			}
		}
		_g_object_unref0 (_data_->enumerator);
	}
	_data_->_state_ = 5;
	g_file_delete_async (_data_->folder, _data_->priority, _data_->cancellable, geary_files_recursive_delete_async_ready, _data_);
	return FALSE;
	_state_5:
	g_file_delete_finish (_data_->folder, _data_->_res_, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
geary_files_query_exists_async_data_free (gpointer _data)
{
	GearyFilesQueryExistsAsyncData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->file);
	_g_object_unref0 (_data_->cancellable);
	g_slice_free (GearyFilesQueryExistsAsyncData, _data_);
}

void
geary_files_query_exists_async (GFile* file,
                                GCancellable* cancellable,
                                GAsyncReadyCallback _callback_,
                                gpointer _user_data_)
{
	GearyFilesQueryExistsAsyncData* _data_;
	GFile* _tmp0_;
	GCancellable* _tmp1_;
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (file, g_file_get_type ()));
	g_return_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()));
	_data_ = g_slice_new0 (GearyFilesQueryExistsAsyncData);
	_data_->_async_result = g_task_new (NULL, cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, geary_files_query_exists_async_data_free);
	_tmp0_ = _g_object_ref0 (file);
	_g_object_unref0 (_data_->file);
	_data_->file = _tmp0_;
	_tmp1_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp1_;
	geary_files_query_exists_async_co (_data_);
}

gboolean
geary_files_query_exists_finish (GAsyncResult* _res_,
                                 GError** error)
{
	gboolean result;
	GearyFilesQueryExistsAsyncData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		gboolean _tmp0_ = FALSE;
		return _tmp0_;
	}
	result = _data_->result;
	return result;
}

/**
 * Asynchronously report if the File exists.
 */
static void
geary_files_query_exists_async_ready (GObject* source_object,
                                      GAsyncResult* _res_,
                                      gpointer _user_data_)
{
	GearyFilesQueryExistsAsyncData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	geary_files_query_exists_async_co (_data_);
}

static gpointer
_g_error_copy0 (gpointer self)
{
	return self ? g_error_copy (self) : NULL;
}

static gboolean
geary_files_query_exists_async_co (GearyFilesQueryExistsAsyncData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		_data_->_state_ = 1;
		geary_files_query_file_type_async (_data_->file, TRUE, _data_->cancellable, geary_files_query_exists_async_ready, _data_);
		return FALSE;
		_state_1:
		geary_files_query_file_type_finish (_data_->_res_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->err = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp0_ = _data_->err;
		if (g_error_matches (_data_->_tmp0_, G_IO_ERROR, G_IO_ERROR_NOT_FOUND)) {
			_data_->result = FALSE;
			_g_error_free0 (_data_->err);
			g_task_return_pointer (_data_->_async_result, _data_, NULL);
			if (_data_->_state_ != 0) {
				while (!g_task_get_completed (_data_->_async_result)) {
					g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
				}
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			_data_->_tmp1_ = _data_->err;
			_data_->_tmp2_ = _g_error_copy0 (_data_->_tmp1_);
			_data_->_inner_error0_ = _data_->_tmp2_;
			_g_error_free0 (_data_->err);
			goto __finally0;
		}
		_g_error_free0 (_data_->err);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->result = TRUE;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
geary_files_query_file_type_async_data_free (gpointer _data)
{
	GearyFilesQueryFileTypeAsyncData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->file);
	_g_object_unref0 (_data_->cancellable);
	g_slice_free (GearyFilesQueryFileTypeAsyncData, _data_);
}

void
geary_files_query_file_type_async (GFile* file,
                                   gboolean follow_symlinks,
                                   GCancellable* cancellable,
                                   GAsyncReadyCallback _callback_,
                                   gpointer _user_data_)
{
	GearyFilesQueryFileTypeAsyncData* _data_;
	GFile* _tmp0_;
	GCancellable* _tmp1_;
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (file, g_file_get_type ()));
	g_return_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()));
	_data_ = g_slice_new0 (GearyFilesQueryFileTypeAsyncData);
	_data_->_async_result = g_task_new (NULL, cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, geary_files_query_file_type_async_data_free);
	_tmp0_ = _g_object_ref0 (file);
	_g_object_unref0 (_data_->file);
	_data_->file = _tmp0_;
	_data_->follow_symlinks = follow_symlinks;
	_tmp1_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp1_;
	geary_files_query_file_type_async_co (_data_);
}

GFileType
geary_files_query_file_type_finish (GAsyncResult* _res_,
                                    GError** error)
{
	GFileType result;
	GearyFilesQueryFileTypeAsyncData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return 0;
	}
	result = _data_->result;
	return result;
}

/**
 * Asynchronously fetch the FileType of the File.
 */
static void
geary_files_query_file_type_async_ready (GObject* source_object,
                                         GAsyncResult* _res_,
                                         gpointer _user_data_)
{
	GearyFilesQueryFileTypeAsyncData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	geary_files_query_file_type_async_co (_data_);
}

static gboolean
geary_files_query_file_type_async_co (GearyFilesQueryFileTypeAsyncData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	if (_data_->follow_symlinks) {
		_data_->_tmp0_ = G_FILE_QUERY_INFO_NONE;
	} else {
		_data_->_tmp0_ = G_FILE_QUERY_INFO_NOFOLLOW_SYMLINKS;
	}
	_data_->_state_ = 1;
	g_file_query_info_async (_data_->file, "standard::type", _data_->_tmp0_, G_PRIORITY_DEFAULT, _data_->cancellable, geary_files_query_file_type_async_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp1_ = g_file_query_info_finish (_data_->file, _data_->_res_, &_data_->_inner_error0_);
	_data_->info = _data_->_tmp1_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->result = g_file_info_get_file_type (_data_->info);
	_g_object_unref0 (_data_->info);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
geary_files_make_directory_with_parents_data_free (gpointer _data)
{
	GearyFilesMakeDirectoryWithParentsData* _data_;
	_data_ = _data;
	g_slice_free (GearyFilesMakeDirectoryWithParentsData, _data_);
}

void
geary_files_make_directory_with_parents (GFile* dir,
                                         GCancellable* cancellable,
                                         GAsyncReadyCallback _callback_,
                                         gpointer _user_data_)
{
	GearyFilesMakeDirectoryWithParentsData* _data_;
	GFile* _tmp0_;
	GCancellable* _tmp1_;
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (dir, g_file_get_type ()));
	g_return_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()));
	_data_ = g_slice_new0 (GearyFilesMakeDirectoryWithParentsData);
	_data_->_async_result = g_task_new (NULL, cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, geary_files_make_directory_with_parents_data_free);
	_tmp0_ = _g_object_ref0 (dir);
	_g_object_unref0 (_data_->dir);
	_data_->dir = _tmp0_;
	_tmp1_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp1_;
	geary_files_make_directory_with_parents_co (_data_);
}

gboolean
geary_files_make_directory_with_parents_finish (GAsyncResult* _res_,
                                                GError** error)
{
	gboolean result;
	GearyFilesMakeDirectoryWithParentsData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		gboolean _tmp0_ = FALSE;
		return _tmp0_;
	}
	result = _data_->result;
	return result;
}

/**
 * Ensure a directory exists, asynchronously.
 *
 * Returns true if the directory ws created. A {@link GLib.Error} is
 * thrown if the directory cannot be created, but not if it already
 * exists.
 */
static Block118Data*
block118_data_ref (Block118Data* _data118_)
{
	g_atomic_int_inc (&_data118_->_ref_count_);
	return _data118_;
}

static void
block118_data_unref (void * _userdata_)
{
	Block118Data* _data118_;
	_data118_ = (Block118Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data118_->_ref_count_)) {
		_g_error_free0 (_data118_->create_err);
		_g_object_unref0 (_data118_->dir);
		_g_object_unref0 (_data118_->cancellable);
		g_slice_free (Block118Data, _data118_);
	}
}

static void
__lambda21_ (Block118Data* _data118_,
             GError** error)
{
	GError* _inner_error0_ = NULL;
	{
		g_file_make_directory_with_parents (_data118_->dir, _data118_->cancellable, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_IO_ERROR) {
				goto __catch0_g_io_error;
			}
			goto __finally0;
		}
	}
	goto __finally0;
	__catch0_g_io_error:
	{
		GError* err = NULL;
		GError* _tmp0_;
		GError* _tmp1_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp0_ = err;
		_tmp1_ = _g_error_copy0 (_tmp0_);
		_g_error_free0 (_data118_->create_err);
		_data118_->create_err = _tmp1_;
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
}

static void
___lambda21__geary_nonblocking_concurrent_concurrent_callback (GCancellable* cancellable,
                                                               gpointer self,
                                                               GError** error)
{
	__lambda21_ (self, error);
}

static void
geary_files_make_directory_with_parents_ready (GObject* source_object,
                                               GAsyncResult* _res_,
                                               gpointer _user_data_)
{
	GearyFilesMakeDirectoryWithParentsData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	geary_files_make_directory_with_parents_co (_data_);
}

static gboolean
geary_files_make_directory_with_parents_co (GearyFilesMakeDirectoryWithParentsData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data118_ = g_slice_new0 (Block118Data);
	_data_->_data118_->_ref_count_ = 1;
	_g_object_unref0 (_data_->_data118_->dir);
	_data_->_data118_->dir = _data_->dir;
	_g_object_unref0 (_data_->_data118_->cancellable);
	_data_->_data118_->cancellable = _data_->cancellable;
	_data_->_data118_->_async_data_ = _data_;
	_data_->ret = FALSE;
	_data_->_data118_->create_err = NULL;
	_data_->_tmp0_ = geary_nonblocking_concurrent_get_global ();
	_data_->_tmp1_ = _data_->_tmp0_;
	_data_->_state_ = 1;
	geary_nonblocking_concurrent_schedule_async (_data_->_tmp1_, ___lambda21__geary_nonblocking_concurrent_concurrent_callback, _data_->_data118_, NULL, geary_files_make_directory_with_parents_ready, _data_);
	return FALSE;
	_state_1:
	geary_nonblocking_concurrent_schedule_finish (_data_->_tmp1_, _data_->_res_, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		block118_data_unref (_data_->_data118_);
		_data_->_data118_ = NULL;
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp2_ = _data_->_data118_->create_err;
	if (_data_->_tmp2_ == NULL) {
		_data_->ret = TRUE;
	} else {
		_data_->_tmp3_ = _data_->_data118_->create_err;
		if (!g_error_matches (_data_->_tmp3_, G_IO_ERROR, G_IO_ERROR_EXISTS)) {
			_data_->_tmp4_ = _data_->_data118_->create_err;
			_data_->_tmp5_ = _g_error_copy0 (_data_->_tmp4_);
			_data_->_inner_error0_ = _data_->_tmp5_;
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			block118_data_unref (_data_->_data118_);
			_data_->_data118_ = NULL;
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	_data_->result = _data_->ret;
	block118_data_unref (_data_->_data118_);
	_data_->_data118_ = NULL;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

guint
geary_files_hash (GFile* file)
{
	guint result;
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (file, g_file_get_type ()), 0U);
	result = g_file_hash (file);
	return result;
}

gboolean
geary_files_equal (GFile* a,
                   GFile* b)
{
	gboolean result;
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (a, g_file_get_type ()), FALSE);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (b, g_file_get_type ()), FALSE);
	result = g_file_equal (a, b);
	return result;
}

guint
geary_files_nullable_hash (GFile* file)
{
	guint _tmp0_ = 0U;
	guint result;
	g_return_val_if_fail ((file == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (file, g_file_get_type ()), 0U);
	if (file != NULL) {
		_tmp0_ = g_file_hash (file);
	} else {
		_tmp0_ = (guint) 0;
	}
	result = _tmp0_;
	return result;
}

gboolean
geary_files_nullable_equal (GFile* a,
                            GFile* b)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean result;
	g_return_val_if_fail ((a == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (a, g_file_get_type ()), FALSE);
	g_return_val_if_fail ((b == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (b, g_file_get_type ()), FALSE);
	if (a == NULL) {
		_tmp0_ = b == NULL;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = TRUE;
		return result;
	}
	if (a == NULL) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = b == NULL;
	}
	if (_tmp1_) {
		result = FALSE;
		return result;
	}
	result = g_file_equal (a, b);
	return result;
}

